/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.eca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class WorkHoursFeeListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final String closeBack_importResult = "importResult";
    private static final Log logger = LogFactory.getLog(WorkHoursFeeListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        switch (itemkey = evt.getItemKey()) {
            case "sysimportcover": {
                this.manuBillImport();
                break;
            }
            case "colreport": {
                this.viewColReport();
            }
        }
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache)) {
            return;
        }
        String acctOrgId = (String)orgCache.get(0);
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.WORKHOURS_FEE.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u62a5\u544a", (String)"WorkHoursFeeListPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void manuBillImport() {
        try {
            List<Object> orgCache = this.getOrgCache();
            String costaccount = this.getPageCache().get("costaccount");
            String costcenter = this.getPageCache().get("mulcostcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (CadEmptyUtils.isEmpty(orgCache) || costaccount == null) {
                return;
            }
            long orgId = Long.parseLong((String)orgCache.get(0));
            List costCenterMultiSelect = new ArrayList(10);
            if (!CadEmptyUtils.isEmpty((String)costcenter)) {
                costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)costcenter, List.class);
            }
            if (!CadEmptyUtils.isEmpty(costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                costCenterMultiSelect.forEach(p -> costCenters.add(Long.parseLong(p)));
            } else {
                List<ComboItem> costCenterComboItemListBy = this.getCostCenterComboItemListBy(String.valueOf(orgId));
                if (!CadEmptyUtils.isEmpty(costCenterComboItemListBy)) {
                    for (ComboItem comboItem : costCenterComboItemListBy) {
                        costCenters.add(Long.parseLong(comboItem.getValue()));
                    }
                }
            }
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)orgId, costCenters);
            if (CadEmptyUtils.isEmpty((Map)objRules)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"WorkHoursFeeListPlugin_0", (String)"macc-eca", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_17"));
                return;
            }
            HashSet<Long> calDimensionIds = new HashSet<Long>(16);
            for (Map.Entry entry : objRules.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                String costCenter = value.getString("costcenter");
                if (costCenters.size() == 1 && !costCenter.equals("0") && ((Long)costCenters.get(0)).equals(Long.valueOf(costCenter))) {
                    calDimensionIds.add(value.getLong("costcalcdimension"));
                    break;
                }
                if (costCenters.size() == 1 && costCenter.equals("0")) {
                    calDimensionIds.add(value.getLong("costcalcdimension"));
                    break;
                }
                calDimensionIds.add(value.getLong("costcalcdimension"));
            }
            String string = this.getView().getFormShowParameter().getAppId() == null ? "eca" : this.getView().getFormShowParameter().getAppId();
            List list = CommonCollConfigService.getCollConfigs((Long)orgId, null, calDimensionIds, (String)"eca_workhoursfee", (String)string);
            if (CadEmptyUtils.isEmpty((List)list)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u65b9\u6848\u3002", (String)"WorkHoursFeeListPlugin_1", (String)"macc-eca", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_18"));
                return;
            }
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)Long.parseLong(costaccount));
            if (currentPeriod == null) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u53ef\u7528\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"WorkHoursFeeListPlugin_2", (String)"macc-eca", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_18"));
                return;
            }
            long currentPeriodId = currentPeriod.getLong("id");
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"WorkHoursFeeListPlugin_3", (String)"macc-eca", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"eca", (String)"WorkHoursFeeService", (String)"importWorkHoursFee", (Object[])new Object[]{orgId, Long.parseLong(costaccount), currentPeriodId, costCenters, AppIdHelper.getCurAppNum((IFormView)this.getView()), progressId});
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"WorkHoursFeeListPlugin_4", (String)"macc-eca", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u62a5\u544a", (String)"WorkHoursFeeListPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List orgList;
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costaccount = this.getPageCache().get("costaccount");
        String costcenter = this.getPageCache().get("costcenter");
        if (CadEmptyUtils.isEmpty((String)acctOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursFeeListPlugin_6", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (CadEmptyUtils.isEmpty((String)costaccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WorkHoursFeeListPlugin_7", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        if (!StringUtils.isEmpty((String)acctOrg) && (orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class)) != null && !orgList.isEmpty()) {
            bsp.setCustomParam("orgId", orgList.get(0));
        }
        bsp.setCustomParam("costaccount", (Object)costaccount);
        bsp.setCustomParam("costcenter", (Object)costcenter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("audit".equals(operateKey) && e.getOperationResult().isSuccess()) {
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(e.getOperationResult().getSuccessPkIds().size());
            for (Object workHoursId : e.getOperationResult().getSuccessPkIds()) {
                selectedRows.add(new ListSelectedRow(workHoursId));
            }
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("eca_workhoursfee");
            pushArgs.setTargetEntityNumber("eca_costcarrybill");
            pushArgs.setHasRight(true);
            pushArgs.setBuildConvReport(true);
            pushArgs.setSelectedRows(selectedRows);
            try (TXHandle h = TX.required();){
                try {
                    ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                    if (!pushResult.isSuccess()) {
                        StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"WorkHoursFeeListPlugin_9", (String)"macc-eca", (Object[])new Object[0]), errMessage));
                    }
                }
                catch (Exception ex) {
                    h.markRollback();
                    throw ex;
                }
            }
        }
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            logger.error(billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                boolean flag = PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)"eca", (String)"eca_workhoursrate");
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5355\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"WorkHoursFeeListPlugin_8", (String)"macc-eca", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }
}

