/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.common.helper.InitHelper;
import kd.macc.eca.common.helper.SysParamHelper;

public class CostInitEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initByListData();
        CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setQtyEnable();
        this.setHourExpenseVisible();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        switch (evt.getItemKey()) {
            case "bar_new": 
            case "bar_copy": 
            case "bar_del": 
            case "bar_save": 
            case "bar_modify": 
            case "bar_submit": 
            case "bar_unsubmit": 
            case "bar_audit": 
            case "bar_unaudit": 
            case "bar_submitandnew": {
                evt.setCancel(this.isInit().booleanValue());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        costObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        switch (name) {
            case "costobject": {
                DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
                if (costCenter == null) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"CostInitEditPlugin_4", (String)"macc-eca", (Object[])new Object[0]));
                    return;
                }
                listFilterParameter.getQFilters().add(new QFilter("billstatus", "=", (Object)"C"));
                listFilterParameter.getQFilters().add(new QFilter("costcenter", "=", costCenter.getPkValue()));
                break;
            }
            case "costcenter": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CostInitEditPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                listFilterParameter.getQFilters().add(new QFilter("accountorg", "=", org.getPkValue()));
                break;
            }
            case "material": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CostInitEditPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                listFilterParameter.getQFilters().add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(org.getLong("id"))));
                break;
            }
            case "period": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u662f\u5426\u5b58\u5728\u3002", (String)"CostInitEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
                if (costAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u201c\u6210\u672c\u8d26\u7c3f\u201d\u662f\u5426\u5b58\u5728\u3002", (String)"CostInitEditPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                listFilterParameter.getQFilters().add(this.getPeriodFilter(org.getLong("id"), costAccount.getLong("id")));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (property) {
            case "costcenter": {
                this.getModel().setValue("costobject", null);
                this.getView().updateView("costobject");
                break;
            }
            case "subelement": {
                ElementHelper.setElement((PropertyChangedArgs)e, (IFormView)this.getView());
                break;
            }
            case "material": {
                this.setSubBaseUnit(changeSet[0]);
                this.changeVerAuxptyEnable(rowIndex);
                if (this.getPageCache().get("isFromSubMatVersionChanged") != null) {
                    return;
                }
                this.clearMatVersion();
                break;
            }
            case "matversion": {
                this.setMaterial();
                break;
            }
        }
    }

    private void setMaterial() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject matVersion = (DynamicObject)this.getModel().getValue("matversion", entryCurrentRowIndex);
        if (matVersion == null) {
            return;
        }
        DynamicObject material = matVersion.getDynamicObject("material");
        if (material == null) {
            return;
        }
        this.getPageCache().put("isFromSubMatVersionChanged", "true");
        this.getModel().setValue("material", (Object)material, entryCurrentRowIndex);
        this.getPageCache().remove("isFromSubMatVersionChanged");
        this.getView().updateView("material", entryCurrentRowIndex);
    }

    private void clearMatVersion() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().beginInit();
        this.getModel().setValue("matversion", null, entryCurrentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("matversion", entryCurrentRowIndex);
    }

    private void changeVerAuxptyEnable(int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        Boolean isEnableMaterialVersion = false;
        Boolean isUseAuxpty = false;
        if (material != null) {
            isEnableMaterialVersion = material.getBoolean("isenablematerialversion");
            List collect = material.getDynamicObjectCollection("auxptyentry").stream().filter(o -> o.getBoolean("isaffectprice")).collect(Collectors.toList());
            Boolean isuseauxpty = material.getBoolean("isuseauxpty");
            isUseAuxpty = isuseauxpty != false && !CollectionUtils.isEmpty(collect);
        }
        this.getView().setEnable(isEnableMaterialVersion, rowIndex, new String[]{"matversion"});
        this.getView().setEnable(isUseAuxpty, rowIndex, new String[]{"auxpty"});
    }

    private void setSubBaseUnit(ChangeData changeData) {
        DynamicObject row = changeData.getDataEntity();
        if (CadEmptyUtils.isEmpty((DynamicObject)row)) {
            return;
        }
        DynamicObject baseUnit = row.getDynamicObject("material.baseunit");
        row.set("unit", (Object)baseUnit);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getView().updateView("unit", entryCurrentRowIndex);
        this.getView().setEnable(Boolean.valueOf(baseUnit != null), entryCurrentRowIndex, new String[]{"qty"});
        if (baseUnit == null) {
            this.getModel().setValue("qty", null);
        }
    }

    private void initByListData() {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        String orgId = "";
        String costaccountId = (String)fsp.getCustomParam("costaccount");
        if (org == null) {
            orgId = (String)fsp.getCustomParam("org");
            model.setValue("org", (Object)orgId);
        } else {
            orgId = String.valueOf(org.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((String)costaccountId)) {
            model.setValue("costaccount", (Object)costaccountId);
        } else if (!CadEmptyUtils.isEmpty((String)orgId)) {
            Long costAccountId = InitHelper.getCostAccountByOrg(Long.parseLong(orgId), this.getView().getFormShowParameter().getAppId());
            this.getModel().setValue("costaccount", (Object)costAccountId);
            this.getView().updateView("costaccount");
        }
    }

    private QFilter getPeriodFilter(Long orgId, Long costAccountId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("appnum", "=", (Object)"eca"), new QFilter("entryentity.costaccount", "=", (Object)costAccountId)};
        DynamicObject initCost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters);
        if (initCost == null) {
            return null;
        }
        QFilter filter = new QFilter("periodtype", "=", (Object)initCost.getLong("periodtype"));
        filter.and("id", "<", (Object)initCost.getLong("startperiod"));
        return filter;
    }

    private void setHourExpenseVisible() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u5b57\u6bb5\u4e0d\u5e94\u4e3a\u7a7a\u3002", (String)"CostInitEditPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        Map<String, Boolean> hourExpenseInfos = SysParamHelper.getHourExpense(org.getLong("id"));
        this.getModel().beginInit();
        for (Map.Entry<String, Boolean> hourExpenseInfo : hourExpenseInfos.entrySet()) {
            BasedataEdit control;
            String key = hourExpenseInfo.getKey().toLowerCase();
            if (CadEmptyUtils.isEmpty((String)key) || (control = (BasedataEdit)this.getControl(key)) == null) continue;
            this.getView().setVisible(hourExpenseInfo.getValue(), new String[]{key});
            control.setMustInput(hourExpenseInfo.getValue().booleanValue());
        }
        this.getModel().endInit();
    }

    private Boolean isInit() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u662f\u5426\u5b58\u5728\u3002", (String)"CostInitEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u201c\u6210\u672c\u8d26\u7c3f\u201d\u662f\u5426\u5b58\u5728\u3002", (String)"CostInitEditPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if (InitHelper.isInit(Long.parseLong(org.getPkValue().toString()), Long.parseLong(costAccount.getPkValue().toString())).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"CostInitEditPlugin_3", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setQtyEnable() {
        DynamicObjectCollection entrys = this.getView().getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject nuit = ((DynamicObject)entrys.get(i)).getDynamicObject("unit");
            this.getView().setEnable(Boolean.valueOf(nuit != null), i, new String[]{"qty"});
        }
        this.getModel().endInit();
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            DynamicObject workCenter;
            List baseData = (List)entry.getValue();
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (baseData == null || baseData.size() <= 1 || !"period".equals(basedataItem.getFieldKey())) continue;
            Object source = e.getSource();
            Map sourceObj = ((RowMapper)source).getSourceObj();
            Map costAccountMap = (Map)sourceObj.get("costaccount");
            long costAccountId = 0L;
            long periodTypeId = 0L;
            if (costAccountMap != null) {
                Object id = costAccountMap.get("id");
                if (id != null) {
                    costAccountId = Long.parseLong(String.valueOf(id));
                }
                if (costAccountId == 0L) {
                    DynamicObject currentPeriodType;
                    String manuOrgNum = String.valueOf(costAccountMap.get("number"));
                    QFilter numberQFilter = new QFilter("number", "=", (Object)manuOrgNum);
                    DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id", (QFilter[])numberQFilter.toArray());
                    if (manuOrg != null) {
                        costAccountId = manuOrg.getLong("id");
                    }
                    if ((currentPeriodType = PeriodHelper.getCurrentPeriodType((Long)costAccountId)) != null) {
                        periodTypeId = currentPeriodType.getLong("id");
                    }
                }
            }
            ArrayList<QFilter> allQf = new ArrayList<QFilter>(2);
            if (!CadEmptyUtils.isEmpty((Long)periodTypeId)) {
                allQf.add(new QFilter("periodtype", "=", (Object)periodTypeId));
            }
            if (!CadEmptyUtils.isEmpty((String)basedataItem.getSearchValue())) {
                allQf.add(new QFilter("number", "=", (Object)basedataItem.getSearchValue()));
            }
            if ((workCenter = QueryServiceHelper.queryOne((String)basedataItem.getEntityNumber(), (String)"id", (QFilter[])allQf.toArray(new QFilter[0]))) == null) continue;
            baseData.retainAll(Collections.singletonList(workCenter.getLong("id")));
        }
    }
}

