/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.common.helper.InitHelper;

public class CostInitListPlugin
extends AbstractListPlugin {
    private Boolean isCostAccountDef = Boolean.FALSE;
    private volatile boolean orgClick = false;
    private FilterContainerInitArgs filterContainerInitArgs = null;

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        switch (evt.getItemKey()) {
            case "tblnew": 
            case "tblcopy": 
            case "tbldel": 
            case "tblsubmit": 
            case "tblunsubmit": 
            case "tblcheck": 
            case "tblunaudit": 
            case "importdata": {
                evt.setCancel(this.isInit().booleanValue());
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String org = this.getPageCache().get("org");
        if (StringUtils.isEmpty((String)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CostInitListPlugin_4", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        bsp.setCustomParam("org", (Object)org);
        String costAccount = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costAccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostInitListPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        bsp.setCustomParam("costaccount", (Object)costAccount);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClickEvent(args);
        this.filterContainerInit(args, null);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String orgId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount") && !CadEmptyUtils.isEmpty((String)(orgId = this.getPageCache().get("org")))) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(orgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    private void filterContainerInit(FilterContainerInitArgs args, String initName) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            String orgId = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (StringUtils.isNotEmpty((String)initName) && !fieldName.contains(initName)) continue;
            if (fieldName.startsWith("org.")) {
                this.resetOrg(commonFilterColumn, orgId);
            }
            if (!fieldName.startsWith("costaccount.")) continue;
            this.resetCostAccount(commonFilterColumn, orgId);
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator filterCols = filterColumns.iterator();
        String org = this.getPageCache().get("org");
        while (filterCols.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)filterCols.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    private void resetOrg(CommonFilterColumn commonFilterColumn, String orgId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> acctOrgs = this.getORGComboItemList();
        if (CadEmptyUtils.isEmpty(acctOrgs)) {
            commonFilterColumn.setDefaultValue("0");
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            orgId = acctOrgs.get(0).getValue();
        }
        commonFilterColumn.setDefaultValues(new Object[]{orgId});
        this.putOrgCache(orgId);
    }

    private void resetCostAccount(CommonFilterColumn commonFilterColumn, String orgId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            List<ComboItem> comboItems = this.getCostAccountByOrg(orgId);
            if (CollectionUtils.isEmpty(comboItems)) {
                commonFilterColumn.setDefaultValue("0");
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            String defVal = this.isCostAccountDef != false ? "" : comboItems.get(0).getValue();
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("costaccount", defVal);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
        }
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        customfilter.add(e.getCurrentCommonFilter());
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            List vals = (List)map.get("Value");
            if (CadEmptyUtils.isEmpty((List)vals)) continue;
            if ("org.id".equals(String.valueOf(names.get(0)))) {
                this.putOrgCache(String.valueOf(vals.get(0)));
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!"costaccount.id".equals(String.valueOf(names.get(0)))) continue;
            String val = String.valueOf(vals.get(0));
            this.getPageCache().put("costaccount", val);
        }
    }

    private void putOrgCache(String org) {
        this.getPageCache().put("org", org);
        this.getPageCache().remove("costaccount");
    }

    private String getOrgCache() {
        return this.getPageCache().get("org");
    }

    private Boolean isInit() {
        String org = this.getPageCache().get("org");
        if (CadEmptyUtils.isEmpty((String)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CostInitListPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        String costAccount = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costAccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostInitListPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if (InitHelper.isInit(Long.parseLong(org), Long.parseLong(costAccount)).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"CostInitListPlugin_3", (String)"macc-eca", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }

    private String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private List<ComboItem> getCostAccountByOrg(String orgId) {
        QFilter filter = null;
        filter = !CadEmptyUtils.isEmpty((String)orgId) ? new QFilter("calorg", "=", (Object)Long.parseLong(orgId)) : new QFilter("calorg", ">", (Object)0L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            filter.and(StartCostHelper.getEnableQfilterByOrg((Long)Long.parseLong(orgId), null, (String)this.getView().getFormShowParameter().getAppId()));
        }
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc");
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return acctItems;
        }
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }
}

