/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.price;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.SysParamHelper;

public class WorkHoursRateEditPlugin
extends AbstractBillPlugIn {
    public static final String ENTITY_ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursRateEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter(createorg);
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursRateEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter showorgduty = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorg = new QFilter("accountorg", "=", createorg.getPkValue());
            qFilters.add(showorgduty);
            qFilters.add(calorg);
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element != null) {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
            }
        });
        BasedataEdit attaSubElementCtrl = (BasedataEdit)this.getControl("entrysubelement");
        attaSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_ENTRY);
            Set attaSubelemenIds = entryEntity.stream().map(s -> s.getLong("entrysubelement.id")).collect(Collectors.toSet());
            if (!attaSubelemenIds.isEmpty()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", attaSubelemenIds));
            }
        });
        BasedataEdit workhoursunitCtrl = (BasedataEdit)this.getControl("workhoursunit");
        workhoursunitCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("group", "=", (Object)4L));
        });
    }

    private void setAttaElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject attasubelement = row.getDynamicObject("entrysubelement");
            if (attasubelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)attasubelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("entryelement", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name = e.getProperty().getName().toUpperCase()) {
            case "effectdate": {
                Date newDate;
                Date oldDate;
                if (oldValue == null || newValue == null || (oldDate = (Date)oldValue).compareTo(newDate = (Date)newValue) <= 0) break;
                this.getModel().beginInit();
                this.getModel().setValue("effectdate", (Object)oldDate);
                this.getModel().endInit();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u9ed8\u8ba4\u4e3a\u7cfb\u7edf\u65f6\u95f4\uff0c\u53ef\u5f80\u7cfb\u7edf\u5f53\u524d\u65f6\u95f4\u540e\u4fee\u6539\uff0c\u4e0d\u80fd\u5f80\u524d\u4fee\u6539\u3002", (String)"WorkHoursRateEditPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                return;
            }
            case "SUBELEMENT": {
                this.setElement(e);
                break;
            }
            case "ENTRYSUBELEMENT": {
                this.setAttaElement(e);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String costaccount;
        String costcenter;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam("orgId");
        if (!StringUtils.isEmpty((CharSequence)acctOrg) && this.getModel().getValue("org") == null) {
            this.getModel().setValue("org", (Object)acctOrg);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        if (!StringUtils.isEmpty((CharSequence)(costcenter = (String)formShowParameter.getCustomParam("costcenter"))) && this.getModel().getValue("costcenter") == null) {
            this.getModel().setValue("costcenter", (Object)costcenter);
        }
        if (!StringUtils.isEmpty((CharSequence)(costaccount = (String)formShowParameter.getCustomParam("costaccount"))) && this.getModel().getValue("costaccount") == null) {
            this.getModel().setValue("costaccount", (Object)costaccount);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        }
        this.setCurrency();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.enableEffectByOrg(org);
        this.setHourExpenseVisible(org);
    }

    private void enableEffectByOrg(DynamicObject org) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (org == null) {
            return;
        }
        Boolean enableEffectByOrg = SysParamHelper.getEnableEffectByOrg(org.getLong("id"), "eca_workhoursrate");
        if (enableEffectByOrg.booleanValue()) {
            if (OperationStatus.ADDNEW == status) {
                Object effectDate = this.getModel().getValue("effectdate");
                Object expDate = this.getModel().getValue("expdate");
                if (effectDate == null) {
                    this.getModel().setValue("effectdate", (Object)DateUtils.getDefaultEffectDate());
                }
                if (expDate == null) {
                    this.getModel().setValue("expdate", (Object)DateUtils.getDeFaultExpDate());
                }
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"effectdate", "expdate"});
            if (OperationStatus.ADDNEW == status) {
                this.getModel().setValue("effectdate", (Object)DateUtils.getDefaultEffectDate());
                Object expDate = this.getModel().getValue("expdate");
                if (expDate == null) {
                    this.getModel().setValue("expdate", (Object)DateUtils.getDeFaultExpDate());
                }
            }
        }
    }

    private void setHourExpenseVisible(DynamicObject org) {
        Long orgId = org == null ? 0L : org.getLong("id");
        Map<String, Boolean> hourExpenseInfo = SysParamHelper.getHourExpense(orgId);
        Boolean exist = hourExpenseInfo.get(HourExpenseEnum.TRADE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"trade"});
        exist = hourExpenseInfo.get(HourExpenseEnum.ROLE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"role"});
        exist = hourExpenseInfo.get(HourExpenseEnum.RESOURCE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"resource"});
    }

    private Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private void setElement(PropertyChangedArgs e) {
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("subelement");
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"));
        }
    }

    private QFilter getCostAccountFilter(DynamicObject org) {
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"eca");
        QFilter isinitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum, isinitFilter});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        return new QFilter("id", "in", costaccountIds);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }
}

