/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.price;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class WorkHoursRateListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        QFilter effectDateQf = null;
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            Object val = qFilter.getValue();
            if (!"period.id".equals(property)) continue;
            Long periodId = Long.parseLong(val.toString());
            if (val != null && periodId > 0L) {
                Map dateByPeriod = PeriodHelper.getDateByPeriod((Set)Sets.newHashSet((Object[])new Long[]{periodId}));
                QFilter dateQFilter = new QFilter("effectdate", "<=", dateByPeriod.get("enddate")).and(new QFilter("expdate", ">=", dateByPeriod.get("begindate")));
                QFilter nullDateQFilter = new QFilter("effectdate", "is null", null).and(new QFilter("expdate", "is null", null));
                effectDateQf = dateQFilter.or(nullDateQFilter);
            }
            iterator.remove();
        }
        if (effectDateQf != null) {
            qFilters.add(effectDateQf);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        switch (itemkey = evt.getItemKey()) {
            default: 
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List orgList;
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costaccount = this.getPageCache().get("costaccount");
        String costcenter = this.getPageCache().get("costcenter");
        if (CadEmptyUtils.isEmpty((String)acctOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursRateListPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (CadEmptyUtils.isEmpty((String)costaccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WorkHoursRateListPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        if (!StringUtils.isEmpty((String)acctOrg) && (orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class)) != null && !orgList.isEmpty()) {
            bsp.setCustomParam("orgId", orgList.get(0));
        }
        bsp.setCustomParam("costaccount", (Object)costaccount);
        bsp.setCustomParam("costcenter", (Object)costcenter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                boolean flag = PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)"eca", (String)"eca_workhoursrate");
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u65f6\u8d39\u7387\u4ef7\u76ee\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"WorkHoursRateListPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }
}

