/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.opplugin.feealloc;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.SysParamHelper;

public class WorkHoursFeeSaveValidate
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject currentperiod;
            Object resource;
            Object role;
            Object trade;
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = this.getDyId(data, "org");
            Long costaccountId = this.getDyId(data, "costaccount");
            Long costcenterId = this.getDyId(data, "costcenter");
            Long periodId = this.getDyId(data, "period");
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"WorkHoursFeeSaveValidate_0", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)costaccountId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WorkHoursFeeSaveValidate_1", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)costcenterId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"WorkHoursFeeSaveValidate_2", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)periodId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u671f\u95f4\u5b57\u6bb5,\u5e76\u68c0\u67e5\u5f53\u524d\u8d26\u7c3f\u662f\u5426\u7ef4\u62a4\u5f53\u524d\u671f\u95f4\u3002", (String)"WorkHoursFeeSaveValidate_3", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (data.get("bizdate") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c47\u62a5\u65f6\u95f4\u3002", (String)"WorkHoursFeeSaveValidate_4", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (data.get("bizdate") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bb0\u8d26\u65e5\u671f\u3002", (String)"WorkHoursFeeSaveValidate_5", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            Map<String, Boolean> hourExpenseInfo = SysParamHelper.getHourExpense(orgId);
            Boolean exist = hourExpenseInfo.get(HourExpenseEnum.TRADE.getValue());
            if (exist != null && exist.booleanValue() && (trade = data.get("trade")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u884c\u4e1a,\u8bf7\u586b\u5199\u884c\u4e1a\u3002", (String)"WorkHoursFeeSaveValidate_6", (String)"macc-eca", (Object[])new Object[0]));
            }
            if ((exist = hourExpenseInfo.get(HourExpenseEnum.ROLE.getValue())) != null && exist.booleanValue() && (role = data.get("role")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u89d2\u8272\uff0c\u8bf7\u586b\u5199\u89d2\u8272\u3002", (String)"WorkHoursFeeSaveValidate_7", (String)"macc-eca", (Object[])new Object[0]));
            }
            if ((exist = hourExpenseInfo.get(HourExpenseEnum.RESOURCE.getValue())) != null && exist.booleanValue() && (resource = data.get("resource")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u8d44\u6e90,\u8bf7\u586b\u5199\u8d44\u6e90\u3002", (String)"WorkHoursFeeSaveValidate_8", (String)"macc-eca", (Object[])new Object[0]));
            }
            if ((currentperiod = PeriodHelper.getCurrentPeriod((Long)costaccountId)) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u68c0\u67e5\u5f53\u524d\u8d26\u7c3f\u662f\u5426\u7ef4\u62a4\u5f53\u524d\u671f\u95f4\u3002", (String)"WorkHoursFeeSaveValidate_9", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            if (Long.compare(currentperiod.getLong("id"), periodId) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7684\u201c\u671f\u95f4\u201d\u4e0d\u662f\u5f53\u524d\u671f\u95f4\uff0c\u53ea\u5141\u8bb8\u67e5\u770b\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"WorkHoursFeeSaveValidate_10", (String)"macc-eca", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u660e\u7ec6\u4fe1\u606f\u5206\u5f55\u6570\u636e\u3002", (String)"WorkHoursFeeSaveValidate_11", (String)"macc-eca", (Object[])new Object[0]));
            }
            int i = 1;
            for (DynamicObject entry : entryentity) {
                BigDecimal amount = entry.getBigDecimal("amount");
                if (CadEmptyUtils.isEmpty((BigDecimal)amount)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u660e\u7ec6\u4fe1\u606f\u5206\u5f55\u7b2c%s\u884c\u91d1\u989d\u3002", (String)"WorkHoursFeeSaveValidate_12", (String)"macc-eca", (Object[])new Object[0]), i));
                }
                ++i;
            }
        }
    }

    private Long getDyId(DynamicObject dy, String fileName) {
        Object value = dy.get(fileName);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }
}

