/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.opplugin.feealloc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;

public class WorkHoursFeeUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("costcenter");
        fieldKeys.add("role");
        fieldKeys.add("resource");
        fieldKeys.add("trade");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObject costaccount = data.getDynamicObject("costaccount");
                    DynamicObject period = data.getDynamicObject("period");
                    String billno = data.getString("billno");
                    if (costaccount == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WorkHoursFeeUnAuditOpPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                        continue;
                    }
                    if (period == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u671f\u95f4\u5b57\u6bb5,\u5e76\u68c0\u67e5\u5f53\u524d\u8d26\u7c3f\u662f\u5426\u7ef4\u62a4\u5f53\u524d\u671f\u95f4\u3002", (String)"WorkHoursFeeUnAuditOpPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject currentperiod = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
                    if (currentperiod == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u68c0\u67e5\u5f53\u524d\u8d26\u7c3f\u662f\u5426\u7ef4\u62a4\u5f53\u524d\u671f\u95f4\u3002", (String)"WorkHoursFeeUnAuditOpPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
                        continue;
                    }
                    if (Long.compare(currentperiod.getLong("id"), period.getLong("id")) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6570\u636e\u7684\u201c\u671f\u95f4\u201d\u4e0d\u662f\u5f53\u524d\u671f\u95f4\uff0c\u53ea\u5141\u8bb8\u67e5\u770b\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"WorkHoursFeeUnAuditOpPlugin_3", (String)"macc-eca", (Object[])new Object[0]), billno));
                        continue;
                    }
                    long id = data.getLong("id");
                    QFilter sourceIdQf = new QFilter("srcbillid", "=", (Object)id);
                    QFilter vouchernumQf = new QFilter("vouchernum", "!=", (Object)" ");
                    boolean exists = QueryServiceHelper.exists((String)"eca_costcarrybill", (QFilter[])new QFilter[]{sourceIdQf, vouchernumQf});
                    if (!exists) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6570\u636e\u7684\u201c\u6210\u672c\u7ed3\u8f6c\u5355\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"WorkHoursFeeUnAuditOpPlugin_4", (String)"macc-eca", (Object[])new Object[0]), billno));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            long id = dataEntity.getLong("id");
            idList.add(id);
        }
        if (idList.size() > 0) {
            QFilter qFilter = new QFilter("srcbillid", "in", idList);
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])new QFilter[]{qFilter});
        }
    }

    private Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    private Set<String> getEntryPropertys(String entryName, String entry) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            if (!transField.getFullFieldName().startsWith(entry)) continue;
            String fieldName = transField.getFieldName();
            dateFields.add(fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName);
        }
        return dateFields;
    }
}

