/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.opplugin.price;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.BaseDataCompareDiffHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.eca.opplugin.price.WorkHoursRateEffectValidate;
import kd.macc.eca.opplugin.price.WorkHoursRateSaveValidate;

public class WorkHoursRateAuditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(WorkHoursRateAuditOpPlugin.class);
    private static final String[] billFile = new String[]{"org", "costaccount", "costcenter", "subelement", "workhoursunit", "qty", "trade", "role", "resource"};
    private static final String[] entryFile = new String[]{"entrysubelement", "stdrate", "amount"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getPropertys("eca_workhoursrate"));
        fieldKeys.addAll(this.getEntryPropertys("eca_workhoursrate", "entryentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new WorkHoursRateSaveValidate());
        e.getValidators().add(new WorkHoursRateEffectValidate());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Set sourceIdsSet = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toSet());
        String selectFileName = "org,costaccount,costcenter,subelement,workhoursunit,qty,trade,role,resource,sourceid,effectdate,entryentity.entrysubelement,entryentity,entryentity.stdrate,entryentity.amount,expdate";
        Map recentDataByUnAuditMap = BaseDataCompareDiffHelper.getRecentDataByUnAudit(sourceIdsSet, (String)"eca_workhoursrate", (String)selectFileName);
        ArrayList<Long> deleteDataList = new ArrayList<Long>(10);
        ArrayList<DynamicObject> modifyDataList = new ArrayList<DynamicObject>(10);
        Long deleteId = null;
        for (DynamicObject dataEntity : dataEntities) {
            Set recentDataEntrySet;
            DynamicObject recentDataByUnAudit;
            Long orgId = dataEntity.getLong("org.id");
            Boolean enableEffectByOrg = SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)"eca", (String)"eca_workhoursrate");
            if (enableEffectByOrg.booleanValue() && (recentDataByUnAudit = (DynamicObject)recentDataByUnAuditMap.get(dataEntity.getLong("id"))) != null && (recentDataEntrySet = BaseDataCompareDiffHelper.recentDataDiffResult((DynamicObject)recentDataByUnAudit, (DynamicObject)dataEntity, (String[])billFile, (String[])entryFile)) != null) {
                if (recentDataEntrySet.size() == 0) {
                    deleteId = recentDataByUnAudit.getLong("id");
                    deleteDataList.add(deleteId);
                } else {
                    this.createModifyData(modifyDataList, recentDataByUnAudit, recentDataEntrySet);
                }
            }
            Date date = dataEntity.getDate("effectdate");
            Date expdate = dataEntity.getDate("expdate");
            if (date != null) {
                if (deleteId != null && enableEffectByOrg.booleanValue() && expdate != null && expdate.compareTo(new Date()) > 0) {
                    date = this.getEffectDate(dataEntity, deleteId);
                    dataEntity.set("effectdate", (Object)date);
                }
            } else {
                date = enableEffectByOrg != false ? this.getEffectDate(dataEntity, deleteId) : DateUtils.getDefaultEffectDate();
                dataEntity.set("effectdate", (Object)date);
            }
            if ((date = dataEntity.getDate("expdate")) == null) {
                dataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
            }
            dataEntity.set("auditdate", (Object)new Date());
            dataEntity.set("auditor", (Object)Long.parseLong(RequestContext.get().getUserId()));
        }
        if (deleteDataList.size() > 0) {
            DeleteServiceHelper.delete((String)"eca_workhoursrate", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteDataList)});
        }
        if (modifyDataList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])modifyDataList.toArray(new DynamicObject[0]));
        }
    }

    private Date getEffectDate(DynamicObject dataEntity, Long deleteId) {
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        Set entryentitySet = entryentity.stream().map(dynamicObject -> dynamicObject.getLong("entrysubelement.id") + "@" + dynamicObject.getBigDecimal("stdrate") + "@" + dynamicObject.getBigDecimal("amount")).collect(Collectors.toSet());
        Long orgId = dataEntity.getLong("org.id");
        Long costcenterId = dataEntity.getLong("costcenter.id");
        Long costaccountId = dataEntity.getLong("costaccount.id");
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter costcenterQf = new QFilter("costcenter", "=", (Object)costcenterId);
        QFilter idQf = new QFilter("id", "!=", dataEntity.getPkValue());
        String selectStr = "id,effectdate,expdate,entryentity.entrysubelement.id as entrysubelementId,entryentity.stdrate as stdrate,entryentity.amount as amount";
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getEffectDateQuery", (String)"eca_workhoursrate", (String)selectStr, (QFilter[])new QFilter[]{orgQf, costaccountQf, costcenterQf, statusQf, idQf}, (String)"effectdate desc");
        Date effectdate = null;
        Date expdate = null;
        while (rows.hasNext()) {
            Date date;
            Row row = rows.next();
            String key = row.getLong("entrysubelementId") + "@" + row.getBigDecimal("stdrate") + "@" + row.getBigDecimal("amount");
            if (!entryentitySet.contains(key)) continue;
            if (deleteId != null && deleteId.compareTo(row.getLong("id")) == 0) {
                date = row.getDate("effectdate");
                if (effectdate == null) {
                    effectdate = date;
                    continue;
                }
                effectdate = effectdate.compareTo(date) > 0 ? date : effectdate;
                continue;
            }
            date = row.getDate("expdate");
            if (expdate == null) {
                expdate = date;
                continue;
            }
            expdate = expdate.compareTo(date) > 0 ? expdate : date;
        }
        if (effectdate == null && expdate == null) {
            effectdate = DateUtils.getDefaultEffectDate();
        } else if (effectdate != null && expdate != null) {
            effectdate = effectdate.compareTo(expdate) > 0 ? effectdate : expdate;
        } else if (expdate != null) {
            effectdate = expdate;
        }
        return effectdate;
    }

    private void createModifyData(ArrayList<DynamicObject> modifyDataList, DynamicObject recentDataByUnAudit, Set<String> recentDataEntrySet) {
        DynamicObjectCollection entryentity = recentDataByUnAudit.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (String key : recentDataEntrySet) {
            String[] split = key.split("@");
            if (split != null && split.length == 4) {
                DynamicObject entry = entryentity.addNew();
                entry.set("material", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[0]));
                entry.set("matversion", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[1]));
                entry.set("auxpty", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[2]));
                entry.set("materialgroup", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[3]));
                continue;
            }
            logger.error("SubElementAndMatAuditOpPlugin\u5206\u5f55key\u5f02\u5e38", (Object)key);
        }
        modifyDataList.add(recentDataByUnAudit);
    }

    private Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    private Set<String> getEntryPropertys(String entryName, String entry) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            if (!transField.getFullFieldName().startsWith(entry)) continue;
            String fieldName = transField.getFieldName();
            dateFields.add(fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName);
        }
        return dateFields;
    }
}

