/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.opplugin.price;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.SysParamHelper;

public class WorkHoursRateEffectValidate
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Date nowDate = new Date();
        StringBuilder tips = new StringBuilder();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = data.getLong("org.id");
            Long costaccountId = data.getLong("costaccount.id");
            Long costcenterId = data.getLong("costcenter.id");
            Boolean enableEffectByOrg = SysParamHelper.getEnableEffectByOrg(orgId, "eca_workhoursrate");
            QFilter orgIdQf = new QFilter("org", "=", (Object)orgId);
            QFilter idQf = new QFilter("id", "!=", data.getPkValue());
            qFilters.clear();
            tips.setLength(0);
            qFilters.add(orgIdQf);
            qFilters.add(idQf);
            qFilters.add(new QFilter("costaccount", "=", (Object)costaccountId));
            qFilters.add(new QFilter("costcenter", "=", (Object)costcenterId));
            Map<String, Boolean> hourExpenseInfo = SysParamHelper.getHourExpense(orgId);
            Boolean exist = hourExpenseInfo.get(HourExpenseEnum.TRADE.getValue());
            if (exist != null && exist.booleanValue()) {
                DynamicObject trade = data.getDynamicObject("trade");
                if (trade == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u884c\u4e1a,\u8bf7\u586b\u5199\u884c\u4e1a\u3002", (String)"WorkHoursRateEffectValidate_0", (String)"macc-eca", (Object[])new Object[0]));
                    continue;
                }
                qFilters.add(new QFilter("trade", "=", trade.getPkValue()));
            } else {
                qFilters.add(new QFilter("trade", "=", (Object)0L));
            }
            exist = hourExpenseInfo.get(HourExpenseEnum.ROLE.getValue());
            if (exist != null && exist.booleanValue()) {
                DynamicObject role = data.getDynamicObject("role");
                if (role == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u89d2\u8272,\u8bf7\u586b\u5199\u89d2\u8272\u3002", (String)"WorkHoursRateEffectValidate_1", (String)"macc-eca", (Object[])new Object[0]));
                    continue;
                }
                qFilters.add(new QFilter("role", "=", role.getPkValue()));
            } else {
                qFilters.add(new QFilter("role", "=", (Object)" "));
            }
            exist = hourExpenseInfo.get(HourExpenseEnum.RESOURCE.getValue());
            if (exist != null && exist.booleanValue()) {
                DynamicObject resource = data.getDynamicObject("resource");
                if (resource == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u201c\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\u201d\u4e2d\u52fe\u9009\u4e86\u8d44\u6e90,\u8bf7\u586b\u5199\u8d44\u6e90\u3002", (String)"WorkHoursRateEffectValidate_2", (String)"macc-eca", (Object[])new Object[0]));
                    continue;
                }
                qFilters.add(new QFilter("resource", "=", resource.getPkValue()));
            } else {
                qFilters.add(new QFilter("resource", "=", (Object)0L));
            }
            if (Boolean.TRUE.equals(enableEffectByOrg)) {
                Date effectDate = data.getDate("effectdate");
                Date expDate = data.getDate("expdate");
                if (effectDate == null || expDate == null || expDate.compareTo(nowDate) > 0) {
                    QFilter dateQFilter = new QFilter("effectdate", "<=", (Object)nowDate).and(new QFilter("expdate", ">=", (Object)nowDate));
                    QFilter nullDateQFilter = new QFilter("effectdate", "is null", null).and(new QFilter("expdate", "is null", null));
                    qFilters.add(dateQFilter.or(nullDateQFilter));
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u6570\u636e\u5df2\u5931\u6548\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"WorkHoursRateEffectValidate_3", (String)"macc-eca", (Object[])new Object[0]), data.getString("billno")));
                    continue;
                }
            }
            DataSet exists = QueryServiceHelper.queryDataSet((String)"", (String)"eca_workhoursrate", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            while (exists.hasNext()) {
                Row next = exists.next();
                String billno = next.getString("billno");
                tips.append(billno).append('\uff0c');
            }
            int length = tips.length();
            if (length <= 1) continue;
            tips.setLength(length - 1);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3001\u6210\u672c\u4e2d\u5fc3\u3001\u6210\u672c\u8d26\u7c3f\u3001\u884c\u4e1a\u3001\u89d2\u8272\u3001\u8d44\u6e90\u90fd\u76f8\u540c\u7684\u5355\u636e\u201c%s\u201d\u7684\u6570\u636e\u5df2\u7ecf\u751f\u6548\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"WorkHoursRateEffectValidate_5", (String)"macc-eca", (Object[])new Object[0]), tips.toString()));
        }
    }
}

