/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.opplugin.price;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.DateUtils;

public class WorkHoursRateUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getPropertys("eca_workhoursrate"));
        fieldKeys.addAll(this.getEntryPropertys("eca_workhoursrate", "entryentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Date date;
                    DynamicObject checkData = dataEntity.getDataEntity();
                    if (!SysParamHelper.getEnableEffectByOrg((Long)checkData.getLong("org.id"), (String)"eca", (String)"eca_workhoursrate").booleanValue() || (date = checkData.getDate("expdate")) == null || date.compareTo(new Date()) >= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\uff0c\u5982\u9700\u53cd\u5ba1\u6838\u8bf7\u5148\u5173\u95ed\u671f\u95f4\u5f00\u5173\u3002", (String)"WorkHoursRateUnAuditOpPlugin_0", (String)"macc-eca", (Object[])new Object[0]), checkData.getString("billno")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Date opDate = new Date();
        ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            if (SysParamHelper.getEnableEffectByOrg((Long)dataEntity.getLong("org.id"), (String)"eca", (String)"eca_workhoursrate").booleanValue()) {
                DynamicObject newProductData = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
                String newNumber = newProductData.getString("billno");
                newProductData.set("billno", (Object)(newNumber + DateUtils.formatDate((Date)new Date(), (String)"ddHHmmss")));
                newProductData.set("expdate", (Object)opDate);
                newProductData.set("billstatus", (Object)"C");
                newProductData.set("sourceid", (Object)dataEntity.getLong("id"));
                DynamicObject role = newProductData.getDynamicObject("role");
                saveDataLIst.add(newProductData);
                dataEntity.set("effectdate", (Object)opDate);
                Date invalidDate = dataEntity.getDate("expdate");
                if (invalidDate == null) {
                    dataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                }
            }
            dataEntity.set("auditdate", null);
            dataEntity.set("auditor", null);
        }
        if (saveDataLIst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
        }
    }

    private Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    private Set<String> getEntryPropertys(String entryName, String entry) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            if (!transField.getFullFieldName().startsWith(entry)) continue;
            String fieldName = transField.getFieldName();
            dateFields.add(fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName);
        }
        return dateFields;
    }
}

