/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterSchemeService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.eca.common.helper.CostObjectHelper;
import kd.macc.eca.report.cost.CostDetailItemParam;

public class CostDetailItemRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(CostDetailItemRptPlugin.class);
    private CostDetailItemParam costDetailItemParam;
    private Boolean isSumLink = Boolean.FALSE;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billnoid"});
        this.addClickListeners(new String[]{"mulsrcbillnumber"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "srcbillno");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("srcbillno".equals(key)) {
                    CostDetailItemRptPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailItemRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("mulcostcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailItemRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit curPeriod = (BasedataEdit)this.getControl("mulperiod");
        curPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostDetailItemRptPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit costcentergroup = (BasedataEdit)this.getControl("costcentergroup");
        costcentergroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostDetailItemRptPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter calorgFilter = new QFilter("org", "in", org.getPkValue());
            qFilters.add(calorgFilter);
        });
        BasedataEdit subelement = (BasedataEdit)this.getControl("mulsubelement");
        subelement.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection subelementDy = (DynamicObjectCollection)this.getModel().getValue("mulsubelement");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)subelementDy)) {
                return;
            }
            List collect = subelementDy.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("id", "not in", collect));
        });
        MulBasedataEdit costobject = (MulBasedataEdit)this.getControl("mulcostobject");
        costobject.addBeforeF7SelectListener(evt -> {
            List costcenterIds;
            DynamicObjectCollection costcenterDatas;
            List collect;
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailItemRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object mulPeriod = this.getModel().getValue("mulperiod");
            if (ObjectUtils.isEmpty((Object)mulPeriod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002", (String)"CostDetailItemRptPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection subelementDy = (DynamicObjectCollection)this.getModel().getValue("mulcostobject");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)subelementDy) && !CollectionUtils.isEmpty(collect = subelementDy.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()))) {
                QFilter idQf = new QFilter("id", "not in", collect);
                qFilters.add(idQf);
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(costcenterDatas = (DynamicObjectCollection)this.getModel().getValue("mulcostcenter"))) && !CollectionUtils.isEmpty(costcenterIds = costcenterDatas.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()))) {
                QFilter costcenterQf = new QFilter("costcenter", "in", costcenterIds);
                qFilters.add(costcenterQf);
            }
            qFilters.add(new QFilter("producttype", "=", (Object)"C"));
        });
        MulBasedataEdit mulProjectNumber = (MulBasedataEdit)this.getControl("mulprojectnumber");
        mulProjectNumber.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter idFilter;
            DynamicObjectCollection costobjects;
            DynamicObjectCollection costCenterObj;
            List costCenterIds;
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailItemRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject costCenterGroupObj = this.getModel().getDataEntity().getDynamicObject("costcentergroup");
            if (costCenterGroupObj != null && !CadEmptyUtils.isEmpty((List)(costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupObj.getLong("id"))))) {
                QFilter idFilter2 = new QFilter("costcenter", "in", (Object)costCenterIds);
                orgFilter.and(idFilter2);
            }
            if ((costCenterObj = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter")) != null && costCenterObj.size() > 0) {
                List costCenterIds2 = costCenterObj.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter idFilter3 = new QFilter("costcenter", "in", costCenterIds2);
                orgFilter.and(idFilter3);
            }
            if ((costobjects = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostobject")) != null && costobjects.size() > 0) {
                List costobjectIds = costobjects.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                idFilter = new QFilter("id", "in", costobjectIds);
                orgFilter.and(idFilter);
            }
            orgFilter.and(new QFilter("projectnumber", ">", (Object)0L));
            List<Long> ids = CostObjectHelper.getProjectNumberIds(orgFilter);
            idFilter = new QFilter("id", "in", ids);
            qFilters.add(idFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetFilterGrid();
    }

    private void setPeriod() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount != null) {
            this.getModel().setValue("mulPeriod", (Object)new Object[]{this.getCurrPeriod()});
            this.getView().updateView("mulPeriod");
        }
    }

    private void setMainCostAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long costaccountId = this.getCostAccountByOrg(org.getLong("id"));
            this.getModel().setValue("costaccount", (Object)costaccountId);
            this.getView().updateView("costaccount");
        }
    }

    private Long getCostAccountByOrg(long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isEndInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter isMainAccount = new QFilter("entryentity.costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)"eca");
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isEndInitFilter, isMainAccount, appnumFilter};
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        return costAccount == null ? 0L : costAccount.getLong("costaccountid");
    }

    private Long getCurrPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return 0L;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return 0L;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
        if (res != null) {
            return res.getLong("currentperiod");
        }
        return 0L;
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        HashSet<String> showPros = new HashSet<String>(16);
        showPros.add("orderby");
        showPros.add("srcbillid");
        showPros.add("calbasis");
        showPros.add("mulprojectnumber");
        showPros.add("mulsrcbillnumber");
        showPros.add("costcenternum");
        showPros.add("subelementnum");
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName, showPros)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName, Set<String> showPros) {
        String[] split = fieldName.split("\\.");
        return !showPros.contains(split[0]) && !fieldName.contains(".longnumber") && !fieldName.contains(".fullname");
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && "mulsrcbillnumber".equalsIgnoreCase((textEdit = (TextEdit)evt.getSource()).getKey())) {
            this.showSrcBillNumberSelectPage();
        }
    }

    private void showSrcBillNumberSelectPage() {
        List costCenterIds;
        DynamicObjectCollection costCenterObj;
        List costCenterIds2;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailItemRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        ArrayList costCenterIdList = Lists.newArrayList();
        DynamicObject costCenterGroupObj = this.getModel().getDataEntity().getDynamicObject("costcentergroup");
        if (costCenterGroupObj != null && !CadEmptyUtils.isEmpty((List)(costCenterIds2 = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupObj.getLong("id"))))) {
            costCenterIdList.addAll(costCenterIds2);
        }
        if ((costCenterObj = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter")) != null && costCenterObj.size() > 0 && !CadEmptyUtils.isEmpty(costCenterIds = costCenterObj.stream().map(costcenter -> costcenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            costCenterIdList.addAll(costCenterIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eca_srcbillnumber");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("orgId", (Object)org.getLong("id"));
        fsp.setCustomParam("costCenterIds", (Object)costCenterIdList);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getSrcbillnumber"));
        this.getView().showForm(fsp);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection projectnumbers;
        String calrange;
        this.getPageCache().put("hasquery", "true");
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "mulperiod"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostDetailItemRptPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        String calBasis = (String)this.getModel().getValue("calbasis");
        if ("srcbillnumber".equals(calBasis) && CadEmptyUtils.isEmpty((String)(calrange = (String)this.getModel().getValue("calrangevalues_tag")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostDetailItemRptPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        if ("projectnumber".equals(calBasis) && CadEmptyUtils.isEmpty((DynamicObjectCollection)(projectnumbers = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostDetailItemRptPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        CostDetailItemParam costDetailItemParam = this.buildCostDetailItemParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(CostDetailItemParam.class.getName(), costDetailItemParam);
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "getSrcbillnumber": {
                String selectData = (String)evt.getReturnData();
                if (CadEmptyUtils.isEmpty((String)selectData)) {
                    return;
                }
                String selectDataValue = selectData;
                if (selectData.length() > 1024) {
                    selectDataValue = selectData.substring(0, 1024);
                }
                this.getModel().setValue("mulsrcbillnumber", (Object)selectDataValue);
                this.getModel().setValue("calrangevalues_tag", (Object)selectData);
                break;
            }
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setMainCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriod();
                this.setCurrency();
                break;
            }
            case "calbasis": {
                this.setQcalBasis();
                break;
            }
        }
    }

    private void setOther() {
        this.getModel().setValue("costcentergroup", null);
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("mulperiod", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulprojectnumber", null);
        this.getModel().setValue("mulsrcbillnumber", null);
        this.getModel().setValue("calrangevalues_tag", null);
    }

    private void setQcalBasis() {
        String calBasis = (String)this.getModel().getValue("calbasis");
        if ("srcbillnumber".equals(calBasis)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulsrcbillnumber"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulprojectnumber"});
            this.getModel().setValue("mulprojectnumber", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulsrcbillnumber"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulprojectnumber"});
            this.getModel().setValue("mulsrcbillnumber", null);
        }
        this.getModel().setValue("calrangevalues_tag", (Object)"");
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
    }

    public void beforeBindData(EventObject e) {
        Object mulPeriod;
        DynamicObject costaccount;
        super.beforeBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
            this.getView().updateView("org");
        }
        if ((costaccount = (DynamicObject)this.getModel().getValue("costaccount")) == null) {
            this.setMainCostAccount();
        }
        if (ObjectUtils.isEmpty((Object)(mulPeriod = this.getModel().getValue("mulperiod")))) {
            this.setPeriod();
        }
        if (this.getModel().getValue("currency") == null) {
            this.setCurrency();
        }
        this.setQcalBasis();
        this.getCostDetailItemParam();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isHyperLink = (String)fsp.getCustomParam("isHyperLink");
        if (!CadEmptyUtils.isEmpty((String)isHyperLink) && !"true".equals(this.getPageCache().get("hasquery"))) {
            if (this.getCostDetailItemParam() != null) {
                this.getView().getModel().getValue("mulsrcbillnumber");
                String calBasis = (String)this.getModel().getValue("calbasis");
                if ("srcbillnumber".equals(calBasis)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulsrcbillnumber"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulprojectnumber"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulsrcbillnumber"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulprojectnumber"});
                }
            }
            this.RemoveDefaultFilterScheme(this.getView());
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    private void RemoveDefaultFilterScheme(IReportView view) {
        try {
            ReportFilter custCont = ((ReportView)view).getCustomFilterContainer();
            Method privateMethod = ReflectionUtils.findMethod(ReportFilter.class, (String)"getSchemeList");
            if (privateMethod == null) {
                return;
            }
            AccessibleObject.setAccessible(new AccessibleObject[]{privateMethod}, true);
            List schemeList = (List)privateMethod.invoke((Object)custCont, new Object[0]);
            FilterScheme defaultScheme = FilterSchemeService.getDefaultSchemeFromAll((List)schemeList);
            if (defaultScheme != null) {
                schemeList.remove(defaultScheme);
            }
        }
        catch (Exception ex) {
            logger.error("RemoveDefaultFilterScheme error -> {}", (Object)ex.getMessage());
        }
    }

    private CostDetailItemParam getCostDetailItemParam() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(CostDetailItemParam.class.getName());
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            this.costDetailItemParam = (CostDetailItemParam)SerializationUtils.fromJsonString((String)openParamStr, CostDetailItemParam.class);
            this.getModel().setValue("org", (Object)this.costDetailItemParam.getOrgId());
            this.getModel().setValue("costaccount", (Object)this.costDetailItemParam.getCostAccountId());
            this.getModel().setValue("currency", (Object)this.costDetailItemParam.getCurrencyId());
            Set<Long> periodIds = this.costDetailItemParam.getPeriodIds();
            this.getModel().setValue("mulperiod", (Object)periodIds.toArray());
            if (this.costDetailItemParam.getCostCenterGroupId() != null) {
                this.getModel().setValue("costcentergroup", (Object)this.costDetailItemParam.getCostCenterGroupId());
            }
            this.isSumLink = this.costDetailItemParam.getIsSumLink();
            if (this.costDetailItemParam.getCostCenterIds() != null) {
                this.getModel().setValue("mulcostcenter", (Object)this.costDetailItemParam.getCostCenterIds().toArray());
            }
            if (this.costDetailItemParam.getSubElementIds() != null) {
                this.getModel().setValue("mulsubelement", (Object)this.costDetailItemParam.getSubElementIds().toArray());
            }
            this.getModel().setValue("calbasis", (Object)this.costDetailItemParam.getCalbasis());
            this.getModel().setValue("calrangevalues_tag", (Object)this.costDetailItemParam.getCalrange());
            if (!CadEmptyUtils.isEmpty(this.costDetailItemParam.getProjectNumberIds())) {
                this.getModel().setValue("mulprojectnumber", (Object)this.costDetailItemParam.getProjectNumberIds().toArray());
            }
            this.getModel().setValue("mulsrcbillnumber", (Object)this.costDetailItemParam.getSrcBillNumbers());
        }
        return this.costDetailItemParam;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostDetailItemRptPlugin_6", (String)"macc-eca", (Object[])new Object[0]);
        String caption = this.getView().getFormShowParameter().getCaption();
        String checkType = String.format(ResManager.loadKDString((String)"%s\u67e5\u8be2", (String)"CostDetailItemRptPlugin_7", (String)"macc-eca", (Object[])new Object[0]), caption);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    private CostDetailItemParam buildCostDetailItemParam(DynamicObject dataEntity) {
        DynamicObjectCollection dscostobject;
        DynamicObjectCollection costcenter;
        CostDetailItemParam costDetailItemParam = new CostDetailItemParam();
        costDetailItemParam.setIsSumLink(this.isSumLink);
        costDetailItemParam.setOrgId(dataEntity.getLong("org.id"));
        costDetailItemParam.setCostAccountId(dataEntity.getLong("costaccount.id"));
        costDetailItemParam.setCurrencyId(dataEntity.getLong("currency.id"));
        DynamicObjectCollection mulPeriod = dataEntity.getDynamicObjectCollection("mulperiod");
        HashSet<Long> periodIds = new HashSet<Long>(12);
        mulPeriod.forEach(s -> periodIds.add(s.getLong("fbasedataid.id")));
        costDetailItemParam.setPeriodIds(periodIds);
        costDetailItemParam.setCalbasis(dataEntity.getString("calbasis"));
        String mulsrcbillnumber = (String)this.getModel().getValue("mulsrcbillnumber");
        costDetailItemParam.setSrcBillNumbers(mulsrcbillnumber);
        costDetailItemParam.setCalrange(dataEntity.getString("calrangevalues_tag"));
        DynamicObjectCollection projectnumbers = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber");
        if (projectnumbers != null) {
            costDetailItemParam.setProjectNumberIds(projectnumbers.stream().map(projectnumber -> projectnumber.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        long costcentergroupId = dataEntity.getLong("costcentergroup.id");
        Set costCenterIds = null;
        if (!CadEmptyUtils.isEmpty((Long)costcentergroupId)) {
            costDetailItemParam.setCostCenterGroupId(costcentergroupId);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"buildCostDetailItemParam", (String)"cad_costcentergroup", (String)"entryentity.costcenter as costcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costcentergroupId)}, null);
            costCenterIds = new HashSet(16);
            while (rows.hasNext()) {
                Row next = rows.next();
                Long costcenter2 = next.getLong("costcenter");
                costCenterIds.add(costcenter2);
            }
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costcenter = dataEntity.getDynamicObjectCollection("mulcostcenter")))) {
            Set id = costcenter.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (costCenterIds == null) {
                costCenterIds = id;
            } else {
                costCenterIds.retainAll(id);
            }
        }
        costDetailItemParam.setCostCenterIds(costCenterIds);
        DynamicObjectCollection subelement = dataEntity.getDynamicObjectCollection("mulsubelement");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)subelement)) {
            Set<Long> id = subelement.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
            costDetailItemParam.setSubElementIds(id);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(dscostobject = dataEntity.getDynamicObjectCollection("mulcostobject")))) {
            Set<Long> id = dscostobject.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
            costDetailItemParam.setCostObjectIds(id);
        }
        return costDetailItemParam;
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        Long billId = row.getLong("srcbillid");
        DynamicObject billtype = row.getDynamicObject("billtype");
        if (billtype == null) {
            return;
        }
        String bizEntityObject = billtype.getString("number");
        if (CadEmptyUtils.isEmpty((Long)billId)) {
            String billno = row.getString("srcbillno");
            List ids = QueryServiceHelper.queryPrimaryKeys((String)bizEntityObject, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)}, null, (int)1);
            if (CadEmptyUtils.isEmpty((List)ids)) {
                return;
            }
            billId = (Long)ids.get(0);
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

