/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.report.cost.CostDetailItemDiyTotalRow;
import kd.macc.eca.report.cost.CostDetailItemHandleRow;
import kd.macc.eca.report.cost.CostDetailItemParam;

public class CostDetailItemSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostDetailItemSourceCf.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"orderby", "currency", "costcenter", "srcbillid"});
    private CostDetailItemParam costDetailItemParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costDetailItemParam = (CostDetailItemParam)ctx.getParam(CostDetailItemParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        Iterator<SrcBlockConf> selectBlockOr = blockCollector.iterator();
        Set<Long> costObjectIds = this.costDetailItemParam.getCostObjectIds();
        while (selectBlockOr.hasNext()) {
            QFilter costObjectQf;
            SrcBlockConf blockConf = selectBlockOr.next();
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if ("eca_init".equals(srcEntity)) {
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    costObjectQf = new QFilter("costobject", "in", costObjectIds);
                    dataFs = dataFs == null ? costObjectQf : dataFs.and(costObjectQf);
                }
            } else if ("eca_costcarrybill".equals(srcEntity) && !CadEmptyUtils.isEmpty(costObjectIds)) {
                costObjectQf = new QFilter("entryentity.costobject", "in", costObjectIds);
                dataFs = dataFs == null ? costObjectQf : dataFs.and(costObjectQf);
            }
            blockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"CostDetailItemSourceCf_0", (String)"macc-eca", (Object[])new Object[0]));
        transCollector.add(new CostDetailItemHandleRow(this.costDetailItemParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        this.logger.info("\u5728\u6dfb\u52a0\u6c47\u603b\u884c\u524d\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\uff0c\u6216\u8005\u5176\u4ed6\u4e0a\u4e0b\u6587\u8bbe\u7f6e");
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new CostDetailItemDiyTotalRow(this.costDetailItemParam, ctx));
    }

    private List<QFilter> getFixedFilter() {
        String calRange;
        List<Long> projectNumberIds;
        Set<Long> subElementIds;
        Set<Long> costCenterIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>();
        Long orgId = this.costDetailItemParam.getOrgId();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        commonFilters.add(orgQf);
        Long costAccountId = this.costDetailItemParam.getCostAccountId();
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        commonFilters.add(costAccountQf);
        Boolean isSumLink = this.costDetailItemParam.getIsSumLink();
        Set<Long> periodIds = this.costDetailItemParam.getPeriodIds();
        if (!CadEmptyUtils.isEmpty(periodIds)) {
            if (periodIds.size() == 1) {
                QFilter periodQf;
                Long periodId = 0L;
                Iterator<Long> iterator = periodIds.iterator();
                while (iterator.hasNext()) {
                    Long period;
                    periodId = period = iterator.next();
                }
                if (isSumLink.booleanValue()) {
                    periodQf = new QFilter("period", "<=", (Object)periodId);
                    commonFilters.add(periodQf);
                } else {
                    periodQf = new QFilter("period", "=", (Object)periodId);
                    commonFilters.add(periodQf);
                }
            } else {
                QFilter periodQf = new QFilter("period", "in", periodIds);
                commonFilters.add(periodQf);
            }
        }
        if ((costCenterIds = this.costDetailItemParam.getCostCenterIds()) != null) {
            QFilter costcenterQf = new QFilter("costcenter", "in", costCenterIds);
            commonFilters.add(costcenterQf);
        }
        if (!CadEmptyUtils.isEmpty(subElementIds = this.costDetailItemParam.getSubElementIds())) {
            QFilter subElementIdQf = new QFilter("subelement", "in", subElementIds);
            commonFilters.add(subElementIdQf);
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = this.costDetailItemParam.getProjectNumberIds())) {
            commonFilters.add(new QFilter("costobject.projectnumber", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(calRange = this.costDetailItemParam.getCalrange()))) {
            String[] calRangeValue = calRange.split(";");
            commonFilters.add(new QFilter("costobject.srcbillnumber", "in", (Object)calRangeValue));
        }
        return commonFilters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        for (ReportColumn reportColumn : cols) {
            String fieldKey = reportColumn.getFieldKey();
            if (this.hideProps.contains(fieldKey)) {
                reportColumn.setHide(true);
                continue;
            }
            if ("srcbillno".equals(fieldKey)) {
                reportColumn.setHyperlink(true);
                continue;
            }
            if (!"qty".equals(fieldKey)) continue;
            reportColumn.setMeasureUnitField("unit");
            reportColumn.setFieldType("qty");
        }
        return cols;
    }
}

