/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.eca.common.util.BigDecimalUtil;
import kd.macc.eca.report.cost.EcaCostSumParam;

public class EcaCostSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private EcaCostSumParam ecaCostSumParam;

    public EcaCostSumFunction(RowMeta rowMeta, EcaCostSumParam ecaCostSumParam) {
        this.rowMeta = rowMeta;
        this.ecaCostSumParam = ecaCostSumParam;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Boolean showbehavior = this.ecaCostSumParam.getShowBehavior();
        Boolean showsumqty = this.ecaCostSumParam.getShowSumQty();
        ArrayList<RowX> targetRows = new ArrayList<RowX>(16);
        HashMap<String, List> roxMap = new HashMap<String, List>(16);
        for (RowX row : iterable) {
            String calbasis = row.getString(this.rowMeta.getFieldIndex("calbasis"));
            String costCenterGroup = row.getString(this.rowMeta.getFieldIndex("costcentergroup"));
            Long costCenter = row.getLong(this.rowMeta.getFieldIndex("costcenter"));
            String key = calbasis + "@" + costCenterGroup + "@" + costCenter;
            roxMap.computeIfAbsent(key, s -> new ArrayList()).add(row);
        }
        for (Map.Entry entry : roxMap.entrySet()) {
            List rowXList = (List)entry.getValue();
            RowX row = (RowX)rowXList.get(0);
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal allTotalAmt = BigDecimal.ZERO;
            for (RowX rowX : rowXList) {
                BigDecimal amtSpB;
                int indexSpB;
                BigDecimal amtSpA;
                int indexSpA;
                String number = rowX.getString(this.rowMeta.getFieldIndex("subelementnumber"));
                String bizType = rowX.getString(this.rowMeta.getFieldIndex("biztype"));
                String sourceType = rowX.getString(this.rowMeta.getFieldIndex("sourcetype"));
                boolean isCurrentType = "C".equals(sourceType);
                String numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
                BigDecimal qty = isCurrentType ? BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("qty"))) : BigDecimal.ZERO;
                BigDecimal amt = isCurrentType ? BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("amt"))) : BigDecimal.ZERO;
                Long id = rowX.getLong(this.getSourceRowMeta().getFieldIndex("subelement"));
                row.set(this.getSourceRowMeta().getFieldIndex(numberStr + "amt" + bizType.toLowerCase()), (Object)amt);
                row.set(this.getSourceRowMeta().getFieldIndex(numberStr + "qty" + bizType.toLowerCase()), (Object)qty);
                row.set(this.getSourceRowMeta().getFieldIndex(numberStr + "id" + bizType.toLowerCase()), (Object)id);
                totalAmt = totalAmt.add(amt);
                BigDecimal sumQty = BigDecimal.ZERO;
                BigDecimal sumAmt = BigDecimal.ZERO;
                if (showsumqty.booleanValue()) {
                    sumQty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumqty")));
                    sumAmt = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumamt")));
                    row.set(this.getSourceRowMeta().getFieldIndex(numberStr + "qty" + bizType.toLowerCase() + "total"), (Object)sumQty);
                    row.set(this.getSourceRowMeta().getFieldIndex(numberStr + "amt" + bizType.toLowerCase() + "total"), (Object)sumAmt);
                    allTotalAmt = allTotalAmt.add(sumAmt);
                }
                if (!showbehavior.booleanValue()) continue;
                String behavior = rowX.getString(this.rowMeta.getFieldIndex("costbehavior"));
                if ("SW".equals(bizType)) {
                    BigDecimal amtSwB;
                    int indexSwB;
                    BigDecimal amtSwA;
                    int indexSwA;
                    if (showsumqty.booleanValue()) {
                        if ("A".equals(behavior)) {
                            indexSwA = this.getSourceRowMeta().getFieldIndex("costbehaviorswa");
                            amtSwA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwA));
                            row.set(indexSwA, (Object)amtSwA.add(amt));
                            int indexSwsumA = this.getSourceRowMeta().getFieldIndex("costbehaviorsumswa");
                            BigDecimal amtSwsumA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwsumA));
                            row.set(indexSwsumA, (Object)amtSwsumA.add(sumAmt));
                        }
                        if ("B".equals(behavior)) {
                            indexSwB = this.getSourceRowMeta().getFieldIndex("costbehaviorswb");
                            amtSwB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwB));
                            row.set(indexSwB, (Object)amtSwB.add(amt));
                            int indexSwsumB = this.getSourceRowMeta().getFieldIndex("costbehaviorsumswb");
                            BigDecimal amtSwsumB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwsumB));
                            row.set(indexSwsumB, (Object)amtSwsumB.add(sumAmt));
                        }
                    } else {
                        if ("A".equals(behavior)) {
                            indexSwA = this.getSourceRowMeta().getFieldIndex("costbehaviorswa");
                            amtSwA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwA));
                            row.set(indexSwA, (Object)amtSwA.add(amt));
                        }
                        if ("B".equals(behavior)) {
                            indexSwB = this.getSourceRowMeta().getFieldIndex("costbehaviorswb");
                            amtSwB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSwB));
                            row.set(indexSwB, (Object)amtSwB.add(amt));
                        }
                    }
                }
                if (!"SP".equals(bizType)) continue;
                if (showsumqty.booleanValue()) {
                    if ("A".equals(behavior)) {
                        indexSpA = this.getSourceRowMeta().getFieldIndex("costbehaviorspa");
                        amtSpA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpA));
                        row.set(indexSpA, (Object)amtSpA.add(amt));
                        int indexSpsumA = this.getSourceRowMeta().getFieldIndex("costbehaviorsumspa");
                        BigDecimal amtSpsumA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpsumA));
                        row.set(indexSpsumA, (Object)amtSpsumA.add(sumAmt));
                    }
                    if (!"B".equals(behavior)) continue;
                    indexSpB = this.getSourceRowMeta().getFieldIndex("costbehaviorspb");
                    amtSpB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpB));
                    row.set(indexSpB, (Object)amtSpB.add(amt));
                    int indexSpsumB = this.getSourceRowMeta().getFieldIndex("costbehaviorsumspb");
                    BigDecimal amtSpsumB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpsumB));
                    row.set(indexSpsumB, (Object)amtSpsumB.add(sumAmt));
                    continue;
                }
                if ("A".equals(behavior)) {
                    indexSpA = this.getSourceRowMeta().getFieldIndex("costbehaviorspa");
                    amtSpA = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpA));
                    row.set(indexSpA, (Object)amtSpA.add(amt));
                }
                if (!"B".equals(behavior)) continue;
                indexSpB = this.getSourceRowMeta().getFieldIndex("costbehaviorspb");
                amtSpB = BigDecimalUtil.getOrZero(row.getBigDecimal(indexSpB));
                row.set(indexSpB, (Object)amtSpB.add(amt));
            }
            row.set(this.getSourceRowMeta().getFieldIndex("totalamt"), (Object)totalAmt);
            row.set(this.getSourceRowMeta().getFieldIndex("alltotalamt"), (Object)allTotalAmt);
            targetRows.add(row);
        }
        for (RowX row : targetRows) {
            collector.collect(row);
        }
    }
}

