/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.macc.eca.report.cost.AddColsSumParam;
import kd.macc.eca.report.cost.EcaCostSumFunction;
import kd.macc.eca.report.cost.EcaCostSumParam;

public class EcaCostSumResultRow
implements IDataTransform {
    private final Log logger = LogFactory.getLog(EcaCostSumResultRow.class);
    private EcaCostSumParam ecaCostSumParam;
    private Map<String, AddColsSumParam> paramMap;
    private Set<String> behaviorSet;
    private Set<String> bizTypeSet;
    private List<String> qtyAndAmtCols = new ArrayList<String>(2);
    private List<String> qtyCols;
    private List<String> idCols = new ArrayList<String>(2);
    private List<String> amtCols;

    public EcaCostSumResultRow(EcaCostSumParam ecaCostSumParam, Map<String, AddColsSumParam> paramMap, Set<String> behaviorSet, Set<String> bizTypeSet, List<String> qtyCols, List<String> amtCols) {
        this.ecaCostSumParam = ecaCostSumParam;
        this.paramMap = paramMap;
        this.behaviorSet = behaviorSet;
        this.bizTypeSet = bizTypeSet;
        this.qtyCols = qtyCols;
        this.amtCols = amtCols;
    }

    public DataSet doTransform(DataSet srcData) {
        srcData = srcData.filter("subelement is not null and subelement > 0");
        DataSet srcDataCopy = srcData.copy();
        this.bulidDynamicColumnMap(srcDataCopy);
        JobSession session = AlgoX.createSession((String)"EcaCostSumResultRow_rMTDD");
        DataSetInput processingAllocInput = new DataSetInput(srcData);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        dataSetX = this.dataSetXAddField(dataSetX);
        dataSetX = dataSetX.groupBy(new String[]{"calbasis", "costcenter", "costcentergroup"}).reduceGroup((GroupReduceFunction)new EcaCostSumFunction(dataSetX.getRowMeta(), this.ecaCostSumParam));
        DataSetOutput dataSetOutput = new DataSetOutput(dataSetX.getRowMeta());
        String resultId = dataSetOutput.getId();
        dataSetX.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet result = session.readDataSet(resultId);
        result = result.removeFields(new String[]{"subelement", "subelementname", "subelementnumber", "costbehavior", "qty", "amt", "biztype"});
        if (this.ecaCostSumParam.getShowSumQty().booleanValue()) {
            result = result.removeFields(new String[]{"sumqty", "sumamt"});
        }
        result = this.buildSumTotal(result);
        result = result.orderBy(new String[]{"calbasis asc", "ccgroupnumber asc", "costcenternumber asc", "sumrow desc"});
        return result;
    }

    private DataSet buildSumTotal(DataSet result) {
        Boolean showccgroup = this.ecaCostSumParam.getShowCCGroup();
        if (showccgroup.booleanValue()) {
            DataSet temp;
            String sumStr = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"EcaCostSumResultRow_0", (String)"macc-eca", (Object[])new Object[0]);
            DataSet sumDataSet = result.groupBy(new String[]{"calbasis", "currency", "costcentergroup", "ccgroupnumber"}).sum("totalamt").sum("alltotalamt").finish().addField("0L", "costcenter").addField(sumStr, "costcentername").addField("''", "costcenternumber").addField("1", "sumrow").addField("''", "sourcetype").distinct();
            for (String field : this.qtyAndAmtCols) {
                temp = result.groupBy(new String[]{"calbasis", "currency", "costcentergroup", "ccgroupnumber"}).sum(field).finish();
                sumDataSet = sumDataSet.join(temp).on("calbasis", "calbasis").on("currency", "currency").on("costcentergroup", "costcentergroup").on("ccgroupnumber", "ccgroupnumber").select(sumDataSet.getRowMeta().getFieldNames(), new String[]{field}).finish();
            }
            for (String field : this.idCols) {
                temp = result.groupBy(new String[]{"calbasis", "currency", "costcentergroup", "ccgroupnumber", field}).finish();
                temp = temp.filter(field + " is not null and " + field + " != 0");
                sumDataSet = sumDataSet.join(temp).on("calbasis", "calbasis").on("currency", "currency").on("costcentergroup", "costcentergroup").on("ccgroupnumber", "ccgroupnumber").select(sumDataSet.getRowMeta().getFieldNames(), new String[]{field}).finish();
            }
            Boolean showCostCenter = this.ecaCostSumParam.getShowCostCenter();
            result = showCostCenter != false ? result.union(sumDataSet.select(result.getRowMeta().getFieldNames())) : sumDataSet.select(result.getRowMeta().getFieldNames());
        }
        return result;
    }

    private DataSetX dataSetXAddField(DataSetX dataSetX) {
        this.amtCols.add("totalamt");
        this.amtCols.add("alltotalamt");
        if (this.paramMap.size() > 0) {
            Boolean showsumqty = this.ecaCostSumParam.getShowSumQty();
            for (Map.Entry<String, AddColsSumParam> entry : this.paramMap.entrySet()) {
                String amtName = entry.getValue().getAmtName();
                String qtyName = entry.getValue().getQtyName();
                String idName = entry.getValue().getIdName();
                dataSetX = dataSetX.addFields(new Field[]{new Field(amtName, (DataType)DataType.BigDecimalType), new Field(qtyName, (DataType)DataType.BigDecimalType), new Field(idName, (DataType)DataType.LongType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, 0L});
                this.qtyAndAmtCols.add(amtName);
                this.qtyAndAmtCols.add(qtyName);
                this.amtCols.add(amtName);
                this.qtyCols.add(qtyName);
                this.idCols.add(idName);
                if (!showsumqty.booleanValue()) continue;
                dataSetX = dataSetX.addFields(new Field[]{new Field(amtName + "total", (DataType)DataType.BigDecimalType), new Field(qtyName + "total", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                this.qtyAndAmtCols.add(amtName + "total");
                this.qtyAndAmtCols.add(qtyName + "total");
                this.amtCols.add(amtName + "total");
                this.qtyCols.add(qtyName + "total");
            }
            Boolean showbehavior = this.ecaCostSumParam.getShowBehavior();
            if (showbehavior.booleanValue()) {
                if (this.bizTypeSet.contains("SW")) {
                    if (showsumqty.booleanValue()) {
                        if (this.behaviorSet.contains("A")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorswa", (DataType)DataType.BigDecimalType), new Field("costbehaviorsumswa", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorswa");
                            this.qtyAndAmtCols.add("costbehaviorsumswa");
                            this.amtCols.add("costbehaviorswa");
                            this.amtCols.add("costbehaviorsumswa");
                        }
                        if (this.behaviorSet.contains("B")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorswb", (DataType)DataType.BigDecimalType), new Field("costbehaviorsumswb", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorswb");
                            this.qtyAndAmtCols.add("costbehaviorsumswb");
                            this.amtCols.add("costbehaviorswb");
                            this.amtCols.add("costbehaviorsumswb");
                        }
                    } else {
                        if (this.behaviorSet.contains("A")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorswa", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorswa");
                            this.amtCols.add("costbehaviorswa");
                        }
                        if (this.behaviorSet.contains("B")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorswb", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorswb");
                            this.amtCols.add("costbehaviorswb");
                        }
                    }
                }
                if (this.bizTypeSet.contains("SP")) {
                    if (showsumqty.booleanValue()) {
                        if (this.behaviorSet.contains("A")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorspa", (DataType)DataType.BigDecimalType), new Field("costbehaviorsumspa", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorspa");
                            this.qtyAndAmtCols.add("costbehaviorsumspa");
                            this.amtCols.add("costbehaviorspa");
                            this.amtCols.add("costbehaviorsumspa");
                        }
                        if (this.behaviorSet.contains("B")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorspb", (DataType)DataType.BigDecimalType), new Field("costbehaviorsumspb", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorspb");
                            this.qtyAndAmtCols.add("costbehaviorsumspb");
                            this.amtCols.add("costbehaviorspb");
                            this.amtCols.add("costbehaviorsumspb");
                        }
                    } else {
                        if (this.behaviorSet.contains("A")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorspa", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorspa");
                            this.amtCols.add("costbehaviorspa");
                        }
                        if (this.behaviorSet.contains("B")) {
                            dataSetX = dataSetX.addFields(new Field[]{new Field("costbehaviorspb", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
                            this.qtyAndAmtCols.add("costbehaviorspb");
                            this.amtCols.add("costbehaviorspb");
                        }
                    }
                }
            }
        }
        this.logger.info("dataSetXAddField_bizTypeSet\uff1a" + this.bizTypeSet);
        this.logger.info("\u52a8\u6001\u6dfb\u52a0\u5217\uff1a" + this.qtyAndAmtCols);
        return dataSetX;
    }

    private void bulidDynamicColumnMap(DataSet srcDataCopy) {
        srcDataCopy = srcDataCopy.groupBy(new String[]{"subelement", "subelementnumber", "subelementname", "costbehavior", "biztype"}).finish().orderBy(new String[]{"subelementnumber asc"});
        for (Row next : srcDataCopy) {
            this.behaviorSet.add(next.getString("costbehavior"));
            String bizType = next.getString("biztype");
            if (!"SW".equals(bizType) && !"SP".equals(bizType)) continue;
            this.bizTypeSet.add(next.getString("biztype"));
            String number = next.getString("subelementnumber");
            String numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
            String name = next.getString("subelementname");
            String bizTypeStr = next.getString("biztype");
            AddColsSumParam sumParam = new AddColsSumParam(numberStr + "qty" + bizTypeStr.toLowerCase(), numberStr + "amt" + bizTypeStr.toLowerCase(), next.getString("costbehavior"), bizTypeStr, numberStr + "id" + bizTypeStr.toLowerCase());
            this.paramMap.put(number + " / " + name + " / " + bizTypeStr, sumParam);
        }
        this.logger.info("bizTypeSet\uff1a" + this.bizTypeSet);
    }
}

