/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.eca.common.helper.CostObjectHelper;
import kd.macc.eca.report.cost.CostDetailItemParam;
import kd.macc.eca.report.cost.EcaCostSumParam;

public class EcaCostSumRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"EcaCostSumRptPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit costCenterGroup = (BasedataEdit)this.getControl("costcentergroup");
        costCenterGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(new QFilter("org", "=", (Object)acctOrgId));
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            qFilters.add(dateFilter);
        });
        MulBasedataEdit mulCostCenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulCostCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List costCenterIds;
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
            DynamicObject costCenterGroupObj = this.getModel().getDataEntity().getDynamicObject("costcentergroup");
            if (costCenterGroupObj != null && !CadEmptyUtils.isEmpty((List)(costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupObj.getLong("id"))))) {
                QFilter idFilter = new QFilter("id", "in", (Object)costCenterIds);
                qFilters.add(idFilter);
            }
        });
        MulBasedataEdit mulProjectNumber = (MulBasedataEdit)this.getControl("mulprojectnumber");
        mulProjectNumber.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter idFilter;
            DynamicObjectCollection costCenterObj;
            List costCenterIds;
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject costCenterGroupObj = this.getModel().getDataEntity().getDynamicObject("costcentergroup");
            if (costCenterGroupObj != null && !CadEmptyUtils.isEmpty((List)(costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupObj.getLong("id"))))) {
                QFilter idFilter2 = new QFilter("costcenter", "in", (Object)costCenterIds);
                orgFilter.and(idFilter2);
            }
            if ((costCenterObj = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter")) != null && costCenterObj.size() > 0) {
                List costCenterIds2 = costCenterObj.stream().map(costcenter -> costcenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                idFilter = new QFilter("costcenter", "in", costCenterIds2);
                orgFilter.and(idFilter);
            }
            orgFilter.and(new QFilter("projectnumber", ">", (Object)0L));
            List<Long> ids = CostObjectHelper.getProjectNumberIds(orgFilter);
            idFilter = new QFilter("id", "in", ids);
            qFilters.add(idFilter);
        });
        this.addClickListeners(new String[]{"mulsrcbillnumber"});
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                EcaCostSumRptPlugin.this.hyperLinkBillNoClick(evt);
            }
        });
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        Boolean showCostCenter;
        Boolean showCCGroup;
        QFilter numberQFilter;
        DynamicObject projectDy;
        String projectNumber;
        String keyValueSub;
        String keyValue = evt.getFieldName();
        CostDetailItemParam param = new CostDetailItemParam();
        ReportList rptList = (ReportList)evt.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(evt.getRowIndex());
        FilterInfo filterInfo = rptList.getReportModel().getReportQueryParam().getFilter();
        int sumrow = row.getInt("sumrow");
        Boolean isSumLink = keyValue.endsWith("total");
        param.setIsSumLink(isSumLink);
        Boolean isSW = Boolean.FALSE;
        String string = keyValueSub = isSumLink != false ? keyValue.substring(0, keyValue.length() - 5) : keyValue;
        if (keyValueSub.endsWith("sw")) {
            isSW = Boolean.TRUE;
        }
        String subelementNumber = isSumLink != false ? keyValue.substring(0, keyValue.length() - 10) : keyValue.substring(0, keyValue.length() - 5);
        param.setIsSumLink(isSumLink);
        String formId = "eca_costdetailitemrpt";
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        DynamicObject period = filterInfo.getDynamicObject("period");
        String calBasis = filterInfo.getString("qcalbasis");
        String mulsrcbillnumber = (String)this.getModel().getValue("mulsrcbillnumber");
        String calrangeValues = (String)this.getModel().getValue("calrangevalues_tag");
        param.setOrgId(org.getLong("id"));
        param.setCostAccountId(costaccount.getLong("id"));
        DynamicObject currency = filterInfo.getDynamicObject("currency");
        param.setCurrencyId(currency.getLong("id"));
        param.setPeriodIds(Sets.newHashSet((Object[])new Long[]{period.getLong("id")}));
        param.setCalbasis(calBasis);
        param.setCalrange(calrangeValues);
        param.setSrcBillNumbers(mulsrcbillnumber);
        if (calBasis.equals("projectnumber") && !CadEmptyUtils.isEmpty((String)(projectNumber = row.getString("calbasis"))) && (projectDy = QueryServiceHelper.queryOne((String)"bd_project", (String)"id", (QFilter[])(numberQFilter = new QFilter("number", "=", (Object)projectNumber)).toArray())) != null) {
            long projectId = projectDy.getLong("id");
            param.setProjectNumberIds(Collections.singletonList(projectId));
            if (isSumLink.booleanValue()) {
                QFilter idQFilter = new QFilter("projectnumber", "=", (Object)projectId);
                idQFilter.and("biztype", "=", (Object)"SP");
                idQFilter.and("org", "=", (Object)org.getLong("id"));
                DynamicObject costObject = QueryServiceHelper.queryOne((String)"cad_costobject", (String)"id", (QFilter[])idQFilter.toArray());
                if (costObject != null) {
                    QFilter qFilter = new QFilter("costobject", "=", (Object)costObject.getLong("id"));
                    DataSet initDs = QueryServiceHelper.queryDataSet((String)"getInit", (String)"eca_init", (String)"entryentity.period as period", (QFilter[])qFilter.toArray(), null);
                    QFilter cFilter = new QFilter("entryentity.costobject", "=", (Object)costObject.getLong("id"));
                    DataSet carryDs = QueryServiceHelper.queryDataSet((String)"getcarry", (String)"eca_costcarrybill", (String)"period", (QFilter[])cFilter.toArray(), null);
                    initDs = initDs.union(carryDs);
                    HashSet<Long> periodIds = new HashSet<Long>(12);
                    initDs.forEach(s -> periodIds.add(s.getLong("period")));
                    if (!CadEmptyUtils.isEmpty(periodIds)) {
                        param.setPeriodIds(periodIds);
                    }
                }
            }
        }
        if ((showCCGroup = (Boolean)this.getModel().getValue("showccgroup")).booleanValue()) {
            param.setCostCenterGroupId(row.getLong("costcentergroup.id"));
        }
        if ((showCostCenter = (Boolean)this.getModel().getValue("showcostcenter")).booleanValue() && sumrow == 0) {
            param.setCostCenterIds(Sets.newHashSet((Object[])new Long[]{row.getLong("costcenter.id")}));
        }
        String subelementIdKey = isSW != false ? subelementNumber + "idsw" : subelementNumber + "idsp";
        Long subelementId = row.getLong(subelementIdKey);
        param.setSubElementIds(Sets.newHashSet((Object[])new Long[]{subelementId}));
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam(CostDetailItemParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)param));
        showParameter.setCustomParam("isHyperLink", (Object)"isHyperLink");
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && "mulsrcbillnumber".equalsIgnoreCase((textEdit = (TextEdit)evt.getSource()).getKey())) {
            this.showSrcBillNumberSelectPage();
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"EcaCostSumRptPlugin_3", (String)"macc-eca", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u670d\u52a1\u6210\u672c\u6c47\u603b\u8868\u67e5\u8be2", (String)"EcaCostSumRptPlugin_4", (String)"macc-eca", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"eca_costsumrpt", (IDataModel)this.getModel());
    }

    private void showSrcBillNumberSelectPage() {
        List costCenterIds;
        DynamicObjectCollection costCenterObj;
        List costCenterIds2;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EcaCostSumRptPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        ArrayList costCenterIdList = Lists.newArrayList();
        DynamicObject costCenterGroupObj = this.getModel().getDataEntity().getDynamicObject("costcentergroup");
        if (costCenterGroupObj != null && !CadEmptyUtils.isEmpty((List)(costCenterIds2 = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupObj.getLong("id"))))) {
            costCenterIdList.addAll(costCenterIds2);
        }
        if ((costCenterObj = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter")) != null && costCenterObj.size() > 0 && !CadEmptyUtils.isEmpty(costCenterIds = costCenterObj.stream().map(costcenter -> costcenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            costCenterIdList.addAll(costCenterIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eca_srcbillnumber");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("orgId", org.get("id"));
        fsp.setCustomParam("costCenterIds", (Object)costCenterIdList);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getSrcbillnumber"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "getSrcbillnumber": {
                String selectData = (String)evt.getReturnData();
                if (CadEmptyUtils.isEmpty((String)selectData)) {
                    return;
                }
                String selectDataValue = selectData;
                if (selectData.length() > 1024) {
                    selectDataValue = selectData.substring(0, 1024);
                }
                this.getModel().setValue("mulsrcbillnumber", (Object)selectDataValue);
                this.getModel().setValue("calrangevalues_tag", (Object)selectData);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
        this.setQcalBasis();
    }

    private void setQcalBasis() {
        String calBasis = (String)this.getModel().getValue("qcalbasis");
        if ("srcbillnumber".equals(calBasis)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulsrcbillnumber"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulprojectnumber"});
            this.getModel().setValue("mulprojectnumber", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulsrcbillnumber"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulprojectnumber"});
            this.getModel().setValue("mulsrcbillnumber", null);
        }
        this.getModel().setValue("calrangevalues_tag", (Object)"");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                break;
            }
            case "costcentergroup": {
                this.getModel().setValue("mulcostcenter", null);
                this.getModel().setValue("mulsrcbillnumber", null);
                this.getModel().setValue("mulprojectnumber", null);
                this.getModel().setValue("calrangevalues_tag", (Object)"");
                break;
            }
            case "mulcostcenter": {
                this.getModel().setValue("mulsrcbillnumber", null);
                this.getModel().setValue("mulprojectnumber", null);
                this.getModel().setValue("calrangevalues_tag", (Object)"");
                break;
            }
            case "qcalbasis": {
                this.setQcalBasis();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)"eca_costsumrpt", (String)"4730fc9f000004ae", (String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u670d\u52a1\u6210\u672c\u6c47\u603b\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EcaCostSumRptPlugin_5", (String)"macc-eca", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection projectnumbers;
        String calrange;
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "period"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"EcaCostSumRptPlugin_6", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        String calBasis = (String)this.getModel().getValue("qcalbasis");
        if ("srcbillnumber".equals(calBasis) && CadEmptyUtils.isEmpty((String)(calrange = (String)this.getModel().getValue("calrangevalues_tag")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"EcaCostSumRptPlugin_6", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        if ("projectnumber".equals(calBasis) && CadEmptyUtils.isEmpty((DynamicObjectCollection)(projectnumbers = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"EcaCostSumRptPlugin_6", (String)"macc-eca", (Object[])new Object[0]));
            return false;
        }
        EcaCostSumParam pram = this.buildEcaCostSumParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(EcaCostSumParam.class.getName(), pram);
        return true;
    }

    private EcaCostSumParam buildEcaCostSumParam(DynamicObject dataEntity) {
        DynamicObjectCollection costcenters;
        EcaCostSumParam param = new EcaCostSumParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        param.setOrgId(org.getLong("id"));
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        param.setCostAccountId(costAccount.getLong("id"));
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(currency.getLong("id"));
        DynamicObject period = dataEntity.getDynamicObject("period");
        param.setPeriodId(period.getLong("id"));
        DynamicObject costCenterGroup = dataEntity.getDynamicObject("costcentergroup");
        if (costCenterGroup != null) {
            param.setCostCenterGroupId(costCenterGroup.getLong("Id"));
        }
        if ((costcenters = (DynamicObjectCollection)this.getModel().getValue("mulcostcenter")) != null) {
            param.setCostCenterIds(costcenters.stream().map(costcenter -> costcenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        String calBasis = (String)this.getModel().getValue("qcalbasis");
        param.setCalBasis(calBasis);
        String mulsrcbillnumber = (String)this.getModel().getValue("mulsrcbillnumber");
        param.setSrcBillNumbers(mulsrcbillnumber);
        String calrange = (String)this.getModel().getValue("calrangevalues_tag");
        param.setCalRange(calrange);
        DynamicObjectCollection projectnumbers = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber");
        if (projectnumbers != null) {
            param.setProjectNumberIds(projectnumbers.stream().map(projectnumber -> projectnumber.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        String biztype = (String)this.getModel().getValue("biztype");
        param.setBizType(biztype);
        Boolean showSumQty = (Boolean)this.getModel().getValue("showsumqty");
        param.setShowSumQty(showSumQty);
        Boolean showCCGroup = (Boolean)this.getModel().getValue("showccgroup");
        param.setShowCCGroup(showCCGroup);
        Boolean showCostCenter = (Boolean)this.getModel().getValue("showcostcenter");
        param.setShowCostCenter(showCostCenter);
        Boolean showQty = (Boolean)this.getModel().getValue("showqty");
        param.setShowQty(showQty);
        Boolean showBehavior = (Boolean)this.getModel().getValue("showbehavior");
        param.setShowBehavior(showBehavior);
        return param;
    }

    private void setOther() {
        this.getModel().setValue("costcentergroup", null);
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("period", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulprojectnumber", null);
        this.getModel().setValue("mulsrcbillnumber", null);
        this.getModel().setValue("calrangevalues_tag", null);
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("period", null);
                this.getModel().setValue("currency", null);
            } else {
                Long currentPeriodId = curPeriod.getLong("id");
                this.getModel().setValue("period", (Object)currentPeriodId);
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("sumrow");
        removedPros.add("qty");
        removedPros.add("amt");
        removedPros.add("totalamt");
        removedPros.add("alltotalamt");
        removedPros.add("costbehavior");
        removedPros.add("biztype");
        removedPros.add("calbasis");
        removedPros.add("mulprojectnumber");
        removedPros.add("mulsrcbillnumber");
        removedPros.add("costcenternumber");
        removedPros.add("subelementname");
        removedPros.add("subelementnumber");
        removedPros.add("ccgroupnumber");
        removedPros.add("costcentername");
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName, removedPros)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName, Set<String> removedPros) {
        String[] split = fieldName.split("\\.");
        return !removedPros.contains(split[0]) && !fieldName.contains(".longnumber") && !fieldName.contains(".fullname");
    }
}

