/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.report.cost.AddColsSumParam;
import kd.macc.eca.report.cost.EcaCostSumParam;
import kd.macc.eca.report.cost.EcaCostSumResultRow;
import kd.macc.eca.report.cost.HandleDataSumRptRow;

public class EcaCostSumSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(EcaCostSumSourceCf.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"currency", "costcenternumber", "sumrow", "sourcetype"});
    private Set<String> showSumQtyhideProps = Sets.newHashSet((Object[])new String[]{"alltotalamt"});
    private Set<String> costCenterHideProps = Sets.newHashSet((Object[])new String[]{"costcentername", "costcenter"});
    private Set<String> costCenterGroupHideProps = Sets.newHashSet((Object[])new String[]{"costcentergroup", "ccgroupnumber"});
    private EcaCostSumParam ecaCostSumParam;
    private Map<String, AddColsSumParam> paramMap = new LinkedHashMap<String, AddColsSumParam>(64);
    private Set<String> behaviorSet = new HashSet<String>(2);
    private Set<String> bizTypeSet = new HashSet<String>(2);
    private List<String> qtyCols = new ArrayList<String>(2);
    private List<String> amtCols = new ArrayList<String>(2);

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.ecaCostSumParam = (EcaCostSumParam)ctx.getParam(EcaCostSumParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    private List<QFilter> getFixedFilter() {
        String biztype;
        String calRange;
        List<Long> projectNumberIds;
        List<Long> costCenterIds;
        this.logger.info("\u8fc7\u6ee4\u6761\u4ef6\u6784\u5efa");
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.ecaCostSumParam.getOrgId();
        commonFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.ecaCostSumParam.getCostAccountId();
        commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        Long currency = this.ecaCostSumParam.getCurrencyId();
        commonFilters.add(new QFilter("currency", "=", (Object)currency));
        Long periodId = this.ecaCostSumParam.getPeriodId();
        commonFilters.add(new QFilter("period", "=", (Object)periodId));
        Long costCenterGroupId = this.ecaCostSumParam.getCostCenterGroupId();
        if (costCenterGroupId != null) {
            costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupId);
            commonFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.ecaCostSumParam.getCostCenterIds())) {
            commonFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = this.ecaCostSumParam.getProjectNumberIds())) {
            commonFilters.add(new QFilter("costobject.projectnumber", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(calRange = this.ecaCostSumParam.getCalRange()))) {
            String[] calRangeValue = calRange.split(";");
            commonFilters.add(new QFilter("costobject.srcbillnumber", "in", (Object)calRangeValue));
        }
        if (!CadEmptyUtils.isEmpty((String)(biztype = this.ecaCostSumParam.getBizType()))) {
            commonFilters.add(new QFilter("biztype", "in", (Object)biztype.split(",")));
        }
        this.ecaCostSumParam.setCommonFilters(commonFilters);
        return commonFilters;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757Union\u540e\u6570\u636e", (String)"EcaCostSumSourceCf_0", (String)"macc-eca", (Object[])new Object[0]));
        transCollector.add(new HandleDataSumRptRow(this.ecaCostSumParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new EcaCostSumResultRow(this.ecaCostSumParam, this.paramMap, this.behaviorSet, this.bizTypeSet, this.qtyCols, this.amtCols));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u62a5\u8868\u5217\u663e\u793a\u8bbe\u7f6e");
        for (ReportColumn reportColumn : cols) {
            String fieldKey = reportColumn.getFieldKey();
            if (this.hideProps.contains(fieldKey)) {
                reportColumn.setHide(true);
            }
            if (!this.ecaCostSumParam.getShowSumQty().booleanValue() && this.showSumQtyhideProps.contains(fieldKey)) {
                reportColumn.setHide(true);
            }
            if (!this.ecaCostSumParam.getShowCostCenter().booleanValue() && this.costCenterHideProps.contains(fieldKey)) {
                reportColumn.setHide(true);
            }
            if (this.ecaCostSumParam.getShowCCGroup().booleanValue() || !this.costCenterGroupHideProps.contains(fieldKey)) continue;
            reportColumn.setHide(true);
        }
        this.logger.info("buildShowColumn_bizTypeSet\uff1a" + this.bizTypeSet);
        if (this.bizTypeSet.size() > 0) {
            List swColumnChildren;
            if (this.bizTypeSet.contains("SW")) {
                this.logger.info("\u5f00\u59cb\u6784\u5efa\u670d\u52a1\u5de5\u5355\u5bf9\u5e94\u5217");
                ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u670d\u52a1\u5de5\u5355", (String)"EcaCostSumSourceCf_1", (String)"macc-eca", (Object[])new Object[0])));
                reportColumnGroup.setFieldKey("swcolumn");
                swColumnChildren = reportColumnGroup.getChildren();
                if (this.ecaCostSumParam.getShowBehavior().booleanValue()) {
                    this.setColShowBehavior(swColumnChildren, "SW", "A");
                    this.setColShowBehavior(swColumnChildren, "SW", "B");
                } else {
                    this.setColUnShowBehavior(swColumnChildren, "SW");
                }
                cols.add((AbstractReportColumn)reportColumnGroup);
            }
            if (this.bizTypeSet.contains("SP")) {
                this.logger.info("\u5f00\u59cb\u6784\u5efa\u670d\u52a1\u9879\u76ee\u5bf9\u5e94\u5217");
                ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u670d\u52a1\u9879\u76ee", (String)"EcaCostSumSourceCf_2", (String)"macc-eca", (Object[])new Object[0])));
                reportColumnGroup.setFieldKey("spcolumn");
                swColumnChildren = reportColumnGroup.getChildren();
                if (this.ecaCostSumParam.getShowBehavior().booleanValue()) {
                    this.setColShowBehavior(swColumnChildren, "SP", "A");
                    this.setColShowBehavior(swColumnChildren, "SP", "B");
                } else {
                    this.setColUnShowBehavior(swColumnChildren, "SP");
                }
                cols.add((AbstractReportColumn)reportColumnGroup);
            }
        }
        return super.buildShowColumn(cols, ctx);
    }

    private void setColUnShowBehavior(List<AbstractReportColumn> swColumnChildren, String bizTypeFlag) {
        String numberStr;
        String number;
        String keyValue;
        String bizType;
        AddColsSumParam addColsSumParam;
        boolean showQty = this.ecaCostSumParam.getShowQty();
        for (Map.Entry<String, AddColsSumParam> entry : this.paramMap.entrySet()) {
            addColsSumParam = entry.getValue();
            bizType = addColsSumParam.getBizType();
            if (!bizTypeFlag.equals(bizType)) continue;
            keyValue = entry.getKey();
            number = keyValue.split(" / ")[0];
            numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
            ReportColumnGroup subElementGroup = new ReportColumnGroup();
            subElementGroup.setFieldKey(numberStr + bizType.toLowerCase());
            subElementGroup.setCaption(new LocaleString(keyValue));
            subElementGroup.setHideSingleColumnRow(false);
            List children = subElementGroup.getChildren();
            this.setQtyCol(numberStr + "qty" + bizType.toLowerCase(), children, showQty);
            this.setAmtCol(numberStr + "amt" + bizType.toLowerCase(), children, true);
            this.setIdCol(numberStr + "id" + bizType.toLowerCase(), children);
            swColumnChildren.add((AbstractReportColumn)subElementGroup);
        }
        if (this.ecaCostSumParam.getShowSumQty().booleanValue()) {
            for (Map.Entry<String, AddColsSumParam> entry : this.paramMap.entrySet()) {
                addColsSumParam = entry.getValue();
                bizType = addColsSumParam.getBizType();
                if (!bizTypeFlag.equals(bizType)) continue;
                keyValue = entry.getKey();
                number = keyValue.split(" / ")[0];
                numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
                ReportColumnGroup subElementSumGroup = new ReportColumnGroup();
                subElementSumGroup.setFieldKey(numberStr + "total" + bizType.toLowerCase());
                subElementSumGroup.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"\u7d2f\u8ba1 %s", (String)"EcaCostSumSourceCf_3", (String)"macc-eca", (Object[])new Object[0]), keyValue)));
                subElementSumGroup.setHideSingleColumnRow(false);
                List sumChildren = subElementSumGroup.getChildren();
                this.setQtyCol(numberStr + "qty" + bizType.toLowerCase() + "total", sumChildren, showQty);
                this.setAmtCol(numberStr + "amt" + bizType.toLowerCase() + "total", sumChildren, true);
                swColumnChildren.add((AbstractReportColumn)subElementSumGroup);
            }
        }
    }

    private void setColShowBehavior(List<AbstractReportColumn> swColumnChildren, String bizTypeFlag, String behaviorFlag) {
        boolean showQty = this.ecaCostSumParam.getShowQty();
        String name = ResManager.loadKDString((String)"\u53d8\u52a8\u6210\u672c\u5408\u8ba1", (String)"EcaCostSumSourceCf_4", (String)"macc-eca", (Object[])new Object[0]);
        String sumName = ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d8\u52a8\u6210\u672c\u5408\u8ba1", (String)"EcaCostSumSourceCf_5", (String)"macc-eca", (Object[])new Object[0]);
        if ("B".equals(behaviorFlag)) {
            name = ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u672c\u5408\u8ba1", (String)"EcaCostSumSourceCf_6", (String)"macc-eca", (Object[])new Object[0]);
            sumName = ResManager.loadKDString((String)"\u7d2f\u8ba1\u56fa\u5b9a\u6210\u672c\u5408\u8ba1", (String)"EcaCostSumSourceCf_7", (String)"macc-eca", (Object[])new Object[0]);
        }
        String keyStr = bizTypeFlag.toLowerCase() + behaviorFlag.toLowerCase();
        Boolean isBehavior = Boolean.FALSE;
        for (Map.Entry<String, AddColsSumParam> entry : this.paramMap.entrySet()) {
            String behavior;
            AddColsSumParam addColsSumParam = entry.getValue();
            String string = addColsSumParam.getBizType();
            if (!bizTypeFlag.equals(string) || !behaviorFlag.equals(behavior = addColsSumParam.getBehavior())) continue;
            isBehavior = Boolean.TRUE;
            String keyValue = entry.getKey();
            String number = keyValue.split(" / ")[0];
            String numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
            ReportColumnGroup subElementGroup = new ReportColumnGroup();
            subElementGroup.setFieldKey(numberStr + string.toLowerCase());
            subElementGroup.setCaption(new LocaleString(keyValue));
            subElementGroup.setHideSingleColumnRow(false);
            List children = subElementGroup.getChildren();
            this.setQtyCol(numberStr + "qty" + string.toLowerCase(), children, showQty);
            this.setAmtCol(numberStr + "amt" + string.toLowerCase(), children, true);
            this.setIdCol(numberStr + "id" + string.toLowerCase(), children);
            swColumnChildren.add((AbstractReportColumn)subElementGroup);
        }
        if (isBehavior.booleanValue()) {
            ReportColumnGroup behaviorGroup = new ReportColumnGroup();
            behaviorGroup.setFieldKey("behavior" + keyStr);
            behaviorGroup.setCaption(new LocaleString(name));
            behaviorGroup.setHideSingleColumnRow(false);
            List children = behaviorGroup.getChildren();
            this.setAmtCol("costbehavior" + keyStr, children, false);
            swColumnChildren.add((AbstractReportColumn)behaviorGroup);
            if (this.ecaCostSumParam.getShowSumQty().booleanValue()) {
                for (Map.Entry entry : this.paramMap.entrySet()) {
                    String behavior;
                    AddColsSumParam addColsSumParam = (AddColsSumParam)entry.getValue();
                    String bizType = addColsSumParam.getBizType();
                    if (!bizTypeFlag.equals(bizType) || !behaviorFlag.equals(behavior = addColsSumParam.getBehavior())) continue;
                    String keyValue = (String)entry.getKey();
                    String number = keyValue.split(" / ")[0];
                    String numberStr = number.replaceAll("[^A-Za-z0-9 ]", "0");
                    ReportColumnGroup subElementSumGroup = new ReportColumnGroup();
                    subElementSumGroup.setFieldKey(numberStr + "total" + bizType.toLowerCase());
                    subElementSumGroup.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"\u7d2f\u8ba1 %s", (String)"EcaCostSumSourceCf_3", (String)"macc-eca", (Object[])new Object[0]), keyValue)));
                    subElementSumGroup.setHideSingleColumnRow(false);
                    List sumChildren = subElementSumGroup.getChildren();
                    this.setQtyCol(numberStr + "qty" + bizType.toLowerCase() + "total", sumChildren, showQty);
                    this.setAmtCol(numberStr + "amt" + bizType.toLowerCase() + "total", sumChildren, true);
                    swColumnChildren.add((AbstractReportColumn)subElementSumGroup);
                }
                ReportColumnGroup behaviorSumGroup = new ReportColumnGroup();
                behaviorSumGroup.setFieldKey("behaviorsum" + keyStr);
                behaviorSumGroup.setCaption(new LocaleString(sumName));
                behaviorSumGroup.setHideSingleColumnRow(false);
                List list = behaviorSumGroup.getChildren();
                this.setAmtCol("costbehaviorsum" + keyStr, list, false);
                swColumnChildren.add((AbstractReportColumn)behaviorSumGroup);
            }
        }
    }

    private void setIdCol(String fieldKey, List<AbstractReportColumn> children) {
        ReportColumn idCol = new ReportColumn();
        idCol.setCaption(new LocaleString(ResManager.loadKDString((String)"id", (String)"EcaCostSumSourceCf_8", (String)"macc-eca", (Object[])new Object[0])));
        idCol.setWidth(new LocaleString("150px"));
        idCol.setFieldKey(fieldKey);
        idCol.setFieldType("decimal");
        idCol.setNoDisplayScaleZero(false);
        idCol.setZeroShow(false);
        idCol.setHideSingleColumnRow(false);
        idCol.setHide(true);
        children.add((AbstractReportColumn)idCol);
    }

    private void setQtyCol(String fieldKey, List<AbstractReportColumn> children, Boolean showQty) {
        ReportColumn qtyCol = new ReportColumn();
        qtyCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf ", (String)"EcaCostSumSourceCf_9", (String)"macc-eca", (Object[])new Object[0])));
        qtyCol.setWidth(new LocaleString("150px"));
        qtyCol.setFieldKey(fieldKey);
        qtyCol.setFieldType("qty");
        qtyCol.setNoDisplayScaleZero(false);
        qtyCol.setZeroShow(false);
        qtyCol.setHideSingleColumnRow(false);
        qtyCol.setHyperlink(true);
        qtyCol.setHide(showQty == false);
        children.add((AbstractReportColumn)qtyCol);
    }

    private void setAmtCol(String fieldKey, List<AbstractReportColumn> children, Boolean isLink) {
        ReportColumn amtCol = new ReportColumn();
        amtCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"EcaCostSumSourceCf_10", (String)"macc-eca", (Object[])new Object[0])));
        amtCol.setWidth(new LocaleString("150px"));
        amtCol.setFieldKey(fieldKey);
        amtCol.setFieldType("amount");
        amtCol.setZeroShow(false);
        if (isLink.booleanValue()) {
            amtCol.setHyperlink(true);
        }
        amtCol.setNoDisplayScaleZero(false);
        amtCol.setHideSingleColumnRow(false);
        amtCol.setCurrencyField("currency");
        children.add((AbstractReportColumn)amtCol);
    }
}

