/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.eca.report.cost.EcaCostSumParam;
import kd.macc.eca.report.cost.SumRptMapFunction;

public class HandleDataSumRptRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private EcaCostSumParam ecaCostSumParam;

    public HandleDataSumRptRow(EcaCostSumParam ecaCostSumParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.ecaCostSumParam = ecaCostSumParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        Boolean showCostCenter;
        Boolean showCCGroup;
        String selectFields = "id,";
        String calBasis = this.ecaCostSumParam.getCalBasis();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costobjectf7");
        DynamicProperty property = mainEntityType.getProperty(calBasis);
        String calBasisStr = calBasis;
        if (property instanceof BasedataProp && !(property instanceof FlexProp)) {
            calBasisStr = calBasis + ".number calbasis";
            selectFields = selectFields + calBasisStr;
        } else {
            calBasisStr = calBasis + " calbasis";
            selectFields = selectFields + calBasisStr;
        }
        OrmInput ormInputInit = new OrmInput("queryCostObject", "cad_costobjectf7", selectFields, this.getCostObjectFilters().toArray(new QFilter[0]));
        DataSetX costObjectDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputInit);
        srcData = srcData.removeFields(new String[]{"calbasis"});
        srcData = srcData.leftJoin(costObjectDataSetX).on("costobject", "id").select(srcData.getRowMeta().getFieldNames(), new String[]{"calbasis"});
        srcData = srcData.groupBy(new String[]{"calbasis", "currency", "costcenter", "costcentername", "costcenternumber", "biztype", "subelement", "subelementname", "subelementnumber", "costbehavior", "costcentergroup", "ccgroupnumber", "sumrow", "sourcetype"}).sum("qty").sum("amt").sum("totalamt").sum("alltotalamt");
        Boolean showSumQty = this.ecaCostSumParam.getShowSumQty();
        if (showSumQty.booleanValue()) {
            OrmInput ormInput = new OrmInput("SumInitRow", "eca_init", "costcenter,costcenter.name costcentername,costcenter.number costcenternumber,currency,entryentity.subelement.name subelementname,entryentity.subelement.number subelementnumber,entryentity.subelement.costbehavior costbehavior,entryentity.qty qty,entryentity.amount amt,costobject.biztype biztype,entryentity.subelement subelement,entryentity.qty sumqty,entryentity.amount sumamt,costobject." + calBasisStr, this.getSumDataSetXFilters(true).toArray(new QFilter[0]));
            DataSetX initDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInput);
            OrmInput ormInputT = new OrmInput("SumCarryRow", "eca_costcarrybill", "costcenter,costcenter.name costcentername,costcenter.number costcenternumber,currency,entryentity.subelement.name subelementname,entryentity.subelement.number subelementnumber,entryentity.subelement.costbehavior costbehavior,entryentity.baseqty qty,entryentity.amount amt,entryentity.costobject.biztype biztype,entryentity.subelement subelement,entryentity.baseqty sumqty,entryentity.amount sumamt,entryentity.costobject." + calBasisStr, this.getSumDataSetXFilters(false).toArray(new QFilter[0]));
            DataSetX carryDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputT);
            DataSetX sumDataSetX = DataSetXHelper.union((DataSetX)initDataSetX, (DataSetX)carryDataSetX);
            sumDataSetX = sumDataSetX.leftJoin(srcData).on("costcenter", "costcenter").on("biztype", "biztype").on("subelement", "subelement").on("calbasis", "calbasis").select(sumDataSetX.getRowMeta().getFieldNames(), new String[]{"sourcetype"});
            DataSetX groupSumDataSetX = sumDataSetX.groupBy(new String[]{"costcenter", "biztype", "subelement", "calbasis"}).sum("sumqty").sum("sumamt");
            DataSetX filterSumData = sumDataSetX.filter("sourcetype is null");
            filterSumData = filterSumData.removeFields(new String[]{"sumqty", "sumamt"});
            filterSumData = filterSumData.leftJoin(groupSumDataSetX).on("costcenter", "costcenter").on("biztype", "biztype").on("subelement", "subelement").on("calbasis", "calbasis").select(filterSumData.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt"});
            srcData = srcData.leftJoin(groupSumDataSetX).on("costcenter", "costcenter").on("biztype", "biztype").on("subelement", "subelement").on("calbasis", "calbasis").select(srcData.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt"});
            srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)filterSumData);
        }
        if ((showCCGroup = this.ecaCostSumParam.getShowCCGroup()).booleanValue()) {
            ArrayList qFilters = Lists.newArrayList();
            Long orgId = this.ecaCostSumParam.getOrgId();
            qFilters.add(new QFilter("org", "=", (Object)orgId));
            Long costCenterGroupId = this.ecaCostSumParam.getCostCenterGroupId();
            if (costCenterGroupId != null && costCenterGroupId > 0L) {
                qFilters.add(new QFilter("id", "=", (Object)costCenterGroupId));
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            qFilters.add(dateFilter);
            OrmInput ormInput = new OrmInput("HandleDataSumRptRow", "cad_costcentergroup", "id costcentergroup,number ccgroupnumber,entryentity.costcenter costcenterId", qFilters.toArray(new QFilter[0]));
            DataSetX ccGroupData = this.ctx.getCurrentJob().fromInput((Input)ormInput);
            srcData = srcData.removeFields(new String[]{"costcentergroup"});
            srcData = srcData.removeFields(new String[]{"ccgroupnumber"});
            srcData = srcData.leftJoin(ccGroupData).on("costcenter", "costcenterId").select(srcData.getRowMeta().getFieldNames(), new String[]{"costcentergroup", "ccgroupnumber"});
            srcData = srcData.map((MapFunction)new SumRptMapFunction());
        }
        if (!(showCostCenter = this.ecaCostSumParam.getShowCostCenter()).booleanValue()) {
            srcData = srcData.removeFields(new String[]{"costcenter", "costcentername", "costcenternumber"});
            srcData = srcData.addFields(new Field[]{new Field("costcenter", (DataType)DataType.LongType), new Field("costcentername", (DataType)DataType.StringType), new Field("costcenternumber", (DataType)DataType.StringType)}, new Object[]{0L, "", ""});
            srcData = showSumQty != false ? srcData.groupBy(new String[]{"calbasis", "currency", "costcenter", "costcentername", "costcenternumber", "biztype", "subelement", "subelementname", "subelementnumber", "costbehavior", "costcentergroup", "ccgroupnumber", "sumrow", "sourcetype"}).sum("qty").sum("amt").sum("totalamt").sum("alltotalamt").sum("sumqty").sum("sumamt") : srcData.groupBy(new String[]{"calbasis", "currency", "costcenter", "costcentername", "costcenternumber", "biztype", "subelement", "subelementname", "subelementnumber", "costbehavior", "costcentergroup", "ccgroupnumber", "sumrow", "sourcetype"}).sum("qty").sum("amt").sum("totalamt").sum("alltotalamt");
        }
        return srcData;
    }

    private List<QFilter> getCostObjectFilters() {
        String biztype;
        List<Long> costCenterIds;
        ArrayList<QFilter> sumFilters = new ArrayList<QFilter>(10);
        Long orgId = this.ecaCostSumParam.getOrgId();
        sumFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costCenterGroupId = this.ecaCostSumParam.getCostCenterGroupId();
        if (costCenterGroupId != null) {
            costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupId);
            sumFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.ecaCostSumParam.getCostCenterIds())) {
            sumFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(biztype = this.ecaCostSumParam.getBizType()))) {
            sumFilters.add(new QFilter("biztype", "in", (Object)biztype.split(",")));
        }
        return sumFilters;
    }

    private List<QFilter> getSumDataSetXFilters(boolean isInit) {
        String biztype;
        String calRange;
        List<Long> costCenterIds;
        ArrayList<QFilter> sumFilters = new ArrayList<QFilter>(10);
        Long orgId = this.ecaCostSumParam.getOrgId();
        sumFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.ecaCostSumParam.getCostAccountId();
        sumFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        Long currency = this.ecaCostSumParam.getCurrencyId();
        sumFilters.add(new QFilter("currency", "=", (Object)currency));
        Long costCenterGroupId = this.ecaCostSumParam.getCostCenterGroupId();
        if (costCenterGroupId != null) {
            costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupId);
            sumFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.ecaCostSumParam.getCostCenterIds())) {
            sumFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        String field = "entryentity.costobject";
        if (isInit) {
            field = "costobject";
        }
        Long periodId = this.ecaCostSumParam.getPeriodId();
        if (isInit) {
            sumFilters.add(new QFilter("entryentity.period", "<=", (Object)periodId));
        } else {
            sumFilters.add(new QFilter("period", "<=", (Object)periodId));
        }
        List<Long> projectNumberIds = this.ecaCostSumParam.getProjectNumberIds();
        if (!CadEmptyUtils.isEmpty(projectNumberIds)) {
            sumFilters.add(new QFilter(field + ".projectnumber", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(calRange = this.ecaCostSumParam.getCalRange()))) {
            String[] calRangeValue = calRange.split(";");
            sumFilters.add(new QFilter(field + ".srcbillnumber", "in", (Object)calRangeValue));
        }
        if (!CadEmptyUtils.isEmpty((String)(biztype = this.ecaCostSumParam.getBizType()))) {
            sumFilters.add(new QFilter(field + ".biztype", "in", (Object)biztype.split(",")));
        }
        return sumFilters;
    }
}

