/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.report.cost;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SrcBillNumberSelectEditPlugin
extends AbstractFormPlugin {
    private static final String SRC_BILL_NUMBER_LIST = "srcbillnumberlist";

    public void afterBindData(EventObject e) {
        DynamicObjectCollection srcBillNumbers;
        int entrySize;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long orgId = (Long)fsp.getCustomParam("orgId");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        List costCenterIds = (List)fsp.getCustomParam("costCenterIds");
        if (!CadEmptyUtils.isEmpty((List)costCenterIds)) {
            filter.and(new QFilter("costcenter", "in", (Object)costCenterIds));
        }
        if ((entrySize = (srcBillNumbers = this.getSrcBillNumbers(filter)).size()) <= 0) {
            return;
        }
        if (model.getEntryRowCount(SRC_BILL_NUMBER_LIST) > 0) {
            model.deleteEntryData(SRC_BILL_NUMBER_LIST);
        }
        int currIndex = 0;
        HashSet srcbillnumberSet = Sets.newHashSet();
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject obj = (DynamicObject)srcBillNumbers.get(i);
            String srcbillnumber = obj.getString("srcbillnumber");
            if (CadEmptyUtils.isEmpty((String)srcbillnumber) || !srcbillnumberSet.add(srcbillnumber)) continue;
            model.createNewEntryRow(SRC_BILL_NUMBER_LIST);
            model.setValue("srcbillnumber", (Object)srcbillnumber, currIndex);
            ++currIndex;
        }
        this.getView().updateView(SRC_BILL_NUMBER_LIST);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "confirm": {
                EntryGrid entrygrid = (EntryGrid)this.getControl(SRC_BILL_NUMBER_LIST);
                int[] selectRows = entrygrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u518d\u786e\u8ba4\u3002", (String)"SrcBillNumberSelectEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Integer> selectList = new ArrayList<Integer>(10);
                int[] nArray = selectRows;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer rowIndex = nArray[i];
                    selectList.add(rowIndex);
                }
                StringBuffer returnData = new StringBuffer();
                DynamicObjectCollection rows = this.getModel().getEntryEntity(SRC_BILL_NUMBER_LIST);
                for (DynamicObject row : rows) {
                    String rowValue;
                    if (!selectList.contains(row.getInt("seq") - 1) || CadEmptyUtils.isEmpty((String)(rowValue = row.getString("srcbillnumber")))) continue;
                    returnData.append(rowValue).append(";");
                }
                this.getView().returnDataToParent((Object)returnData.toString());
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    private DynamicObjectCollection getSrcBillNumbers(QFilter filter) {
        String selectFields = "id AS costaccount,srcbillnumber";
        String orderby = "srcbillnumber ASC";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_costobject", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderby);
        return result;
    }
}

