/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.meservice;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.eca.meservice.api.WorkHoursFeeService;
import kd.macc.eca.meservice.workhours.IWorkHoursFeeAction;
import kd.macc.eca.meservice.workhours.WorkHoursFeeArgs;
import kd.macc.eca.meservice.workhours.WorkHoursFeeContext;
import kd.macc.eca.meservice.workhours.WorkHoursResultBuilder;

public class WorkHoursFeeServiceImpl
implements WorkHoursFeeService {
    private static final Log logger = LogFactory.getLog(WorkHoursFeeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> importWorkHoursFee(Long acctOrg, Long costAccount, Long currentPeriod, List<Long> costCenters, String appNum, String progressId) {
        WorkHoursFeeContext workHoursFeeContext;
        block8: {
            WorkHoursFeeArgs workHoursFeeArgs = new WorkHoursFeeArgs();
            workHoursFeeArgs.setProgressId(progressId);
            workHoursFeeArgs.setAccountOrgId(acctOrg);
            workHoursFeeArgs.setCostAccountId(costAccount);
            workHoursFeeArgs.setPeriodId(currentPeriod);
            workHoursFeeArgs.setCostCenterIds(costCenters);
            workHoursFeeArgs.setAppNum(appNum);
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)});
            if (result != null) {
                Long currency = result.getLong("currency");
                workHoursFeeArgs.setCurrencyId(currency);
            }
            workHoursFeeContext = new WorkHoursFeeContext();
            workHoursFeeContext.setWorkHoursFeeArgs(workHoursFeeArgs);
            workHoursFeeContext.getCollectReport().logBaseInfo(acctOrg, CollectObjectEnum.WORKHOURS_FEE, appNum);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)acctOrg, (String)appNum);
            CostCenterHelper.getWorkCenter(costCenters, (List)importScopeDate, (CollectReport)workHoursFeeContext.getCollectReport());
            CostCenterHelper.getBosOrgs(costCenters, (List)importScopeDate, (CollectReport)workHoursFeeContext.getCollectReport());
            CostCenterHelper.getAdminOrg(costCenters, (List)importScopeDate, (CollectReport)workHoursFeeContext.getCollectReport());
            long time = System.currentTimeMillis();
            List<IWorkHoursFeeAction> workHoursFeeActions = IWorkHoursFeeAction.initialize();
            try {
                for (IWorkHoursFeeAction workHoursFeeAction : workHoursFeeActions) {
                    long actionTime = System.currentTimeMillis();
                    workHoursFeeAction.setContext(workHoursFeeContext);
                    workHoursFeeAction.execute();
                    logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)workHoursFeeAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5f15\u5165\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"WorkHoursFeeServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                    workHoursFeeContext.getCollectReport().logError((Throwable)e, errorMsg);
                    break block8;
                }
                throw e;
            }
            finally {
                logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        WorkHoursResultBuilder workHoursResultBuilder = new WorkHoursResultBuilder(workHoursFeeContext);
        return workHoursResultBuilder.buildResult();
    }
}

