/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.meservice.workhours;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.BaseDataCompareDiffHelper;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.TimeConverter;
import kd.macc.eca.meservice.workhours.AbstractWorkHoursFeeAction;
import kd.macc.eca.meservice.workhours.WorkHoursFeeArgs;
import kd.macc.eca.meservice.workhours.WorkHoursFeeContext;

public class BaseImportDataAction
extends AbstractWorkHoursFeeAction {
    private static final Log logger = LogFactory.getLog(BaseImportDataAction.class);
    private String[] billFileNames = new String[]{"org", "costcenter", "costaccount", "trade", "role", "resource", "period", "sourceid", "sourcebillentry"};
    private String[] entryFileNames = new String[]{"subelement", "workhour", "facthour", "costobject", "project", "rate", "amount"};

    @Override
    protected void doExecute() {
    }

    protected Set<String> dealExistsManu(Long acctOrg, Long costAccountId, List<Long> costCenters, List<DynamicObject> manuBill, Set<String> a, Map<String, DynamicObject> changePlannedMap, Map<Long, String> costCarryBillVoucher, List<String> existBillNos) {
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        HashSet<Long> sourceIdSet = new HashSet<Long>(16);
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> sonEntryIdSet = new HashSet<Long>(16);
        String sign = "-";
        for (DynamicObject manu : manuBill) {
            sourceIdSet.add(manu.getLong("id"));
            sourceEntryIdSet.add(manu.getLong("entryId"));
            sonEntryIdSet.add(manu.getLong("sonid"));
        }
        if (sourceIdSet.isEmpty() || sourceEntryIdSet.isEmpty()) {
            this.deleteAll(acctOrg, costAccountId, costCenters);
            return needReturnInfo;
        }
        QFilter qFilter = new QFilter("sourceid", "in", sourceIdSet);
        DynamicObjectCollection existPlans = QueryServiceHelper.query((String)"eca_workhoursfee", (String)"id,billno,sourceid,sourcebillentry,sonbillentry", (QFilter[])new QFilter[]{qFilter});
        existPlans.forEach(p -> existBillNos.add(p.getString("billno")));
        logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5355\uff1a{}", existBillNos);
        if (existPlans.size() == 0) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> plannedMap = this.getPlannedMap(existPlans);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> existWorkHourIdSets = new HashSet<Long>();
        for (DynamicObject planned : existPlans) {
            Long sourcebillentryId = planned.getLong("sourcebillentry");
            Long sonbillentryId = planned.getLong("sonbillentry");
            String key = planned.getLong("sourceid") + sign + sourcebillentryId + sign + sonbillentryId;
            needReturnInfo.add(key);
            existWorkHourIdSets.add(planned.getLong("id"));
            if (!sonEntryIdSet.contains(sonbillentryId)) {
                needDeleteIds.add(planned.getLong("id"));
                continue;
            }
            changePlannedMap.put(key, plannedMap.get(planned.getLong("id")));
        }
        logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5355:{}", needDeleteIds);
        costCarryBillVoucher = this.getCostCarryBillVoucher(existWorkHourIdSets, costCarryBillVoucher);
        needDeleteIds.removeAll(costCarryBillVoucher.keySet());
        if (needDeleteIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"), (Object[])needDeleteIds.toArray(new Long[0]));
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", needDeleteIds)});
            this.getWorkHoursFeeContext().setDelNum(this.getWorkHoursFeeContext().getDelNum() + needDeleteIds.size());
        }
        return needReturnInfo;
    }

    protected Map<Long, DynamicObject> getPlannedMap(DynamicObjectCollection plannedBill) {
        DynamicObject[] planneds;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        HashSet ids = new HashSet(16);
        plannedBill.forEach(p -> ids.add(p.getLong("id")));
        for (DynamicObject planned : planneds = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eca_workhoursfee"))) {
            resultMap.put(planned.getLong("id"), planned);
        }
        return resultMap;
    }

    protected String calWorkHoursFee(DynamicObject srcBill, DynamicObject compareData, DynamicObject targetBill, Map<String, DynamicObject> workHoursRateMap, WorkHoursFeeContext context, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, HashMap<Long, String> costCarryBillVoucher) {
        Boolean isUpdateData = compareData != null;
        long costcenterId = this.getDyId(targetBill, "costcenter");
        List<String> hourExpenses = context.getWorkHoursFeeArgs().getHourExpenses();
        long trade = this.getDyId(targetBill, "trade");
        long resource = this.getDyId(targetBill, "resource");
        Object role = targetBill.get("role");
        if (role == null) {
            role = " ";
        } else if (role instanceof DynamicObject) {
            role = ((DynamicObject)role).getPkValue();
        }
        StringBuilder sg = new StringBuilder();
        if (hourExpenses.contains(HourExpenseEnum.TRADE.getValue())) {
            sg.append('@').append(trade);
        }
        if (hourExpenses.contains(HourExpenseEnum.ROLE.getValue())) {
            sg.append('@').append(role);
        }
        if (hourExpenses.contains(HourExpenseEnum.RESOURCE.getValue())) {
            sg.append('@').append(resource);
        }
        for (String hourExpense : hourExpenses) {
            String customkey = hourExpense.toLowerCase().trim();
            if (CadEmptyUtils.isEmpty((String)customkey) || "trade".equals(customkey) || "role".equals(customkey) || "resource".equals(customkey)) continue;
            long customValue = this.getDyId(targetBill, customkey);
            sg.append('@').append(customValue);
        }
        String key = sg.toString();
        String rateKey = costcenterId + key;
        DynamicObject workHoursRate = workHoursRateMap.get(rateKey);
        if (workHoursRate == null) {
            rateKey = "0" + key;
            workHoursRate = workHoursRateMap.get(rateKey);
        }
        if (workHoursRate == null) {
            logger.info("\u6e90\u5355{}\u884c\u53f7{} key{}\u672a\u627e\u5230\u5339\u914d\u7684\u5de5\u65f6\u8d39\u7387\u4ef7\u76ee\u8868", new Object[]{srcBill.getString("billno"), srcBill.getString("entryseq"), rateKey});
            return String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u672a\u627e\u5230\u5339\u914d\u7684\u5de5\u65f6\u8d39\u7387\u4ef7\u76ee\u8868\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_6", (String)"macc-eca-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"));
        }
        Object element = workHoursRate.get("element");
        Object subelement = workHoursRate.get("subelement");
        targetBill.set("trade", (Object)trade);
        targetBill.set("role", role);
        targetBill.set("resource", (Object)resource);
        Long accountOrgId = context.getWorkHoursFeeArgs().getAccountOrgId();
        logger.info("\u5339\u914d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u6210\u672c\u4e2d\u5fc3->{}", (Object)costcenterId);
        Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(accountOrgId).concat(String.valueOf(costcenterId)));
        if (CadEmptyUtils.isEmpty(matInfoList)) {
            matInfoList = existCostObjectMap.get(String.valueOf(accountOrgId));
        }
        if (CadEmptyUtils.isEmpty(matInfoList)) {
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u6210\u672c\u4e2d\u5fc3\u201c%2$s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_7", (String)"macc-eca-mservice", (Object[])new Object[0]), accountOrgId, costcenterId);
        }
        String str = this.getCostObjectHashCodeBySrcBill(srcBill, collConfigRuleMappingMap);
        DynamicObject costObject = matInfoList.get(str);
        if (costObject == null) {
            return String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_8", (String)"macc-eca-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"));
        }
        BigDecimal rateminuteValue = TimeConverter.convertPriceByConversionFactor((long)workHoursRate.getLong("workhoursunit.id"), (long)9L, (BigDecimal)BigDecimal.ONE);
        BigDecimal qty = workHoursRate.getBigDecimal("qty");
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entrys = null;
        entrys = isUpdateData != false ? compareData.getDynamicObjectCollection("entryentity") : entryentity;
        if (isUpdateData.booleanValue()) {
            entryentity.clear();
        }
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entrys) {
            BigDecimal facthour = entry.getBigDecimal("facthour");
            if (CadEmptyUtils.isEmpty((BigDecimal)facthour)) {
                return String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u8f6c\u6362\u6210\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u540e,\u5b9e\u9645\u5de5\u65f6\u4e3a\u96f6,\u8bf7\u68c0\u67e5\u3002", (String)"BaseImportDataAction_9", (String)"macc-eca-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"));
            }
            long workhourId = this.getDyId(entry, "workhour");
            BigDecimal minuteValue = TimeConverter.convertPriceByConversionFactor((long)workhourId, (long)9L, (BigDecimal)BigDecimal.ONE);
            if (CadEmptyUtils.isEmpty((BigDecimal)minuteValue) || CadEmptyUtils.isEmpty((Long)workhourId)) {
                return String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7%2$s\u201c\u65f6\u95f4\u5355\u4f4d\u201d\u8f6c\u6362\u4e3a\u5206\u949f\u65f6\u8f6c\u6362\u7cfb\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseImportDataAction_10", (String)"macc-eca-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"));
            }
            entry.set("amount", (Object)rateminuteValue.multiply(qty).multiply(facthour).divide(minuteValue, 10, RoundingMode.HALF_UP));
            entry.set("rate", (Object)qty.multiply(rateminuteValue).divide(minuteValue, 10, RoundingMode.HALF_UP));
            entry.set("costobject", costObject.get("id"));
            entry.set("project", costObject.get("projectnumber"));
            entry.set("subelement", subelement);
            entry.set("element", element);
            if (!isUpdateData.booleanValue()) continue;
            entryList.add(entry);
        }
        DynamicObjectCollection workHoursRateEntrys = workHoursRate.getDynamicObjectCollection("entryentity");
        for (DynamicObject workHoursRateEntry : workHoursRateEntrys) {
            BigDecimal stdrate = workHoursRateEntry.getBigDecimal("stdrate");
            if (stdrate == null) {
                stdrate = BigDecimal.ZERO;
            }
            for (DynamicObject workHoursEntry : entrys) {
                DynamicObjectType entryType = workHoursEntry.getDynamicObjectType();
                DynamicObject addEntry = new DynamicObject(entryType);
                long workhourId = this.getDyId(workHoursEntry, "workhour");
                BigDecimal minuteValue = TimeConverter.convertPriceByConversionFactor((long)workhourId, (long)9L, (BigDecimal)BigDecimal.ONE);
                BigDecimal facthour = workHoursEntry.getBigDecimal("facthour");
                addEntry.set("costobject", workHoursEntry.get("costobject"));
                addEntry.set("project", workHoursEntry.get("project"));
                addEntry.set("subelement", workHoursRateEntry.get("entrysubelement"));
                addEntry.set("element", workHoursRateEntry.get("entryelement"));
                addEntry.set("workhour", (Object)workhourId);
                addEntry.set("rate", (Object)stdrate.multiply(rateminuteValue).divide(minuteValue, 10, RoundingMode.HALF_UP));
                addEntry.set("facthour", (Object)facthour);
                addEntry.set("amount", (Object)rateminuteValue.multiply(stdrate).multiply(facthour).divide(minuteValue, 10, RoundingMode.HALF_UP));
                entryList.add(addEntry);
            }
        }
        entryentity.addAll(entryList);
        return null;
    }

    protected void deleteAll(Long acctOrg, Long costAccountId, List<Long> costCenters) {
        DynamicObject currentPeriod;
        QFilter qfOrgAndCostCenter = new QFilter("org", "=", (Object)-1L);
        if (!CadEmptyUtils.isEmpty((Long)acctOrg)) {
            qfOrgAndCostCenter = new QFilter("org", "=", (Object)acctOrg);
        }
        if (!CadEmptyUtils.isEmpty((Long)costAccountId)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costaccount", "=", (Object)costAccountId));
        }
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        if ((currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId)) == null) {
            return;
        }
        qfOrgAndCostCenter.and(new QFilter("period", "=", currentPeriod.getPkValue()));
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"eca_workhoursfee", (String)"id", (QFilter[])new QFilter[]{qfOrgAndCostCenter});
        HashSet<Long> deleteIds = new HashSet<Long>(16);
        plannedBill.forEach(p -> deleteIds.add(p.getLong("id")));
        Map<Long, String> costCarryMap = this.getCostCarryBillVoucher(deleteIds, new HashMap<Long, String>());
        deleteIds.removeAll(costCarryMap.keySet());
        if (!CadEmptyUtils.isEmpty(deleteIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eca_workhoursfee"), (Object[])deleteIds.toArray(new Long[0]));
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", deleteIds)});
        }
        this.getWorkHoursFeeContext().setDelNum(this.getWorkHoursFeeContext().getDelNum() + deleteIds.size());
    }

    protected Map<Long, String> getCostCarryBillVoucher(Set<Long> deleteIds, Map<Long, String> costCarryBillMap) {
        if (CadEmptyUtils.isEmpty(deleteIds)) {
            return costCarryBillMap;
        }
        QFilter qFilter = new QFilter("srcbillid", "in", deleteIds);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostCarryBill", (String)"eca_costcarrybill", (String)"srcbillid,vouchernum", (QFilter[])new QFilter[]{qFilter}, null);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long srcbillid = next.getLong("srcbillid");
            String vouchernum = next.getString("vouchernum");
            if (CadEmptyUtils.isEmpty((String)vouchernum)) continue;
            costCarryBillMap.put(srcbillid, vouchernum);
        }
        return costCarryBillMap;
    }

    protected Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    protected void save(List<DynamicObject> plannedBills) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_plannedoutputbill", (DynamicObject[])plannedBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            throw new KDBizException(errorInfo);
        }
        List successPkIds = operateResult.getSuccessPkIds();
        this.getWorkHoursFeeContext().getSaveSuccessWorkHoursFeeList().addAll(successPkIds);
    }

    protected void updateData(DynamicObject plan, DynamicObject targetBill) {
        Iterator iterator;
        Set propertys = EntityPropertyHelper.getPropertys((String)"eca_workhoursfee");
        HashSet notUpdateFileSet = Sets.newHashSet((Object[])new String[]{"billno", "creator", "createtime"});
        for (String property : propertys) {
            if (notUpdateFileSet.contains(property)) continue;
            plan.set(property, targetBill.get(property));
        }
        DynamicObjectCollection entryentity = plan.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection targetBillEntrys = targetBill.getDynamicObjectCollection("entryentity");
        int diffnum = entryentity.size() - targetBillEntrys.size();
        if (diffnum > 0) {
            iterator = entryentity.iterator();
            while (iterator.hasNext() && diffnum != 0) {
                iterator.next();
                --diffnum;
                iterator.remove();
            }
        } else if (diffnum < 0) {
            while (diffnum != 0) {
                ++diffnum;
                iterator = entryentity.addNew();
            }
        }
        Set entryPropertys = EntityPropertyHelper.getEntryPropertys((String)"eca_workhoursfee", (String)"entryentity");
        int size = entryentity.size();
        for (int i = 0; i < targetBillEntrys.size(); ++i) {
            DynamicObject targetBillEntry = (DynamicObject)targetBillEntrys.get(i);
            if (i >= size) continue;
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            for (String entryProperty : entryPropertys) {
                entry.set(entryProperty, targetBillEntry.get(entryProperty));
            }
        }
    }

    protected void setValuePlanData(DynamicObject srcBill, DynamicObject workHour, WorkHoursFeeContext workHoursFeeContext) {
        WorkHoursFeeArgs workHoursFeeArgs = workHoursFeeContext.getWorkHoursFeeArgs();
        workHour.set("org", (Object)workHoursFeeArgs.getAccountOrgId());
        workHour.set("costaccount", (Object)workHoursFeeArgs.getCostAccountId());
        workHour.set("currency", (Object)workHoursFeeArgs.getCurrencyId());
        workHour.set("period", (Object)workHoursFeeArgs.getPeriodId());
        workHour.set("sourceid", (Object)srcBill.getLong("id"));
        workHour.set("sourcebillentry", (Object)srcBill.getLong("entryId"));
        workHour.set("billstatus", (Object)"C");
        Date now = TimeServiceHelper.now();
        long currUserId = RequestContext.get().getCurrUserId();
        Object creator = workHour.get("creator");
        if (creator == null) {
            workHour.set("creator", (Object)currUserId);
            workHour.set("createtime", (Object)now);
        }
        workHour.set("modifier", (Object)currUserId);
        workHour.set("modifytime", (Object)now);
        workHour.set("auditor", (Object)currUserId);
        workHour.set("auditdate", (Object)now);
        if (workHour.get("bizdate") == null) {
            workHour.set("bizdate", (Object)now);
        }
        if (workHour.get("bookdate") == null) {
            workHour.set("bookdate", (Object)now);
        }
    }

    protected Boolean compareIsExistSame(DynamicObject plan, DynamicObject targetBill) {
        return BaseDataCompareDiffHelper.recentDataDiffFlag((DynamicObject)plan, (DynamicObject)targetBill, (String[])this.billFileNames, (String[])this.entryFileNames);
    }

    protected Long getDyId(DynamicObject dy, String fileName) {
        if (CadEmptyUtils.isEmpty((String)fileName)) {
            return 0L;
        }
        Object value = dy.get(fileName);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    private String getCostObjectHashCodeBySrcBill(DynamicObject srcBill, TreeMap<String, String> collConfigRuleMappingMap) {
        String srcStr = "";
        if (CadEmptyUtils.isEmpty(collConfigRuleMappingMap)) {
            return srcStr;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)srcBill.getLong("id")), new QFilter("sumentry.id", "=", (Object)srcBill.getLong("entryId"))};
        logger.info("\u5de5\u5e8f\u6c47\u62a5\u5355ID:{}", (Object)(srcBill.getString("id") + "@" + srcBill.getString("entryId")));
        String selectFields = "sumentry.mroorderentryid.bdproject AS project";
        DynamicObject reportBill = QueryServiceHelper.queryOne((String)"sfc_processreportbill", (String)selectFields, (QFilter[])filters);
        if (reportBill == null) {
            return srcStr;
        }
        DataEntityPropertyCollection cols = srcBill.getDataEntityType().getProperties();
        StringBuilder sg = new StringBuilder();
        for (IDataEntityProperty col : cols) {
            sg.append(col.getName());
            sg.append(',');
        }
        logger.info("\u6e90\u5355\u5b57\u6bb5\uff1a{}", (Object)sg.toString());
        for (Map.Entry<String, String> configRule : collConfigRuleMappingMap.entrySet()) {
            String srcField = configRule.getValue();
            if (CadEmptyUtils.isEmpty((String)srcStr)) {
                if ("sumentry.mroorderentryid.bdproject".equals(srcField)) {
                    srcStr = reportBill.getString("project");
                    logger.info("project:{}", (Object)reportBill.getString("project"));
                    continue;
                }
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5339\u914d\u4fe1\u606f\u6e90\u5355\u5b57\u6bb5\uff1a{}", (Object)srcField);
                srcStr = srcBill.getString(srcField);
                continue;
            }
            if ("sumentry.mroorderentryid.bdproject".equals(srcField)) {
                srcStr = srcStr + "@" + reportBill.getString("project");
                logger.info("project:{}", (Object)reportBill.getString("project"));
                continue;
            }
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5339\u914d\u4fe1\u606f\u6e90\u5355\u5b57\u6bb5\uff1a{}", (Object)srcField);
            srcStr = srcStr + "@" + srcBill.getString(srcField);
        }
        return srcStr;
    }
}

