/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.meservice.workhours;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.eca.meservice.workhours.BaseImportDataAction;

public class CompletionSaveAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getWorkHoursFeeContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u5230\u7684\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5355", (String)"CompletionSaveAction_0", (String)"macc-eca-mservice", (Object[])new Object[0]));
        String progressId = this.getWorkHoursFeeContext().getWorkHoursFeeArgs().getProgressId();
        List<DynamicObject> planOutBills = this.getWorkHoursFeeContext().getPlanOutPutBills();
        List billNos = planOutBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", billNos);
        try (TXHandle txHandle = TX.required();){
            this.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f52\u96c6\u7684\u6570\u636e", (String)"CompletionSaveAction_1", (String)"macc-eca-mservice", (Object[])new Object[0]), 1, 0, true);
            int saveSize = planOutBills.size();
            int batchSize = 300;
            if (saveSize <= batchSize * 3) {
                this.save(planOutBills);
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = planOutBills.subList(startCount, endCount);
                    this.save(batchBillList);
                }
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CompletionSaveAction_2", (String)"macc-eca-mservice", (Object[])new Object[0]), -1, 0, false);
        }
        this.getWorkHoursFeeContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"%s\u6761\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompletionSaveAction_3", (String)"macc-eca-mservice", (Object[])new Object[0]), planOutBills.size()));
    }
}

