/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.meservice.workhours;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.meservice.workhours.BaseImportDataAction;

public class CreateCostCarryBillAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(CreateCostCarryBillAction.class);

    @Override
    protected void doExecute() {
        QFilter qFilter;
        this.getWorkHoursFeeContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u751f\u6210\u6210\u672c\u7ed3\u8f6c\u5355", (String)"CreateCostCarryBillAction_0", (String)"macc-eca-mservice", (Object[])new Object[0]));
        List<Object> successWorkHoursFeeList = this.getWorkHoursFeeContext().getSaveSuccessWorkHoursFeeList();
        if (CadEmptyUtils.isEmpty(successWorkHoursFeeList)) {
            this.getWorkHoursFeeContext().getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u96c6\u672a\u751f\u6210\u6210\u672c\u7ed3\u8f6c\u5355\u3002", (String)"CreateCostCarryBillAction_1", (String)"macc-eca-mservice", (Object[])new Object[0]));
            logger.info("\u672c\u6b21\u5f52\u96c6\u672a\u751f\u6210\u6210\u672c\u7ed3\u8f6c\u5355");
            return;
        }
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(successWorkHoursFeeList.size());
        for (Object workHoursId : successWorkHoursFeeList) {
            selectedRows.add(new ListSelectedRow(workHoursId));
        }
        QFilter sourceIdQf = new QFilter("srcbillid", "in", successWorkHoursFeeList);
        HashSet notVouCherNumBillIds = new HashSet(16);
        HashSet hasVouCherNumBillIds = new HashSet(16);
        DynamicObjectCollection costCarryBill = QueryServiceHelper.query((String)"eca_costcarrybill", (String)"id,vouchernum", (QFilter[])sourceIdQf.toArray());
        if (costCarryBill != null && !costCarryBill.isEmpty()) {
            costCarryBill.forEach(s -> {
                if (CadEmptyUtils.isEmpty((String)s.getString("vouchernum"))) {
                    notVouCherNumBillIds.add(s.getLong("id"));
                } else {
                    hasVouCherNumBillIds.add(s.getLong("id"));
                }
            });
        }
        if (!CadEmptyUtils.isEmpty(notVouCherNumBillIds)) {
            qFilter = new QFilter("id", "in", notVouCherNumBillIds);
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])qFilter.toArray());
        }
        if (!CadEmptyUtils.isEmpty(hasVouCherNumBillIds)) {
            qFilter = new QFilter("id", "in", hasVouCherNumBillIds);
            Map carryBillMap = BusinessDataServiceHelper.loadFromCache((String)"eca_costcarrybill", (QFilter[])qFilter.toArray());
            CloneUtils cloneUtils = new CloneUtils(Boolean.TRUE.booleanValue(), Boolean.TRUE.booleanValue());
            long userId = RequestContext.get().getCurrUserId();
            ArrayList<DynamicObject> revertCarryBills = new ArrayList<DynamicObject>(carryBillMap.size());
            for (Map.Entry carryBill : carryBillMap.entrySet()) {
                DynamicObject sourceBill = (DynamicObject)carryBill.getValue();
                DynamicObject copyCarryBill = (DynamicObject)cloneUtils.clone((IDataEntityBase)sourceBill);
                copyCarryBill.set("billno", (Object)copyCarryBill.getString("billno").concat("-pzcx"));
                Date nowTime = TimeServiceHelper.now();
                copyCarryBill.set("createtime", (Object)nowTime);
                copyCarryBill.set("creator", (Object)userId);
                copyCarryBill.set("modifytime", (Object)nowTime);
                copyCarryBill.set("modifier", (Object)userId);
                copyCarryBill.set("auditor", (Object)userId);
                copyCarryBill.set("auditdate", (Object)nowTime);
                copyCarryBill.set("vouchernum", (Object)" ");
                DynamicObjectCollection entryEntity = copyCarryBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal amount = dynamicObject.getBigDecimal("amount");
                    BigDecimal baseQty = dynamicObject.getBigDecimal("baseqty");
                    dynamicObject.set("amount", (Object)amount.negate());
                    dynamicObject.set("baseqty", (Object)baseQty.negate());
                }
                revertCarryBills.add(copyCarryBill);
            }
            if (!CadEmptyUtils.isEmpty(revertCarryBills)) {
                SaveServiceHelper.save((DynamicObject[])revertCarryBills.toArray(new DynamicObject[0]));
            }
        }
        logger.info("\u5b58\u5728{}\u6750\u6599\u5206\u914d\u5355\u636e\u4e0b\u63a8\u5230\u6210\u672c\u7ed3\u8f6c\u5355", (Object)successWorkHoursFeeList.size());
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("eca_workhoursfee");
        pushArgs.setTargetEntityNumber("eca_costcarrybill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        try (TXHandle h = TX.required();){
            try {
                ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                if (!pushResult.isSuccess()) {
                    StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"CreateCostCarryBillAction_4", (String)"macc-eca-mservice", (Object[])new Object[0]), errMessage.toString()));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        this.getWorkHoursFeeContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u65f6\u8d39\u7387\u5f52\u96c6\u5355\u5171\u751f\u6210%s\u6761\u6210\u672c\u7ed3\u8f6c\u5355\u3002", (String)"CreateCostCarryBillAction_3", (String)"macc-eca-mservice", (Object[])new Object[0]), successWorkHoursFeeList.size()));
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            logger.error(billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }
}

