/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.meservice.workhours;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.SysParamHelper;
import kd.macc.eca.meservice.workhours.AbstractWorkHoursFeeAction;
import kd.macc.eca.meservice.workhours.WorkHoursFeeArgs;

public class WorkHoursFeeBuildConditionAction
extends AbstractWorkHoursFeeAction {
    private static final Log logger = LogFactory.getLog(WorkHoursFeeBuildConditionAction.class);

    @Override
    protected void doExecute() {
        Map<String, DynamicObject> workHoursRateMap;
        WorkHoursFeeArgs workHoursFeeArgs = this.getWorkHoursFeeContext().getWorkHoursFeeArgs();
        Long accountOrgId = workHoursFeeArgs.getAccountOrgId();
        List<Long> costCenterIds = workHoursFeeArgs.getCostCenterIds();
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getWorkHoursFeeContext().getAcctOrgCostCentersMap();
        Map<String, List<Long>> acctOrgCalmethodCostCentersMap = this.getWorkHoursFeeContext().getAcctOrgCalmethodCostCenters();
        String appNum = workHoursFeeArgs.getAppNum();
        int totalNum = 20;
        this.refreshProgress(ResManager.loadKDString((String)"\u6784\u5efa\u6761\u4ef6\uff0c\u5f52\u96c6\u5f00\u59cb\u3002", (String)"WorkHoursFeeBuildConditionAction_0", (String)"macc-eca-mservice", (Object[])new Object[0]), 1, totalNum, false);
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(accountOrgId), (Set)Sets.newHashSet(costCenterIds), (String)"eca_workhoursfee", (String)appNum);
        HashSet costCenterSet = new HashSet(enableCostCenters);
        acctOrgCostCentersMap.put(accountOrgId, costCenterSet);
        Map rulesMap = null;
        Map costCenterByRules = null;
        Map dimensionAndRuleMap = null;
        dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
        rulesMap = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, (List)enableCostCenters);
        costCenterByRules = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)rulesMap);
        List importScopeDate = kd.macc.cad.common.helper.SysParamHelper.getImportScopeDate((Long)accountOrgId, (String)appNum);
        CostCenterHelper.getWorkCenter(costCenterIds, (List)importScopeDate, (CollectReport)this.getWorkHoursFeeContext().getCollectReport());
        CostCenterHelper.getAdminOrg(costCenterIds, (List)importScopeDate, (CollectReport)this.getWorkHoursFeeContext().getCollectReport());
        CostCenterHelper.getBosOrgs(costCenterIds, (List)importScopeDate, (CollectReport)this.getWorkHoursFeeContext().getCollectReport());
        if (CadEmptyUtils.isEmpty((Map)costCenterByRules)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"WorkHoursFeeBuildConditionAction_1", (String)"macc-eca-mservice", (Object[])new Object[0]), this.getWorkHoursFeeContext().getResponseInfo());
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"WorkHoursFeeBuildConditionAction_2", (String)"macc-eca-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        acctOrgCalmethodCostCentersMap.putAll(costCenterByRules);
        this.getWorkHoursFeeContext().getAcctOrgObjRules().putAll(rulesMap);
        if (!CadEmptyUtils.isEmpty((Map)dimensionAndRuleMap)) {
            this.getWorkHoursFeeContext().getDimensionAndRuleMap().putAll(dimensionAndRuleMap);
        }
        if (CadEmptyUtils.isEmpty(workHoursRateMap = this.getWorkHoursRate(accountOrgId, workHoursFeeArgs.getCostAccountId()))) {
            this.getWorkHoursFeeContext().setContinueExecute(false);
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5de5\u65f6\u8d39\u7387\u4ef7\u76ee\u8868\u3002", (String)"WorkHoursFeeBuildConditionAction_3", (String)"macc-eca-mservice", (Object[])new Object[0]), this.getWorkHoursFeeContext().getResponseInfo());
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"WorkHoursFeeBuildConditionAction_2", (String)"macc-eca-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        this.getWorkHoursFeeContext().setWorkHoursRateMap(workHoursRateMap);
        CostObjectService.generateCostObject((Long)accountOrgId, costCenterIds, workHoursFeeArgs.getManuOrgs(), null, (String)workHoursFeeArgs.getAppNum(), (CollectReport)this.getWorkHoursFeeContext().getCollectReport());
        logger.info("\u5de5\u65f6\u8d39\u7528\u5f52\u96c6\uff0c\u83b7\u53d6\u6e90\u5355\u53c2\u6570\u3002\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u6210\u672c\u4e2d\u5fc3\u6761\u6570", (Object)acctOrgCostCentersMap.size());
    }

    private Map<String, DynamicObject> getWorkHoursRate(Long acctOrg, Long costAccountId) {
        Object[] workHoursRates;
        QFilter orgQf = new QFilter("org", "=", (Object)acctOrg);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        Date date = new Date();
        QFilter effectdateQf = new QFilter("effectdate", "<=", (Object)date);
        QFilter expdateQf = new QFilter("expdate", ">=", (Object)date);
        Map hourExpense = SysParamHelper.getHourExpense((Long)acctOrg);
        HashSet<String> extFieldSet = new HashSet<String>(4);
        for (Map.Entry entry : hourExpense.entrySet()) {
            String fileName = ((String)entry.getKey()).toLowerCase();
            if (StringUtils.isEmpty((Object)fileName)) continue;
            if (!("trade".equalsIgnoreCase(fileName) || "role".equalsIgnoreCase(fileName) || "resource".equalsIgnoreCase(fileName))) {
                extFieldSet.add(fileName);
            }
            if (((Boolean)entry.getValue()).booleanValue()) {
                if ("role".equalsIgnoreCase(fileName)) {
                    orgQf.and(new QFilter(fileName, "!=", (Object)" "));
                    continue;
                }
                orgQf.and(new QFilter(fileName, "!=", (Object)0L));
                continue;
            }
            if ("role".equalsIgnoreCase(fileName)) {
                orgQf.and(new QFilter(fileName, "=", (Object)" "));
                continue;
            }
            orgQf.and(new QFilter(fileName, "=", (Object)0L));
        }
        StringBuffer sb = new StringBuffer("costcenter,element,subelement,trade,role,resource,qty,workhoursunit,entryentity,entryentity.entryelement,entryentity.entrysubelement,entryentity.stdrate");
        if (!CadEmptyUtils.isEmpty(extFieldSet)) {
            extFieldSet.forEach(s -> sb.append(",").append((String)s));
        }
        if (!CadEmptyUtils.isEmpty((Object[])(workHoursRates = BusinessDataServiceHelper.load((String)"eca_workhoursrate", (String)sb.toString(), (QFilter[])new QFilter[]{orgQf, costaccountQf, effectdateQf, expdateQf, statusFilter})))) {
            boolean isTradeDimenSion = (Boolean)hourExpense.get(HourExpenseEnum.TRADE.getValue());
            boolean isRoleDimenSion = (Boolean)hourExpense.get(HourExpenseEnum.ROLE.getValue());
            boolean isResourceDimenSion = (Boolean)hourExpense.get(HourExpenseEnum.RESOURCE.getValue());
            HashMap<String, DynamicObject> workHoursRateMap = new HashMap<String, DynamicObject>();
            StringBuilder keyBuilder = new StringBuilder();
            for (Object workHoursRate : workHoursRates) {
                long costcenter = workHoursRate.getLong("costcenter.id");
                long trade = workHoursRate.getLong("trade.id");
                String role = workHoursRate.getString("role.id");
                if (StringUtils.isEmpty((Object)role)) {
                    role = " ";
                }
                long resource = workHoursRate.getLong("resource.id");
                keyBuilder.append(costcenter);
                if (isTradeDimenSion) {
                    keyBuilder.append("@").append(trade);
                }
                if (isRoleDimenSion) {
                    keyBuilder.append("@").append(role);
                }
                if (isResourceDimenSion) {
                    keyBuilder.append("@").append(resource);
                }
                if (!CadEmptyUtils.isEmpty(extFieldSet)) {
                    for (String extField : extFieldSet) {
                        long extFieldId = 0L;
                        Object extObj = workHoursRate.get(extField);
                        if (extObj != null) {
                            if (extObj instanceof DynamicObject) {
                                extFieldId = ((DynamicObject)extObj).getLong("id");
                            }
                            if (extObj instanceof Long) {
                                extFieldId = (Long)extObj;
                            }
                        }
                        keyBuilder.append("@").append(extFieldId);
                    }
                }
                workHoursRateMap.put(keyBuilder.toString(), (DynamicObject)workHoursRate);
                keyBuilder.setLength(0);
            }
            logger.info("\u5de5\u65f6\u8d39\u7528\u4ef7\u76ee\u8868\u7684\u6570\u636e\u4e3a{}", workHoursRateMap);
            return workHoursRateMap;
        }
        return null;
    }
}

