/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.util.AnalysisModelUtil;

public class CheckPeriodUpgradeService
implements IUpgradeService {
    private static Log log = LogFactory.getLog(CheckPeriodUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("CheckPeriodUpgradePlugin - info:").append(dbKey);
            String ret1 = this.upgradePeriod(dbKey);
            sb.append(ret1).append(System.lineSeparator());
            result.setSuccess(true);
            sb.append("The CheckPeriodUpgradePlugin execution was completed and the upgrade was successful!");
            result.setLog(sb.toString());
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setEl("error");
            String msg = "CheckPeriodUpgradePlugin upgrade failed! error:" + e.getMessage();
            result.setErrorInfo(msg);
            result.setLog(msg);
        }
        return result;
    }

    private String upgradePeriod(String dbKey) {
        StringBuilder resultSb = new StringBuilder();
        MainEntityType meta = null;
        try {
            meta = EntityMetadataCache.getDataEntityType((String)"pa_analysismodel");
        }
        catch (Exception ex) {
            resultSb.append("pa_analysismodel is not existed :").append(ex.getMessage()).append(System.lineSeparator());
        }
        if (meta != null) {
            String sql = " select fid from t_pa_analysismodel where fid not in (select fanalysismodelid from t_pa_accperiodlock)";
            List list = (List)DB.query((DBRoute)DBRoute.of((String)meta.getDBRouteKey()), (String)sql, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                public List<Object> handle(ResultSet rs) throws Exception {
                    ArrayList<Object> ids = new ArrayList<Object>(10);
                    while (rs.next()) {
                        Long id = rs.getLong(1);
                        ids.add(id);
                    }
                    return ids;
                }
            });
            DynamicObject[] modelObjs = null;
            try {
                modelObjs = BusinessDataServiceHelper.load((Object[])list.toArray(new Long[0]), (DynamicObjectType)meta);
            }
            catch (Exception ex) {
                resultSb.append("fail to load analysismodel :").append(ex.getMessage()).append(System.lineSeparator());
            }
            if (modelObjs != null) {
                for (DynamicObject modelObj : modelObjs) {
                    this.handleRecords(resultSb, meta, modelObj);
                }
            }
        }
        return resultSb.toString();
    }

    private void handleRecords(StringBuilder resultSb, MainEntityType meta, DynamicObject modelObj) {
        Object modeId = modelObj.getPkValue();
        Long sysId = modelObj.getLong("analysis_system_id");
        String tableNumber = modelObj.getString("tablenumber");
        resultSb.append("ModeId:").append(modeId).append("--");
        if (StringUtils.isBlank((String)tableNumber)) {
            resultSb.append("table number is empty").append(System.lineSeparator());
            return;
        }
        String tableName = "t_" + AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)meta.getDBRouteKey()), (String)tableName)) {
            resultSb.append(tableName).append(" is not existed").append(System.lineSeparator());
            return;
        }
        FAFAnalysisModelModel modelModel = new FAFAnalysisModelModel();
        try {
            modelModel.loadFromDynamicObject(modelObj, true);
        }
        catch (Exception ex) {
            resultSb.append("failed to load dim").append(System.lineSeparator());
            return;
        }
        String org = modelModel.getOrgDim().getNumber();
        String period = modelModel.getPeriodDim().getNumber();
        String periodFormId = "";
        if (modelModel.getPeriodDim().getDataType() == DimensionTypeEnum.PERIOD) {
            periodFormId = "pa_analysisperiod";
        } else if (modelModel.getPeriodDim().getDataType() == DimensionTypeEnum.DATABASE) {
            periodFormId = "bd_period";
        } else {
            resultSb.append("period type is not alowed : ").append(modelModel.getPeriodDim().getDataType()).append(System.lineSeparator());
            return;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select ", new Object[0]);
        sb.append(" f" + org, new Object[0]).append(", f" + period, new Object[0]);
        sb.append(" from ", new Object[0]);
        sb.append(tableName, new Object[0]);
        sb.append(" group by", new Object[0]);
        sb.append(" f" + org, new Object[0]).append(", f" + period, new Object[0]);
        List listOrgPeriod = (List)DB.query((DBRoute)DBRoute.of((String)meta.getDBRouteKey()), (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<List<Map<Long, Long>>>(){

            public List<Map<Long, Long>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<Long, Long>> list = new ArrayList<Map<Long, Long>>(10);
                while (rs.next()) {
                    HashMap<Long, Long> map = new HashMap<Long, Long>(1);
                    map.put(rs.getLong(1), rs.getLong(2));
                    list.add(map);
                }
                return list;
            }
        });
        if (listOrgPeriod != null && listOrgPeriod.size() > 0) {
            StringBuilder insertResult = this.batchCreateCtrlRecord(meta.getDBRouteKey(), sysId, modeId, listOrgPeriod, periodFormId, "1");
            if (insertResult != null) {
                resultSb.append((CharSequence)insertResult).append(System.lineSeparator());
            }
        } else {
            resultSb.append("there are not records in ").append(tableName).append(System.lineSeparator());
        }
    }

    private StringBuilder batchCreateCtrlRecord(String dbRouteKey, long analysisSystemId, Object analysisModelId, List<Map<Long, Long>> listPair, String periodFormId, String status) {
        int[] newIds;
        StringBuilder resultSB = new StringBuilder();
        ArrayList<Object[]> values = new ArrayList<Object[]>(24);
        int i = 0;
        long[] tempIds = DB.genGlobalLongIds((int)listPair.size());
        for (Map<Long, Long> map : listPair) {
            Long orgId = (Long)map.keySet().stream().findAny().get();
            Long periodId = map.values().stream().findAny().get();
            StringBuilder sb = new StringBuilder();
            String beginDateFiled = "pa_analysisperiod".equals(periodFormId) ? "startdate" : "begindate";
            sb.append("id").append(",").append(beginDateFiled).append(",").append("enddate");
            DynamicObject periodObj = null;
            try {
                periodObj = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)periodFormId, (String)sb.toString());
            }
            catch (Exception e) {
                resultSB.append("miss load period-\uff1a").append(e.getMessage()).append(System.lineSeparator());
                resultSB.append("----period formid:").append(periodFormId).append(System.lineSeparator());
                resultSB.append("----period id:").append(periodId).append(System.lineSeparator());
            }
            if (periodObj == null) continue;
            long id = tempIds[i];
            long timeMill = System.currentTimeMillis();
            Object[] vals = new Object[]{id, "number_" + timeMill, "name_" + timeMill, Character.valueOf('C'), 0, 0, Character.valueOf('1'), new Timestamp(timeMill), new Timestamp(timeMill), id, RequestContext.get().getOrgId(), orgId, Character.valueOf(' '), 0, 0, 0, analysisSystemId, analysisModelId, null, periodId, periodFormId, new Timestamp(periodObj.getDate(beginDateFiled).getTime()), new Timestamp(periodObj.getDate("enddate").getTime()), status};
            values.add(vals);
            ++i;
        }
        String sql = "insert into T_PA_ACCPERIODLOCK(FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FCREATEORGID,FORGID,FCTRLSTRATEGY,FSOURCEDATAID,FBITINDEX,FSOURCEBITINDEX,FANALYSISSYSTEMID,FANALYSISMODELID,FDATE,FPERIODID,FPERIODTYPE,FSTARTDATE,FENDDATE,FISOPEN) values (?,?,?, ?,?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,?,?,?,?,?)";
        if (!(values.isEmpty() || (newIds = DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, values)) != null && newIds.length != 0)) {
            resultSB.append("fail to insert records").append(System.lineSeparator());
        }
        return resultSB;
    }
}

