/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.result.ServiceResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ResultCodeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.macc.faf.fas.dto.FAFComparisonDTO;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.index.FAFIndexDynamicObject;
import kd.macc.faf.mservice.FAFDimensionService;

public class FAFDimensionServiceImpl
implements FAFDimensionService {
    private static Log logger = LogFactory.getLog(FAFDimensionServiceImpl.class);
    private static final String BD_PERIOD = "bd_period";
    private static final String PA_ANALYSISPERIOD = "pa_analysisperiod";
    private static final String PARAMETER_ERROR = "parameter error";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String KEY_ID = "id";
    private static final String DIMENSIONSOURCE_NUMBER = "dimensionsource.number";

    public ServiceResult<Long> queryPeriodValueId(Long fasIndexId, Date date) {
        ServiceResult result = null;
        if (fasIndexId == null || date == null) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                FAFIndexDynamicObject indexDynamicObject = FAFIndexDynamicObject.create((Object)fasIndexId);
                DynamicObject dim = indexDynamicObject.getRoot().getDimensionPeriod();
                if (BD_PERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    QFilter qFilter = new QFilter("begindate", "<=", (Object)date);
                    qFilter.and(new QFilter("enddate", ">=", (Object)date));
                    qFilter.and(new QFilter("periodtype", "=", dim.get("group.id")));
                    DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (QFilter[])qFilter.toArray());
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                    result.setData((Object)period.getLong(KEY_ID));
                } else if (PA_ANALYSISPERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int month = cal.get(2) + 1;
                    QFilter qFilter = new QFilter("startdate", "<=", (Object)date);
                    qFilter.and(new QFilter("enddate", ">=", (Object)date));
                    qFilter.and(new QFilter("isadjust", "=", (Object)Character.valueOf('0')));
                    qFilter.and(new QFilter(MONTH, "=", (Object)month));
                    DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)PA_ANALYSISPERIOD, (QFilter[])qFilter.toArray());
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                    result.setData((Object)period.getLong(KEY_ID));
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Long> queryPeriodValueIdByDimensionId(Date date, Long dimensionId) {
        ServiceResult result = null;
        if (dimensionId == null || date == null) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                if (BD_PERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    QFilter qFilter = new QFilter("begindate", "<=", (Object)date);
                    qFilter.and(new QFilter("enddate", ">=", (Object)date));
                    qFilter.and(new QFilter("periodtype", "=", dim.get("group.id")));
                    DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (QFilter[])qFilter.toArray());
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                    result.setData((Object)period.getLong(KEY_ID));
                } else if (PA_ANALYSISPERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int month = cal.get(2) + 1;
                    QFilter qFilter = new QFilter("startdate", "<=", (Object)date);
                    qFilter.and(new QFilter("enddate", ">=", (Object)date));
                    qFilter.and(new QFilter("isadjust", "=", (Object)Character.valueOf('0')));
                    qFilter.and(new QFilter(MONTH, "=", (Object)month));
                    DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)PA_ANALYSISPERIOD, (QFilter[])qFilter.toArray());
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                    result.setData((Object)period.getLong(KEY_ID));
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Long> queryLastPeriod(Long dimensionId, Long periodId) {
        ServiceResult result = null;
        if (dimensionId == null || periodId == null) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                FAFComparisonDTO dto = FAFComparisonDTO.quickCreate((String)FAFComparisonEnum.C_03.getCode());
                Map valueMap = (Map)dto.loadLinkMap(dim, new Object[]{periodId}).get("qoq");
                AtomicReference rsultValue = new AtomicReference();
                valueMap.forEach((k, v) -> {
                    if (v.equals(periodId)) {
                        rsultValue.set(k);
                    }
                });
                result = new ServiceResult(ResultCodeEnum.SUCCESS);
                result.setData(rsultValue.get());
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Long> queryLastYearPeriod(Long dimensionId, Long periodId) {
        ServiceResult result = null;
        if (dimensionId == null || periodId == null) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                FAFComparisonDTO dto = FAFComparisonDTO.quickCreate((String)FAFComparisonEnum.C_01.getCode());
                Map valueMap = (Map)dto.loadLinkMap(dim, new Object[]{periodId}).get("yoy");
                AtomicReference rsultValue = new AtomicReference();
                valueMap.forEach((k, v) -> {
                    if (v.equals(periodId)) {
                        rsultValue.set(k);
                    }
                });
                result = new ServiceResult(ResultCodeEnum.SUCCESS);
                result.setData(rsultValue.get());
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Map<Date, Long>> queryPeriodIdMapByDimensionId(Long dimensionId, List<Date> dates) {
        ServiceResult result = null;
        if (dimensionId == null || dates == null || dates.isEmpty()) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                HashMap<Date, Long> resultMap = new HashMap<Date, Long>(dates.size());
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                if (BD_PERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    QFilter qFilter = new QFilter("periodtype", "=", dim.get("group.id"));
                    qFilter.and(new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0')));
                    Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)BD_PERIOD, (QFilter[])qFilter.toArray());
                    for (Date date : dates) {
                        for (DynamicObject period : dynamicObjectMap.values()) {
                            Date begindate = period.getDate("begindate");
                            Date enddate = period.getDate("enddate");
                            if (begindate == null || enddate == null || begindate.getTime() > date.getTime() || date.getTime() > enddate.getTime()) continue;
                            resultMap.put(date, period.getLong(KEY_ID));
                        }
                    }
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                } else if (PA_ANALYSISPERIOD.equals(dim.getString(DIMENSIONSOURCE_NUMBER))) {
                    QFilter qFilter = new QFilter("isadjust", "=", (Object)Character.valueOf('0'));
                    Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)PA_ANALYSISPERIOD, (QFilter[])qFilter.toArray());
                    for (Date date : dates) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(date);
                        int month = cal.get(2) + 1;
                        for (DynamicObject period : dynamicObjectMap.values()) {
                            Date begindate = period.getDate("startdate");
                            Date enddate = period.getDate("enddate");
                            int monthDate = period.getInt(MONTH);
                            if (begindate == null || enddate == null || monthDate == 0 || month != monthDate || begindate.getTime() > date.getTime() || date.getTime() > enddate.getTime()) continue;
                            resultMap.put(date, period.getLong(KEY_ID));
                        }
                    }
                    result = new ServiceResult(ResultCodeEnum.SUCCESS);
                }
                if (result != null) {
                    result.setData(resultMap);
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Map<Long, Long>> queryLastPeriodMap(Long dimensionId, List<Long> periodIds) {
        ServiceResult result = null;
        if (dimensionId == null || periodIds == null || periodIds.isEmpty()) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                HashMap resultMap = new HashMap(periodIds.size());
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                FAFComparisonDTO dto = FAFComparisonDTO.quickCreate((String)FAFComparisonEnum.C_03.getCode());
                Map valueMap = (Map)dto.loadLinkMap(dim, periodIds.toArray()).get("qoq");
                valueMap.forEach((k, v) -> resultMap.put(v, k));
                result = new ServiceResult(ResultCodeEnum.SUCCESS);
                result.setData(resultMap);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }

    public ServiceResult<Map<Long, Long>> queryLastYearPeriodMap(Long dimensionId, List<Long> periodIds) {
        ServiceResult result = null;
        if (dimensionId == null || periodIds == null || periodIds.isEmpty()) {
            result = new ServiceResult(ResultCodeEnum.ERROR);
            result.setMessage(PARAMETER_ERROR);
        } else {
            try {
                HashMap resultMap = new HashMap(periodIds.size());
                DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                FAFComparisonDTO dto = FAFComparisonDTO.quickCreate((String)FAFComparisonEnum.C_01.getCode());
                Map valueMap = (Map)dto.loadLinkMap(dim, periodIds.toArray()).get("yoy");
                valueMap.forEach((k, v) -> resultMap.put(v, k));
                result = new ServiceResult(ResultCodeEnum.SUCCESS);
                result.setData(resultMap);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new ServiceResult(ResultCodeEnum.ERROR);
                result.setMessage("invoke error: " + e.getMessage());
            }
        }
        return result;
    }
}

