/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.datasync.SyncDataExecutor;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.model.IWorkTaskTransLog;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.IDataWorkTask;
import kd.macc.faf.engine.task.IDataWorkTaskManager;
import kd.macc.faf.engine.task.impl.FAFDataMangerSequenceWorkTaskGroup;
import kd.macc.faf.engine.task.impl.FAFWorkTaskFactory;
import kd.macc.faf.enums.FAFStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.mservice.FAFFetchDataScheduleService;
import kd.macc.faf.service.FAFFetchDataScheduleServiceHelper;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.FAFTableUtil;

public class FAFFetchDataScheduleServiceImpl
implements FAFFetchDataScheduleService {
    private static final Log logger = LogFactory.getLog(FAFFetchDataScheduleServiceImpl.class);

    public Map<Object, ErrorCode> createManageDataViewTask(Map<Object, DynamicObject> syncDataParamMap) {
        HashMap<Object, ErrorCode> result = new HashMap<Object, ErrorCode>(10);
        for (Map.Entry<Object, DynamicObject> entry : syncDataParamMap.entrySet()) {
            DynamicObject syncParamDynamicObject = entry.getValue();
            long pkValue = syncParamDynamicObject.getLong("model.id");
            DataExtractingDTO dataExtractingDTO = DataExtractingDTO.parseSyncDataParam((DynamicObject)syncParamDynamicObject);
            dataExtractingDTO.setForce(true);
            SyncDataExecutor executor = new SyncDataExecutor((Object)pkValue, dataExtractingDTO);
            ErrorCode sync = executor.sync();
            result.put(entry.getKey(), sync);
        }
        return result;
    }

    public void summaryModelTask(Long analysisModelId) {
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        FAFWorkTaskMeta meta = this.createMeta(analysisModelObj, FAFWorkTaskTypeEnum.SUMMARY_MODEL_TASK);
        IDataAbstractWorkTask summaryTask = FAFWorkTaskFactory.createPAWorkTask((Integer)FAFWorkTaskTypeEnum.SUMMARY_MODEL_TASK.getValue(), (IWorkTaskTransLog)meta, (boolean)false);
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)summaryTask);
    }

    public void calculateModelLazyTask(Long analysisModelId) {
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        FAFWorkTaskMeta meta = this.createMeta(analysisModelObj, FAFWorkTaskTypeEnum.CALCULATE_MODEL_LAZY_TASK);
        IDataAbstractWorkTask calTask = FAFWorkTaskFactory.createPAWorkTask((Integer)FAFWorkTaskTypeEnum.CALCULATE_MODEL_LAZY_TASK.getValue(), (IWorkTaskTransLog)meta, (boolean)false);
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)calTask);
    }

    public void summaryCalculateModeTask(Long analysisModelId) {
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        FAFWorkTaskMeta meta = this.createMeta(analysisModelObj, FAFWorkTaskTypeEnum.SUMMARY_CALCULATE_MODEL_Task);
        IDataAbstractWorkTask sumCalTask = FAFWorkTaskFactory.createPAWorkTask((Integer)FAFWorkTaskTypeEnum.SUMMARY_CALCULATE_MODEL_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)false);
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)sumCalTask);
    }

    public boolean createTableTask(Long anaModId, String tableNumber, String tableName, Boolean reCreate) {
        return FAFTableUtil.createOrDropTable((Long)anaModId, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (Boolean)reCreate);
    }

    public boolean dropTableTask(Long anaModId, String tableNumber, String tableName, Boolean reCreate) {
        return FAFTableUtil.createOrDropTable((Long)anaModId, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Drop_Table_Task, (String)tableNumber, (String)tableName, (Boolean)reCreate);
    }

    public void createComplementTask(Long anaModId, Set<Long> orgIdSet, String periodBaseData, Set<Long> periodIdSet) {
        FAFFetchDataScheduleServiceHelper.createComplementTask((Long)anaModId, orgIdSet, (String)periodBaseData, periodIdSet);
    }

    private FAFDataMangerSequenceWorkTaskGroup createManageDataTask() {
        String taskKey = "Manage_" + System.currentTimeMillis();
        return new FAFDataMangerSequenceWorkTaskGroup((Serializable)((Object)taskKey), null);
    }

    private IDataAbstractWorkTask createDataTask(DynamicObject syncParamDynamicObject) {
        long systemId = syncParamDynamicObject.getLong("system.id");
        long modelId = syncParamDynamicObject.getLong("model.id");
        String lockKey = String.format("fi/pa/%s", modelId);
        DataExtractingDTO dataExtractingDTO = DataExtractingDTO.parseSyncDataParam((DynamicObject)syncParamDynamicObject);
        ArrayList orgIdList = new ArrayList(dataExtractingDTO.getOrgIdSet());
        ArrayList periodIdList = new ArrayList(dataExtractingDTO.getPeriodIdSet());
        String periodBaseData = dataExtractingDTO.getPeriodBaseData();
        boolean flag = PeriodServiceHelper.checkPeriodOrgList((long)modelId, orgIdList, periodIdList, (boolean)true);
        if (flag) {
            try {
                PeriodServiceHelper.batchCreateCtrlRecord((long)systemId, (long)modelId, orgIdList, periodIdList, (String)periodBaseData);
            }
            catch (Exception exception) {
                logger.error(String.format("[MACC-FAF] PeriodServiceHelper#batchCreateCtrlRecord occur an error: %s", exception.getMessage()), (Throwable)exception);
            }
        } else {
            logger.error("[MACC-FAF] PeriodServiceHelper checkPeriodOrgList error!");
            return null;
        }
        DynamicObject dataScheme = this.getDataScheme(syncParamDynamicObject);
        if (dataScheme == null) {
            return null;
        }
        DynamicObject syncLog = this.getSyncLog(dataScheme);
        Long dataSchemeId = dataScheme.getLong("id");
        String dataSchemeName = dataScheme.getString("name");
        Long syncLogId = (Long)syncLog.getPkValue();
        FAFWorkTaskMeta paWorkTaskMeta = new FAFWorkTaskMeta(lockKey, syncLogId, Long.valueOf(modelId), FAFWorkTaskTypeEnum.QUERY_SUMMARY_CALCULATE_MODEL_Group_Task, false, dataSchemeId, dataSchemeName, dataExtractingDTO);
        return FAFWorkTaskFactory.createPAWorkTask((Integer)FAFWorkTaskTypeEnum.QUERY_SUMMARY_CALCULATE_MODEL_Group_Task_Schedule.getValue(), (IWorkTaskTransLog)paWorkTaskMeta, (boolean)false);
    }

    private FAFWorkTaskMeta createMeta(DynamicObject analysisModelObj, FAFWorkTaskTypeEnum taskType) {
        String tableNumber = analysisModelObj.getString("tablenumber");
        String tableName = analysisModelObj.getString("tablename");
        String entityNumber = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
        Long taskId = System.currentTimeMillis();
        Long analysisModelId = analysisModelObj.getLong("id");
        return new FAFWorkTaskMeta(entityNumber, taskId, analysisModelId, taskType, true, tableNumber, tableName);
    }

    private DynamicObject getDataScheme(DynamicObject syncParamDynamicObject) {
        Long modelId = syncParamDynamicObject.getLong("model.id");
        QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"pa_syncdataschema", (String)"id,name", (QFilter[])new QFilter[]{modelFilter, enableFilter});
    }

    private DynamicObject getSyncLog(DynamicObject dataSchemeDynamicObject) {
        DynamicObject syncTask = BusinessDataServiceHelper.newDynamicObject((String)"pa_taskpreview");
        syncTask.set("syncdatascheme", (Object)dataSchemeDynamicObject.getLong("id"));
        syncTask.set("syncschemename", (Object)dataSchemeDynamicObject.getString("name"));
        syncTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        syncTask.set("createtime", (Object)new Date());
        syncTask.set("status", (Object)FAFStatusEnum.NEW.getCodeString());
        syncTask.set("tasktype", (Object)String.valueOf(FAFWorkTaskTypeEnum.Query_DB_Data_Sync_Group_Task.getValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncTask});
        return syncTask;
    }
}

