/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.fas.index.FAFIndexDynamicObject;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.ICalculateService;
import kd.macc.faf.fas.service.factory.FAFIndexServiceFactory;
import kd.macc.faf.mservice.FAFIndexCalculateService;

public class FAFIndexCalculateServiceImpl
implements FAFIndexCalculateService {
    private static final Log logger = LogFactory.getLog(FAFIndexCalculateServiceImpl.class);
    private final ICalculateService service = FAFIndexServiceFactory.getCalculateService();

    public Map<String, Object> querySelectableGroupDimensions(Long pkValue, Long useOrgId) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        FAFIndexDynamicObject object = FAFIndexDynamicObject.create((Object)pkValue);
        object.checkPerm(useOrgId);
        FAFIndex root = object.getRoot();
        map.put("code", "success");
        map.put("alldimenisons", root.getDimensions());
        map.put("necessityOrg", root.getDimensionOrg());
        map.put("necessityPeriod", root.getDimensionPeriod());
        return map;
    }

    public Map<String, Object> querySelectableGroupDimensions(Long pkValue) {
        return this.querySelectableGroupDimensions(pkValue, null);
    }

    public Map<String, Object> commitComparisonCalculate(Long pkValue, Long useOrgId, Map<Long, Object[]> params, Map<String, Object> comparison) {
        try {
            Map map = this.service.commit(pkValue, useOrgId, params, comparison);
            map.put("code", "success");
            return map;
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("pa.fas.service", (Throwable)e);
            throw new KDBizException(new ErrorCode("pa.fas.service", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, Object> commitComparisonCalculate(Long pkValue, Map<Long, Object[]> params, Map<String, Object> comparison) {
        return this.commitComparisonCalculate(pkValue, null, params, comparison);
    }

    public Map<String, Object> commitMix(Long pkValue, Map<String, Object> mixParams) {
        try {
            Map map = this.service.commitMix(pkValue, null, mixParams);
            map.put("code", "success");
            return map;
        }
        catch (Exception e) {
            logger.error("pa.fas.service", (Throwable)e);
            throw new KDBizException(new ErrorCode("pa.fas.service.commintMix", e.getMessage()), new Object[0]);
        }
    }

    public List<Row> getCalculateResult(String cacheId, int begin, int length) {
        try {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            return cacheDataSet.getList(begin, length);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new KDBizException(new ErrorCode("pa.fas.service", ex.getMessage()), new Object[0]);
        }
    }
}

