/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.mservice;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.GenericServiceResult;
import kd.macc.faf.management.bo.param.request.BatchUpdateTaskParam;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.bo.param.request.RegisterTaskParam;
import kd.macc.faf.management.bo.param.request.TaskParam;
import kd.macc.faf.management.bo.param.request.UpdateTaskParam;
import kd.macc.faf.management.bo.result.TaskManagementResult;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.enums.TaskResultCodeEnum;
import kd.macc.faf.management.enums.TaskStatusEnum;
import kd.macc.faf.management.exec.processor.manage.BatchUpdateTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.QueryTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.RegisterTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.UpdateTaskManagementProcessor;
import kd.macc.faf.management.factory.TaskManagementProcessorFactory;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.management.helper.TaskManagementDataHelper;
import kd.macc.faf.mservice.TaskManagementService;

public class TaskManagementServiceImpl
implements TaskManagementService {
    private static final Log logger = LogFactory.getLog(TaskManagementServiceImpl.class);

    public GenericServiceResult<String> registerTask(String requestJson) {
        TaskManagementResult result;
        RegisterTaskParam registerTaskParam = (RegisterTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.REGISTER, (String)requestJson);
        logger.info(String.format("[TaskManagementServiceImpl - registerTask - \u6ce8\u518c\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570] requestJson : %s", requestJson));
        try {
            RegisterTaskManagementProcessor registerProcessor = (RegisterTaskManagementProcessor)TaskManagementProcessorFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.REGISTER);
            result = registerProcessor.process((TaskParam)registerTaskParam);
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            logger.error(String.format("[TaskManagementServiceImpl - registerTask - \u6ce8\u518c\u4efb\u52a1\u8bf7\u6c42\u5f02\u5e38] exception : %s", errorMessage));
            return new GenericServiceResult(Boolean.FALSE, "500", errorMessage);
        }
        String resultCode = result.getCode();
        if (TaskResultCodeEnum.SUCCESS == TaskResultCodeEnum.getEnumByCode((String)resultCode)) {
            logger.info("[TaskManagementServiceImpl - registerTask - \u6ce8\u518c\u4efb\u52a1\u8bf7\u6c42\u6210\u529f]");
            return new GenericServiceResult(Boolean.TRUE, resultCode, "");
        }
        logger.error(String.format("[TaskManagementServiceImpl - registerTask - \u6ce8\u518c\u4efb\u52a1\u8bf7\u6c42\u5931\u8d25] errorMessage : %s", result.getErrorMessage()));
        return new GenericServiceResult(Boolean.FALSE, resultCode, result.getErrorMessage());
    }

    public GenericServiceResult<String> updateTaskStatus(String requestJson) {
        TaskManagementResult result;
        UpdateTaskParam updateTaskParam = (UpdateTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.UPDATE, (String)requestJson);
        logger.info(String.format("[TaskManagementServiceImpl - updateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570] requestJson : %s", requestJson));
        try {
            UpdateTaskManagementProcessor updateProcessor = (UpdateTaskManagementProcessor)TaskManagementProcessorFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.UPDATE);
            result = updateProcessor.process((TaskParam)updateTaskParam);
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            logger.error(String.format("[TaskManagementServiceImpl - updateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u5f02\u5e38] exception : %s", errorMessage));
            return new GenericServiceResult(Boolean.FALSE, TaskResultCodeEnum.SERVER_ERROR.getCode(), errorMessage);
        }
        String resultCode = result.getCode();
        if (TaskResultCodeEnum.SUCCESS == TaskResultCodeEnum.getEnumByCode((String)resultCode)) {
            logger.info(String.format("[TaskManagementServiceImpl - updateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u6210\u529f] result: %s", result));
            String jsonData = result.getData() != null ? SerializationUtils.toJsonString((Object)result.getData()) : "";
            return new GenericServiceResult(Boolean.TRUE, resultCode, "", (Object)jsonData);
        }
        logger.error(String.format("[TaskManagementServiceImpl - updateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u5931\u8d25] errorMessage : %s", result.getErrorMessage()));
        return new GenericServiceResult(Boolean.FALSE, resultCode, result.getErrorMessage());
    }

    public GenericServiceResult<DynamicObject[]> queryTask(String requestJson) {
        TaskManagementResult result;
        QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.QUERY, (String)requestJson);
        logger.info(String.format("[TaskManagementServiceImpl - QueryTaskParam - \u67e5\u8be2\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570] requestJson : %s", requestJson));
        try {
            QueryTaskManagementProcessor queryProcessor = (QueryTaskManagementProcessor)TaskManagementProcessorFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.QUERY);
            result = queryProcessor.process((TaskParam)queryTaskParam);
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            logger.error(String.format("[TaskManagementServiceImpl - queryTask - \u67e5\u8be2\u4efb\u52a1\u8bf7\u6c42\u5f02\u5e38] exception : %s", errorMessage));
            return new GenericServiceResult(Boolean.FALSE, TaskResultCodeEnum.SERVER_ERROR.getCode(), errorMessage);
        }
        String resultCode = result.getCode();
        if (TaskResultCodeEnum.SUCCESS == TaskResultCodeEnum.getEnumByCode((String)resultCode)) {
            logger.info(String.format("[TaskManagementServiceImpl - queryTask - \u67e5\u8be2\u4efb\u52a1\u8bf7\u6c42\u6210\u529f] result: %s", result));
            DynamicObject[] taskDys = (DynamicObject[])result.getData();
            return new GenericServiceResult(Boolean.TRUE, resultCode, "", (Object)taskDys);
        }
        logger.error(String.format("[TaskManagementServiceImpl - queryTask - \u67e5\u8be2\u4efb\u52a1\u8bf7\u6c42\u5931\u8d25] errorMessage : %s", result.getErrorMessage()));
        return new GenericServiceResult(Boolean.FALSE, resultCode, result.getErrorMessage());
    }

    public GenericServiceResult<String> manualFail(List<Long> taskIds) {
        logger.info(String.format("[TaskManagementServiceImpl - manualFail - \u6807\u8bc6\u5931\u8d25\u4efb\u52a1id\u96c6\u5408] taskIds : %s", taskIds));
        HashMap<String, List<Long>> queryParam = new HashMap<String, List<Long>>(1);
        queryParam.put("taskIds", taskIds);
        GenericServiceResult<DynamicObject[]> queryTaskResult = this.queryTask(SerializationUtils.toJsonString(queryParam));
        if (queryTaskResult.getSuccess().booleanValue()) {
            DynamicObject[] tasks;
            for (DynamicObject task : tasks = (DynamicObject[])queryTaskResult.getData()) {
                task.set("execstatus", (Object)TaskStatusEnum.FAILED.getCode());
                task.set("endexectime", (Object)new Date());
                task.set("loginfo", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u6807\u8bb0\u6267\u884c\u5931\u8d25", (String)"TaskManagementServiceImpl_0", (String)"macc-faf-mservice", (Object[])new Object[0]));
            }
            TaskManagementDataHelper.batchSave((DynamicObject[])tasks);
            return new GenericServiceResult(Boolean.TRUE, TaskResultCodeEnum.SUCCESS.getCode(), TaskResultCodeEnum.SUCCESS.getText());
        }
        return new GenericServiceResult(Boolean.FALSE, queryTaskResult.getCode(), queryTaskResult.getMessage());
    }

    public GenericServiceResult<String> batchUpdateTaskStatus(String requestJson) {
        TaskManagementResult result;
        BatchUpdateTaskParam updateTaskParam = (BatchUpdateTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.BATCH_UPDATE, (String)requestJson);
        logger.info(String.format("[TaskManagementServiceImpl - batchUpdateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570] requestJson : %s", requestJson));
        try {
            BatchUpdateTaskManagementProcessor updateProcessor = (BatchUpdateTaskManagementProcessor)TaskManagementProcessorFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.BATCH_UPDATE);
            result = updateProcessor.process((TaskParam)updateTaskParam);
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            logger.error(String.format("[TaskManagementServiceImpl - batchUpdateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u5f02\u5e38] exception : %s", errorMessage));
            return new GenericServiceResult(Boolean.FALSE, TaskResultCodeEnum.SERVER_ERROR.getCode(), errorMessage);
        }
        String resultCode = result.getCode();
        if (TaskResultCodeEnum.SUCCESS == TaskResultCodeEnum.getEnumByCode((String)resultCode)) {
            logger.info(String.format("[TaskManagementServiceImpl - batchUpdateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u6210\u529f] result: %s", result));
            String jsonData = result.getData() != null ? SerializationUtils.toJsonString((Object)result.getData()) : "";
            return new GenericServiceResult(Boolean.TRUE, resultCode, "", (Object)jsonData);
        }
        logger.error(String.format("[TaskManagementServiceImpl - batchUpdateTaskStatus - \u66f4\u65b0\u4efb\u52a1\u8bf7\u6c42\u5931\u8d25] errorMessage : %s", result.getErrorMessage()));
        return new GenericServiceResult(Boolean.FALSE, resultCode, result.getErrorMessage());
    }

    public GenericServiceResult<String> cancelTask(String jsonData) {
        return null;
    }

    public GenericServiceResult<String> retryTask(String jsonData) {
        return null;
    }

    public GenericServiceResult<String> isExist(String jsonData) {
        return null;
    }
}

