/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.FAFReportDynFieldClass;
import kd.macc.faf.datareview.FAFCustomReportFilter;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.ValidatorTipsUtil;
import org.jetbrains.annotations.NotNull;

public abstract class FAFAbstactModelReport
extends FAFReportDynFieldClass
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(FAFAbstactModelReport.class);

    public FAFAbstactModelReport(@NotNull String relatedFieldOfModel, String ORG, String ACCOUNT, String PERIOD, String DATERANGE) {
        super(relatedFieldOfModel, ORG, ACCOUNT, PERIOD, DATERANGE);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"reportfilterap"});
        this.getView().addCustomControls(new String[]{"filtergridap"});
    }

    public abstract Long getSystemId();

    public void afterBindData(EventObject e) {
        this.showFilter();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (this.getMODEL().equals(name)) {
            this.showFilter();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if ("reportfilterap".equals(e.getKey()) && !(e.getControl() instanceof FAFCustomReportFilter)) {
            Control control = e.getControl();
            ReportFilter paCustomReportFilter = this.getPaCustomReportFilter((ReportFilter)control);
            e.setControl((Control)paCustomReportFilter);
        }
    }

    public ReportFilter getPaCustomReportFilter(ReportFilter control) {
        return new FAFCustomReportFilter(this, control);
    }

    private void showFilter() {
        Long analysisModelId = this.getModelPkID();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        IReportView view = this.getView();
        if (analysisModelId == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
            view.updateView("filtergridap");
            filterGrid.setBtnStatus();
            return;
        }
        String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(analysisModelId);
        if (StringUtils.isNotEmpty((String)modelNewVersionMsg)) {
            view.showTipNotification(modelNewVersionMsg);
            filterGrid.setFilterColumns(Collections.emptyList());
            view.updateView("filtergridap");
            filterGrid.setBtnStatus();
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("filtergridap", "setAddBtnStatus", new Object[]{false});
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
        List<Object> dimensionFilterColumns = Collections.emptyList();
        if (analysisModel != null) {
            String tableNumber = analysisModel.getString("tablenumber");
            this.getPageCache().put("tablenumber", tableNumber);
            dimensionFilterColumns = this.getFilterGridColumns(analysisModel);
            filterGrid.setEntityNumber(AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber));
            filterGrid.SetValue(new FilterCondition());
        }
        filterGrid.setFilterColumns(dimensionFilterColumns);
        view.updateView("filtergridap");
    }

    public List<Map<String, Object>> getFilterGridColumns(DynamicObject analysisModel) {
        DynamicObjectCollection measureEntry;
        ArrayList<Map<String, Object>> dimensionFilterColumns = new ArrayList<Map<String, Object>>(4);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        HashSet<String> dimensionNumberSet = new HashSet<String>(4);
        if (dimensionEntry != null) {
            for (Iterator dimensionRow : dimensionEntry) {
                String necessityDim = dimensionRow.getString("necessity_dim");
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim) || DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim) || DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) continue;
                DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
                String dimensionNumber = dimension.getString("number");
                dimensionNumberSet.add(dimensionNumber);
            }
        }
        if ((measureEntry = analysisModel.getDynamicObjectCollection("measure_entry")) != null) {
            for (DynamicObject measureRow : measureEntry) {
                String measureNumber;
                DynamicObject measure = measureRow.getDynamicObject("measure");
                if (measure == null || (measureNumber = measure.getString("number")) == null) continue;
                dimensionNumberSet.add(measureNumber.toLowerCase());
            }
        }
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModel.getString("tablenumber"));
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List allFilterColumns = entityTypeUtil.createFilterColumns((IDataEntityType)entityType, false);
        for (Map currentFilterColumn : allFilterColumns) {
            String fieldName = String.valueOf(currentFilterColumn.get("fieldName"));
            if (dimensionNumberSet.contains(fieldName.toLowerCase())) {
                dimensionFilterColumns.add(currentFilterColumn);
                continue;
            }
            int charIndex = fieldName.indexOf(".");
            String prefixFiled = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!dimensionNumberSet.contains(prefixFiled.toLowerCase())) continue;
            dimensionFilterColumns.add(currentFilterColumn);
        }
        return dimensionFilterColumns;
    }

    public boolean checkModelTable() {
        Long modelPkID = this.getModelPkID();
        IReportView view = this.getView();
        if (modelPkID == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"FAFAbstactModelReport_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelPkID);
        if (StringUtils.isNotEmpty((String)modelNewVersionMsg)) {
            view.showTipNotification(modelNewVersionMsg);
            return false;
        }
        String tableNumber = this.getModelTableNumber();
        String tableNumberCache = this.getPageCache().get("tablenumber");
        if (tableNumber != null && !tableNumber.equals(tableNumberCache)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u5df2\u53d8\u66f4\u6216\u8005\u9875\u9762\u7f13\u5b58\u5931\u6548\uff0c\u8bf7\u5207\u6362\u6a21\u578b\u540e\u91cd\u65b0\u9009\u62e9\u6216\u8005\u8bf7\u5237\u65b0\u9875\u9762\u6216\u8005\u70b9\u51fb\u91cd\u7f6e\u6309\u94ae\u3002", (String)"FAFAbstactModelReport_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected abstract String getModelTableNumber();

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.checkModelTable();
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName = evt.getFieldName();
        int charIndex = fieldName.lastIndexOf(".");
        logger.info("\u591a\u529f\u80fd\u8fc7\u6ee4\u63a7\u4ef6beforeF7Select\uff1afieldName=" + fieldName + "charIndex=" + charIndex);
        if (charIndex != -1) {
            Tuple2 dimSourceNumber;
            String dimensionNumber = fieldName.substring(0, charIndex);
            logger.info("\u591a\u529f\u80fd\u8fc7\u6ee4\u63a7\u4ef6beforeF7Select\uff1adimensionNumber=" + dimensionNumber);
            Long systemId = this.getSystemId();
            if (systemId == null) {
                return;
            }
            QFilter filter = new QFilter("number", "=", (Object)dimensionNumber).and(new QFilter("system", "=", (Object)systemId));
            logger.info("\u591a\u529f\u80fd\u8fc7\u6ee4\u63a7\u4ef6beforeF7Select\uff1a" + filter.toString());
            DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_dimension", (QFilter[])filter.toArray());
            if (dimension != null && (dimSourceNumber = DimensionDyUtil.getDimensionSourceNumberFromDimension((DynamicObject)dimension)) != null && dimSourceNumber.t2 != null && ((QFilter[])dimSourceNumber.t2).length > 0) {
                evt.getCustomQFilters().addAll(Arrays.asList((Object[])dimSourceNumber.t2));
            }
        }
    }
}

