/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.IDataDateUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public abstract class FAFReportDynFieldClass
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private final String MODEL;
    private final String PERIOD;
    private final String DATERANGE;
    private final String ACCOUNT;
    private final String ORG;
    private boolean notLoadDefaultScheme = false;
    private boolean orgNeedAuthority = true;
    protected static final String CURRENT_DIMENSION_TYPE = "CurrentDimensionTypeCache";

    public void setOrgNeedAuthority(boolean orgNeedAuthority) {
        this.orgNeedAuthority = orgNeedAuthority;
    }

    public FAFReportDynFieldClass(@NotNull String relatedFieldOfModel, String ORG, String ACCOUNT, String PERIOD, String DATERANGE) {
        this.MODEL = relatedFieldOfModel;
        this.PERIOD = PERIOD;
        this.DATERANGE = DATERANGE;
        this.ACCOUNT = ACCOUNT;
        this.ORG = ORG;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.PERIOD != null) {
            BasedataEdit period = (BasedataEdit)this.getView().getControl(this.PERIOD);
            period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.ORG != null) {
            BasedataEdit org = (BasedataEdit)this.getView().getControl(this.ORG);
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.ACCOUNT != null) {
            BasedataEdit account = (BasedataEdit)this.getView().getControl(this.ACCOUNT);
            account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (this.MODEL.equals(name)) {
            Long modelPKId = this.getModelPkID();
            if (this.PERIOD != null) {
                this.getModel().setValue(this.PERIOD, (Object)"");
            }
            if (this.ORG != null) {
                this.getModel().setValue(this.ORG, (Object)"");
            }
            if (this.ACCOUNT != null) {
                this.getModel().setValue(this.ACCOUNT, (Object)"");
            }
            IDefaultValueSet defaultValueSet = this.getIDefaultValueSet();
            this.getFilter(modelPKId, defaultValueSet);
            this.registDynamicProps(this.getModel().getDataEntityType());
            this.setDefaultValue();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (fieldKey.equals(this.PERIOD) || fieldKey.equals(this.ORG) || fieldKey.equals(this.ACCOUNT)) {
            String filter = this.getPageCache().get("filterF7Filter");
            Map map = filter == null ? Collections.EMPTY_MAP : (Map)SerializationUtils.deSerializeFromBase64((String)filter);
            this.beforeSelectPeriodOrOrgOrAccount(fieldKey, map, evt);
        }
    }

    public abstract Long getModelPkID();

    public abstract void beforeSelectPeriodOrOrgOrAccount(String var1, Map<String, QFilter[]> var2, BeforeF7SelectEvent var3);

    public IDefaultValueSet getIDefaultValueSet() {
        return new IDefaultValueSet();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void registDynamicProps(MainEntityType newMainType) {
        this.registDynamicProps(newMainType, null);
    }

    public void registDynamicProps(MainEntityType newMainType, Map<String, String> map) {
        if (map == null) {
            String filterEntity = this.getPageCache().get("filterEntity");
            if (filterEntity == null) {
                return;
            }
            map = (Map)SerializationUtils.deSerializeFromBase64((String)filterEntity);
        }
        String orgEntityName = map.get(this.ORG);
        String periodEntityName = map.get(this.PERIOD);
        String accountEntityName = (String)map.get(this.ACCOUNT);
        DynamicProperty org = newMainType.getProperty(this.ORG);
        this.changeEntity(org, orgEntityName);
        DynamicProperty account = newMainType.getProperty(this.ACCOUNT);
        this.changeEntity(account, accountEntityName);
        DynamicProperty period = newMainType.getProperty(this.PERIOD);
        this.changeEntity(period, periodEntityName);
    }

    private void changeEntity(DynamicProperty dynamicProperty, String entityName) {
        if (entityName == null) {
            return;
        }
        if (dynamicProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dynamicProperty;
            basedataProp.setBaseEntityId(entityName);
            basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName));
        } else if (dynamicProperty instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicProperty;
            mulBasedataProp.setBaseEntityId(entityName);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
            ((BasedataProp)mulBasedataProp.getRefBaseProp()).setBaseEntityId(entityName);
            ((BasedataProp)mulBasedataProp.getRefBaseProp()).setComplexType((IDataEntityType)dt);
        }
    }

    protected AbstractPeriod<?> buildPeriod(DimensionTypeEnum dimensionTypeEnum) {
        AbstractPeriod period;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PERIOD, this.DATERANGE});
        if (dimensionTypeEnum == DimensionTypeEnum.DATABASE || dimensionTypeEnum == DimensionTypeEnum.PERIOD || dimensionTypeEnum == DimensionTypeEnum.ASSISTANTDATA) {
            period = new Period((AbstractFormPlugin)this);
        } else if (dimensionTypeEnum == DimensionTypeEnum.DATE) {
            period = new DateRange((AbstractFormPlugin)this);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u6807\u8bb0\u7684\u65f6\u95f4\u671f\u95f4\u5fc5\u8981\u7ef4\u5ea6\u7684\u7c7b\u578b\u76ee\u524d\u53ea\u652f\u6301\u57fa\u7840\u8d44\u6599\u3001\u671f\u95f4\u7ef4\u5ea6\u3001\u8f85\u52a9\u8d44\u6599\u3001\u65f6\u95f4", (String)"FAFReportDynFieldClass_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(CURRENT_DIMENSION_TYPE, dimensionTypeEnum.getCodeString());
        this.getView().setVisible(Boolean.TRUE, new String[]{period.getControlKey()});
        return period;
    }

    public AbstractPeriod<?> getCurrentDimensionType() {
        String currentDimensionType = this.getPageCache().get(CURRENT_DIMENSION_TYPE);
        return this.buildPeriod(DimensionTypeEnum.getCode((String)currentDimensionType));
    }

    public void getFilter(Long modelPkValue) {
        this.getFilter(modelPkValue, this.getIDefaultValueSet());
    }

    public void getFilter(Long modelPkValue, IDefaultValueSet defaultValueSet) {
        if (modelPkValue == null) {
            return;
        }
        if (defaultValueSet == null) {
            defaultValueSet = new IDefaultValueSet();
        }
        DimensionTypeEnum dimensionTypeFromNess = DimensionDyUtil.getDimensionTypeFromNess((Long)modelPkValue, (DimensionNecessityEnum)DimensionNecessityEnum.PERIOD);
        this.buildPeriod(dimensionTypeFromNess);
        HashMap filterEntity = new HashMap(3);
        HashMap filterDefaultValue = new HashMap(1);
        HashMap filterF7filter = new HashMap(3);
        Map dimensionNecessityEnumTuple2Map = DimensionDyUtil.loopDoDimensionNecessity((Long)modelPkValue, DimensionDyUtil::getDimensionSourceNumberFromDimension);
        IDefaultValueSet finalDefaultValueSet = defaultValueSet;
        dimensionNecessityEnumTuple2Map.forEach((k, v) -> {
            if (v != null) {
                String entity = (String)v.t1;
                Object[] f7Filters = (QFilter[])v.t2;
                if (k == DimensionNecessityEnum.ORG && this.ORG != null) {
                    filterEntity.put(this.ORG, entity);
                    if (this.orgNeedAuthority) {
                        OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)this.getModel().getDataEntityType().getName(), (String)this.getView().getFormShowParameter().getAppId());
                        Object[] qFilters = null;
                        qFilters = permOrgResult.hasAllOrgPerm() ? QFilter.of((String)"1=1", (Object[])new Object[0]).toArray() : new QFilter("id", "in", (Object)permOrgResult.getPermOrgs()).toArray();
                        f7Filters = (QFilter[])ArrayUtils.addAll((Object[])qFilters, (Object[])f7Filters);
                    }
                    filterF7filter.put(this.ORG, f7Filters);
                    Object defaultValue = finalDefaultValueSet.orgDefaultSet(entity, (QFilter[])f7Filters);
                    if (defaultValue != null) {
                        filterDefaultValue.put(this.ORG, defaultValue);
                    }
                } else if (k == DimensionNecessityEnum.PERIOD && this.PERIOD != null) {
                    filterEntity.put(this.PERIOD, entity);
                    filterF7filter.put(this.PERIOD, f7Filters);
                    Object defaultValue = finalDefaultValueSet.periodDefaultSet(entity, (QFilter[])f7Filters);
                    if (defaultValue != null) {
                        filterDefaultValue.put(this.PERIOD, defaultValue);
                    }
                } else if (k == DimensionNecessityEnum.ACCOUNT && this.ACCOUNT != null) {
                    filterEntity.put(this.ACCOUNT, entity);
                    filterF7filter.put(this.ACCOUNT, f7Filters);
                    Object defaultValue = finalDefaultValueSet.accountDefaultSet(entity, (QFilter[])f7Filters);
                    if (defaultValue != null) {
                        filterDefaultValue.put(this.ACCOUNT, defaultValue);
                    }
                }
            }
        });
        this.getPageCache().put("filterEntity", SerializationUtils.serializeToBase64(filterEntity));
        this.getPageCache().put("filterDefaultValue", SerializationUtils.serializeToBase64(filterDefaultValue));
        this.getPageCache().put("filterF7Filter", SerializationUtils.serializeToBase64(filterF7filter));
    }

    private void setDefaultValue() {
        String filterDefaultValue = this.getPageCache().get("filterDefaultValue");
        if (filterDefaultValue == null) {
            return;
        }
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)filterDefaultValue);
        Iterator iterator = map.entrySet().iterator();
        IDataModel model = this.getModel();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            Object value = next.getValue();
            model.setValue(key, value);
        }
    }

    public boolean isNotLoadDefaultScheme() {
        return this.notLoadDefaultScheme;
    }

    public void setNotLoadDefaultScheme(boolean notLoadDefaultScheme) {
        this.notLoadDefaultScheme = notLoadDefaultScheme;
    }

    public String getMODEL() {
        return this.MODEL;
    }

    public String getPERIOD() {
        return this.PERIOD;
    }

    public String getDATERANGE() {
        return this.DATERANGE;
    }

    public String getACCOUNT() {
        return this.ACCOUNT;
    }

    public String getORG() {
        return this.ORG;
    }

    public static class IDefaultValueSet {
        public Object orgDefaultSet(String entity, QFilter[] f7Filters) {
            return null;
        }

        public Object periodDefaultSet(String entity, QFilter[] f7Filters) {
            return null;
        }

        public Object accountDefaultSet(String entity, QFilter[] f7Filters) {
            return null;
        }
    }

    public class DateRange
    extends AbstractPeriod<Tuple2<Date, Date>> {
        private static final long serialVersionUID = -8002793396894584598L;

        public DateRange(AbstractFormPlugin abstractFormPlugin) {
            super(abstractFormPlugin, FAFReportDynFieldClass.this.DATERANGE, ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FAFReportDynFieldClass_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), true);
        }

        @Override
        public Tuple2<Date, Date> getValue() {
            Date startdate = (Date)this.abstractFormPlugin.getView().getModel().getValue("startdate");
            Date enddate = (Date)this.abstractFormPlugin.getView().getModel().getValue("enddate");
            if (startdate == null && enddate == null) {
                return null;
            }
            return new Tuple2((Object)startdate, (Object)enddate);
        }

        @Override
        public void setValue(Object object) {
            if (object instanceof JSONObject) {
                object = JSONObject.parseObject((String)object.toString(), Tuple2.class);
            }
            if (object instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)object;
                this.abstractFormPlugin.getView().getModel().setValue("startdate", (Object)this.getDate(tuple2.t1));
                this.abstractFormPlugin.getView().getModel().setValue("enddate", (Object)this.getDate(tuple2.t2));
            }
        }

        public Date getDate(Object object) {
            Date date = null;
            if (object instanceof String) {
                String dateString;
                date = IDataDateUtil.stringToDate((String)dateString, (String)((dateString = (String)object).length() == 19 ? "yyyy-MM-dd HH:mm:ss" : "yyyyMMdd"));
            } else if (object instanceof Date) {
                date = (Date)object;
            }
            return date;
        }

        @Override
        public QFilter getQFilter(String periodNumber) {
            Tuple2<Date, Date> value = this.getValue();
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if (value == null) {
                return qFilter;
            }
            Date t1 = (Date)value.t1;
            Date t2 = (Date)value.t2;
            if (t1 != null) {
                qFilter = new QFilter(periodNumber, ">=", (Object)t1);
            }
            if (t2 != null) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(t2.toInstant(), ZoneId.systemDefault());
                localDateTime = localDateTime.plusDays(1L);
                Date to = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                QFilter qFilter2 = new QFilter(periodNumber, "<", (Object)to);
                qFilter = qFilter.and(qFilter2);
            }
            return qFilter;
        }

        @Override
        public String getQFilterShowMessage() {
            Tuple2<Date, Date> value = this.getValue();
            if (value == null) {
                return "";
            }
            if (value.t1 == null && value.t2 != null) {
                return IDataDateUtil.dateToString((Date)((Date)value.t2)) + String.format(ResManager.loadKDString((String)"\u4ee5\u524d~%s", (String)"FAFReportDynFieldClass_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), IDataDateUtil.dateToString((Date)((Date)value.t2)));
            }
            if (value.t1 != null && value.t2 == null) {
                return String.format(ResManager.loadKDString((String)"%1$s~$2$s\u4ee5\u540e", (String)"FAFReportDynFieldClass_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), IDataDateUtil.dateToString((Date)((Date)value.t1)), IDataDateUtil.dateToString((Date)((Date)value.t1)));
            }
            return IDataDateUtil.dateToString((Date)((Date)value.t1)) + "~" + IDataDateUtil.dateToString((Date)((Date)value.t2));
        }
    }

    public class Period
    extends AbstractPeriod<Long> {
        private static final long serialVersionUID = -2083069583270752838L;

        public Period(AbstractFormPlugin abstractFormPlugin) {
            super(abstractFormPlugin, FAFReportDynFieldClass.this.PERIOD, ResManager.loadKDString((String)"\u671f\u95f4", (String)"FAFReportDynFieldClass_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), true);
        }

        @Override
        public Long getValue() {
            DynamicObject dynamicObject = (DynamicObject)this.abstractFormPlugin.getView().getModel().getValue(FAFReportDynFieldClass.this.PERIOD);
            if (dynamicObject == null) {
                return null;
            }
            return (Long)dynamicObject.getPkValue();
        }

        @Override
        public void setValue(Object aLong) {
            if (aLong instanceof Long || aLong instanceof Integer) {
                this.abstractFormPlugin.getView().getModel().setValue(FAFReportDynFieldClass.this.PERIOD, aLong);
            } else {
                this.abstractFormPlugin.getView().getModel().setValue(FAFReportDynFieldClass.this.PERIOD, null);
            }
        }

        @Override
        public QFilter getQFilter(String periodNumber) {
            return new QFilter(periodNumber, "=", (Object)this.getValue());
        }

        @Override
        public String getQFilterShowMessage() {
            DynamicObject dynamicObject = (DynamicObject)this.abstractFormPlugin.getView().getModel().getValue(FAFReportDynFieldClass.this.PERIOD);
            if (dynamicObject == null) {
                return "";
            }
            return dynamicObject.getString("name");
        }
    }

    public static abstract class AbstractPeriod<T>
    implements Serializable {
        private static final long serialVersionUID = -1137107245220234210L;
        String controlKey;
        String controlName;
        boolean isMustInput;
        AbstractFormPlugin abstractFormPlugin;

        public AbstractPeriod(AbstractFormPlugin abstractFormPlugin, String controlKey, String controlName, boolean isMustInput) {
            this.abstractFormPlugin = abstractFormPlugin;
            this.controlKey = controlKey;
            this.controlName = controlName;
            this.isMustInput = isMustInput;
        }

        public abstract T getValue();

        public abstract void setValue(Object var1);

        public abstract QFilter getQFilter(String var1);

        public abstract String getQFilterShowMessage();

        public String getControlKey() {
            return this.controlKey;
        }

        public boolean isMustInput() {
            return this.isMustInput;
        }

        public String getControlName() {
            return this.controlName;
        }
    }
}

