/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.FAFTableUtil;

public class FAFScanRebuildModelPlugin
extends AbstractFormPlugin {
    private static final Map<String, Boolean> centerIdMap = new ConcurrentHashMap<String, Boolean>();

    public void createNewData(BizDataEventArgs e) {
        String centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        if (centerIdMap.get(centerId) == null) {
            centerIdMap.put(centerId, Boolean.TRUE);
            Runnable runnable = () -> {
                QFilter qFilter = new QFilter("tablenumber", "!=", (Object)" ");
                DynamicObjectCollection analysisModels = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,tablenumber,tablename", (QFilter[])new QFilter[]{qFilter});
                for (DynamicObject analysisModel : analysisModels) {
                    boolean exist;
                    String tableNumber = analysisModel.getString("tablenumber");
                    if (!StringUtils.isNotEmpty((String)tableNumber) || (exist = MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber)))) continue;
                    String tableName = analysisModel.getString("tablename");
                    Long id = analysisModel.getLong("id");
                    FAFTableUtil.createOrDropTable((Long)id, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (Boolean)Boolean.FALSE);
                }
            };
            ThreadPools.executeOnce((String)"PAScanRebuildModelPlugin", (Runnable)runnable);
        }
    }
}

