/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.asynctask.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.faf.asynctask.model.ModelUpgradeProcessTask;

public class BackGroupUpgradeTaskCreator {
    public static void createBackGroundModelUpgradeTask(IFormView view, Map<Long, List<Long>> toUpgradeSystemModelsMap) {
        Map systemIdMap = BusinessDataServiceHelper.loadFromCache((Object[])toUpgradeSystemModelsMap.keySet().toArray(), (String)"pa_anasystemsetting");
        for (Map.Entry<Long, List<Long>> systemIdAndModelIdsEntry : toUpgradeSystemModelsMap.entrySet()) {
            Long systemId = systemIdAndModelIdsEntry.getKey();
            List<Long> modelIdsOfSystem = systemIdAndModelIdsEntry.getValue();
            JobFormInfo jobFormInfo = BackGroupUpgradeTaskCreator.createJobFormInfoBySystem(view, (DynamicObject)systemIdMap.get(systemId), modelIdsOfSystem);
            BackGroupUpgradeTaskCreator.dispatchAndDoBackgroundTask(view, jobFormInfo);
        }
    }

    private static JobFormInfo createJobFormInfoBySystem(IFormView view, DynamicObject systemDyObj, List<Long> modelIdsOfSystem) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskId(String.valueOf(DB.genGlobalLongId()));
        jobInfo.setAppId("faf");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setNumber(systemDyObj.getString("number"));
        jobInfo.setName(systemDyObj.getString("name"));
        jobInfo.setTaskClassname(ModelUpgradeProcessTask.class.getName());
        HashMap<String, Object> jobInfoParam = new HashMap<String, Object>();
        jobInfoParam.put("task_id", jobInfo.getTaskId());
        jobInfoParam.put("ana_system_id", systemDyObj.getLong("id"));
        jobInfoParam.put("ana_model_ids", modelIdsOfSystem);
        jobInfoParam.put("lang", RequestContext.get().getLang().toString());
        jobInfo.setParams(jobInfoParam);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setParentPageId(view.getPageId());
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private static void dispatchAndDoBackgroundTask(IFormView view, JobFormInfo jobFormInfo) {
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        jobDispatcher.dispatch(jobFormInfo.getJobInfo());
        String taskId = jobFormInfo.getJobInfo().getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((IFormView)view, (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"FAFModelUpgrade-background-monitor", (Runnable)subscriber);
        }
    }
}

