/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.asynctask.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.faf.asynctask.model.ModelUpgradeModelDTO;
import kd.macc.faf.asynctask.model.ModelUpgradeProcessManager;
import kd.macc.faf.asynctask.model.ModelUpgradeSystemDTO;
import kd.macc.faf.enums.FAFCollectStatusEnum;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.enums.ModelUpgradeStatusEnum;
import kd.macc.faf.exception.ModelUpgradeException;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.ModelUpgradeHelper;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.system.FAFAnalysisModelEdit;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import kd.macc.faf.util.FAFTableUtil;

public class ModelUpgradeProcessTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ModelUpgradeProcessTask.class);
    public static final String ANA_SYSTEM_ID = "ana_system_id";
    public static final String ANA_MODEL_IDS = "ana_model_ids";
    public static final String TASK_ID = "task_id";
    public static final String LANGUAGE = "lang";
    private static final ExecutorService fafModelUpgradeExecutorService = ThreadPools.newExecutorService((String)"faf_model_upgrade", (int)(Runtime.getRuntime().availableProcessors() * 2));

    public void execute(RequestContext requestContext, Map<String, Object> taskParams) throws KDException {
        String langStr = (String)taskParams.get(LANGUAGE);
        if (StringUtils.isNotBlank((CharSequence)langStr)) {
            RequestContext.get().setLang(Lang.from((String)langStr));
        }
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"ModelUpgradeProcessTask_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), null);
        ModelUpgradeSystemDTO modelUpgradeSystemDTO = null;
        try {
            modelUpgradeSystemDTO = this.beforeExecuteUpgrade(taskParams);
            this.executeUpgrade(modelUpgradeSystemDTO);
            this.afterExecuteUpgrade(modelUpgradeSystemDTO);
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            this.feedbackProgress(100, errorMessage, null);
            logger.error(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u5931\u8d25] taskId:%1$s\uff0c\u5f02\u5e38\u4fe1\u606f:%2$s\uff0c\u5347\u7ea7\u5bf9\u8c61:%3$s\u3002", modelUpgradeSystemDTO != null ? modelUpgradeSystemDTO.getTaskId() : "", errorMessage, modelUpgradeSystemDTO));
            this.saveInException(exception, modelUpgradeSystemDTO);
            throw new KDBizException(errorMessage);
        }
    }

    private void saveInException(Exception exception, ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        if (modelUpgradeSystemDTO != null) {
            for (ModelUpgradeModelDTO upgradeModelDTO : modelUpgradeSystemDTO.getUpgradeModelDTOList()) {
                upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                upgradeModelDTO.setUpgradeErrorMessage(exception.getMessage());
            }
            try {
                this.saveRecordsAfterUpgrading(modelUpgradeSystemDTO);
            }
            catch (Exception e) {
                logger.error(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u5931\u8d25\u540e,\u5f02\u5e38\u72b6\u6001\u66f4\u65b0\u5931\u8d25] taskId:%1$s\uff0c\u5f02\u5e38\u4fe1\u606f:%2$s\uff0c\u5347\u7ea7\u5bf9\u8c61:%3$s\u3002", modelUpgradeSystemDTO.getTaskId(), e.getMessage(), modelUpgradeSystemDTO));
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private ModelUpgradeSystemDTO beforeExecuteUpgrade(Map<String, Object> taskParams) {
        String taskId;
        List anaModelIds;
        Long anaSystemId = (Long)taskParams.get(ANA_SYSTEM_ID);
        ModelUpgradeSystemDTO modelUpgradeSystemDTO = this.buildModelUpgradeSystemDTO(anaSystemId, anaModelIds = (List)taskParams.get(ANA_MODEL_IDS), taskId = (String)taskParams.get(TASK_ID));
        if (modelUpgradeSystemDTO == null || CollectionUtils.isEmpty((Collection)modelUpgradeSystemDTO.getUpgradeModelDTOList())) {
            logger.error(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u524d] \u5f53\u524d\u5347\u7ea7\u4f53\u7cfb\u4e0d\u5b58\u5728,\u4f53\u7cfbid\uff1a%1$s\uff0c\u6a21\u578bid\u4e3a\uff1a(%2$s)\u3002", anaSystemId, anaModelIds));
            throw new ModelUpgradeException(ResManager.loadKDString((String)"\u5347\u7ea7\u7684\u5206\u6790\u4f53\u7cfb\u6216\u6a21\u578b\u4e0d\u5b58\u5728", (String)"ModelUpgradeProcessTask_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u91cd\u5efa\u660e\u7ec6\u6570\u636e\u8868...", (String)"ModelUpgradeProcessTask_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), null);
        this.createDetailTable(modelUpgradeSystemDTO);
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u521b\u5efa\u5347\u7ea7\u65e5\u5fd7...", (String)"ModelUpgradeProcessTask_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), null);
        this.saveRecordsBeforeUpgrading(modelUpgradeSystemDTO);
        logger.info(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u524d] taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801\uff1a%2$s\uff0c\u5f85\u5347\u7ea7\u6a21\u578b\u7f16\u7801\uff1a(%3$s)\u3002", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), modelUpgradeSystemDTO.getUpgradeModelDTOList().stream().map(ModelUpgradeModelDTO::getModelNumber).collect(Collectors.toList())));
        return modelUpgradeSystemDTO;
    }

    private void saveRecordsBeforeUpgrading(ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        DynamicObject upgradeRecordsOfCurrentSystem = ModelUpgradeHelper.loadModelUpgradeRecordsByAnaSystemId((Long)modelUpgradeSystemDTO.getSystemId());
        upgradeRecordsOfCurrentSystem.set("lastedtaskid", (Object)modelUpgradeSystemDTO.getTaskId());
        DynamicObjectCollection upgradeRecordsOfModel = upgradeRecordsOfCurrentSystem.getDynamicObjectCollection("entryentity");
        for (ModelUpgradeModelDTO upgradeModelDTO : modelUpgradeSystemDTO.getUpgradeModelDTOList()) {
            Optional<DynamicObject> any = upgradeRecordsOfModel.stream().filter(model -> upgradeModelDTO.getModelId().longValue() == model.getLong("anamodel_id")).findAny();
            if (!any.isPresent()) {
                logger.error(String.format("\u66f4\u65b0\u5347\u7ea7\u65e5\u5fd7\u4e3a\u8fdb\u884c\u72b6\u6001\u65f6(Upgrading or Fail)\u65f6,\u672a\u627e\u5230\u5bf9\u5e94\u7684TO UPGRADE\u6a21\u578b\u5347\u7ea7\u65e5\u5fd7 : taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801:%2$s\uff0c\u7f16\u7801\u7f16\u7801\uff1a%3$s", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), upgradeModelDTO.getModelName()));
                continue;
            }
            DynamicObject modelRecord = any.get();
            if (ModelUpgradeStatusEnum.CANCEL_UPGRADE != ModelUpgradeStatusEnum.getEnumByCode((String)modelRecord.getString("upgradestatus"))) {
                modelRecord.set("upgradecountinpurpose", (Object)upgradeModelDTO.getUpgradeTotalCount());
                modelRecord.set("upgradecountinfact", (Object)0);
                modelRecord.set("taskid", (Object)upgradeModelDTO.getTaskId());
                modelRecord.set("starttime", (Object)upgradeModelDTO.getStartTime());
                modelRecord.set("endtime", null);
                ModelUpgradeStatusEnum upgradeStatus = upgradeModelDTO.getUpgradeStatus();
                switch (upgradeStatus) {
                    case UPGRADING: {
                        modelRecord.set("upgradestatus", (Object)upgradeStatus.getCode());
                        modelRecord.set("errormessage", (Object)"");
                        break;
                    }
                    case FAIL: {
                        String upgradeErrorMessage = upgradeModelDTO.getUpgradeErrorMessage();
                        modelRecord.set("upgradestatus", (Object)upgradeStatus.getCode());
                        modelRecord.set("errormessage", (Object)(StringUtils.isBlank((CharSequence)upgradeErrorMessage) ? "" : upgradeErrorMessage.substring(0, Math.min(upgradeErrorMessage.length(), 255))));
                        break;
                    }
                    default: {
                        String errorMessage = String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5347\u7ea7\u524d - \u975e\u6cd5\u72b6\u6001\uff1a%s", (String)"ModelUpgradeProcessTask_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), upgradeStatus.getCode());
                        modelRecord.set("upgradestatus", (Object)ModelUpgradeStatusEnum.FAIL.getCode());
                        modelRecord.set("errormessage", (Object)errorMessage.substring(0, Math.min(errorMessage.length(), 255)));
                        upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                        upgradeModelDTO.setUpgradeErrorMessage(errorMessage);
                        break;
                    }
                }
                continue;
            }
            upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.CANCEL_UPGRADE);
            String detailEntityNumber = upgradeModelDTO.getTableEntityNumber() + "_d";
            if (!MetadataDao.checkNumber((String)detailEntityNumber)) continue;
            CustomizedDynamicFormBuilderUtil.deleteForm((String)detailEntityNumber, (boolean)true);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{upgradeRecordsOfCurrentSystem});
    }

    private void createDetailTable(ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        List upgradeModelDTOList = modelUpgradeSystemDTO.getUpgradeModelDTOList();
        Map modelDyMap = BusinessDataServiceHelper.loadFromCache((Object[])upgradeModelDTOList.stream().map(ModelUpgradeModelDTO::getModelId).toArray(Long[]::new), (String)"pa_analysismodel");
        for (ModelUpgradeModelDTO upgradeModelDTO : upgradeModelDTOList) {
            DynamicObject model = (DynamicObject)modelDyMap.get(upgradeModelDTO.getModelId());
            if (model == null) continue;
            String tableNumber = model.getString("tablenumber");
            String inputTableName = (String)model.get("tablename");
            String tableNumber_dtl = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber.toLowerCase());
            try {
                CustomizedFormBuilderInfo builderInfo;
                IDataMapEntry result;
                if (MetadataDao.checkNumber((String)tableNumber_dtl)) {
                    CustomizedDynamicFormBuilderUtil.deleteForm((String)tableNumber_dtl, (boolean)true);
                }
                if ((result = FAFTableUtil.createOrDropTable((Long)model.getLong("id"), (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)inputTableName, (Boolean)Boolean.FALSE, (boolean)true)) == null) {
                    upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                    upgradeModelDTO.setUpgradeErrorMessage(ResManager.loadKDString((String)"[\u521b\u5efa\u52a8\u6001\u660e\u7ec6\u8868\u5931\u8d25]", (String)"ModelUpgradeProcessTask_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                } else if (FAFSyncLogStatusEnum.SUCCESS != result.getKey()) {
                    upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                    upgradeModelDTO.setUpgradeErrorMessage(String.format(ResManager.loadKDString((String)"[\u521b\u5efa\u52a8\u6001\u660e\u7ec6\u8868\u5931\u8d25] : %s", (String)"ModelUpgradeProcessTask_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), result.getValue()));
                }
                if (!FAFAnalysisModelEdit.isMetaNeedRebuild(builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)inputTableName, (String)"2UK0B8T0A=WJ", (String)"BaseFormModel"), AnalysisModelUtil.buildEntityNumber((String)tableNumber), Boolean.FALSE)) continue;
                EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderInfo, (DynamicObject)model);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderInfo, (Boolean)Boolean.FALSE), (boolean)true);
            }
            catch (Exception exception) {
                upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                upgradeModelDTO.setUpgradeErrorMessage(String.format(ResManager.loadKDString((String)"[\u521b\u5efa\u52a8\u6001\u660e\u7ec6\u8868\u5931\u8d25]\uff1a%s", (String)"ModelUpgradeProcessTask_7", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()));
            }
        }
    }

    private void executeUpgrade(final ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        final ModelUpgradeProcessManager processManager = ModelUpgradeProcessManager.getInstance((ModelUpgradeSystemDTO)modelUpgradeSystemDTO);
        List futureList = modelUpgradeSystemDTO.getUpgradeModelDTOList().stream().map(modelDTO -> new Callable<ModelUpgradeModelDTO>(){

            @Override
            public ModelUpgradeModelDTO call() {
                if (ModelUpgradeStatusEnum.UPGRADING == modelDTO.getUpgradeStatus()) {
                    ModelUpgradeProcessTask.this.upgradeModel(modelDTO, modelUpgradeSystemDTO, processManager);
                }
                modelDTO.setEndTime(new Date());
                return modelDTO;
            }
        }).map(fafModelUpgradeExecutorService::submit).collect(Collectors.toList());
        List upgradeModelDTOList = modelUpgradeSystemDTO.getUpgradeModelDTOList();
        for (int i = 0; i < futureList.size(); ++i) {
            ModelUpgradeModelDTO UpgradeModelDTOInException;
            try {
                ModelUpgradeModelDTO upgradeModelDTO = (ModelUpgradeModelDTO)((Future)futureList.get(i)).get(24L, TimeUnit.HOURS);
                if (ModelUpgradeStatusEnum.SUCCESS != upgradeModelDTO.getUpgradeStatus() || this.isTotallyModelUpgrade(upgradeModelDTO)) continue;
                upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                upgradeModelDTO.setUpgradeErrorMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e0d\u5b8c\u6574: %1$s / %2$s", (String)"ModelUpgradeProcessTask_8", (String)"macc-faf-formplugin", (Object[])new Object[0]), upgradeModelDTO.getUpgradeCountInFact(), upgradeModelDTO.getUpgradeTotalCount()));
                continue;
            }
            catch (TimeoutException exception) {
                UpgradeModelDTOInException = (ModelUpgradeModelDTO)upgradeModelDTOList.get(i);
                UpgradeModelDTOInException.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                UpgradeModelDTOInException.setUpgradeErrorMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u65f6", (String)"ModelUpgradeProcessTask_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                continue;
            }
            catch (Exception exception) {
                UpgradeModelDTOInException = (ModelUpgradeModelDTO)upgradeModelDTOList.get(i);
                boolean isCancelUpgrade = this.isCancelUpgrade(UpgradeModelDTOInException, modelUpgradeSystemDTO);
                if (isCancelUpgrade) {
                    UpgradeModelDTOInException.setUpgradeStatus(ModelUpgradeStatusEnum.CANCEL_UPGRADE);
                    UpgradeModelDTOInException.setUpgradeErrorMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u5347\u7ea7", (String)"ModelUpgradeProcessTask_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    continue;
                }
                UpgradeModelDTOInException.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                UpgradeModelDTOInException.setUpgradeErrorMessage(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
            }
        }
        logger.info(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u540e,\u4f53\u7cfb\u4e0b\u6a21\u578b\u5347\u7ea7\u7ed3\u679c] taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801\uff1a%2$s\uff0c\u6a21\u578b\u5347\u7ea7\u7ed3\u679c\uff1a%3$s\u3002", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), upgradeModelDTOList));
    }

    private void upgradeModel(ModelUpgradeModelDTO modelDTO, ModelUpgradeSystemDTO modelUpgradeSystemDTO, ModelUpgradeProcessManager processManager) {
        String tableEntityNumber = modelDTO.getTableEntityNumber();
        MainEntityType summaryEntityType = EntityMetadataCache.getDataEntityType((String)tableEntityNumber);
        int detailIndex = 0;
        int batchQueryCount = 100000;
        Long[] detailIds = new Long[batchQueryCount];
        try (DataSet detailDataSetInSummaryTable = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)tableEntityNumber, (String)this.getFieldsByEntityType(summaryEntityType), (QFilter[])new QFilter[]{new QFilter("collectstatus", "=", (Object)FAFCollectStatusEnum.DETAIL.getCode())}, null);){
            for (Row row : detailDataSetInSummaryTable) {
                detailIds[detailIndex++] = row.getLong("id");
                if (detailIndex != batchQueryCount) continue;
                this.batchExecuteModelUpgrade(detailIds, modelDTO);
                int upgradeProgressOfCurrentTask = processManager.addAndGetProgress((long)detailIndex);
                this.feedbackProgress(upgradeProgressOfCurrentTask, String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff1a%1$s%2$s", (String)"ModelUpgradeProcessTask_11", (String)"macc-faf-formplugin", (Object[])new Object[0]), upgradeProgressOfCurrentTask, "%"), null);
                detailIndex = 0;
                detailIds = new Long[batchQueryCount];
            }
            if (detailIndex > 0) {
                this.batchExecuteModelUpgrade(detailIds, modelDTO);
                int upgradeProgressOfCurrentTask = processManager.addAndGetProgress((long)detailIndex);
                this.feedbackProgress(upgradeProgressOfCurrentTask, String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff1a%1$s%2$s", (String)"ModelUpgradeProcessTask_11", (String)"macc-faf-formplugin", (Object[])new Object[0]), upgradeProgressOfCurrentTask, "%"), null);
            }
            modelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.SUCCESS);
        }
        catch (Exception e) {
            boolean isCancelUpgrade = this.isCancelUpgrade(modelDTO, modelUpgradeSystemDTO);
            if (isCancelUpgrade) {
                modelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.CANCEL_UPGRADE);
                modelDTO.setUpgradeErrorMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u5347\u7ea7", (String)"ModelUpgradeProcessTask_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                modelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.FAIL);
                modelDTO.setUpgradeErrorMessage(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
            }
            logger.error(String.format("{\u6a21\u578b\u6570\u636e\u5347\u7ea7\u5931\u8d25}taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801\uff1a%2$s\uff0c\u6a21\u578b\u7f16\u7801\uff1a%3$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%4$s\u3002", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), modelDTO.getModelNumber(), modelDTO.getUpgradeErrorMessage()));
        }
    }

    private boolean isCancelUpgrade(ModelUpgradeModelDTO modelDTO, ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        if (!MetadataDao.checkNumber((String)(modelDTO.getTableEntityNumber() + "_d"))) {
            QFilter systemFilter = new QFilter("anasystem", "=", (Object)modelUpgradeSystemDTO.getSystemId());
            QFilter modelFilter = new QFilter("entryentity.anamodel", "=", (Object)modelDTO.getModelId());
            DynamicObject cancelUpgradeRecord = QueryServiceHelper.queryOne((String)"faf_modelupgraderecord", (String)"id,entryentity.upgradestatus", (QFilter[])new QFilter[]{systemFilter, modelFilter});
            return cancelUpgradeRecord != null && ModelUpgradeStatusEnum.CANCEL_UPGRADE == ModelUpgradeStatusEnum.getEnumByCode((String)cancelUpgradeRecord.getString("entryentity.upgradestatus"));
        }
        return false;
    }

    private void batchExecuteModelUpgrade(Long[] detailIds, ModelUpgradeModelDTO modelDTO) {
        String tableEntityNumber = modelDTO.getTableEntityNumber();
        MainEntityType summaryEntityType = EntityMetadataCache.getDataEntityType((String)tableEntityNumber);
        MainEntityType detailEntityType = EntityMetadataCache.getDataEntityType((String)(tableEntityNumber + "_d"));
        try (DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)tableEntityNumber, (String)this.getFieldsByEntityType(summaryEntityType), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)detailIds)}, null);
             DataSet detailSummaryMapping = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)"pa_detailsummarymapping", (String)"summaryid,detailid,createtimestamp", (QFilter[])new QFilter[]{new QFilter("detailid", "in", (Object)detailIds)}, null).distinct();
             DataSet sourceModelMapping = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)"pa_sourcemodelmapping", (String)"modeltableid,sourcenumber,sourceentityid", (QFilter[])new QFilter[]{new QFilter("modeltableid", "in", (Object)detailIds)}, null);
             DataSet adjExeDetail = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)"pa_adexecdetail", (String)"execution_logpk,ad_execution_logpk sec_execution_logpk,source_pk,target_pk", (QFilter[])new QFilter[]{new QFilter("target_pk", "in", (Object)detailIds)}, null);
             DataSet offExeDetail = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)"pa_offexecdetail", (String)"execution_logpk,0 sec_execution_logpk,source_pk,target_pk", (QFilter[])new QFilter[]{new QFilter("target_pk", "in", (Object)detailIds)}, null);
             DataSet ruleExeDetail = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)"pa_ruleexecdetail", (String)"execution_logpk,rule_execution_logpk sec_execution_logpk,source_pk,target_pk", (QFilter[])new QFilter[]{new QFilter("target_pk", "in", (Object)detailIds)}, null);){
            DataSet dsJoinWithSummary = detailDataSet.leftJoin(detailSummaryMapping).on("id", "detailid").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{"summaryid", "createtimestamp createstamp"}).finish();
            DataSet distinctJoinWithSummary = this.distinctDataSetByUnDeleteDetailSummaryMapping(dsJoinWithSummary, detailSummaryMapping.copy(), tableEntityNumber);
            DataSet dsJoinWithSource = distinctJoinWithSummary.leftJoin(sourceModelMapping).on("id", "modeltableid").select(distinctJoinWithSummary.getRowMeta().getFieldNames(), new String[]{"sourcenumber sourceformid", "sourceentityid sourcebillid"}).finish();
            DataSet dsJoinWithLogDetail = dsJoinWithSource.leftJoin(adjExeDetail.union(new DataSet[]{offExeDetail, ruleExeDetail})).on("id", "target_pk").select(dsJoinWithSource.getRowMeta().getFieldNames(), new String[]{"execution_logpk execlogid", "sec_execution_logpk subexeclogid", "source_pk execparentbillid"}).finish();
            int dyIndex = 0;
            int batchSaveCount = 5000;
            Object[] dynamicObjects = new DynamicObject[batchSaveCount];
            for (Row row : dsJoinWithLogDetail) {
                dynamicObjects[dyIndex++] = this.transRowToDynamicObject(row, detailEntityType);
                if (dyIndex != batchSaveCount) continue;
                BusinessDataWriter.save((IDataEntityType)detailEntityType, (Object[])dynamicObjects);
                dyIndex = 0;
                dynamicObjects = new DynamicObject[batchSaveCount];
            }
            if (dyIndex > 0) {
                BusinessDataWriter.save((IDataEntityType)detailEntityType, (Object[])Arrays.copyOf(dynamicObjects, dyIndex));
            }
        }
    }

    private DataSet distinctDataSetByUnDeleteDetailSummaryMapping(DataSet dsJoinWithSummary, DataSet detailSummaryMapping, String tableEntityNumber) {
        HashSet<Long> summaryIds = new HashSet<Long>();
        for (Row row : detailSummaryMapping) {
            summaryIds.add(row.getLong("summaryid"));
        }
        try (DataSet summaryDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)tableEntityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", summaryIds)}, null);){
            DataSet dataSet = dsJoinWithSummary.join(summaryDataSet).on("summaryid", "id").select(dsJoinWithSummary.getRowMeta().getFieldNames()).finish();
            return dataSet;
        }
    }

    private void afterExecuteUpgrade(ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        List upgradeModelDTOList = modelUpgradeSystemDTO.getUpgradeModelDTOList();
        try (TXHandle h = TX.required();){
            try {
                this.saveRecordsAfterUpgrading(modelUpgradeSystemDTO);
                this.updateSuccessfulModelVersion(upgradeModelDTOList);
                upgradeModelDTOList.stream().filter(upgradeModel -> ModelUpgradeStatusEnum.SUCCESS == upgradeModel.getUpgradeStatus()).filter(upgradeModel -> MetadataDao.checkNumber((String)(upgradeModel.getTableEntityNumber() + "_d"))).forEach(upgradeModel -> DB.execute((DBRoute)DBRoute.of((String)"fias"), (String)String.format("delete from %s where fcollectstatus = 0", upgradeModel.getTableNumber()), (Object[])new Object[0]));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            logger.error(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u540e,\u6a21\u578b\u5347\u7ea7\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25] taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801\uff1a%2$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%3$s\u3002", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            throw e;
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210", (String)"ModelUpgradeProcessTask_12", (String)"macc-faf-formplugin", (Object[])new Object[0]), null);
    }

    private void saveRecordsAfterUpgrading(ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        DynamicObject upgradeRecordsOfCurrentSystem = ModelUpgradeHelper.loadModelUpgradeRecordsByAnaSystemId((Long)modelUpgradeSystemDTO.getSystemId());
        DynamicObjectCollection upgradeRecordsOfModel = upgradeRecordsOfCurrentSystem.getDynamicObjectCollection("entryentity");
        for (ModelUpgradeModelDTO upgradeModelDTO : modelUpgradeSystemDTO.getUpgradeModelDTOList()) {
            Optional<DynamicObject> any = upgradeRecordsOfModel.stream().filter(model -> upgradeModelDTO.getModelId().longValue() == model.getLong("anamodel_id")).findAny();
            if (!any.isPresent()) {
                logger.error(String.format("\u66f4\u65b0\u5347\u7ea7\u65e5\u5fd7\u4e3a\u7ed3\u675f\u72b6\u6001(Success or Fail)\u65f6,\u672a\u627e\u5230\u5bf9\u5e94\u7684TO UPGRADE\u6a21\u578b\u5347\u7ea7\u65e5\u5fd7 : taskId\uff1a%1$s\uff0c\u4f53\u7cfb\u7f16\u7801:%2$s \uff0c\u7f16\u7801\u7f16\u7801\uff1a%3$s", modelUpgradeSystemDTO.getTaskId(), modelUpgradeSystemDTO.getSystemNumber(), upgradeModelDTO.getModelName()));
                continue;
            }
            DynamicObject modelRecord = any.get();
            if (ModelUpgradeStatusEnum.CANCEL_UPGRADE != ModelUpgradeStatusEnum.getEnumByCode((String)modelRecord.getString("upgradestatus"))) {
                modelRecord.set("upgradecountinfact", (Object)upgradeModelDTO.getUpgradeCountInFact());
                modelRecord.set("endtime", (Object)upgradeModelDTO.getEndTime());
                ModelUpgradeStatusEnum upgradeStatus = upgradeModelDTO.getUpgradeStatus();
                switch (upgradeStatus) {
                    case SUCCESS: {
                        modelRecord.set("upgradestatus", (Object)upgradeStatus.getCode());
                        modelRecord.set("errormessage", (Object)"");
                        break;
                    }
                    case FAIL: {
                        String upgradeErrorMessage = upgradeModelDTO.getUpgradeErrorMessage();
                        modelRecord.set("upgradestatus", (Object)upgradeStatus.getCode());
                        modelRecord.set("errormessage", (Object)(StringUtils.isBlank((CharSequence)upgradeErrorMessage) ? "" : upgradeErrorMessage.substring(0, Math.min(upgradeErrorMessage.length(), 255))));
                        break;
                    }
                    default: {
                        String errorMessage = String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5347\u7ea7\u524d - \u975e\u6cd5\u72b6\u6001\uff1a%s", (String)"ModelUpgradeProcessTask_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), upgradeStatus.getCode());
                        modelRecord.set("upgradestatus", (Object)ModelUpgradeStatusEnum.FAIL.getCode());
                        modelRecord.set("errormessage", (Object)errorMessage.substring(0, Math.min(errorMessage.length(), 255)));
                        break;
                    }
                }
                continue;
            }
            upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.CANCEL_UPGRADE);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{upgradeRecordsOfCurrentSystem});
    }

    private void updateSuccessfulModelVersion(List<ModelUpgradeModelDTO> upgradeModelDTOList) {
        List upgradeSuccessModelIds = upgradeModelDTOList.stream().filter(modelDTO -> ModelUpgradeStatusEnum.SUCCESS == modelDTO.getUpgradeStatus()).filter(modelDTO -> MetadataDao.checkNumber((String)(modelDTO.getTableEntityNumber() + "_d"))).map(modelDTO -> String.valueOf(modelDTO.getModelId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(upgradeSuccessModelIds)) {
            DB.execute((DBRoute)DBRoute.of((String)"fias"), (String)String.format("UPDATE t_%1$s SET FVERSION = 1 WHERE FID IN (%2$s)", "pa_analysismodel", String.join((CharSequence)",", upgradeSuccessModelIds)), (Object[])new Object[0]);
        }
    }

    private ModelUpgradeSystemDTO buildModelUpgradeSystemDTO(Long anaSystemId, List<Long> anaModelIds, String taskId) {
        DynamicObject systemModelUpgradeRecord = ModelUpgradeHelper.loadModelUpgradeRecordsByAnaSystemId((Long)anaSystemId);
        DynamicObjectCollection modelUpgradeRecordOfSystem = systemModelUpgradeRecord.getDynamicObjectCollection("entryentity");
        ModelUpgradeSystemDTO modelUpgradeSystemDTO = null;
        for (Long anaModelId : anaModelIds) {
            Optional<DynamicObject> any = modelUpgradeRecordOfSystem.stream().filter(modelEntry -> modelEntry.getLong("anamodel_id") == anaModelId.longValue()).findAny();
            if (!any.isPresent()) continue;
            DynamicObject modelRecordEntry = any.get();
            if (modelUpgradeSystemDTO == null) {
                modelUpgradeSystemDTO = new ModelUpgradeSystemDTO();
                modelUpgradeSystemDTO.setSystemId(Long.valueOf(systemModelUpgradeRecord.getLong("anasystem.id")));
                modelUpgradeSystemDTO.setSystemNumber(systemModelUpgradeRecord.getString("anasystem.number"));
                modelUpgradeSystemDTO.setSystemName(systemModelUpgradeRecord.getString("anasystem.name"));
                modelUpgradeSystemDTO.setUpgradeModelDTOList(new ArrayList(modelUpgradeRecordOfSystem.size()));
                modelUpgradeSystemDTO.setTaskId(Long.valueOf(taskId));
            }
            DynamicObject model = modelRecordEntry.getDynamicObject("anamodel");
            String tableNumber = modelRecordEntry.getString("summarytablenumber");
            String tableEntityNumber = AnalysisModelUtil.getEntityNumberByTableNumber((String)tableNumber);
            int detailDataSetCountInSummaryTable = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)tableEntityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("collectstatus", "=", (Object)FAFCollectStatusEnum.DETAIL.getCode())}, null).count("id", true);
            ModelUpgradeModelDTO upgradeModelDTO = new ModelUpgradeModelDTO();
            upgradeModelDTO.setModelId(Long.valueOf(model.getLong("id")));
            upgradeModelDTO.setModelNumber(model.getString("number"));
            upgradeModelDTO.setModelName(model.getString("name"));
            upgradeModelDTO.setTableEntityNumber(tableEntityNumber);
            upgradeModelDTO.setTableNumber(tableNumber);
            upgradeModelDTO.setUpgradeStatus(ModelUpgradeStatusEnum.UPGRADING);
            upgradeModelDTO.setUpgradeTotalCount(detailDataSetCountInSummaryTable);
            upgradeModelDTO.setTaskId(Long.valueOf(taskId));
            upgradeModelDTO.setStartTime(new Date());
            List upgradeModelDTOList = modelUpgradeSystemDTO.getUpgradeModelDTOList();
            upgradeModelDTOList.add(upgradeModelDTO);
        }
        return modelUpgradeSystemDTO;
    }

    private boolean isTotallyModelUpgrade(ModelUpgradeModelDTO upgradeModelDTO) {
        int detailUpgradeCountInFact = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.asynctask.model.ModelUpgradeProcessTask", (String)(upgradeModelDTO.getTableEntityNumber() + "_d"), (String)"id", null, null).count("id", true);
        upgradeModelDTO.setUpgradeCountInFact(detailUpgradeCountInFact);
        logger.info(String.format("[\u6a21\u578b\u6570\u636e\u5347\u7ea7\u6570\u636e\u8fc1\u79fb] taskId\uff1a%1$s\uff0c\u6a21\u578bid\uff1a%2$s\uff0c\u9884\u671f\u8fc1\u79fb\u6570\u636e\u603b\u91cf\u4e3a:%3$s\uff0c\u5b9e\u9645\u8fc1\u79fb\u6570\u636e\u603b\u91cf\u4e3a\uff1a%4$s\u3002", upgradeModelDTO.getTaskId(), upgradeModelDTO.getModelNumber(), upgradeModelDTO.getUpgradeTotalCount(), detailUpgradeCountInFact));
        return upgradeModelDTO.getUpgradeTotalCount() == detailUpgradeCountInFact;
    }

    private String getFieldsByEntityType(MainEntityType dataEntityType) {
        return dataEntityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.joining(","));
    }

    private DynamicObject transRowToDynamicObject(Row row, MainEntityType detailDataEntityType) {
        DynamicObject dynObj = new DynamicObject((DynamicObjectType)detailDataEntityType);
        for (IDataEntityProperty property : detailDataEntityType.getProperties()) {
            property.setValueFast((Object)dynObj, row.get(property.getName()));
        }
        return dynObj;
    }
}

