/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Control;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.bservice.check.DataCheckBusinessHelper;

public class SystemAndModelCommonList
extends AbstractListPlugin {
    private static final String FILED_SYSTEM = "system.id";
    private static final String FILED_MODEL = "model.id";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        try {
            List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumnList) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String itemjson = (String)this.getView().getFormShowParameter().getCustomParam(commonFilterColumn.getFieldName());
                if (StringUtils.isNotEmpty((CharSequence)itemjson)) {
                    if ("null".equals(itemjson)) {
                        commonFilterColumn.getDefaultValues().clear();
                    } else {
                        ComboItem item = (ComboItem)SerializationUtils.fromJsonString((String)itemjson, ComboItem.class);
                        commonFilterColumn.setComboItems(Collections.singletonList(item));
                    }
                }
                if (!FILED_SYSTEM.equals(commonFilterColumn.getFieldName()) && !FILED_MODEL.equals(commonFilterColumn.getFieldName())) continue;
                List comboItems = commonFilterColumn.getComboItems();
                if (comboItems != null && !comboItems.isEmpty()) {
                    String value = ((ComboItem)comboItems.get(0)).getValue();
                    commonFilterColumn.setDefaultValue(value);
                    if (this.getPageCache().get("_cache_filter_" + commonFilterColumn.getFieldName()) != null) continue;
                    this.getPageCache().put("_cache_filter_" + commonFilterColumn.getFieldName(), value);
                    continue;
                }
                commonFilterColumn.setDefaultValue(null);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (FILED_MODEL.equals(args.getFieldName())) {
            Map<String, CommonFilterColumn> commonFilterColumn = this.getAllCommonFilterColumn();
            List filterValue = ((FilterColumnSetFilterEvent)args).getCommonFilterValue(FILED_SYSTEM);
            long pkvalue = 0L;
            if (filterValue != null) {
                pkvalue = filterValue.stream().map(o -> Long.valueOf(String.valueOf(o))).findFirst().orElse(0L);
            } else {
                List comboItems;
                CommonFilterColumn filterColumn = commonFilterColumn.get(FILED_SYSTEM);
                List list = comboItems = filterColumn != null ? filterColumn.getComboItems() : null;
                if (comboItems != null && !comboItems.isEmpty()) {
                    pkvalue = Long.parseLong(String.valueOf(((ComboItem)comboItems.get(0)).getValue()));
                }
            }
            Set ids = DataCheckBusinessHelper.queryModelSet((Long)pkvalue, (String)"bd_period");
            args.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        } else if (FILED_SYSTEM.equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("enable", "=", (Object)"1"));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && Objects.equals(FILED_SYSTEM, ((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put("_cache_filter_system.id", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
            List customfilter = (List)args.getFilterValues().get("customfilter");
            customfilter.removeIf(t -> ((List)t.get("FieldName")).get(0).equals(FILED_MODEL));
            List defaultValues = this.getAllCommonFilterColumn().get(FILED_MODEL).getDefaultValues();
            if (!defaultValues.isEmpty()) {
                this.getPageCache().put("_cache_filter_model.id", String.valueOf(defaultValues.get(0)));
            } else {
                this.getPageCache().remove("_cache_filter_model.id");
            }
        } else if (currentCommonFilter != null && Objects.equals(FILED_MODEL, ((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put("_cache_filter_model.id", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
        }
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        String modelid;
        String systemid = this.getPageCache().get("_cache_filter_system.id");
        if (systemid != null) {
            e.getQFilters().add(new QFilter(FILED_SYSTEM, "=", (Object)Long.valueOf(systemid)));
        }
        if ((modelid = this.getPageCache().get("_cache_filter_model.id")) != null) {
            e.getQFilters().add(new QFilter(FILED_MODEL, "=", (Object)Long.valueOf(modelid)));
        }
        super.setFilter(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus()) {
            try {
                String modelid;
                String systemid = this.getPageCache().get("_cache_filter_system.id");
                if (systemid != null) {
                    e.getParameter().setCustomParam(FILED_SYSTEM, (Object)Long.valueOf(systemid));
                }
                if ((modelid = this.getPageCache().get("_cache_filter_model.id")) != null) {
                    e.getParameter().setCustomParam(FILED_MODEL, (Object)Long.valueOf(modelid));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map<String, CommonFilterColumn> getAllCommonFilterColumn() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        HashMap<String, CommonFilterColumn> map = new HashMap<String, CommonFilterColumn>();
        for (Control item : fc.getItems()) {
            if (!(item instanceof AbstractFilterGridView)) continue;
            for (Control childitem : ((AbstractFilterGridView)item).getFilterColumns()) {
                if (!(childitem instanceof CommonFilterColumn)) continue;
                map.put(((CommonFilterColumn)childitem).getFieldName(), (CommonFilterColumn)childitem);
            }
        }
        return map;
    }
}

