/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.faf.bservice.BusinessDynamicFactory;
import kd.macc.faf.bservice.ExcuteCacheInfo;
import kd.macc.faf.bservice.ExecuteCache;
import kd.macc.faf.bservice.check.DataCheckRuleExecParams;
import kd.macc.faf.bservice.check.DataCheckRuleExecutor;
import kd.macc.faf.bservice.check.DataCheckRunModeEnum;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.dto.ChangeDataDTO;

public class DataCheckExecFormPlugin
extends AbstractFormPlugin
implements ProgresssListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DataCheckExecFormPlugin.class);
    private static final String VIEWSTATUS = "viewstatus";
    private static final String CACHE_KEY_REQUESTID = "cache_request_id";
    private static final String CACHE_KEY_BATCHNO = "cache_batch_no";

    public static FormShowParameter createShowParameter() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("faf_datacheckbyhand");
        return fsp;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnbackexec", "btnviewdata"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("period");
        periodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datacheckruleF7 = (BasedataEdit)this.getControl("datacheckrule");
        datacheckruleF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        Object modelVal = this.getModel().getValue("model");
        switch (propertyName) {
            case "org": {
                long currUserId = RequestContext.get().getCurrUserId();
                String appId = this.getView().getFormShowParameter().getAppId();
                HasPermOrgResult orgs = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"15", (String)appId, (String)"faf_datacheckbyhand", (String)"445AP97LXD88", (boolean)false);
                if (orgs.hasAllOrgPerm()) break;
                event.addCustomQFilter(new QFilter("id", "in", (Object)orgs.getHasPermOrgs()));
                break;
            }
            case "period": {
                if (!(modelVal instanceof DynamicObject)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"DataCheckExecFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                DataSyncModel dataSyncModel = BusinessDynamicFactory.createDataSyncModel((Object)((DynamicObject)modelVal).getPkValue());
                event.addCustomQFilter(new QFilter("periodtype", "in", dataSyncModel.getPeriodtypeID()));
                break;
            }
            case "datacheckrule": {
                if (!(modelVal instanceof DynamicObject)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"DataCheckExecFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                event.addCustomQFilter(new QFilter("model", "=", ((DynamicObject)modelVal).getPkValue()));
                DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("org");
                if (collection == null || collection.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ec4\u7ec7\u201d\u3002", (String)"DataCheckExecFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                List useOrgIds = collection.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)parameter.getBillFormId(), useOrgIds, (boolean)false);
                baseDataFilter.and("runMode", "!=", (Object)DataCheckRunModeEnum.AUTO_BY_REPLENISH_DATA.getCode());
                event.addCustomQFilter(baseDataFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.getModel().setValue("system", parameter.getCustomParam("system"));
            this.getModel().setValue("model", parameter.getCustomParam("model"));
            this.getModel().setValue("org", (Object)new Object[]{Long.valueOf((String)parameter.getCustomParam("org"))});
            List checkruleidlist = (List)parameter.getCustomParam("checkruleidlist");
            this.getModel().setValue("datacheckrule", (Object)checkruleidlist.toArray());
        }
        catch (Exception ex) {
            logger.info("jump faf_datacheckbyhand , params erro", (Object)ex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("execute".equals(operateKey)) {
            this.execute();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewstatus": {
                this.resetImageap(new ChangeDataDTO(e));
                break;
            }
            case "system": {
                this.getModel().setValue("model", null);
                this.getModel().setValue("org", null);
                break;
            }
            case "model": {
                this.getModel().setValue("org", null);
                this.getModel().setValue("datacheckrule", null);
                this.getModel().setValue("period", null);
                break;
            }
            case "org": {
                this.getModel().setValue("datacheckrule", null);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnbackexec": {
                this.getModel().setValue(VIEWSTATUS, (Object)"1");
                break;
            }
            case "btnviewdata": {
                this.viewReport();
            }
        }
    }

    private void execute() {
        DataCheckRuleExecParams params = new DataCheckRuleExecParams();
        params.setSendMessage(Boolean.TRUE);
        params.getFilterRunMode().add(DataCheckRunModeEnum.BYHAND.getCode());
        params.getFilterRunMode().add(DataCheckRunModeEnum.AUTO_END_SYNC_DATA.getCode());
        params.setModelPkvalue((Long)this.getModel().getValue("model_id"));
        params.setOrgList(this.getMultiFieldValue("org"));
        params.setDataCheckRuleList(this.getMultiFieldValue("datacheckrule"));
        params.setPeriodList(Collections.singletonList((Long)this.getModel().getValue("period_id")));
        DataCheckRuleExecutor executor = DataCheckRuleExecutor.create((DataCheckRuleExecParams)params);
        ErrorCode exec = executor.syncExecute();
        if ("success".equals(exec.getCode())) {
            this.start();
            this.getPageCache().put(CACHE_KEY_REQUESTID, executor.getRequestId());
            this.getPageCache().put(CACHE_KEY_BATCHNO, executor.getBatchNo());
        } else {
            this.getView().showTipNotification(exec.getMessage());
        }
    }

    private void start() {
        this.getModel().setValue(VIEWSTATUS, (Object)"2");
        this.getModel().setValue("executioninfo", (Object)"");
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(0);
        progressBar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        String requestId = this.getPageCache().get(CACHE_KEY_REQUESTID);
        ExcuteCacheInfo cache = ExecuteCache.getCache((String)requestId);
        this.getModel().setValue("executioninfo", (Object)cache.getRollMessage());
        if (StringUtils.isNotEmpty((CharSequence)cache.getTipMessage())) {
            this.getView().showTipNotification(cache.getTipMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)cache.getErroMessage())) {
            this.getModel().setValue("executioninfo", (Object)cache.getErroMessage());
            this.getModel().setValue(VIEWSTATUS, (Object)"3");
            progressBar.stop();
        }
        if (cache.isComplete()) {
            String message = cache.getMessage();
            if (StringUtils.isBlank((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"DataCheckExecFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue("executioninfo", (Object)message);
            this.getModel().setValue(VIEWSTATUS, (Object)"4");
            progressBar.stop();
        }
        progressEvent.setProgress(cache.getProgress());
    }

    private void resetImageap(ChangeDataDTO changeDataDTO) {
        HashMap<String, String> data;
        if (!"2".equals(changeDataDTO.getNewValue()) && "2".equals(changeDataDTO.getOldValue())) {
            data = new HashMap<String, String>();
            data.put("imageKey", "/images/pc/other/zncw_cwgx_200_200.png");
            this.getView().updateControlMetadata("imageap", data);
        }
        if ("2".equals(changeDataDTO.getNewValue()) && !"2".equals(changeDataDTO.getOldValue())) {
            data = new HashMap();
            data.put("imageKey", "/icons/pc/other/zncw_sjtb_214_214.gif");
            this.getView().updateControlMetadata("imageap", data);
        }
    }

    private List<Long> getMultiFieldValue(String propName) {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue(propName);
        return collection.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private void viewReport() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setFormId("bos_list");
        lsp.setBillFormId("faf_datacheckreport");
        String batchNo = this.getPageCache().get(CACHE_KEY_BATCHNO);
        lsp.getListFilterParameter().getQFilters().add(new QFilter("batchno", "=", (Object)batchNo));
        ComboItem systemItem = new ComboItem(new LocaleString(String.valueOf(this.getModel().getDataEntity().getString("system.name"))), String.valueOf(this.getModel().getValue("system_id")));
        lsp.setCustomParam("system.id", (Object)SerializationUtils.toJsonString((Object)systemItem));
        ComboItem modelItem = new ComboItem(new LocaleString(String.valueOf(this.getModel().getDataEntity().getString("model.name"))), String.valueOf(this.getModel().getValue("model_id")));
        lsp.setCustomParam("model.id", (Object)SerializationUtils.toJsonString((Object)modelItem));
        lsp.setCustomParam("checkorg.id", (Object)"null");
        this.getView().showForm((FormShowParameter)lsp);
    }
}

