/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.dialog.SyncDataConditionDialogPlugin;
import kd.macc.faf.dto.TagTextFiledData;

public class DataCheckReportEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String ENTRY_F_checkcondition = "checkcondition";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_F_checkcondition});
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (ENTRY_F_checkcondition.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    DataCheckReportEdit.this.showCheckConditionDialog();
                }
            };
            control.setKey(ENTRY_F_checkcondition);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        entryEntity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryentity) {
            dynamicObject.set("hyperlink", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u6570\u636e\u8be6\u60c5", (String)"DataCheckReportEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("refreshcheckresult".equals(args.getOperateKey())) {
            this.getView().updateView();
        }
    }

    private void showCheckConditionDialog() {
        try {
            Object value = this.getModel().getValue("model");
            TagTextFiledData data = new TagTextFiledData(ENTRY_F_checkcondition, "checkcondition_tag");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String mapText = (String)this.getModel().getValue("checkcondition_tag", rowIndex);
            Map map = (Map)SerializationUtils.fromJsonString((String)mapText, Map.class);
            data.setValue((String)map.get("checkcondition_tag"));
            data.getParams().put("model", this.getModel().getValue("model_id"));
            data.setCaption(ResManager.loadKDString((String)"\u6821\u9a8c\u6761\u4ef6", (String)"DataCheckReportEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            SyncDataConditionDialogPlugin.openBy((AbstractFormPlugin)this, data, "ACTIONID_SET_VALUE_BYDIALOG");
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        try {
            IDataModel model = this.getModel();
            Object modelId = model.getValue("model_id");
            DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
            if (analysisModel == null || analysisModel.get("tablenumber") == null || StringUtils.isEmpty((CharSequence)analysisModel.get("tablenumber").toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"DataCheckReportEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView view = this.getView();
            int rowIndex = evt.getRowIndex();
            ReportShowParameter rsp = new ReportShowParameter();
            rsp.setFormId("faf_datadetail");
            rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            rsp.setCustomParam("systemId", model.getValue("system_id"));
            rsp.setCustomParam("modelId", modelId);
            rsp.setCustomParam("reportEntry", this.getModel().getEntryEntity("entryentity").get(rowIndex));
            rsp.setCustomParam("checkorg", model.getValue("checkorg_id"));
            rsp.setCustomParam("checkperiod", model.getValue("checkperiod_id"));
            rsp.setCustomParam("checkruleId", model.getValue("checkrule_id"));
            rsp.setCustomParam("billno", model.getValue("billno"));
            rsp.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u8be6\u60c5", (String)"DataCheckReportEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            view.showForm((FormShowParameter)rsp);
        }
        catch (NullPointerException nullPointerException) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u62a5\u544a\u6570\u636e\u5f02\u5e38\u3002", (String)"DataCheckReportEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

