/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.bservice.BusinessDynamicFactory;
import kd.macc.faf.bservice.check.DataCheckResultEnum;
import kd.macc.faf.bservice.check.DataCheckRunModeEnum;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.dialog.SyncDataConditionDialogPlugin;
import kd.macc.faf.dto.ChangeDataDTO;
import kd.macc.faf.dto.TagTextFiledData;

public class DataCheckRuleEdit
extends AbstractBillPlugIn {
    private static final String FIELD_SYSTEM = "system";
    private static final String FIELD_MODEL = "model";
    private static final String ENTRY_RULEINFO = "entryentity";
    private static final String ENTRY_F_CHECKCONDITION_DESC = "checkconditiondesc";
    private static final String ENTRY_F_CHECKCONDITION_TAG = "checkcondition_tag";
    private static final String CALLBACKID_changedata = "callbackid_changedata";
    private static final String ACTIONID_SET_VALUE_BYDIALOG = "actionid_set_value_by_dialog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRY_F_CHECKCONDITION_DESC});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object system_id = this.getView().getFormShowParameter().getCustomParam("system.id");
        this.getModel().setValue(FIELD_SYSTEM, system_id);
        Object model_id = this.getView().getFormShowParameter().getCustomParam("model.id");
        this.getModel().setValue(FIELD_MODEL, model_id);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockCtrls();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeDataDTO changeDataDTO = new ChangeDataDTO(propName, e.getChangeSet());
        switch (propName) {
            case "system": {
                if (this.getModel().getEntryRowCount(ENTRY_RULEINFO) == 0) {
                    this.getModel().setValue(FIELD_MODEL, null);
                    return;
                }
            }
            case "model": {
                if (this.getModel().getEntryRowCount(ENTRY_RULEINFO) == 0) {
                    return;
                }
                ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACKID_changedata, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5206\u6790\u4f53\u7cfb\u6216\u5206\u6790\u6a21\u578b\u4f1a\u6e05\u7a7a\u89c4\u5219\u4fe1\u606f\u7684\u914d\u7f6e\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataCheckRuleEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Save, listener, null, SerializationUtils.toJsonString((Object)changeDataDTO));
                break;
            }
            case "checkconditiondesc": {
                if (!StringUtils.isBlank((Object)changeDataDTO.getNewValue())) break;
                this.getModel().setValue(ENTRY_F_CHECKCONDITION_TAG, null);
                break;
            }
            case "runmode": {
                ComboEdit comboEdit = (ComboEdit)this.getControl("promptmode");
                ComboProp comboProp = (ComboProp)comboEdit.getProperty();
                List valueMapItems = comboProp.getComboItems();
                ArrayList<ComboItem> collect = new ArrayList<ComboItem>(valueMapItems.size());
                for (ValueMapItem valueMapItem : valueMapItems) {
                    ComboItem item = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                    if (DataCheckRunModeEnum.AUTO_BY_REPLENISH_DATA.eq(changeDataDTO.getNewValue())) {
                        item.setItemVisible(Objects.equals(item.getValue(), DataCheckResultEnum.ERRO.getCode()));
                    }
                    collect.add(item);
                }
                comboEdit.setComboItems(collect);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int rowCount;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("newentry".equals(operateKey) && (rowCount = this.getModel().getEntryRowCount(ENTRY_RULEINFO)) >= 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u4fe1\u606f\u5206\u5f55\u4e2d\u53ea\u5141\u8bb8\u6dfb\u52a020\u884c\u6821\u9a8c\u6761\u4ef6\u3002", (String)"DataCheckRuleEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey())) {
            this.lockCtrls();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(ENTRY_F_CHECKCONDITION_DESC)) {
            this.showCheckConditionDialog();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        TagTextFiledData data;
        String actionId = event.getActionId();
        if (ACTIONID_SET_VALUE_BYDIALOG.equals(actionId) && event.getReturnData() != null && (data = (TagTextFiledData)FAFUtils.cast((Object)event.getReturnData())) != null) {
            data.fillValue(this.getModel());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CALLBACKID_changedata.equals(callBackId)) {
            String customVaule = event.getCustomVaule();
            ChangeDataDTO dto = (ChangeDataDTO)SerializationUtils.fromJsonString((String)customVaule, ChangeDataDTO.class);
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().beginInit();
                switch (dto.getPropName()) {
                    case "system": {
                        this.getModel().setValue(FIELD_MODEL, null);
                    }
                    case "model": {
                        this.getModel().deleteEntryData(ENTRY_RULEINFO);
                    }
                }
                this.getModel().endInit();
                this.getView().updateView("fs_baseinfo");
                this.getView().updateView(ENTRY_RULEINFO);
            } else {
                this.getModel().beginInit();
                Object oldValue = dto.getOldValue();
                if (oldValue instanceof Map) {
                    this.getModel().setValue(dto.getPropName(), ((Map)oldValue).get("id"));
                } else {
                    this.getModel().setValue(dto.getPropName(), oldValue);
                }
                this.getModel().endInit();
                this.getView().updateView("fs_baseinfo");
            }
        }
    }

    private void lockCtrls() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L) {
            Long masterid = (Long)this.getModel().getValue("masterid");
            if (!pkValue.equals(masterid)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SYSTEM, FIELD_MODEL, "runmode"});
            } else if (BaseDataRefrenceHelper.isRefrenced((String)"faf_datacheckrule", (Object)pkValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SYSTEM, FIELD_MODEL, "runmode"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    private void showCheckConditionDialog() {
        Object value = this.getModel().getValue(FIELD_MODEL);
        if (value instanceof DynamicObject) {
            TagTextFiledData data = new TagTextFiledData(ENTRY_F_CHECKCONDITION_DESC, ENTRY_F_CHECKCONDITION_TAG).pickValue(this.getModel(), ENTRY_RULEINFO);
            data.getParams().put(FIELD_MODEL, this.getModel().getValue("model_id"));
            DataSyncModel model = BusinessDynamicFactory.createDataSyncModel((Object)((DynamicObject)value).getPkValue());
            data.getParams().put("exclude", Collections.singletonList(model.getPeriodNumber()));
            data.setCaption(ResManager.loadKDString((String)"\u6821\u9a8c\u6761\u4ef6", (String)"DataCheckRuleEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            SyncDataConditionDialogPlugin.openBy((AbstractFormPlugin)this, data, ACTIONID_SET_VALUE_BYDIALOG);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"DataCheckRuleEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }
}

