/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.bservice.check.DataCheckResultEnum;
import kd.macc.faf.dataquery.dto.FAFDataQueryModelDTO;
import kd.macc.faf.dataquery.func.DataDetailFilterFunction;
import kd.macc.faf.dataquery.func.FAFReportDateTimeFormatFunction;
import kd.macc.faf.dataquery.func.FAFReportPrecisionFunction;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.helper.FAFMeasureHelper;

public class DataDetailReportListDataPlugin
extends AbstractReportListDataPlugin {
    private FAFDataQueryModelDTO dataQueryModelDTO;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        try {
            Map customParam = reportQueryParam.getCustomParam();
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.dataQueryModelDTO.getQueryTableEntityNumber());
            ORM orm = ORM.create();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String queryFieldsInfo = this.dataQueryModelDTO.getQueryFieldsInfo();
            if (dataEntityType.getAllFields().get("_markpass") != null) {
                queryFieldsInfo = queryFieldsInfo + ',' + "_markpass_tag";
            }
            IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
            List currentBatchRows = byBatchInfo.getCurrentBatchRows().stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.bservice.check.DataDetailReportListDataPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), queryFieldsInfo, new QFilter("id", "in", currentBatchRows).toArray(), String.format("%s,createtime desc", dimensionNumberOfOrg));
            JSONObject reportEntry = (JSONObject)customParam.get("reportentry");
            DataSet ans = this.processReportQueryDataSetForDisplay(dataSet, reportEntry.getLong("checkconditionid"));
            ans = ans.map((MapFunction)new FAFReportPrecisionFunction(dataSet.getRowMeta(), this.dataQueryModelDTO.getAnaModelId()));
            if (dataEntityType.getAllFields().get("_markpass") != null) {
                ans = ans.removeFields(new String[]{"_markpass_tag"});
            }
            return ans;
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataDetailReportListDataPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    public DataSet queryBatchBy(ReportQueryParam reportQueryParam) {
        try {
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            Map customParam = reportQueryParam.getCustomParam();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String dimensionNumberOfPeriod = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.PERIOD).getString("number");
            ORM orm = ORM.create();
            List<QFilter> headFilters = reportQueryParam.getFilter().getHeadFilters();
            headFilters = this.replaceProp(headFilters);
            for (Map.Entry entry : reportQueryParam.getCustomParam().entrySet()) {
                if ("org".equals(entry.getKey())) {
                    headFilters.add(new QFilter(dimensionNumberOfOrg, "=", entry.getValue()));
                    continue;
                }
                if (!"bdperiod".equals(entry.getKey())) continue;
                headFilters.add(new QFilter(dimensionNumberOfPeriod, "=", entry.getValue()));
            }
            if (customParam.get("rulecondition") != null) {
                headFilters.add((QFilter)customParam.get("rulecondition"));
            }
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.bservice.check.DataDetailReportListDataPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), "id", headFilters.toArray(new QFilter[0]), String.format("%s,createtime desc", dimensionNumberOfOrg));
            IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
            byBatchInfo.setCountPerBatch(300);
            byBatchInfo.setMaxRowCountCached(100000);
            return dataSet;
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataDetailReportListDataPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    public DataSet queryAll(ReportQueryParam reportQueryParam) {
        try {
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.dataQueryModelDTO.getQueryTableEntityNumber());
            Map customParam = reportQueryParam.getCustomParam();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String dimensionNumberOfPeriod = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.PERIOD).getString("number");
            String queryFieldsInfo = this.dataQueryModelDTO.getQueryFieldsInfo();
            if (dataEntityType.getAllFields().get("_markpass") != null) {
                queryFieldsInfo = queryFieldsInfo + ',' + "_markpass_tag";
            }
            ORM orm = ORM.create();
            List<QFilter> headFilters = reportQueryParam.getFilter().getHeadFilters();
            headFilters = this.replaceProp(headFilters);
            for (Map.Entry entry : reportQueryParam.getCustomParam().entrySet()) {
                if ("org".equals(entry.getKey())) {
                    headFilters.add(new QFilter(dimensionNumberOfOrg, "=", entry.getValue()));
                    continue;
                }
                if (!"bdperiod".equals(entry.getKey())) continue;
                headFilters.add(new QFilter(dimensionNumberOfPeriod, "=", entry.getValue()));
            }
            if (customParam.get("rulecondition") != null) {
                headFilters.add((QFilter)customParam.get("rulecondition"));
            }
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.bservice.check.DataDetailReportListDataPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), queryFieldsInfo, headFilters.toArray(new QFilter[0]), String.format("%s,createtime desc", dimensionNumberOfOrg));
            JSONObject reportEntry = (JSONObject)customParam.get("reportentry");
            DataSet ans = this.processReportQueryDataSetForDisplay(dataSet, reportEntry.getLong("checkconditionid"));
            if (dataEntityType.getAllFields().get("_markpass") != null) {
                ans = ans.removeFields(new String[]{"_markpass_tag"});
            }
            return ans;
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataDetailReportListDataPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    public DataSet processReportQueryDataSetForDisplay(DataSet dataSet, Long conditionId) {
        dataSet = dataSet.filter((FilterFunction)new DataDetailFilterFunction(dataSet.getRowMeta(), conditionId));
        dataSet = dataSet.map((MapFunction)new FAFReportDateTimeFormatFunction(dataSet.getRowMeta()));
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> allColumns) throws Throwable {
        try {
            Map customParam;
            List conditionField = Collections.emptyList();
            DataCheckResultEnum resultEnum = null;
            Map map = customParam = this.getQueryParam() == null ? Collections.emptyMap() : this.getQueryParam().getCustomParam();
            if (customParam.get("conditionfield") != null) {
                conditionField = (List)customParam.get("conditionfield");
            }
            if (customParam.get("promptmode") != null && StringUtils.isNotEmpty((CharSequence)customParam.get("promptmode").toString())) {
                resultEnum = DataCheckResultEnum.getEnum((String)customParam.get("promptmode").toString());
            }
            ColumnStyle columnStyle = new ColumnStyle();
            columnStyle.setForeColor(resultEnum == null ? "#000000" : resultEnum.getForeColor());
            ArrayList<Object> priorityColumn = new ArrayList<Object>(10);
            allColumns.add(this.createTextColumn("id", "id", false, true));
            List<AbstractReportColumn> dimensionReportColumn = this.createDimensionReportColumn();
            Iterator<AbstractReportColumn> iterator = dimensionReportColumn.iterator();
            while (iterator.hasNext()) {
                DecimalReportColumn decColumn;
                AbstractReportColumn dim = iterator.next();
                if (dim instanceof TextReportColumn) {
                    TextReportColumn textColumn = (TextReportColumn)dim;
                    if (!conditionField.contains(textColumn.getFieldKey())) continue;
                    textColumn.setStyle(columnStyle);
                    priorityColumn.add(textColumn);
                    iterator.remove();
                    continue;
                }
                if (dim instanceof ComboReportColumn) {
                    ComboReportColumn comboColumn = (ComboReportColumn)dim;
                    if (!conditionField.contains(comboColumn.getFieldKey())) continue;
                    comboColumn.setStyle(columnStyle);
                    priorityColumn.add(comboColumn);
                    iterator.remove();
                    continue;
                }
                if (!(dim instanceof DecimalReportColumn) || !conditionField.contains((decColumn = (DecimalReportColumn)dim).getFieldKey())) continue;
                decColumn.setStyle(columnStyle);
                priorityColumn.add(decColumn);
                iterator.remove();
            }
            List<AbstractReportColumn> measureReportColumn = this.createMeasureReportColumn();
            Iterator<AbstractReportColumn> measureIterator = measureReportColumn.iterator();
            while (measureIterator.hasNext()) {
                DecimalReportColumn decColumn;
                AbstractReportColumn measure = measureIterator.next();
                if (!(measure instanceof DecimalReportColumn) || !conditionField.contains((decColumn = (DecimalReportColumn)measure).getFieldKey())) continue;
                decColumn.setStyle(columnStyle);
                priorityColumn.add(decColumn);
                measureIterator.remove();
            }
            allColumns.addAll(priorityColumn);
            allColumns.addAll(dimensionReportColumn);
            allColumns.addAll(measureReportColumn);
            return super.getColumns(allColumns);
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5217\u6784\u5efa\u5931\u8d25\uff1a%s", (String)"DataDetailReportListDataPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    private AbstractReportColumn createTextColumn(String columnKey, String columnCaption, boolean isHyperlink, boolean isHide) {
        TextReportColumn textReportColumn = new TextReportColumn();
        textReportColumn.setFieldKey(columnKey);
        textReportColumn.setCaption(new LocaleString(columnCaption));
        textReportColumn.setFieldType("text");
        textReportColumn.setHyperlink(isHyperlink);
        textReportColumn.setHide(isHide);
        return textReportColumn;
    }

    private List<AbstractReportColumn> createDimensionReportColumn() {
        ArrayList<AbstractReportColumn> dimensionReportColumns = new ArrayList<AbstractReportColumn>(8);
        Map dimensionNumberFieldNumbersMap = this.dataQueryModelDTO.getDimensionNumberFieldNumbersMap();
        Map dimensionNumberFieldNamesMap = this.dataQueryModelDTO.getDimensionNumberFieldNamesMap();
        QFilter systemFilter = new QFilter("system", "=", (Object)this.dataQueryModelDTO.getAnaSystemId());
        QFilter numberFilter = new QFilter("number", "in", dimensionNumberFieldNumbersMap.keySet());
        Collection dimensionDys = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{systemFilter, numberFilter}).values();
        block5: for (Map.Entry dimensionEntry : dimensionNumberFieldNumbersMap.entrySet()) {
            String dimensionNumber = (String)dimensionEntry.getKey();
            DynamicObject dimension = dimensionDys.stream().filter(dy -> dimensionNumber.equals(dy.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u7ef4\u5ea6%s\u4e0d\u5b58\u5728", (String)"DataDetailReportListDataPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionNumber)));
            MainEntityType fieldEntityType = null;
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    String dimensionSourceNumber = dimension.getDynamicObject("dimensionsource").getString("number");
                    fieldEntityType = EntityMetadataCache.getDataEntityType((String)dimensionSourceNumber);
                }
                case ASSISTANTDATA: {
                    if (fieldEntityType == null) {
                        fieldEntityType = EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                    }
                    List dimensionFieldNumberList = (List)dimensionEntry.getValue();
                    for (String dimensionFieldNumber : dimensionFieldNumberList) {
                        if (!StringUtils.isNotBlank((CharSequence)dimensionFieldNumber)) continue;
                        String[] shortFieldNumbers = dimensionFieldNumber.split("\\.");
                        MainEntityType tmpEntityType = fieldEntityType;
                        for (int i = 0; i < shortFieldNumbers.length - 1; ++i) {
                            DynamicProperty property = fieldEntityType.getProperty(shortFieldNumbers[i]);
                            if (property instanceof BasedataProp) {
                                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                                tmpEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                                continue;
                            }
                            if (i == shortFieldNumbers.length - 1) continue;
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u521b\u5efa\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7ef4\u5ea6\u7684\u62a5\u8868\u5217\u5931\u8d25,\u7ef4\u5ea6\u4e3a{%1$s},\u7ef4\u5ea6\u5b57\u6bb5\u4e3a{%2$s}", (String)"DataDetailReportListDataPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionNumber, dimensionFieldNumber));
                        }
                        String dimensionReportNumber = String.format("%1$s.%2$s", dimension.getString("number"), dimensionFieldNumber);
                        String dimensionReportName = String.format("%1$s.%2$s", dimension.getString("name"), ((List)dimensionNumberFieldNamesMap.get(dimensionNumber)).get(dimensionFieldNumberList.indexOf(dimensionFieldNumber)));
                        DynamicProperty property = tmpEntityType.getProperty(shortFieldNumbers[shortFieldNumbers.length - 1]);
                        if (property instanceof ComboProp) {
                            List comboItems = ((ComboProp)property).getComboItems();
                            dimensionReportColumns.add(this.createComboColumn(dimensionReportNumber, dimensionReportName, comboItems));
                            continue;
                        }
                        if (property instanceof DateTimeProp) {
                            dimensionReportColumns.add(this.createTextColumn(dimensionReportNumber, dimensionReportName, false, false));
                            continue;
                        }
                        if (property instanceof DecimalProp) {
                            dimensionReportColumns.add(this.createDecimalColumn(dimensionReportNumber, dimensionReportName, false, 2));
                            continue;
                        }
                        dimensionReportColumns.add(this.createTextColumn(dimensionReportNumber, dimensionReportName, false, false));
                    }
                    continue block5;
                }
                case DENUMS: {
                    String dimensionReportNumberOfCombo = dimension.getString("number");
                    String dimensionReportNameOfCombo = dimension.getString("name");
                    List<ValueMapItem> comboItems = dimension.getDynamicObjectCollection("entryentityenums").stream().map(dy -> new ValueMapItem(null, dy.getString("value"), new LocaleString(dy.getString("title")))).collect(Collectors.toList());
                    dimensionReportColumns.add(this.createComboColumn(dimensionReportNumberOfCombo, dimensionReportNameOfCombo, comboItems));
                    break;
                }
                default: {
                    String dimensionReportNumberOfText = dimension.getString("number");
                    String dimensionReportNameOfText = dimension.getString("name");
                    dimensionReportColumns.add(this.createTextColumn(dimensionReportNumberOfText, dimensionReportNameOfText, false, false));
                }
            }
        }
        return dimensionReportColumns;
    }

    private List<AbstractReportColumn> createMeasureReportColumn() {
        Map precisionMap;
        ArrayList<AbstractReportColumn> measureReportColumns = new ArrayList<AbstractReportColumn>(8);
        List measureNumbers = this.dataQueryModelDTO.getMeasureNumbers();
        QFilter systemFilter = new QFilter("system", "=", (Object)this.dataQueryModelDTO.getAnaSystemId());
        QFilter numberFilter = new QFilter("number", "in", (Object)measureNumbers);
        Collection measureDys = BusinessDataServiceHelper.loadFromCache((String)"pa_measure", (QFilter[])new QFilter[]{systemFilter, numberFilter}).values();
        try {
            DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)this.dataQueryModelDTO.getAnaModelId(), (String)"pa_analysismodel");
            List measureNumberList = analysisModel.getDynamicObjectCollection("measure_entry").stream().map(x -> x.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
            precisionMap = FAFMeasureHelper.getMeasureScaleMap((Long)analysisModel.getLong("analysis_system_id"), measureNumberList);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u89e3\u6790\u81ea\u5b9a\u4e49\u7cbe\u5ea6\u5931\u8d25\u3002", (String)"DataDetailReportListDataPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        for (String measureNumber : measureNumbers) {
            DynamicObject measure = measureDys.stream().filter(dy -> measureNumber.equals(dy.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u5ea6\u91cf%s\u4e0d\u5b58\u5728", (String)"DataDetailReportListDataPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), measureNumber)));
            boolean isCommonMeasure = MeasureTypeEnum.ORDINARY == MeasureTypeEnum.getEnum((String)measure.getString("measuretype"));
            measureReportColumns.add(this.createDecimalColumn(measure.getString("number"), measure.getString("name"), isCommonMeasure, (Integer)precisionMap.get(measure.getString("number"))));
        }
        return measureReportColumns;
    }

    private AbstractReportColumn createComboColumn(String columnKey, String columnCaption, List<ValueMapItem> comboItems) {
        ComboReportColumn comboReportColumn = new ComboReportColumn();
        comboReportColumn.setFieldKey(columnKey);
        comboReportColumn.setCaption(new LocaleString(columnCaption));
        comboReportColumn.setFieldType("combofield");
        if (!CollectionUtils.isEmpty(comboItems)) {
            comboReportColumn.setComboItems(comboItems);
        }
        return comboReportColumn;
    }

    private AbstractReportColumn createDecimalColumn(String columnKey, String columnCaption, boolean isHyperlink, Integer precision) {
        DecimalReportColumn decimalReportColumn = new DecimalReportColumn();
        decimalReportColumn.setFieldKey(columnKey);
        decimalReportColumn.setCaption(new LocaleString(columnCaption));
        decimalReportColumn.setFieldType("decimal");
        decimalReportColumn.setHyperlink(isHyperlink);
        decimalReportColumn.setScale(precision == null ? 2 : precision);
        decimalReportColumn.setNoDisplayScaleZero(false);
        decimalReportColumn.setZeroShow(true);
        decimalReportColumn.setNeedFormat(true);
        return decimalReportColumn;
    }

    public List<QFilter> replaceProp(List<QFilter> headFilters) {
        Map dimensionNumberFieldNumbersMap = this.dataQueryModelDTO.getDimensionNumberFieldNumbersMap();
        List measureNumbers = this.dataQueryModelDTO.getMeasureNumbers();
        for (QFilter headFilter : headFilters) {
            String property = headFilter.getProperty();
            if (property.contains("_")) {
                String[] split = property.split("_");
                StringBuilder propSb = new StringBuilder(split[0]);
                for (int i = 1; i < split.length; ++i) {
                    if (dimensionNumberFieldNumbersMap.get(propSb.toString()) != null) {
                        headFilter.__setProperty(propSb.append(".").append(property.substring(propSb.length())).toString());
                        break;
                    }
                    propSb.append("_").append(split[i]);
                }
            }
            if (measureNumbers.contains(property)) {
                headFilter.__setValue((Object)new BigDecimal(headFilter.getValue() == null ? "0" : headFilter.getValue().toString()));
            }
            if (headFilter.getNests(true).isEmpty()) continue;
            this.replaceNestProp(headFilter.getNests(true));
        }
        return headFilters;
    }

    public void replaceNestProp(List<QFilter.QFilterNest> headFilters) {
        Map dimensionNumberFieldNumbersMap = this.dataQueryModelDTO.getDimensionNumberFieldNumbersMap();
        List measureNumbers = this.dataQueryModelDTO.getMeasureNumbers();
        for (QFilter.QFilterNest headFilter : headFilters) {
            QFilter filter = headFilter.getFilter();
            String property = filter.getProperty();
            if (property.contains("_")) {
                String[] split = property.split("_");
                StringBuilder propSb = new StringBuilder(split[0]);
                for (int i = 1; i < split.length; ++i) {
                    if (dimensionNumberFieldNumbersMap.get(propSb.toString()) != null) {
                        filter.__setProperty(propSb.append(".").append(property.substring(propSb.length())).toString());
                        break;
                    }
                    propSb.append("_").append(split[i]);
                }
            }
            if (measureNumbers.contains(property)) {
                filter.__setValue((Object)new BigDecimal(filter.getValue() == null ? "0" : filter.getValue().toString()));
            }
            if (filter.getNests(true).isEmpty()) continue;
            this.replaceNestProp(filter.getNests(true));
        }
    }
}

