/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataextract.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.ErrorCode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.datareview.FAFDataReview2Plugin;
import kd.macc.faf.datasync.SyncDataExecutor;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.management.enums.TaskExecTypeEnum;
import kd.macc.faf.util.DateUtil;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.IDataDateUtil;
import kd.macc.faf.util.LicenseUtil;

public class FAFDataExtractingFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(FAFDataExtractingFormPlugin.class);
    private static final String staticUrl = "/images/pc/other/zncw_cwgx_200_200.png";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";
    private static final String FILTER_FLEXPANEL = "filter_flexpanel";
    private static final String COMPLETEFLEXPANEL = "completeflexpanel";
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_VIEWDATA = "viewdata";
    private static final String PARAMETERFLEX = "parameterflex";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String KEY_TIME_TYPE = "timetype";
    private static final String KEY_DATE_RANGE = "daterange";
    private static final String KEY_PERIOD_BASEDATA = "periodbasedata";
    private static final String KEY_ACCOUNT_PERIOD = "accountperiod";
    private static final String KEY_ANALYSIS_PERIOD = "analysisperiod";
    private static final String KEY_START_DATE = "range_startdate";
    private static final String KEY_END_DATE = "range_enddate";
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        BasedataEdit analysisPeriod;
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CLOSE, "cancel", BUTTON_VIEWDATA});
        BasedataEdit anaSystem = (BasedataEdit)this.getControl("analysis_system");
        anaSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisModel = (BasedataEdit)this.getControl("analysismodel");
        analysisModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        BasedataEdit accountPeriod = (BasedataEdit)this.getControl(KEY_ACCOUNT_PERIOD);
        if (accountPeriod != null) {
            accountPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((analysisPeriod = (BasedataEdit)this.getControl(KEY_ANALYSIS_PERIOD)) != null) {
            analysisPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "close": {
                this.getView().setVisible(Boolean.TRUE, new String[]{PARAMETERFLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL, COMPLETEFLEXPANEL});
                model.setValue("statusinfo", (Object)"");
                model.setValue("executioninfo", (Object)"");
                model.setValue("successcout", (Object)"");
                model.setValue("failcount", (Object)"");
                break;
            }
            case "viewdata": {
                this.openPADataReview();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        IDataModel model = this.getModel();
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) {
            case "analysismodel": {
                Long anaSystemId = (Long)model.getValue("analysis_system_id");
                if (anaSystemId == null || anaSystemId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFDataExtractingFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                QFilter filter = new QFilter("analysis_system", "=", (Object)anaSystemId);
                filter.and(new QFilter("tablenumber", "!=", (Object)" "));
                qFilterList.add(filter);
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setListFilterParameter(new ListFilterParameter(qFilterList, "createtime desc"));
                break;
            }
            case "org": {
                if (!this.validate()) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataextracting", (String)this.getView().getFormShowParameter().getAppId());
                if (permOrgResult.hasAllOrgPerm()) break;
                QFilter orgIdFilter = new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                listFilterParameter.setFilter(orgIdFilter);
                break;
            }
            case "accountperiod": {
                if (!this.validate()) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long modelId = (Long)this.getModel().getValue("analysismodel_id");
                DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
                Long periodType = timeDimension.getLong("dimension_entry.dimension.group");
                QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
                listFilterParameter.setFilter(periodTypeFilter);
                break;
            }
            case "analysisperiod": {
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"analysis_system", (CharSequence)key)) {
            model.setValue("analysismodel", null);
            model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
        }
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)key)) {
            Long modelId = (Long)this.getModel().getValue("analysismodel_id");
            if (modelId == null || modelId == 0L) {
                model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
                model.setValue(KEY_PERIOD_BASEDATA, (Object)"bd_period");
                return;
            }
            DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
            String dimType = timeDimension.getString("dimension_entry.dimension.dimensiontype");
            String dimBaseData = timeDimension.getString("dimension_entry.dimension.dimensionsource");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimType);
            if (dimensionTypeEnum == null) {
                model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.OTHER.getCode());
                return;
            }
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: 
                case PERIOD: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
                    model.setValue(KEY_PERIOD_BASEDATA, (Object)dimBaseData);
                    break;
                }
                case DATE: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.DATE.getCode());
                    break;
                }
                default: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.OTHER.getCode());
                }
            }
            this.setTimeFieldAttr();
        }
        if (StringUtils.equals((CharSequence)KEY_TIME_TYPE, (CharSequence)key)) {
            this.setTimeFieldAttr();
        }
        if (StringUtils.equals((CharSequence)"org", (CharSequence)key) && e.getChangeSet() != null && e.getChangeSet().length > 0) {
            DynamicObjectCollection orgIds;
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue instanceof DynamicObjectCollection && (orgIds = (DynamicObjectCollection)newValue).size() > 100) {
                if (oldValue != null && ((DynamicObjectCollection)oldValue).size() <= 100) {
                    model.setValue("org", oldValue);
                } else {
                    model.setValue("org", null);
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u5141\u8bb8\u9009\u62e9100\u4e2a\u7ec4\u7ec7\u3002", (String)"FAFDataExtractingFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Donothing && "fetchdata".equals(((Donothing)args.getSource()).getOperateKey())) {
            this.exeRegisterExtract(false);
        }
    }

    public void exeRegisterExtract(boolean force) {
        Object pkvalue = this.getModel().getValue("analysismodel_id");
        DataExtractingDTO dataExtractingDTO = this.buildDataExtractingDTO();
        dataExtractingDTO.setTaskExecType(TaskExecTypeEnum.MANUAL.getCode());
        dataExtractingDTO.setForce(force);
        SyncDataExecutor executor = new SyncDataExecutor(pkvalue, dataExtractingDTO);
        ErrorCode sync = executor.sync();
        if ("success".equals(sync.getCode())) {
            this.getPageCache().put("syncTaskId", executor.getRequestId());
            this.changeVIewToInitialSart();
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u53d6\u6570\u4e2d......", (String)"FAFDataExtractingFormPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            this.startProgressBar();
            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        } else if ("TO_CONFIRM_YesNo".equals(sync.getCode())) {
            this.getView().showConfirm(sync.getMessage(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("forceRegister", (IFormPlugin)this));
        } else if ("TO_CONFIRM_OK".equals(sync.getCode())) {
            this.getView().showConfirm(sync.getMessage(), MessageBoxOptions.OK);
        } else {
            this.getView().showTipNotification(sync.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("forceRegister".equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.exeRegisterExtract(true);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        IFormView view = this.getView();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        String taskId = this.getPageCache().get("syncTaskId");
        String cacheStatusStr = this.cache.get("FAF|" + taskId);
        if ("true".equals(cacheStatusStr)) {
            this.cache.remove("FAF|" + taskId);
            progressEvent.setProgress(95);
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u5b8c\u6210\uff0c\u6b63\u5728\u6267\u884c\u6570\u636e\u6c47\u603b\u3002", (String)"FAFDataExtractingFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else if ("summarySuccess".equals(cacheStatusStr)) {
            progressEvent.setProgress(100);
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE, BUTTON_VIEWDATA});
            view.setEnable(Boolean.TRUE, new String[]{"fetch_data"});
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u5df2\u5b8c\u6210", (String)"FAFDataExtractingFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            this.getShowViewTips(taskId);
            bar.stop();
        } else if (StringUtils.isNotEmpty((CharSequence)cacheStatusStr) && (cacheStatusStr.startsWith("error:") || cacheStatusStr.startsWith("success:"))) {
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE, BUTTON_VIEWDATA});
            view.setEnable(Boolean.TRUE, new String[]{"fetch_data"});
            if (cacheStatusStr.startsWith("success:")) {
                this.getModel().setValue("statusinfo", (Object)String.format(ResManager.loadKDString((String)"\u53d6\u6570\u5b8c\u6210, %s", (String)"FAFDataExtractingFormPlugin_20", (String)"macc-faf-formplugin", (Object[])new Object[0]), cacheStatusStr.substring(8)));
            } else {
                this.getModel().setValue("statusinfo", (Object)String.format(ResManager.loadKDString((String)"\u53d6\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002%s", (String)"FAFDataExtractingFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), cacheStatusStr));
            }
            this.getShowViewTips(taskId);
            bar.stop();
        }
    }

    private void getShowViewTips(String taskId) {
        String showViewTips = this.cache.get("FAF|" + taskId + "showView");
        if (StringUtils.isNotEmpty((CharSequence)showViewTips) && showViewTips.startsWith("showView:")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u548c\u671f\u95f4\u627e\u4e0d\u5230\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u518d\u83b7\u53d6\u6570\u636e", (String)"FAFDataExtractingFormPlugin_19", (String)"macc-faf-formplugin", (Object[])new Object[0]), showViewTips.substring(9), MessageTypes.Default);
        }
    }

    private void init() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL, COMPLETEFLEXPANEL, "progressbarap", "cancel", "textfield"});
        this.setTimeFieldAttr();
    }

    private void setTimeFieldAttr() {
        IDataModel model = this.getModel();
        HashSet<String> trueFieldSet = new HashSet<String>();
        HashSet<String> falseFieldSet = new HashSet<String>();
        String timeType = (String)model.getValue(KEY_TIME_TYPE);
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)timeType);
        switch (timeTypeEnum) {
            case DATE: {
                trueFieldSet.add(KEY_DATE_RANGE);
                falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                break;
            }
            case PERIOD: {
                String periodBaseData = (String)model.getValue(KEY_PERIOD_BASEDATA);
                if (StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) {
                    trueFieldSet.add(KEY_ACCOUNT_PERIOD);
                    falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                } else if (StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) {
                    trueFieldSet.add(KEY_ANALYSIS_PERIOD);
                    falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                } else {
                    falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                    falseFieldSet.add(KEY_ANALYSIS_PERIOD);
                }
                falseFieldSet.add(KEY_DATE_RANGE);
                break;
            }
            default: {
                falseFieldSet.add(KEY_DATE_RANGE);
                falseFieldSet.add(KEY_ACCOUNT_PERIOD);
                falseFieldSet.add(KEY_ANALYSIS_PERIOD);
            }
        }
        String[] trueFields = trueFieldSet.toArray(new String[0]);
        String[] falseFields = falseFieldSet.toArray(new String[0]);
        this.setFieldMustInput(true, trueFields);
        this.setFieldMustInput(false, falseFields);
        this.setFieldVisible(true, trueFields);
        this.setFieldVisible(false, falseFields);
    }

    private void setFieldMustInput(boolean flag, String ... fields) {
        IFormView view = this.getView();
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(field);
            fieldEdit.setMustInput(flag);
        }
    }

    private void setFieldVisible(boolean flag, String ... fields) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(flag), fields);
    }

    public void openPADataReview() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        Set<Long> orgSet = ((MulBasedataDynamicObjectCollection)org).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        Object analysisSystemId = ((DynamicObject)model.getValue("analysis_system")).getPkValue();
        Object analysisModelId = ((DynamicObject)model.getValue("analysismodel")).getPkValue();
        DimensionTypeEnum dimensionTypeFromNess = DimensionDyUtil.getDimensionTypeCodeFromNess((Long)((Long)analysisModelId), (DimensionNecessityEnum)DimensionNecessityEnum.PERIOD);
        DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)((Long)analysisModelId));
        String dimensionsource = timeDimension.getString("dimension_entry.dimension.dimensionsource");
        Long periodId = null;
        String periodKey = KEY_ACCOUNT_PERIOD;
        if (dimensionTypeFromNess == DimensionTypeEnum.PERIOD || dimensionTypeFromNess == DimensionTypeEnum.DATABASE) {
            if ("pa_analysisperiod".equals(dimensionsource)) {
                periodKey = KEY_ANALYSIS_PERIOD;
            }
            Object period = model.getValue(periodKey);
            periodId = ((DynamicObject)period).getLong("id");
        } else if (dimensionTypeFromNess == DimensionTypeEnum.DATE) {
            Date range_startdate = (Date)this.getModel().getValue(KEY_START_DATE);
            Date range_enddate = (Date)this.getModel().getValue(KEY_END_DATE);
            periodId = new Tuple2((Object)IDataDateUtil.dateToString((Date)range_startdate), (Object)IDataDateUtil.dateToString((Date)range_enddate));
        }
        FAFDataReview2Plugin.openF7(this, null, analysisSystemId, analysisModelId, orgSet, periodId);
    }

    public boolean validate() {
        IDataModel model = this.getModel();
        Object analysisSystem = model.getValue("analysis_system");
        Object analysisModel = model.getValue("analysismodel");
        if (analysisSystem == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFDataExtractingFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (analysisModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"FAFDataExtractingFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public DataExtractingDTO buildDataExtractingDTO() {
        IDataModel model = this.getModel();
        MulBasedataDynamicObjectCollection orgDyCol = (MulBasedataDynamicObjectCollection)model.getValue("org");
        Set orgIdSet = orgDyCol.stream().map(dy -> dy.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        String timeType = (String)model.getValue(KEY_TIME_TYPE);
        TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)timeType);
        String periodBaseData = null;
        Set<Long> periodIdSet = null;
        Date startDate = null;
        Date endDate = null;
        switch (timeTypeEnum) {
            case PERIOD: {
                long periodId;
                periodBaseData = (String)model.getValue(KEY_PERIOD_BASEDATA);
                if (StringUtils.equals((CharSequence)"bd_period", (CharSequence)periodBaseData)) {
                    periodId = ((DynamicObject)model.getValue(KEY_ACCOUNT_PERIOD)).getLong("id");
                    periodIdSet = Collections.singleton(periodId);
                    break;
                }
                if (!StringUtils.equals((CharSequence)"pa_analysisperiod", (CharSequence)periodBaseData)) break;
                periodId = ((DynamicObject)model.getValue(KEY_ANALYSIS_PERIOD)).getLong("id");
                periodIdSet = Collections.singleton(periodId);
                break;
            }
            case DATE: {
                startDate = (Date)model.getValue(KEY_START_DATE);
                endDate = DateUtil.getNextDay((Date)((Date)model.getValue(KEY_END_DATE)), (int)1);
                break;
            }
        }
        DynamicObjectCollection dimEntry = this.getAnalysisModel().getDynamicObjectCollection("dimension_entry");
        String orgDimNumber = null;
        String periodDimNumber = null;
        for (DynamicObject dim : dimEntry) {
            if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                orgDimNumber = dim.getDynamicObject("dimension").getString("number");
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) continue;
            periodDimNumber = dim.getDynamicObject("dimension").getString("number");
        }
        return new DataExtractingDTO(orgIdSet, timeType, startDate, endDate, periodBaseData, periodIdSet, orgDimNumber, periodDimNumber);
    }

    private void changeVIewToInitialSart() {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{"progressbarap", FILTER_FLEXPANEL});
        view.setEnable(Boolean.FALSE, new String[]{"fetch_data"});
        view.setVisible(Boolean.FALSE, new String[]{"textfield", PARAMETERFLEX, BUTTON_CLOSE, BUTTON_VIEWDATA, "cancel"});
        this.changeImage("imageap", gifUrl);
        this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FAFDataExtractingFormPlugin_11", (String)"macc-faf-formplugin", (Object[])new Object[0]));
    }

    private void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(0);
        progressBar.start();
    }

    private void changeImage(String apMark, String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(apMark, data);
    }

    private DynamicObject getAnalysisModel() {
        Long analysisModelId = ((DynamicObject)this.getModel().getValue("analysismodel")).getLong("id");
        return BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

