/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataextract.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.datasync.exec.AlgoXRecalculateExecutor;
import kd.macc.faf.datasync.exec.data.DataRecalculateParam;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.lock.ModelTaskLock;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.ValidatorTipsUtil;

public class FAFRecalcMeasureFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(FAFRecalcMeasureFormPlugin.class);
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    private static final String staticUrl = "/images/pc/other/zncw_cwgx_200_200.png";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";
    private static final String FILTER_FLEXPANEL = "filter_flexpanel";
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_RECALC = "recalc";
    private static final String PARAMETERFLEX = "parameterflex";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String KEY_ACCOUNT_PERIOD = "accountperiod";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CLOSE, BUTTON_RECALC});
        BasedataEdit anaSystem = (BasedataEdit)this.getControl("analysis_system");
        anaSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisModel = (BasedataEdit)this.getControl("analysismodel");
        analysisModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountPeriod = (BasedataEdit)this.getControl(KEY_ACCOUNT_PERIOD);
        accountPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "close": {
                this.getView().setVisible(Boolean.TRUE, new String[]{PARAMETERFLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL});
                model.setValue("statusinfo", (Object)"");
                break;
            }
            case "recalc": {
                FormParam formParam = FormParam.get(this.getModel());
                if (!formParam.verifyParam(this.getView())) {
                    return;
                }
                this.recalcMeasure(formParam);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        IDataModel model = this.getModel();
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) {
            case "analysismodel": {
                Long anaSystemId = (Long)model.getValue("analysis_system_id");
                if (anaSystemId == null || anaSystemId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFRecalcMeasureFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                QFilter filter = new QFilter("analysis_system", "=", (Object)anaSystemId);
                filter.and(new QFilter("tablenumber", "!=", (Object)" "));
                qFilterList.add(filter);
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setListFilterParameter(new ListFilterParameter(qFilterList, "createtime desc"));
                break;
            }
            case "org": 
            case "accountperiod": {
                FormParam formParam = FormParam.get(this.getModel());
                if (!formParam.verifyAnaSystem(this.getView()) || !formParam.verifyAnaModel(this.getView())) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if ("org".equals(key)) {
                    OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataextracting", (String)this.getView().getFormShowParameter().getAppId());
                    if (permOrgResult.hasAllOrgPerm()) break;
                    QFilter orgIdFilter = new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                    listFilterParameter.setFilter(orgIdFilter);
                    break;
                }
                Long modelId = (Long)this.getModel().getValue("analysismodel_id");
                DynamicObject timeDimension = FAFAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
                Long periodType = timeDimension.getLong("dimension_entry.dimension.group");
                QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
                listFilterParameter.setFilter(periodTypeFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"analysis_system", (CharSequence)key)) {
            model.setValue("analysismodel", null);
        }
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)key)) {
            Long modelId = (Long)this.getModel().getValue("analysismodel_id");
            if (modelId == null || modelId == 0L) {
                return;
            }
            model.setValue(KEY_ACCOUNT_PERIOD, null);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        IFormView view = this.getView();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        String taskId = this.getPageCache().get("syncTaskId");
        String cacheStatusStr = this.cache.get("FAF|" + taskId);
        if ("recalcSuccess".equals(cacheStatusStr)) {
            progressEvent.setProgress(100);
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u578b\u5ea6\u91cf\u5df2\u91cd\u7b97\u5b8c\u6210\u3002", (String)"FAFRecalcMeasureFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            bar.stop();
            this.cache.remove("FAF|" + taskId);
        } else if (StringUtils.isNotEmpty((CharSequence)cacheStatusStr) && cacheStatusStr.startsWith("error:")) {
            this.changeImage("imageap", staticUrl);
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
            this.getModel().setValue("statusinfo", (Object)String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u578b\u5ea6\u91cf\u91cd\u7b97\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"FAFRecalcMeasureFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), cacheStatusStr));
            bar.stop();
        } else if (StringUtils.isNotEmpty((CharSequence)cacheStatusStr)) {
            float percent = 0.0f;
            try {
                percent = Float.parseFloat(cacheStatusStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (percent < 100.0f) {
                progressEvent.setProgress((int)percent);
            }
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
        }
    }

    private void init() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_FLEXPANEL, "progressbarap"});
    }

    private void recalcMeasure(FormParam formParam) {
        ArrayList orgIdList = new ArrayList(formParam.orgIds);
        ArrayList periodIdList = new ArrayList(formParam.periodIds);
        if (PeriodServiceHelper.checkPeriodOrgList((long)formParam.anaModelId, orgIdList, periodIdList, (boolean)true).booleanValue()) {
            Long syncTaskId = DB.genGlobalLongId();
            this.getPageCache().put("syncTaskId", syncTaskId.toString());
            this.changeViewToInitialStart();
            this.getModel().setValue("statusinfo", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u91cd\u7b97\u4e2d...", (String)"FAFRecalcMeasureFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            ThreadPools.executeOnceIncludeRequestContext((String)"FAFAnalysisModelMakeDataFormPlugin", (Runnable)new FAFRecalcMeasureTask(syncTaskId, this.cache, formParam));
            this.startProgressBar();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u91cd\u7b97\u3002", (String)"FAFRecalcMeasureFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeViewToInitialStart() {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{PARAMETERFLEX});
        view.setVisible(Boolean.TRUE, new String[]{"progressbarap", FILTER_FLEXPANEL});
        this.changeImage("imageap", gifUrl);
    }

    private void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(0);
        progressBar.start();
    }

    private void changeImage(String imageAp, String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(imageAp, data);
    }

    private static class FormParam {
        private Long anaSystemId;
        private DynamicObject analysisSystem;
        private Long anaModelId;
        private DynamicObject analysisModel;
        private Set<Long> orgIds;
        private Set<Long> periodIds;

        private FormParam() {
        }

        public static FormParam get(IDataModel model) {
            FormParam formParam = new FormParam();
            formParam.anaSystemId = (Long)model.getValue("analysis_system_id");
            if (formParam.anaSystemId != null) {
                formParam.analysisSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaSystemId, (String)"pa_anasystemsetting");
            }
            formParam.anaModelId = (Long)model.getValue("analysismodel_id");
            if (formParam.anaModelId != null) {
                formParam.analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaModelId, (String)"pa_analysismodel");
            }
            MulBasedataDynamicObjectCollection orgDyCol = (MulBasedataDynamicObjectCollection)model.getValue("org");
            formParam.orgIds = orgDyCol.stream().map(dy -> dy.getLong(FAFRecalcMeasureFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
            MulBasedataDynamicObjectCollection acPeriodDyCol = (MulBasedataDynamicObjectCollection)model.getValue(FAFRecalcMeasureFormPlugin.KEY_ACCOUNT_PERIOD);
            formParam.periodIds = acPeriodDyCol.stream().map(dy -> dy.getLong(FAFRecalcMeasureFormPlugin.FBASEDATAID_ID)).collect(Collectors.toSet());
            return formParam;
        }

        public boolean verifyParam(IFormView view) {
            if (!this.verifyAnaSystem(view) || !this.verifyAnaModel(view)) {
                return false;
            }
            if (!"1".equals(this.analysisModel.getString("enable"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u6790\u6a21\u578b\u5df2\u88ab\u7981\u7528,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFRecalcMeasureFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(this.anaModelId);
            if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                view.showTipNotification(modelNewVersionMsg);
                return false;
            }
            return true;
        }

        public boolean verifyAnaSystem(IFormView view) {
            if (this.analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFRecalcMeasureFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }

        public boolean verifyAnaModel(IFormView view) {
            if (this.analysisModel == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"FAFRecalcMeasureFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
    }

    private static class FAFRecalcMeasureTask
    implements Runnable {
        private static final Log logger = LogFactory.getLog(FAFRecalcMeasureTask.class);
        private Long syncTaskId;
        private DistributeCache cache;
        private FormParam formParam;

        public FAFRecalcMeasureTask(Long syncTaskId, DistributeCache cache, FormParam formParam) {
            this.syncTaskId = syncTaskId;
            this.cache = cache;
            this.formParam = formParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    String tableNumber = this.formParam.analysisModel.getString("tablenumber");
                    String detailEntityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
                    ModelTaskLock modelTaskLock = ModelTaskLock.create((String)detailEntityNumber, (Long)this.formParam.anaModelId);
                    try {
                        if (modelTaskLock.tryLock(10000L)) {
                            ArrayList periodIds = new ArrayList(this.formParam.periodIds);
                            Collections.sort(periodIds);
                            int periodCount = periodIds.size();
                            for (int i = 0; i < periodCount; ++i) {
                                int percent = i / periodCount;
                                this.cache.put("FAF|" + this.syncTaskId, (Object)String.valueOf(percent));
                                DataRecalculateParam param = new DataRecalculateParam();
                                param.getOrgIdSet().addAll(this.formParam.orgIds);
                                param.setPeriodId((Long)periodIds.get(i));
                                AlgoXRecalculateExecutor executor = new AlgoXRecalculateExecutor(this.formParam.analysisModel, param);
                                JobSession jobSession = executor.exec();
                                if (jobSession == null) continue;
                                jobSession.commit(1, TimeUnit.DAYS);
                            }
                            this.cache.put("FAF|" + this.syncTaskId, (Object)"recalcSuccess");
                            break block7;
                        }
                        throw new KDBizException("get model lock fail");
                    }
                    finally {
                        modelTaskLock.unlock();
                    }
                }
                catch (Exception e) {
                    logger.error("recalc measure error", (Throwable)e);
                    FAFDataSyncUtil.updateCacheErrorMessage((DistributeCache)this.cache, (Long)this.syncTaskId, (String)e.getMessage());
                }
            }
        }
    }
}

