/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataextract.formplugin;

import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.TimeZone;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.macc.faf.helper.FAFSyncTaskLogHelper;

public class FAFTaskPreviewEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
ProgresssListener {
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);

    public void initialize() {
        this.addBillListFilter();
    }

    private void addBillListFilter() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(setFilterEvent -> {
            Long taskId = (Long)this.getModel().getValue("id");
            QFilter taskIdFilter = new QFilter("datasynctask", "=", (Object)taskId);
            setFilterEvent.addCustomQFilter(taskIdFilter);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        BillList billList = (BillList)view.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (0.0 > percent) {
            view.setVisible(Boolean.TRUE, new String[]{"unfetch"});
            view.setVisible(Boolean.FALSE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            bar.stop();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"unfetch"});
            view.setVisible(Boolean.TRUE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            if (percent >= 100.0) {
                progressEvent.setProgress(99);
                model.setValue("completepercent", (Object)99);
            } else {
                progressEvent.setProgress((int)percent);
                model.setValue("completepercent", (Object)percent);
            }
        }
        if (staticStatus != null && staticStatus.isTaskEnd()) {
            progressEvent.setProgress((int)percent);
            model.setValue("completepercent", (Object)percent);
            bar.stop();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        hyperLinkClickEvent.getFieldName();
        Object logId = ((BillListHyperLinkClickEvent)hyperLinkClickEvent).getCurrentRow().getPrimaryKeyValue();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(logId);
        billShowParameter.setFormId("pa_tasklog");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object syncdatascheme = model.getValue("syncdatascheme");
        model.setValue("syncscheme", syncdatascheme);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        if (0.0 >= percent) {
            view.setVisible(Boolean.TRUE, new String[]{"percentchar"});
            view.setVisible(Boolean.FALSE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "info"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            if (percent >= 100.0) {
                bar.setPercent(100);
                model.setValue("completepercent", (Object)100);
            } else {
                bar.setPercent((int)percent);
                bar.start();
                model.setValue("completepercent", (Object)percent);
            }
        }
        if (staticStatus != null && staticStatus.isTaskEnd()) {
            bar.stop();
        }
        model.setDataChanged(false);
    }

    public IDataSimpleWorkTaskStatisticStatus getStaticStatus() {
        int[] taskStatisticsPoints;
        long[] totalTaskTimeCost;
        IDataModel model = this.getModel();
        Long taskId = (Long)model.getValue("id");
        String cacheStatusStr = this.cache.get("FAF|" + taskId);
        IDataSimpleWorkTaskStatisticStatus statisticStatus = null;
        if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
            statisticStatus = (IDataSimpleWorkTaskStatisticStatus)FAFSyncTaskLogHelper.getCachedWorkTaskStatusEvent((String)cacheStatusStr);
        } else {
            cacheStatusStr = (String)model.getValue("staticstatus_info_tag");
            if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
                statisticStatus = (IDataSimpleWorkTaskStatisticStatus)FAFSyncTaskLogHelper.getCachedWorkTaskStatusEvent((String)cacheStatusStr);
            }
        }
        if (statisticStatus != null && !statisticStatus.isTaskEnd() && (totalTaskTimeCost = statisticStatus.getTotalTaskTimeCost()).length == 2 && (taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints()).length == 2) {
            long time = totalTaskTimeCost[1] - totalTaskTimeCost[0];
            double predictTime = (double)time / (double)taskStatisticsPoints[0] * (double)(taskStatisticsPoints[1] - taskStatisticsPoints[0]);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            String dateTime = sdf.format(time);
            String predictdateTime = sdf.format(predictTime);
            model.setValue("executiontime", (Object)String.format(ResManager.loadKDString((String)"%1$s (\u9884\u8ba1\u5269\u4f59\u65f6\u95f4: %2$s)", (String)"FAFTaskPreviewEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), dateTime, predictdateTime));
        }
        return statisticStatus;
    }

    public double getPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        IDataModel model = this.getModel();
        if (statisticStatus != null) {
            int[] taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints();
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            long taskExecutionTime = statisticStatus.getTaskExecutionTime();
            double percent = (double)taskStatisticsPoints[0] / (double)taskStatisticsPoints[1] * 100.0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            boolean error = statisticStatus.isWithError();
            boolean interrupt = statisticStatus.isInterrupt();
            if (interrupt) {
                model.setValue("info", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u4e2d\u65ad\u3002", (String)"FAFTaskPreviewEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return -1.0;
            }
            if (error) {
                model.setValue("info", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"FAFTaskPreviewEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return -1.0;
            }
            if (taskEnd || Double.doubleToLongBits(percent) == Double.doubleToLongBits(100.0)) {
                model.setValue("info", (Object)((statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()) + String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%1$s, \u5df2\u8bfb\u53d6\uff1a%s, \u5b9e\u9645\u603b\u6570\uff1a%2$s", (String)"FAFTaskPreviewEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1])));
            } else if (Double.doubleToLongBits(percent) == Double.doubleToLongBits(0.0)) {
                model.setValue("info", (Object)(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FAFTaskPreviewEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]) + (statisticStatus.getStatusMessage() == null ? "" : ": " + statisticStatus.getStatusMessage())));
            } else if (0.0 < percent && percent < 100.0) {
                model.setValue("info", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%1$s, \u5df2\u8bfb\u53d6\uff1a%2$s, \u5b9e\u9645\u603b\u6570\uff1a%3$s", (String)"FAFTaskPreviewEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1]));
            } else {
                model.setValue("info", (Object)(statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()));
            }
            return percent;
        }
        return 0.0;
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy;
        super.itemClick(evt);
        switch (operationKy = evt.getItemKey()) {
            case "terminate_task": {
                IDataModel model = this.getModel();
                Long taskId = (Long)model.getValue("id");
                FAFWorkTaskStatusConsumer.getInstance().markTaskCancel((Object)taskId);
                break;
            }
        }
    }
}

