/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.macc.faf.dataquery.func.FAFQingAnalysisEnumDimensionMapFunction;
import kd.macc.faf.dataquery.query.FAFDataQueryReviewListPlugin;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFDimensionHelper;

public class FAFDataQueryQingDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    public static final String PARAMS_QUERY_PARAM = "ReportQueryParam";
    public static final String RESULT_CACHE_ID = "ResultCacheId";
    public static final String QING_META = "QingMeta";
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put(PARAMS_QUERY_PARAM, filterParameter);
        this.getPageCache().saveChanges();
    }

    public String getFilterParameter() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAMS_QUERY_PARAM);
    }

    public QingMeta getMeta(String pageId) {
        ReportQueryParam reportQueryParam = this.getReportQueryParam();
        FAFDataQueryReviewListPlugin fafDataQueryReviewListPlugin = new FAFDataQueryReviewListPlugin();
        this.cacheDataSet(fafDataQueryReviewListPlugin, reportQueryParam);
        QingMeta qingMeta = this.buildQingMeta(fafDataQueryReviewListPlugin);
        this.getPageCache().put(QING_META, SerializationUtils.serializeToBase64((Object)qingMeta));
        this.getPageCache().saveChanges();
        return qingMeta;
    }

    public QingData getData(String pageId, int startRow, int limit) {
        String cacheId = this.getPageCache().get(RESULT_CACHE_ID);
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(QING_META));
        return this.buildQingData(cacheId, qingMeta, startRow, limit);
    }

    private ReportQueryParam getReportQueryParam() {
        String parameter = this.getFilterParameter();
        if (parameter == null) {
            parameter = this.getPageCache().get(PARAMS_QUERY_PARAM);
        }
        return (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)parameter);
    }

    private QingMeta buildQingMeta(FAFDataQueryReviewListPlugin fafDataQueryReviewListPlugin) {
        QingMeta qingMeta = new QingMeta();
        List<AbstractReportColumn> columns = null;
        try {
            columns = fafDataQueryReviewListPlugin.getColumns(new ArrayList<AbstractReportColumn>());
            for (AbstractReportColumn reportColumn : columns) {
                ReportColumn column = (ReportColumn)reportColumn;
                qingMeta.addColumn(this.createField(column));
            }
        }
        catch (Throwable throwable) {
            throw new KDBizException(throwable.getMessage());
        }
        return qingMeta;
    }

    private Field createField(ReportColumn column) {
        Field field = new Field();
        field.setKey(FAFDataQueryQingDataProvider.compatibilityFieldKey(column.getFieldKey()));
        field.setName(column.getCaption());
        field.setFieldType(this.getQingType(column.getFieldType()));
        field.setEntity(column.getEntityId());
        field.setRefEntity(column.getEntityId());
        return field;
    }

    private int getQingType(String fieldType) {
        switch (fieldType) {
            case "price": 
            case "qty": 
            case "amount": 
            case "decimal": {
                return QingFieldType.Number.toNumber();
            }
            case "integer": {
                return QingFieldType.Int.toNumber();
            }
            case "date": {
                return QingFieldType.Date.toNumber();
            }
        }
        return QingFieldType.String.toNumber();
    }

    public static String compatibilityFieldKey(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean match = false;
        while (matcher.find()) {
            match = true;
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        if (match) {
            sb.insert(0, "_");
        }
        return sb.toString().toLowerCase();
    }

    private void cacheDataSet(FAFDataQueryReviewListPlugin fafDataQueryReviewListPlugin, ReportQueryParam reportQueryParam) {
        try {
            DataSet queryDataSet = fafDataQueryReviewListPlugin.queryAll(reportQueryParam, null);
            DataSet resultDataSet = queryDataSet.map((MapFunction)new FAFQingAnalysisEnumDimensionMapFunction(queryDataSet.getRowMeta(), this.getEnumDimensionItemDataMap(reportQueryParam)));
            CacheHint cacheHint = CacheHint.getDefault();
            cacheHint.setTimeout(600000L, TimeUnit.MILLISECONDS);
            String cacheId = resultDataSet.cache(cacheHint).getCacheId();
            this.getPageCache().put(RESULT_CACHE_ID, cacheId);
        }
        catch (Throwable throwable) {
            throw new KDBizException(throwable.getMessage());
        }
    }

    private Map<String, Map<Object, String>> getEnumDimensionItemDataMap(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        FilterItemInfo anaModelItem = filterInfo.getFilterItem("anamodel");
        if (anaModelItem == null || anaModelItem.getValue() == null) {
            throw new KDBizException("query param of analysis model can not be null");
        }
        long anaModelId = ((DynamicObject)anaModelItem.getValue()).getLong("id");
        LinkedHashMap<String, Map<Object, String>> mapMap = new LinkedHashMap<String, Map<Object, String>>(4);
        DynamicObject analysisModel = FAFAnalysisModelHelper.loadAnalysisModel((Object)anaModelId);
        for (DynamicObject dimensionEntry : analysisModel.getDynamicObjectCollection("dimension_entry")) {
            DynamicObject dimension = dimensionEntry.getDynamicObject("dimension");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            if (DimensionTypeEnum.DENUMS != dimensionTypeEnum) continue;
            Map<Object, String> enumItemMap = FAFDimensionHelper.getValueMapItems((DynamicObject)dimension).stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().toString()));
            mapMap.put(dimension.getString("number"), enumItemMap);
        }
        return mapMap;
    }

    private QingData buildQingData(String cacheId, QingMeta qingMeta, int startRow, int length) {
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
        List objects = cacheDataSet.getList(startRow - 1, length).stream().map(row -> ((AbstractRow)row).values()).collect(Collectors.toList());
        LinkedHashMap<String, Integer> dataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (Field field : qingMeta.getColumns()) {
            if (dataIndexMap.containsKey(field.getKey().toLowerCase())) continue;
            dataIndexMap.put(field.getKey().toLowerCase(), columnSeqNo++);
        }
        QingData qingData = new QingData();
        qingData.setRows(objects);
        qingData.setDataindex(dataIndexMap);
        return qingData;
    }

    public String getSchemaAdditionalTag(String pageId) {
        return super.getSchemaAdditionalTag(pageId);
    }

    public static FormShowParameter buildFsp(ReportQueryParam queryParam) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("faf_dataquery_qing");
        fsp.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u8f7b\u5206\u6790", (String)"FAFDataQueryQingDataProvider_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam(PARAMS_QUERY_PARAM, (Object)SerializationUtils.serializeToBase64((Object)queryParam));
        return fsp;
    }
}

