/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.query;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.dataquery.query.FAFDataQueryQingDataProvider;
import kd.macc.faf.dataquery.query.FAFDataQueryReportFilter;
import kd.macc.faf.enums.DataQueryTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFAnasystemSettingHelper;
import kd.macc.faf.helper.FAFDataQueryHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.DateUtil;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.LicenseUtil;
import kd.macc.faf.util.M;
import kd.macc.faf.util.ValidatorTipsUtil;

public class FAFDataQueryReviewFormPlugin
extends AbstractReportFormPlugin
implements BeforeFilterF7SelectListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    public static final String ANA_SYSTEM = "anasystem";
    public static final String ANA_MODEL = "anamodel";
    public static final String BD_PERIOD = "bdperiod";
    public static final String PA_PERIOD = "paperiod";
    public static final String DATE_RANGE = "daterange";
    public static final String DATE_RANGE_START = "startdate";
    public static final String DATE_RANGE_END = "enddate";
    public static final String ORG = "org";
    public static final String DATA_TYPE = "datatype";
    public static final String DETAIL_IDS = "detailids";
    public static final String[] removeTypes = new String[]{"-1", "-2", "-3", "-4", "-5", "-6"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit anaModel = (BasedataEdit)this.getView().getControl(ANA_MODEL);
        anaModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bdPeriod = (BasedataEdit)this.getView().getControl(BD_PERIOD);
        bdPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit paPeriod = (BasedataEdit)this.getView().getControl(PA_PERIOD);
        paPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void initialize() {
        this.getView().addCustomControls(new String[]{"reportfilterap"});
    }

    public void onGetControl(OnGetControlArgs e) {
        Control control;
        String key = e.getKey();
        if ("reportfilterap".equals(key) && (control = e.getControl()) != null && !(control instanceof FAFDataQueryReportFilter)) {
            e.setControl((Control)FAFDataQueryReportFilter.create((ReportFilter)control));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.InitByReportQueryParameters();
    }

    private void InitByReportQueryParameters() {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = formShowParameter.getReportQueryParam();
        IDataModel model = this.getModel();
        if (reportQueryParam != null) {
            FilterInfo filter = reportQueryParam.getFilter();
            if (filter != null) {
                FilterItemInfo dataTypeItem;
                FilterItemInfo anaModelItem;
                FilterItemInfo anaSystemItem = filter.getFilterItem(ANA_SYSTEM);
                if (anaSystemItem != null) {
                    model.setValue(ANA_SYSTEM, anaSystemItem.getValue());
                }
                if ((anaModelItem = filter.getFilterItem(ANA_MODEL)) != null) {
                    model.setValue(ANA_MODEL, anaModelItem.getValue());
                }
                this.setPeriodOrDateRangeValue(model, filter);
                FilterItemInfo orgItem = filter.getFilterItem(ORG);
                if (orgItem != null) {
                    model.setValue(ORG, (Object)this.getPermOrgOfUser((DynamicObjectCollection)orgItem.getValue()));
                }
                if ((dataTypeItem = filter.getFilterItem(DATA_TYPE)) != null) {
                    model.setValue(DATA_TYPE, dataTypeItem.getValue());
                }
            }
        } else {
            String dataType = (String)formShowParameter.getCustomParam(DATA_TYPE);
            if (StringUtils.isNotBlank((CharSequence)dataType)) {
                model.setValue(DATA_TYPE, (Object)dataType);
            }
        }
    }

    private void setPeriodOrDateRangeValue(IDataModel model, FilterInfo filterInfo) {
        FilterItemInfo anaModelItem = filterInfo.getFilterItem(ANA_MODEL);
        if (anaModelItem != null) {
            long anaModelId = ((DynamicObject)anaModelItem.getValue()).getLong("id");
            Map dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)anaModelId, dimension -> dimension);
            DynamicObject periodDimension = (DynamicObject)dimensionNecessityEnumDynamicObjectMap.get(DimensionNecessityEnum.PERIOD);
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"));
            switch (dimensionType) {
                case DATABASE: 
                case PERIOD: 
                case ASSISTANTDATA: {
                    String periodNumber = this.getPeriodNumber();
                    FilterItemInfo periodItem = filterInfo.getFilterItem(periodNumber);
                    if (periodItem == null) break;
                    model.setValue(periodNumber, periodItem.getValue());
                    break;
                }
                case DATE: {
                    FilterItemInfo dateEndItem;
                    FilterItemInfo dateStartItem = filterInfo.getFilterItem(DATE_RANGE_START);
                    if (dateStartItem != null) {
                        model.setValue(DATE_RANGE_START, dateStartItem.getValue());
                    }
                    if ((dateEndItem = filterInfo.getFilterItem(DATE_RANGE_END)) == null) break;
                    model.setValue(DATE_RANGE_END, dateEndItem.getValue());
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u6807\u8bb0\u7684\u65f6\u95f4\u671f\u95f4\u5fc5\u8981\u7ef4\u5ea6\u7684\u7c7b\u578b\u76ee\u524d\u53ea\u652f\u6301\u57fa\u7840\u8d44\u6599\u3001\u671f\u95f4\u7ef4\u5ea6\u3001\u8f85\u52a9\u8d44\u6599\u3001\u65f6\u95f4", (String)"FAFDataQueryReviewFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private Object[] getPermOrgOfUser(DynamicObjectCollection orgDys) {
        if (CollectionUtils.isEmpty((Collection)orgDys)) {
            return null;
        }
        OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)this.getModel().getDataEntityType().getName(), (String)this.getView().getFormShowParameter().getAppId());
        if (permOrgResult.hasAllOrgPerm()) {
            return orgDys.stream().map(dy -> dy.getLong("id")).toArray();
        }
        Set permOrgSet = permOrgResult.getPermOrgs();
        return orgDys.stream().map(dy -> dy.getLong("id")).filter(permOrgSet::contains).toArray();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGrid((Long)this.getModel().getValue("anamodel_id"), false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setQueryControlVisible();
    }

    private void setQueryControlVisible() {
        boolean isDetailReview;
        IReportView view = this.getView();
        Long modelId = (Long)this.getModel().getValue("anamodel_id");
        if (modelId != null && modelId != 0L) {
            Map dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)modelId, dimension -> dimension);
            DynamicObject periodDimension = (DynamicObject)dimensionNecessityEnumDynamicObjectMap.get(DimensionNecessityEnum.PERIOD);
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"));
            switch (dimensionType) {
                case DATABASE: 
                case PERIOD: 
                case ASSISTANTDATA: {
                    String periodNumber = this.getPeriodNumber();
                    view.setVisible(Boolean.TRUE, new String[]{periodNumber});
                    view.setVisible(Boolean.FALSE, new String[]{DATE_RANGE, periodNumber.equals(BD_PERIOD) ? PA_PERIOD : BD_PERIOD});
                    break;
                }
                case DATE: {
                    view.setVisible(Boolean.TRUE, new String[]{DATE_RANGE});
                    view.setVisible(Boolean.FALSE, new String[]{PA_PERIOD, BD_PERIOD});
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u6807\u8bb0\u7684\u65f6\u95f4\u671f\u95f4\u5fc5\u8981\u7ef4\u5ea6\u7684\u7c7b\u578b\u76ee\u524d\u53ea\u652f\u6301\u57fa\u7840\u8d44\u6599\u3001\u671f\u95f4\u7ef4\u5ea6\u3001\u8f85\u52a9\u8d44\u6599\u3001\u65f6\u95f4", (String)"FAFDataQueryReviewFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            view.setVisible(Boolean.TRUE, new String[]{"filtergridap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{BD_PERIOD});
            view.setVisible(Boolean.FALSE, new String[]{DATE_RANGE, PA_PERIOD, "filtergridap"});
        }
        ReportQueryParam reportQueryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        if (reportQueryParam != null && (isDetailReview = reportQueryParam.getFilter().getFilterItems().stream().anyMatch(filterItem -> DETAIL_IDS.equals(filterItem.getPropName())))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportfilterap"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (("exportexcel".equals(itemKey) || "refresh".equals(itemKey)) && !this.validateModelTable()) {
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("qinganalysis".equals(keyName) && !this.validateModelTable()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("qinganalysis".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().showForm(FAFDataQueryQingDataProvider.buildFsp(this.getQueryParam()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "anasystem": {
                this.getModel().setValue(ANA_MODEL, null);
                break;
            }
            case "anamodel": {
                Long modelId = (Long)this.getModel().getValue("anamodel_id");
                boolean isValidated = this.validateModelVersion(modelId, e);
                if (!isValidated) break;
                this.clearQueryParamValueByModel(modelId);
                this.initFilterGrid(modelId, true);
                if (modelId != 0L) {
                    this.initPeriodDefaultValue(modelId);
                }
                this.setQueryControlVisible();
            }
        }
    }

    private void initPeriodDefaultValue(Long modelId) {
        Map dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)modelId, dimension -> dimension);
        DynamicObject periodDimension = (DynamicObject)dimensionNecessityEnumDynamicObjectMap.get(DimensionNecessityEnum.PERIOD);
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"));
        if (DimensionTypeEnum.DATABASE == dimensionTypeEnum) {
            LocalDate now;
            QFilter filter;
            List objectList;
            String dimensionSourceNumber = periodDimension.getDynamicObject("dimensionsource").getString("number");
            if ("bd_period".equals(dimensionSourceNumber)) {
                List objectList2;
                Date now2 = DateUtil.getDataFormat((Date)new Date(), (boolean)true);
                QFilter dateFilter = new QFilter("begindate", "<=", (Object)now2).and(new QFilter(DATE_RANGE_END, ">=", (Object)now2));
                QFilter adjustFilter = new QFilter("isadjustperiod", "!=", (Object)"1");
                QFilter groupFilter = null;
                String typeField = periodDimension.getString("typefield");
                Object group = periodDimension.get("group_id");
                if (StringUtils.isNotBlank((CharSequence)typeField) && group != null) {
                    groupFilter = new QFilter(typeField, "=", group);
                }
                if (!CollectionUtils.isEmpty((Collection)(objectList2 = QueryServiceHelper.queryPrimaryKeys((String)dimensionSourceNumber, (QFilter[])new QFilter[]{dateFilter, adjustFilter, groupFilter}, null, (int)1)))) {
                    this.getModel().setValue(BD_PERIOD, objectList2.get(0));
                }
            } else if ("pa_analysisperiod".equals(dimensionSourceNumber) && !CollectionUtils.isEmpty((Collection)(objectList = QueryServiceHelper.queryPrimaryKeys((String)dimensionSourceNumber, (QFilter[])new QFilter[]{filter = new QFilter(DATE_RANGE_START, "<=", (Object)(now = LocalDate.now())).and(DATE_RANGE_END, ">=", (Object)now).and("isleaf", "=", (Object)true).and("isadjust", "=", (Object)false).and("enable", "=", (Object)"1")}, null, (int)1)))) {
                this.getModel().setValue(PA_PERIOD, objectList.get(0));
            }
        } else {
            this.getModel().setValue(BD_PERIOD, null);
            this.getModel().setValue(PA_PERIOD, null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection orgs;
        IReportView view = this.getView();
        FilterInfo filter = queryParam.getFilter();
        StringBuilder sb = new StringBuilder();
        DynamicObject anaSystem = (DynamicObject)filter.getFilterItem(ANA_SYSTEM).getValue();
        if (anaSystem == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFDataQueryReviewFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        sb.append(new LocaleString(ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb", (String)"FAFDataQueryReviewFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]))).append('\uff1a').append(anaSystem.getString("name")).append("\uff1b  ");
        DynamicObject anaModel = (DynamicObject)filter.getFilterItem(ANA_MODEL).getValue();
        if (anaModel == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFDataQueryReviewFormPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        sb.append(new LocaleString(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b", (String)"FAFDataQueryReviewFormPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]))).append('\uff1a').append(anaModel.getString("name")).append("\uff1b  ");
        boolean needNotPeriod = "1".equals(this.getView().getFormShowParameter().getCustomParam("needNotPeriod"));
        if (!needNotPeriod) {
            String periodNumber = this.getPeriodNumber();
            Map dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)anaModel.getLong("id"), dimension -> dimension);
            DynamicObject periodDimension = (DynamicObject)dimensionNecessityEnumDynamicObjectMap.get(DimensionNecessityEnum.PERIOD);
            DimensionTypeEnum periodDimensionTypeEnum = DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"));
            switch (periodDimensionTypeEnum) {
                case DATABASE: {
                    DynamicObject period = (DynamicObject)filter.getFilterItem(periodNumber).getValue();
                    if (period == null) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFDataQueryReviewFormPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    sb.append(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"FAFDataQueryReviewFormPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]))).append('\uff1a').append(period.getString("name")).append("\uff1b  ");
                    break;
                }
                case DATE: {
                    Date startDate = (Date)queryParam.getFilter().getFilterItem(DATE_RANGE_START).getValue();
                    Date endDate = (Date)queryParam.getFilter().getFilterItem(DATE_RANGE_END).getValue();
                    if (startDate == null || endDate == null) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFDataQueryReviewFormPlugin_11", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    sb.append(new LocaleString(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FAFDataQueryReviewFormPlugin_12", (String)"macc-faf-formplugin", (Object[])new Object[0]))).append('\uff1a').append(simpleDateFormat.format(startDate)).append(" ~ ").append(simpleDateFormat.format(endDate)).append("\uff1b  ");
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orgs = (DynamicObjectCollection)filter.getFilterItem(ORG).getValue()))) {
            sb.append(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"FAFDataQueryReviewFormPlugin_13", (String)"macc-faf-formplugin", (Object[])new Object[0]))).append('\uff1a').append(orgs.stream().map(p -> p.getString("name")).collect(Collectors.joining("\uff0c"))).append("\uff1b  ");
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("reportfilterap", "updateSearchCondition", new Object[]{sb.toString()});
        return super.verifyQuery(queryParam);
    }

    private boolean validateModelVersion(Long modelId, PropertyChangedArgs e) {
        String modelNewVersionMsg;
        if (modelId != 0L && StringUtils.isNotBlank((CharSequence)(modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId)))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            this.getModel().beginInit();
            this.getModel().setValue(ANA_MODEL, oldValue);
            this.getModel().endInit();
            this.getView().showTipNotification(modelNewVersionMsg);
            return false;
        }
        return true;
    }

    private void clearQueryParamValueByModel(Long modelId) {
        this.getModel().setValue(BD_PERIOD, null);
        this.getModel().setValue(PA_PERIOD, null);
        this.getModel().setValue(DATE_RANGE_START, null);
        this.getModel().setValue(DATE_RANGE_END, null);
        this.getModel().setValue(ORG, null);
    }

    private void initFilterGrid(Long modelId, boolean isClearValue) {
        String entityNumber;
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (model == null) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(new ArrayList(1));
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView("filtergridap");
            return;
        }
        if (StringUtils.isBlank((CharSequence)model.getString("tablenumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"FAFDataQueryReviewFormPlugin_14", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(new ArrayList(1));
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView("filtergridap");
            return;
        }
        DataQueryTypeEnum dataQueryTypeEnum = DataQueryTypeEnum.getEnumByCode((String)((String)this.getModel().getValue(DATA_TYPE)));
        switch (dataQueryTypeEnum) {
            case SUMMARY: {
                entityNumber = AnalysisModelUtil.buildEntityNumber((String)model.getString("tablenumber"));
                break;
            }
            case DETAIL: {
                entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)model.getString("tablenumber"));
                break;
            }
            default: {
                return;
            }
        }
        Map necessityDimMap = DimensionDyUtil.loopDoDimensionNecessity((Long)modelId, dimension -> dimension);
        ArrayList<String> filterFieldKeys = new ArrayList<String>();
        for (DynamicObject dimensionEntry : model.getDynamicObjectCollection("dimension_entry")) {
            String dimensionNumber = dimensionEntry.getDynamicObject("dimension").getString("number");
            String fieldNumbers = dimensionEntry.getString("field_number_tag");
            if (((DynamicObject)necessityDimMap.get(DimensionNecessityEnum.ORG)).getString("number").equals(dimensionNumber) || ((DynamicObject)necessityDimMap.get(DimensionNecessityEnum.PERIOD)).getString("number").equals(dimensionNumber)) continue;
            if (StringUtils.isNotBlank((CharSequence)fieldNumbers)) {
                String[] fieldNumberSplit;
                for (String fieldNumber : fieldNumberSplit = fieldNumbers.split(",")) {
                    filterFieldKeys.add(String.format("%1$s.%2$s", dimensionNumber, fieldNumber));
                }
                continue;
            }
            filterFieldKeys.add(dimensionNumber);
        }
        for (DynamicObject measureEntry : model.getDynamicObjectCollection("measure_entry")) {
            filterFieldKeys.add(measureEntry.getDynamicObject("measure").getString("number"));
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.setFilterColumns(this.getFilterColumns(model, entityNumber, filterFieldKeys));
        if (isClearValue) {
            filterGrid.SetValue(new FilterCondition());
        }
        this.getView().updateView("filtergridap");
    }

    private List<Map<String, Object>> getFilterColumns(DynamicObject model, String entityNumber, List<String> filterFieldKeys) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List allFilterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(8);
        List measureNumberList = model.getDynamicObjectCollection("measure_entry").stream().map(measureEntry -> measureEntry.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
        for (Map allFilterColumn : allFilterColumns) {
            String fieldName = (String)allFilterColumn.get("fieldName");
            if (!filterFieldKeys.contains(fieldName)) continue;
            if (measureNumberList.contains(fieldName)) {
                List compareTypeDTOs = (List)FAFUtils.cast(allFilterColumn.get("compareTypes"));
                compareTypeDTOs.removeIf(dto -> ArrayUtils.contains((Object[])removeTypes, (Object)dto.getId()));
            }
            filterColumns.add(allFilterColumn);
        }
        return filterColumns;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (!this.validateModelTable()) {
            return;
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        if ("field_review_source".equals(fieldName)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setFormId(rowData.getString("sourceformid"));
            billShowParameter.setPkId((Object)rowData.getLong("sourcebillid"));
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if ("field_review_detail".equals(fieldName)) {
            ReportQueryParam reportQueryParaByDetailReview = this.getReportQueryParaByDetailReview(rowData);
            if (reportQueryParaByDetailReview.getFilter().getFilterItem(DETAIL_IDS) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u8ba1\u7b97\u578b\u5ea6\u91cf\u6570\u636e\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u660e\u7ec6\u3002", (String)"FAFDataQueryReviewFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("faf_dataquery_d");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            reportShowParameter.setQueryParam(reportQueryParaByDetailReview);
            this.getView().showForm((FormShowParameter)reportShowParameter);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pa_data_review");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("modelId", (Object)((DynamicObject)this.getQueryParam().getFilter().getFilterItem(ANA_MODEL).getValue()).getLong("id"));
            formShowParameter.setCustomParam("summaryId", (Object)rowData.getLong("id"));
            formShowParameter.setCustomParam("measureNumber", (Object)fieldName);
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean validateModelTable() {
        DynamicObject currentAnaModel;
        DynamicObject anaModelOfQueryParam;
        FilterItemInfo filterItem = this.getQueryParam().getFilter().getFilterItem(ANA_MODEL);
        if (filterItem != null && (anaModelOfQueryParam = (DynamicObject)filterItem.getValue()) != null && StringUtils.isBlank((CharSequence)(currentAnaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)anaModelOfQueryParam.getLong("id"), (String)"pa_analysismodel")).getString("tablenumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"FAFDataQueryReviewFormPlugin_14", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void open(AbstractFormPlugin formPlugin, Object systemId, Object analysisModelId, Collection<Long> orgIds, Object periodId) {
        ReportQueryParam reportQueryPara = new ReportQueryParam();
        FilterInfo filterInfo = reportQueryPara.getFilter();
        filterInfo.addFilterItem(ANA_SYSTEM, (Object)FAFAnasystemSettingHelper.getAnasystemSettingById((Object)systemId), "67");
        filterInfo.addFilterItem(ANA_MODEL, (Object)FAFAnalysisModelHelper.loadAnalysisModel((Object)analysisModelId), "67");
        filterInfo.addFilterItem(ORG, (Object)QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter("id", "in", orgIds).toArray()), "67");
        filterInfo.addFilterItem(DATA_TYPE, (Object)DataQueryTypeEnum.SUMMARY.getCode(), "67");
        DynamicObject period = null;
        DynamicObject periodDimension = (DynamicObject)DimensionDyUtil.loopDoDimensionNecessity((Long)((Long)analysisModelId), dimension -> dimension).get(DimensionNecessityEnum.PERIOD);
        if (DimensionTypeEnum.DATABASE == DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"))) {
            String periodNumber;
            String periodSourceNumber = periodDimension.getDynamicObject("dimensionsource").getString("number");
            if (periodId != null) {
                period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)periodSourceNumber);
            }
            switch (periodSourceNumber) {
                case "bd_period": {
                    periodNumber = BD_PERIOD;
                    break;
                }
                case "pa_analysisperiod": {
                    periodNumber = PA_PERIOD;
                    break;
                }
                default: {
                    throw new KDBizException("period type error");
                }
            }
            filterInfo.addFilterItem(periodNumber, (Object)period, "67");
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("faf_data_query");
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        reportShowParameter.setQueryParam(reportQueryPara);
        formPlugin.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private ReportQueryParam getReportQueryParaByDetailReview(DynamicObject rowData) {
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        FilterInfo currentQueryFilterInfo = this.getQueryParam().getFilter();
        for (FilterItemInfo filterItem : currentQueryFilterInfo.getFilterItems()) {
            Object value;
            String propName = filterItem.getPropName();
            String compareType = filterItem.getCompareType();
            if (DATA_TYPE.equals(propName)) {
                value = DataQueryTypeEnum.DETAIL.getCode();
            } else if (DETAIL_IDS.equals(propName)) {
                long anaModelId = ((DynamicObject)currentQueryFilterInfo.getFilterItem(ANA_MODEL).getValue()).getLong("id");
                Object[] ids = FAFDataQueryHelper.getDetailIdsBySummaryId((Long)rowData.getLong("id"), (Long)anaModelId);
                if (ArrayUtils.isEmpty((Object[])ids)) continue;
                value = JSON.toJSONString((Object)ids);
            } else {
                value = filterItem.getValue();
            }
            filterInfo.addFilterItem(propName, value, compareType);
        }
        return reportQueryParam;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String periodNumber = this.getPeriodNumber();
        if (ORG.equals(fieldKey) || periodNumber.equals(fieldKey)) {
            Long anaModelId = (Long)this.getModel().getValue("anamodel_id");
            if (anaModelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"FAFDataQueryReviewFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter qfilter;
                Map dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)anaModelId, dimension -> dimension);
                if (fieldKey.equals(ORG)) {
                    OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"faf_data_query", (String)"faf");
                    qfilter = permOrgResult.hasAllOrgPerm() ? QFilter.of((String)"1=1", (Object[])new Object[0]) : new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                } else {
                    DynamicObject dimension2 = (DynamicObject)dimensionNecessityEnumDynamicObjectMap.get(DimensionNecessityEnum.PERIOD);
                    qfilter = FAFDataQueryHelper.getDimensionF7SelectQFilter((DynamicObject)dimension2);
                }
                beforeF7SelectEvent.getCustomQFilters().add(qfilter);
            }
        } else if (ANA_MODEL.equals(fieldKey)) {
            DynamicObject anaSystem = (DynamicObject)this.getModel().getValue(ANA_SYSTEM);
            if (anaSystem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFDataQueryReviewFormPlugin_15", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter systemFilter = new QFilter("analysis_system", "=", (Object)anaSystem.getLong("id"));
            QFilter tableFilter = new QFilter("tablenumber", "!=", (Object)"");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(systemFilter.and(tableFilter));
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String[] fieldNameSplit = beforeFilterF7SelectEvent.getFieldName().split("\\.");
        if (fieldNameSplit.length == 2) {
            DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)fieldNameSplit[0]), new QFilter("system", "=", this.getModel().getValue("anasystem_id"))});
            QFilter filter = null;
            ImportSystemSourceTypeEnum systemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)dimension.getString("systemsource"));
            switch (systemSourceTypeEnum) {
                case BCM: 
                case EPM: {
                    DynamicObjectCollection dimensionMappings = FAFDimensionHelper.queryDimensionMappingByDimensionIds((List)M.objectArraylist((Object[])new Object[]{dimension.getLong("id")}), (ImportSystemSourceTypeEnum)systemSourceTypeEnum);
                    if (CollectionUtils.isEmpty((Collection)dimensionMappings)) break;
                    filter = new QFilter("model.id", "=", (Object)((DynamicObject)dimensionMappings.get(0)).getLong("immodel")).and(new QFilter("dimension", "=", (Object)((DynamicObject)dimensionMappings.get(0)).getLong("imdimension")));
                    break;
                }
                case NEW: {
                    filter = FAFDataQueryHelper.getDimensionF7SelectQFilter((DynamicObject)dimension);
                    break;
                }
            }
            beforeFilterF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    private String getPeriodNumber() {
        String periodNumber = BD_PERIOD;
        DynamicObject anaModel = (DynamicObject)this.getModel().getValue(ANA_MODEL);
        if (anaModel == null) {
            return periodNumber;
        }
        DynamicObject periodDimension = (DynamicObject)DimensionDyUtil.loopDoDimensionNecessity((Long)anaModel.getLong("id"), dimension -> dimension).get(DimensionNecessityEnum.PERIOD);
        if (DimensionTypeEnum.DATABASE == DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"))) {
            String periodSourceNumber;
            switch (periodSourceNumber = periodDimension.getDynamicObject("dimensionsource").getString("number")) {
                case "bd_period": {
                    periodNumber = BD_PERIOD;
                    break;
                }
                case "pa_analysisperiod": {
                    periodNumber = PA_PERIOD;
                    break;
                }
                default: {
                    throw new KDBizException("period type error");
                }
            }
        }
        return periodNumber;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

