/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.dataquery.dto.FAFDataQueryModelDTO;
import kd.macc.faf.dataquery.func.FAFReportDateTimeFormatFunction;
import kd.macc.faf.dataquery.func.FAFReportQueryDetailCalMeasureMapFunction;
import kd.macc.faf.dataquery.func.FAFReportQueryReviewDetailMapFunction;
import kd.macc.faf.dataquery.func.FAFReportQuerySourceBillMapFunction;
import kd.macc.faf.enums.DataQueryTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.exception.StopRecursionException;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFDataQueryReviewListPlugin
extends AbstractReportListDataPlugin {
    private FAFDataQueryModelDTO dataQueryModelDTO;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        try {
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            ORM orm = ORM.create();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String queryFieldsInfo = this.dataQueryModelDTO.getQueryFieldsInfo();
            IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
            List currentBatchRows = byBatchInfo.getCurrentBatchRows().stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.dataquery.query.FAFDataQueryReviewListPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), queryFieldsInfo, new QFilter("id", "in", currentBatchRows).toArray(), String.format("%s,createtime desc", dimensionNumberOfOrg));
            return this.processReportQueryDataSetForDisplay(dataSet, this.dataQueryModelDTO);
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"FAFDataQueryReviewListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    public DataSet queryBatchBy(ReportQueryParam reportQueryParam) {
        try {
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            ORM orm = ORM.create();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String dimensionNumberOfAccount = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ACCOUNT).getString("number");
            QFilter[] queryFilter = this.dataQueryModelDTO.getQueryFilter();
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.dataquery.query.FAFDataQueryReviewListPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), "id", this.getDataSetQueryFilter(orm, queryFilter, dimensionNumberOfAccount), String.format("%s,createtime desc", dimensionNumberOfOrg));
            IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
            byBatchInfo.setCountPerBatch(300);
            byBatchInfo.setMaxRowCountCached(100000);
            return dataSet;
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"FAFDataQueryReviewListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    public DataSet queryAll(ReportQueryParam reportQueryParam, Object o) {
        try {
            this.dataQueryModelDTO = FAFDataQueryModelDTO.buildOf((ReportQueryParam)reportQueryParam);
            ORM orm = ORM.create();
            String dimensionNumberOfOrg = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG).getString("number");
            String dimensionNumberOfAccount = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ACCOUNT).getString("number");
            QFilter[] queryFilter = this.dataQueryModelDTO.getQueryFilter();
            String queryFieldsInfo = this.dataQueryModelDTO.getQueryFieldsInfo();
            DataSet dataSet = orm.queryDataSet("kd.macc.faf.dataquery.query.FAFDataQueryReviewListPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), queryFieldsInfo, this.getDataSetQueryFilter(orm, queryFilter, dimensionNumberOfAccount), String.format("%s,createtime desc", dimensionNumberOfOrg));
            return this.processReportQueryDataSetForDisplay(dataSet, this.dataQueryModelDTO);
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"FAFDataQueryReviewListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    private QFilter[] getDataSetQueryFilter(ORM orm, QFilter[] queryFilter, String dimensionNumberOfAccount) {
        QFilter[] filter;
        if (this.isShouldBeVersioned()) {
            Set<Long> masterIdsOfAccount = this.getMasterIdsOfAccountByDataSet(orm, queryFilter, dimensionNumberOfAccount);
            filter = this.getAccountVersionQueryFilter(queryFilter, masterIdsOfAccount);
        } else {
            filter = queryFilter;
        }
        return filter;
    }

    private Set<Long> getMasterIdsOfAccountByDataSet(ORM orm, QFilter[] queryFilter, String dimensionNumberOfAccount) {
        String accountMasterIdField = String.format("%s.masterid", dimensionNumberOfAccount);
        DataSet dataSet = orm.queryDataSet("kd.macc.faf.dataquery.query.FAFDataQueryReviewListPlugin", this.dataQueryModelDTO.getQueryTableEntityNumber(), String.format("id,%s", accountMasterIdField), queryFilter, null);
        HashSet<Long> masterIdsOfAccount = new HashSet<Long>();
        for (Row row : dataSet) {
            masterIdsOfAccount.add(row.getLong(accountMasterIdField));
        }
        return masterIdsOfAccount;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> allColumns) throws Throwable {
        try {
            if (DataQueryTypeEnum.DETAIL == this.dataQueryModelDTO.getDataQueryTypeEnum()) {
                allColumns.add(this.createTextColumn("field_review_source", ResManager.loadKDString((String)"\u8054\u67e5", (String)"FAFDataQueryReviewListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), true, false));
                allColumns.add(this.createTextColumn("sourceformid", "sourceformid", false, true));
                allColumns.add(this.createTextColumn("sourcebillid", "sourcebillid", false, true));
            }
            if (DataQueryTypeEnum.SUMMARY == this.dataQueryModelDTO.getDataQueryTypeEnum()) {
                allColumns.add(this.createTextColumn("field_review_detail", ResManager.loadKDString((String)"\u8054\u67e5", (String)"FAFDataQueryReviewListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), true, false));
            }
            allColumns.add(this.createTextColumn("id", "id", false, true));
            allColumns.addAll(this.createDimensionReportColumn());
            allColumns.addAll(this.createMeasureReportColumn());
            return super.getColumns(allColumns);
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5217\u6784\u5efa\u5931\u8d25\uff1a%s", (String)"FAFDataQueryReviewListPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), exception.getMessage())});
        }
    }

    private boolean isShouldBeVersioned() {
        DynamicObject accountDimension = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ACCOUNT);
        DynamicObject accountDy = accountDimension.getDynamicObject("dimensionsource");
        if (accountDy == null) {
            return false;
        }
        if (!"bd_accountview".equals(accountDy.getString("number"))) {
            return false;
        }
        FilterInfo filterInfo = this.dataQueryModelDTO.getQueryParam().getFilter();
        Map commFilterMap = filterInfo.getCommFilter();
        boolean flag = false;
        if (!CollectionUtils.isEmpty((Map)commFilterMap)) {
            QFilter commFilter = (QFilter)commFilterMap.get(AnalysisModelUtil.buildEntityNumber((String)this.dataQueryModelDTO.getTableNumber()));
            try {
                this.checkAccountItemInFilter(commFilter, accountDimension);
            }
            catch (StopRecursionException existAccountItem) {
                flag = true;
            }
        }
        return flag;
    }

    private void checkAccountItemInFilter(QFilter oldFilter, DynamicObject accountDimension) {
        if (oldFilter != null) {
            String property = oldFilter.getProperty();
            String accountDimensionNumber = accountDimension.getString("number");
            if (property.split("\\.")[0].equals(accountDimensionNumber)) {
                throw new StopRecursionException("exist account item");
            }
            List oldFilterNests = oldFilter.getNests(false);
            if (!CollectionUtils.isEmpty((Collection)oldFilterNests)) {
                for (QFilter.QFilterNest oldFilterNest : oldFilterNests) {
                    this.checkAccountItemInFilter(oldFilterNest.getFilter(), accountDimension);
                }
            }
        }
    }

    private QFilter[] getAccountVersionQueryFilter(QFilter[] queryFilter, Set<Long> masterIdsOfAccount) {
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>(queryFilter.length);
        DynamicObject accountDimensionOfModel = this.dataQueryModelDTO.getNecessaryDimensionOfModel(DimensionNecessityEnum.ACCOUNT);
        for (QFilter filter : queryFilter) {
            queryFilters.add(this.getAccountVersionedItemFilter(filter, accountDimensionOfModel, masterIdsOfAccount));
        }
        return CollectionUtils.isEmpty(queryFilters) ? null : queryFilters.toArray(new QFilter[0]);
    }

    private QFilter getAccountVersionedItemFilter(QFilter oldFilter, DynamicObject accountDimensionOfModel, Set<Long> masterIdsOfAccount) {
        QFilter newFilter = null;
        if (oldFilter != null) {
            String property = oldFilter.getProperty();
            String accountDimensionNumber = accountDimensionOfModel.getString("number");
            newFilter = property.split("\\.")[0].equals(accountDimensionNumber) ? new QFilter(String.format("%s.masterid", accountDimensionNumber), "in", masterIdsOfAccount) : new QFilter(oldFilter.getProperty(), oldFilter.getCP(), oldFilter.getValue());
            List oldFilterNests = oldFilter.getNests(false);
            if (!CollectionUtils.isEmpty((Collection)oldFilterNests)) {
                this.replaceAccountVersionFilter(newFilter, oldFilterNests, accountDimensionOfModel, masterIdsOfAccount);
            }
        }
        return newFilter;
    }

    private void replaceAccountVersionFilter(QFilter newFilter, List<QFilter.QFilterNest> oldFilterNests, DynamicObject accountDimension, Set<Long> masterIdsOfAccount) {
        String accountDimensionNumber = accountDimension.getString("number");
        for (QFilter.QFilterNest nest : oldFilterNests) {
            List filterNests;
            QFilter filter = nest.getFilter();
            QFilter tmpFilter = filter.getProperty().split("\\.")[0].equals(accountDimensionNumber) ? new QFilter(String.format("%s.masterid", accountDimensionNumber), "in", masterIdsOfAccount) : new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
            if (nest.isAnd()) {
                newFilter.and(tmpFilter);
            } else {
                newFilter.or(tmpFilter);
            }
            if (CollectionUtils.isEmpty((Collection)(filterNests = filter.getNests(false)))) continue;
            this.replaceAccountVersionFilter(tmpFilter, filterNests, accountDimension, masterIdsOfAccount);
        }
    }

    private DataSet processReportQueryDataSetForDisplay(DataSet dataSet, FAFDataQueryModelDTO dataQueryModelDTO) {
        DataQueryTypeEnum dataQueryTypeEnum = dataQueryModelDTO.getDataQueryTypeEnum();
        switch (dataQueryTypeEnum) {
            case DETAIL: {
                DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)dataQueryModelDTO.getAnaModelId(), (String)"pa_analysismodel");
                List calMeasureNumberList = anaModel.getDynamicObjectCollection("measure_entry").stream().filter(measureEntry -> MeasureTypeEnum.CALCULATION == MeasureTypeEnum.getEnum((String)measureEntry.getDynamicObject("measure").getString("measuretype"))).map(measureEntry -> measureEntry.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
                dataSet = dataSet.map((MapFunction)new FAFReportQuerySourceBillMapFunction(dataSet.getRowMeta()));
                dataSet = dataSet.map((MapFunction)new FAFReportQueryDetailCalMeasureMapFunction(dataSet.getRowMeta(), calMeasureNumberList));
                dataSet = dataSet.map((MapFunction)new FAFReportDateTimeFormatFunction(dataSet.getRowMeta()));
                break;
            }
            case SUMMARY: {
                dataSet = dataSet.map((MapFunction)new FAFReportQueryReviewDetailMapFunction(dataSet.getRowMeta()));
                dataSet = dataSet.map((MapFunction)new FAFReportDateTimeFormatFunction(dataSet.getRowMeta()));
            }
        }
        return dataSet;
    }

    private List<AbstractReportColumn> createDimensionReportColumn() {
        ArrayList<AbstractReportColumn> dimensionReportColumns = new ArrayList<AbstractReportColumn>(8);
        Map dimensionNumberFieldNumbersMap = this.dataQueryModelDTO.getDimensionNumberFieldNumbersMap();
        Map dimensionNumberFieldNamesMap = this.dataQueryModelDTO.getDimensionNumberFieldNamesMap();
        QFilter systemFilter = new QFilter("system", "=", (Object)this.dataQueryModelDTO.getAnaSystemId());
        QFilter numberFilter = new QFilter("number", "in", dimensionNumberFieldNumbersMap.keySet());
        Collection dimensionDys = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{systemFilter, numberFilter}).values();
        block5: for (Map.Entry dimensionEntry : dimensionNumberFieldNumbersMap.entrySet()) {
            String dimensionNumber = (String)dimensionEntry.getKey();
            DynamicObject dimension = dimensionDys.stream().filter(dy -> dimensionNumber.equals(dy.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u7ef4\u5ea6%s\u4e0d\u5b58\u5728", (String)"FAFDataQueryReviewListPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionNumber)));
            MainEntityType fieldEntityType = null;
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    String dimensionSourceNumber = dimension.getDynamicObject("dimensionsource").getString("number");
                    fieldEntityType = EntityMetadataCache.getDataEntityType((String)dimensionSourceNumber);
                }
                case ASSISTANTDATA: {
                    if (fieldEntityType == null) {
                        fieldEntityType = EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                    }
                    List dimensionFieldNumberList = (List)dimensionEntry.getValue();
                    for (String dimensionFieldNumber : dimensionFieldNumberList) {
                        if (!StringUtils.isNotBlank((CharSequence)dimensionFieldNumber)) continue;
                        String[] shortFieldNumbers = dimensionFieldNumber.split("\\.");
                        MainEntityType tmpEntityType = fieldEntityType;
                        for (int i = 0; i < shortFieldNumbers.length - 1; ++i) {
                            DynamicProperty property = fieldEntityType.getProperty(shortFieldNumbers[i]);
                            if (property instanceof BasedataProp) {
                                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                                tmpEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                                continue;
                            }
                            if (i == shortFieldNumbers.length - 1) continue;
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u521b\u5efa\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7ef4\u5ea6\u7684\u62a5\u8868\u5217\u5931\u8d25,\u7ef4\u5ea6\u4e3a{%1$s},\u7ef4\u5ea6\u5b57\u6bb5\u4e3a{%2$s}", (String)"FAFDataQueryReviewListPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionNumber, dimensionFieldNumber));
                        }
                        String dimensionReportNumber = String.format("%1$s.%2$s", dimension.getString("number"), dimensionFieldNumber);
                        String dimensionReportName = String.format("%1$s.%2$s", dimension.getString("name"), ((List)dimensionNumberFieldNamesMap.get(dimensionNumber)).get(dimensionFieldNumberList.indexOf(dimensionFieldNumber)));
                        DynamicProperty property = tmpEntityType.getProperty(shortFieldNumbers[shortFieldNumbers.length - 1]);
                        if (property instanceof ComboProp) {
                            List comboItems = ((ComboProp)property).getComboItems();
                            dimensionReportColumns.add(this.createComboColumn(dimensionReportNumber, dimensionReportName, comboItems));
                            continue;
                        }
                        if (property instanceof DateTimeProp) {
                            dimensionReportColumns.add(this.createTextColumn(dimensionReportNumber, dimensionReportName, false, false));
                            continue;
                        }
                        if (property instanceof DecimalProp) {
                            dimensionReportColumns.add(this.createDecimalColumn(dimensionReportNumber, dimensionReportName, false, 2));
                            continue;
                        }
                        dimensionReportColumns.add(this.createTextColumn(dimensionReportNumber, dimensionReportName, false, false));
                    }
                    continue block5;
                }
                case DENUMS: {
                    String dimensionReportNumberOfCombo = dimension.getString("number");
                    String dimensionReportNameOfCombo = dimension.getString("name");
                    List<ValueMapItem> comboItems = dimension.getDynamicObjectCollection("entryentityenums").stream().map(dy -> new ValueMapItem(null, dy.getString("value"), new LocaleString(dy.getString("title")))).collect(Collectors.toList());
                    dimensionReportColumns.add(this.createComboColumn(dimensionReportNumberOfCombo, dimensionReportNameOfCombo, comboItems));
                    break;
                }
                default: {
                    String dimensionReportNumberOfText = dimension.getString("number");
                    String dimensionReportNameOfText = dimension.getString("name");
                    dimensionReportColumns.add(this.createTextColumn(dimensionReportNumberOfText, dimensionReportNameOfText, false, false));
                }
            }
        }
        return dimensionReportColumns;
    }

    private List<AbstractReportColumn> createMeasureReportColumn() {
        ArrayList<AbstractReportColumn> measureReportColumns = new ArrayList<AbstractReportColumn>(8);
        List measureNumbers = this.dataQueryModelDTO.getMeasureNumbers();
        QFilter systemFilter = new QFilter("system", "=", (Object)this.dataQueryModelDTO.getAnaSystemId());
        QFilter numberFilter = new QFilter("number", "in", (Object)measureNumbers);
        Collection measureDys = BusinessDataServiceHelper.loadFromCache((String)"pa_measure", (QFilter[])new QFilter[]{systemFilter, numberFilter}).values();
        for (String measureNumber : measureNumbers) {
            boolean isCommonMeasure;
            DynamicObject measure = measureDys.stream().filter(dy -> measureNumber.equals(dy.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"[\u62a5\u8868\u67e5\u8be2\u5931\u8d25] : \u5ea6\u91cf%s\u4e0d\u5b58\u5728", (String)"FAFDataQueryReviewListPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]), measureNumber)));
            int scale = 2;
            boolean bl = isCommonMeasure = MeasureTypeEnum.ORDINARY == MeasureTypeEnum.getEnum((String)measure.getString("measuretype"));
            if (isCommonMeasure) {
                scale = measure.getInt("precision");
            } else if (measure.getDynamicObject("measure") != null) {
                scale = measure.getDynamicObject("measure").getInt("precision");
            }
            switch (this.dataQueryModelDTO.getDataQueryTypeEnum()) {
                case SUMMARY: {
                    measureReportColumns.add(this.createDecimalColumn(measure.getString("number"), measure.getString("name"), isCommonMeasure, scale));
                    break;
                }
                case DETAIL: {
                    if (isCommonMeasure) {
                        measureReportColumns.add(this.createDecimalColumn(measure.getString("number"), measure.getString("name"), false, scale));
                        break;
                    }
                    measureReportColumns.add(this.createTextColumn(measure.getString("number"), measure.getString("name"), false, false));
                }
            }
        }
        return measureReportColumns;
    }

    private AbstractReportColumn createTextColumn(String columnKey, String columnCaption, boolean isHyperlink, boolean isHide) {
        TextReportColumn textReportColumn = new TextReportColumn();
        textReportColumn.setFieldKey(columnKey);
        textReportColumn.setCaption(new LocaleString(columnCaption));
        textReportColumn.setFieldType("text");
        textReportColumn.setHyperlink(isHyperlink);
        textReportColumn.setHide(isHide);
        return textReportColumn;
    }

    private AbstractReportColumn createDecimalColumn(String columnKey, String columnCaption, boolean isHyperlink, int scale) {
        DecimalReportColumn decimalReportColumn = new DecimalReportColumn();
        decimalReportColumn.setFieldKey(columnKey);
        decimalReportColumn.setCaption(new LocaleString(columnCaption));
        decimalReportColumn.setFieldType("decimal");
        decimalReportColumn.setHyperlink(isHyperlink);
        decimalReportColumn.setScale(scale);
        decimalReportColumn.setNoDisplayScaleZero(false);
        decimalReportColumn.setZeroShow(true);
        decimalReportColumn.setNeedFormat(true);
        return decimalReportColumn;
    }

    private AbstractReportColumn createComboColumn(String columnKey, String columnCaption, List<ValueMapItem> comboItems) {
        ComboReportColumn comboReportColumn = new ComboReportColumn();
        comboReportColumn.setFieldKey(columnKey);
        comboReportColumn.setCaption(new LocaleString(columnCaption));
        comboReportColumn.setFieldType("combofield");
        if (!CollectionUtils.isEmpty(comboItems)) {
            comboReportColumn.setComboItems(comboItems);
        }
        return comboReportColumn;
    }
}

