/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.FilterGrid;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.FAFAbstactModelReport;
import kd.macc.faf.util.AnalysisModelUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FAFCustomReportFilter
extends ReportFilter {
    FAFAbstactModelReport reviewPlugin;
    JSONObject jsonObject;
    Function<DynamicObject, DynamicObject> function;
    private static final String[] args = new String[]{"org", "account", "period"};

    public FAFCustomReportFilter() {
    }

    public FAFCustomReportFilter(FAFAbstactModelReport reviewPlugin, ReportFilter reportFilter) {
        this(reviewPlugin, reportFilter, p -> p);
    }

    public FAFCustomReportFilter(FAFAbstactModelReport reviewPlugin, ReportFilter reportFilter, @NotNull Function<DynamicObject, DynamicObject> function) {
        this.reviewPlugin = reviewPlugin;
        this.setView(reportFilter.getView());
        this.setModel(reportFilter.getModel());
        this.getItems().addAll(reportFilter.getItems());
        this.setKey(reportFilter.getKey());
        this.function = function;
        this.setReportFilterFieldConfig(reportFilter.getReportFilterFieldConfig());
    }

    private void scheme2Json(FilterScheme filterScheme) {
        if (filterScheme == null) {
            return;
        }
        String schemeJson = filterScheme.getScheme();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String customFilters = (String)filterMap.get("custfilters");
        this.jsonObject = JSONObject.parseObject((String)customFilters);
    }

    public void loadScheme(String id) {
        IFilterModel filterModel = this.getFilterModel();
        FilterScheme filterScheme = filterModel.load(id);
        this.scheme2Json(filterScheme);
        super.loadScheme(id);
    }

    public void initDefaultQueryScheme() {
        if (this.reviewPlugin.isNotLoadDefaultScheme()) {
            return;
        }
        IFilterModel filterModel = this.getFilterModel();
        filterModel.setFormId(this.getView().getEntityId());
        List schemeList = filterModel.getSchemeList();
        FilterScheme filterScheme = schemeList.stream().filter(FilterScheme::isDefault).findFirst().orElse(null);
        this.scheme2Json(filterScheme);
        super.initDefaultQueryScheme();
    }

    public IFilterModel getFilterModel() {
        return (IFilterModel)TypesContainer.createInstance((String)"kd.bos.filter.FilterModel");
    }

    private String getTypeFromScheme(String key) {
        JSONArray jsonArray;
        if (this.jsonObject == null) {
            return null;
        }
        Object o = this.jsonObject.get((Object)key);
        JSONObject jsonObjectA = null;
        if (o instanceof JSONObject) {
            jsonObjectA = (JSONObject)o;
        } else if (o instanceof JSONArray && !CollectionUtils.isEmpty((Collection)(jsonArray = (JSONArray)o))) {
            jsonObjectA = jsonArray.getJSONObject(0).getJSONObject("fbasedataid");
        }
        if (jsonObjectA != null) {
            return jsonObjectA.getString("_Type_");
        }
        return null;
    }

    public void loadQuerySchemeData(DynamicObject scheme, FilterInfo filterInfo) {
        DynamicObject model = scheme.getDynamicObject(this.reviewPlugin.getMODEL());
        if ((model = this.function.apply(model)) != null) {
            this.reviewPlugin.getFilter(model.getLong("id"), null);
            FilterGrid filterGridAp = (FilterGrid)this.view.getControl("filtergridap");
            filterGridAp.setEntityNumber(this.reviewPlugin.getView().getModel().getDataEntityType().getName());
            filterGridAp.SetValue(new FilterCondition());
            filterGridAp.setFilterColumns(Collections.EMPTY_LIST);
            this.getView().updateView("filtergridap");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            String typeFromScheme = this.getTypeFromScheme(arg);
            if (typeFromScheme == null) continue;
            map.put(arg, typeFromScheme);
        }
        this.reviewPlugin.registDynamicProps(this.reviewPlugin.getView().getModel().getDataEntityType());
        this.reviewPlugin.registDynamicProps((MainEntityType)scheme.getDataEntityType(), map);
        this.cleanSchemeDataValue(scheme);
        super.loadQuerySchemeData(scheme, filterInfo);
    }

    private void cleanSchemeDataValue(DynamicObject scheme) {
        IReportView view = this.reviewPlugin.getView();
        String filterEntity = view.getPageCache().get("filterEntity");
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)filterEntity);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String schemeEntityName = "";
            MainEntityType mainEntityType = (MainEntityType)scheme.getDataEntityType();
            DynamicProperty property = mainEntityType.getProperty(key);
            if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                schemeEntityName = mulBasedataProp.getBaseEntityId();
            } else if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                schemeEntityName = basedataProp.getBaseEntityId();
            }
            if (((String)entry.getValue()).equals(schemeEntityName)) continue;
            scheme.set(key, null);
        }
    }

    public void search() {
        DynamicObject analysisModelObj = (DynamicObject)this.reviewPlugin.getView().getModel().getValue(this.reviewPlugin.getMODEL());
        if (!this.verify(this.function.apply(analysisModelObj))) {
            return;
        }
        try {
            super.search();
        }
        catch (KDException kdException) {
            if (kdException.getMessage() != null && kdException.getMessage().contains(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"FAFCustomReportFilter_0", (String)"macc-faf-formplugin", (Object[])new Object[0]))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u5df2\u53d8\u66f4\u6216\u8005\u9875\u9762\u7f13\u5b58\u5931\u6548\uff0c\u8bf7\u5207\u6362\u6a21\u578b\u540e\u91cd\u65b0\u9009\u62e9\u6216\u8005\u8bf7\u5237\u65b0\u9875\u9762\u6216\u8005\u70b9\u51fb\u91cd\u7f6e\u6309\u94ae", (String)"FAFCustomReportFilter_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            throw kdException;
        }
    }

    private boolean verify(DynamicObject analysisModelObj) {
        String tableNumber;
        if (!(analysisModelObj == null || StringUtils.isNotEmpty((CharSequence)(tableNumber = (analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelObj.getLong("id"), (String)"pa_analysismodel")).getString("tablenumber"))) && MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber)))) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"FAFCustomReportFilter_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void reset(Map<String, Object> map) {
        if ("".equals(map.get("schemeId"))) {
            FilterGrid filterGrid = (FilterGrid)this.reviewPlugin.getView().getControl("filtergridap");
            filterGrid.setEntityNumber(this.reviewPlugin.getView().getModel().getDataEntityType().getName());
        }
        super.reset(map);
    }
}

