/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.macc.faf.FAFDataAdjustFormPlugin;
import kd.macc.faf.FAFReportDynFieldClass;
import kd.macc.faf.datareview.FAFDataReviewPlugin;
import kd.macc.faf.datareview.ProcessViewReportFormPlugin;
import kd.macc.faf.dto.SourceToModelTableMappingDTO;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.util.LicenseUtil;

public class FAFDataReview2Plugin
extends FAFDataReviewPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FAFDataReview2Plugin.class);
    private static final Set<String> hideSet = new HashSet<String>();

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            this.buildPeriod(DimensionTypeEnum.PERIOD);
            this.init();
            super.afterCreateNewData(e);
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.error("FAFDataReview2Plugin afterCreateNewData error", (Throwable)ex);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        IReportView view = this.getView();
        ReportList reportList = (ReportList)view.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            this.buildCommonFilter();
            if (this.getView().getFormShowParameter().getCustomParams().containsKey("FROM_HyperLink")) {
                ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
                reportFilter.search();
            }
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            logger.error("FAFDataReview2Plugin afterBindData error", (Throwable)ex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("exportexcel".equals(keyName) && !this.checkModelTable()) {
            args.setCancel(true);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        Tuple2<String, String> sysNameAndModelName = this.getSysNameAndModelName();
        Long analysisModelId = this.getModelPkValue();
        List<Long> ids = rowData.stream().filter(p -> "0".equals(p.getString("collectstatus")) && "0".equals(p.getString("datastatus"))).map(p -> p.getLong("id")).collect(Collectors.toList());
        Map<Object, Object> idMapSourceNumber = Collections.emptyMap();
        if (!ids.isEmpty()) {
            List sourceToModelTableMappingDTOS = FAFTableDataHelper.transformQuerySourceModelTable((Long)analysisModelId, (boolean)false, (Long[])ids.toArray(new Long[0]));
            idMapSourceNumber = sourceToModelTableMappingDTOS.stream().collect(Collectors.toMap(SourceToModelTableMappingDTO::getModelTableId, SourceToModelTableMappingDTO::getSourceNumber));
        }
        Map finalIdMapSourceNumber = idMapSourceNumber;
        rowData.forEach(p -> {
            if ("1".equals(p.getString("collectstatus"))) {
                p.set("report_analysis", sysNameAndModelName.t1);
                p.set("report_analysis_model", sysNameAndModelName.t2);
                p.set("datastatus", (Object)"");
            } else {
                p.set("report_period_name", null);
                p.set("report_org_name", null);
                p.set("report_account_name", null);
                p.set("report_period_number", null);
                p.set("report_org_number", null);
                p.set("report_account_number", null);
                String sourceDataNumber = (String)finalIdMapSourceNumber.get(p.getLong("id"));
                if (hideSet.contains(sourceDataNumber) || (StringUtils.isEmpty((CharSequence)sourceDataNumber) || "0".equals(sourceDataNumber)) && "0".equals(p.get("datastatus"))) {
                    p.set("datastatus", (Object)"");
                }
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        String collectStatus = rowData.getString("collectstatus");
        if ("datastatus".equals(fieldName) && "0".equals(collectStatus)) {
            IDataModel model = this.getModel();
            Tuple2<String, String> sysNameAndModelName = this.getSysNameAndModelName();
            Long id = rowData.getLong("id");
            Long analysisModelId = this.getModelPkValue();
            String dataStatus = rowData.getString("datastatus");
            HashSet<String> adSet = new HashSet<String>(Arrays.asList("3", "-3"));
            if ("0".equals(dataStatus)) {
                SourceToModelTableMappingDTO sourceToModelTableMappingDTO = FAFTableDataHelper.queryOneSourceToModelTableMapping((Long)analysisModelId, (Long)id);
                Long entityPrimaryKey = sourceToModelTableMappingDTO.getEntityPrimaryKey();
                if (StringUtils.isNotEmpty((CharSequence)sourceToModelTableMappingDTO.getSourceNumber()) && entityPrimaryKey != null && !entityPrimaryKey.equals(0L)) {
                    BillShowParameter formShowParameter = new BillShowParameter();
                    formShowParameter.setPkId((Object)sourceToModelTableMappingDTO.getEntityPrimaryKey());
                    formShowParameter.setFormId(sourceToModelTableMappingDTO.getSourceNumber());
                    formShowParameter.setStatus(OperationStatus.VIEW);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)formShowParameter);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"FAFDataReview2Plugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            } else if (adSet.contains(dataStatus)) {
                FAFDataAdjustFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id);
            } else {
                boolean showNumber = (Boolean)model.getValue("shownumber");
                ProcessViewReportFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id, (String)sysNameAndModelName.t1, (String)sysNameAndModelName.t2, showNumber);
            }
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("showdata");
        FilterItemInfo showNumber = queryParam.getFilter().getFilterItem("shownumber");
        Object value = filterItem.getValue();
        Object showNumberValue = showNumber.getValue();
        boolean returnValue = super.verifyQuery(queryParam);
        queryParam.getFilter().addFilterItem("showdata", value);
        queryParam.getFilter().addFilterItem("shownumber", showNumberValue);
        if (returnValue) {
            this.updateSystemModelCache();
        }
        return returnValue;
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("report_collectstatus");
    }

    public Tuple2<String, String> getSysNameAndModelName() {
        String sysName = this.getPageCache().get("cache_system_name");
        String analysisModelName = this.getPageCache().get("cache_model_name");
        return new Tuple2((Object)sysName, (Object)analysisModelName);
    }

    public static void openF7(AbstractFormPlugin that, String title, Object systemId, Object analysisModelId, Collection<Long> orgIds, Object periodId) {
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId("pa_data_review2");
        rsp.setCustomParam("analysis_system", systemId);
        rsp.setCustomParam("analysis_model", analysisModelId);
        rsp.setCustomParam("period", periodId);
        rsp.setCustomParam("FROM_F7", (Object)1);
        rsp.setCustomParam("org", orgIds);
        rsp.setCustomParam("showNumber", (Object)false);
        rsp.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2", (String)"FAFDataReview2Plugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        if (title != null) {
            rsp.setCaption(title);
        }
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        that.getView().showForm((FormShowParameter)rsp);
    }

    public static void openF7FromHyperlink(AbstractFormPlugin that, Object systemId, Object analysisModelId, Object period, Collection<Object> orgIds, Object account, String originFilterJson, Map<String, Tuple<DimensionTypeEnum, List<Object>>> filterGridColumn) {
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId("pa_data_review2");
        rsp.setCustomParam("analysis_system", systemId);
        rsp.setCustomParam("analysis_model", analysisModelId);
        rsp.setCustomParam("period", period);
        rsp.setCustomParam("FROM_HyperLink", (Object)1);
        rsp.setCustomParam("org", orgIds);
        rsp.setCustomParam("showNumber", (Object)false);
        if (account != null) {
            rsp.setCustomParam("account", account);
        }
        rsp.setCustomParam("originFilterJson", (Object)originFilterJson);
        rsp.setCustomParam("filterGridColumn", (Object)JSON.toJSONString(filterGridColumn));
        rsp.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2", (String)"FAFDataReview2Plugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        that.getView().showForm((FormShowParameter)rsp);
    }

    public void init() {
        Object account;
        OrgHelper.PermOrgResult permOrgResult;
        Object orgIds;
        String currentDimensionType;
        DimensionTypeEnum code;
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        ReportShowParameter rsp = (ReportShowParameter)view.getFormShowParameter();
        Object systemId = rsp.getCustomParam("analysis_system");
        Object analysisModelId = rsp.getCustomParam("analysis_model");
        if (rsp.getCustomParams().containsKey("FROM_F7")) {
            this.setNotLoadDefaultScheme(true);
            this.setAutoSearch(true);
        } else if (rsp.getCustomParams().containsKey("FROM_HyperLink")) {
            this.setNotLoadDefaultScheme(true);
            this.setAutoSearch(false);
        }
        Object showNumber = rsp.getCustomParam("showNumber");
        if (showNumber instanceof Boolean && ((Boolean)showNumber).booleanValue()) {
            model.setValue("shownumber", (Object)true);
        }
        if (systemId != null) {
            model.setValue("analysis_system", systemId);
        }
        if (analysisModelId != null) {
            model.endInit();
            model.setValue("analysis_model", analysisModelId);
            model.beginInit();
        }
        FAFReportDynFieldClass.AbstractPeriod<?> abstractPeriod = null;
        Object periodId = rsp.getCustomParam("period");
        if (periodId != null && ((code = DimensionTypeEnum.getCode((String)(currentDimensionType = this.getPageCache().get("CurrentDimensionTypeCache")))) == DimensionTypeEnum.DATABASE || DimensionTypeEnum.PERIOD == code || code == DimensionTypeEnum.DATE || code == DimensionTypeEnum.ASSISTANTDATA)) {
            abstractPeriod = this.buildPeriod(code);
            abstractPeriod.setValue(periodId);
        }
        if (systemId == null || analysisModelId == null || abstractPeriod == null || !abstractPeriod.isMustInput() || abstractPeriod.getValue() == null) {
            this.setAutoSearch(false);
        }
        if ((orgIds = rsp.getCustomParam("org")) instanceof JSONArray && !(permOrgResult = OrgHelper.getPermOrgSet((String)model.getDataEntityType().getName(), (String)view.getFormShowParameter().getAppId())).hasAllOrgPerm()) {
            Set permOrgSet = permOrgResult.getPermOrgs();
            HashSet originOrgSet = new HashSet((JSONArray)orgIds);
            Iterator originOrgIterator = originOrgSet.iterator();
            while (originOrgIterator.hasNext()) {
                Object next = originOrgIterator.next();
                Long currentOrgId = Long.parseLong(String.valueOf(next));
                if (permOrgSet.contains(currentOrgId)) continue;
                originOrgIterator.remove();
            }
            model.setValue("org", (Object)originOrgSet.toArray(new Object[0]));
        }
        if ((account = rsp.getCustomParam("account")) instanceof JSONArray) {
            model.setValue("account", (Object)((JSONArray)account).toArray(new Object[0]));
        }
    }

    private void buildCommonFilter() {
        try {
            String filterGridColumnJson;
            Map filterGridColumn;
            FilterCondition originFilterCondition;
            List originFilterRow;
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            List filterRow = filterCondition.getFilterRow();
            filterRow.clear();
            String originFilterJson = (String)this.getView().getFormShowParameter().getCustomParam("originFilterJson");
            if (StringUtils.isNotEmpty((CharSequence)originFilterJson) && (originFilterRow = (originFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)originFilterJson, FilterCondition.class)).getFilterRow()) != null && !originFilterRow.isEmpty()) {
                for (SimpleFilterRow simpleFilterRow : originFilterRow) {
                    SimpleFilterRow newCopyValueFilter = new SimpleFilterRow();
                    List filterValueList = simpleFilterRow.getValue();
                    if (filterValueList != null && !filterValueList.isEmpty()) {
                        for (FilterValue filterValue : filterValueList) {
                            filterValue.setId(null);
                        }
                        newCopyValueFilter.setValue(filterValueList);
                    }
                    newCopyValueFilter.setLogic(simpleFilterRow.getLogic());
                    newCopyValueFilter.setFieldName(simpleFilterRow.getFieldName());
                    newCopyValueFilter.setCompareType(simpleFilterRow.getCompareType());
                    newCopyValueFilter.setCompareTypeDesc(simpleFilterRow.getCompareTypeDesc());
                    newCopyValueFilter.setEntityNumber(simpleFilterRow.getEntityNumber());
                    newCopyValueFilter.setLeftBracket(simpleFilterRow.getLeftBracket());
                    newCopyValueFilter.setRightBracket(simpleFilterRow.getRightBracket());
                    filterRow.add(newCopyValueFilter);
                }
            }
            if ((filterGridColumn = (Map)JSON.parseObject((String)(filterGridColumnJson = (String)this.getView().getFormShowParameter().getCustomParam("filterGridColumn")), (TypeReference)new TypeReference<Map<String, Tuple<DimensionTypeEnum, List<Object>>>>(){}, (Feature[])new Feature[0])) != null && !filterGridColumn.isEmpty()) {
                for (Map.Entry entry : filterGridColumn.entrySet()) {
                    String key = (String)entry.getKey();
                    Tuple typeAndMember = (Tuple)entry.getValue();
                    List dimensionValueList = (List)typeAndMember.item2;
                    if (dimensionValueList == null || dimensionValueList.isEmpty()) continue;
                    SimpleFilterRow simpleFilterRow = new SimpleFilterRow();
                    simpleFilterRow.setLogic("0");
                    switch ((DimensionTypeEnum)typeAndMember.item1) {
                        case DATABASE: 
                        case ASSISTANTDATA: {
                            simpleFilterRow.setFieldName(key + ".number");
                            break;
                        }
                        default: {
                            simpleFilterRow.setFieldName(key);
                        }
                    }
                    if (dimensionValueList.size() > 1) {
                        simpleFilterRow.setCompareType(DimensionTypeEnum.DENUMS == typeAndMember.item1 ? CompareTypeEnum.CHECKBOXIN.getId() : CompareTypeEnum.IN.getId());
                        ArrayList<FilterValue> valueList = new ArrayList<FilterValue>(dimensionValueList.size());
                        for (Object obj : dimensionValueList) {
                            FilterValue filterValue = new FilterValue();
                            filterValue.setValue(obj);
                            valueList.add(filterValue);
                        }
                        simpleFilterRow.setValue(valueList);
                    } else {
                        simpleFilterRow.setCompareType(DimensionTypeEnum.DENUMS == typeAndMember.item1 ? CompareTypeEnum.CHECKBOXEQUAL.getId() : CompareTypeEnum.EQUAL.getId());
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue(dimensionValueList.get(0));
                        ArrayList<FilterValue> valueList = new ArrayList<FilterValue>(1);
                        valueList.add(filterValue);
                        simpleFilterRow.setValue(valueList);
                    }
                    filterRow.add(simpleFilterRow);
                }
            }
            filterGrid.SetValue(filterCondition);
        }
        catch (Exception ex) {
            logger.error("FAFDataReview2Plugin build common filter error", (Throwable)ex);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }

    private DynamicObject getFmodel() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue("analysis_model");
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"FAFIndexEdit_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private DynamicObject getFsystem() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue("analysis_system");
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFIndexEdit_7", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private void updateSystemModelCache() {
        DynamicObject fmodel;
        DynamicObject fsystem = this.getFsystem();
        if (fsystem != null) {
            this.getPageCache().put("cache_system_pk", String.valueOf(fsystem.getPkValue()));
            this.getPageCache().put("cache_system_name", fsystem.getString("name"));
        }
        if ((fmodel = this.getFmodel()) != null) {
            this.getPageCache().put("cache_model_pk", String.valueOf(fmodel.getPkValue()));
            this.getPageCache().put("cache_model_name", fmodel.getString("name"));
        }
    }

    private Long getSystemPkValue() {
        try {
            return Long.valueOf(this.getPageCache().get("cache_system_pk"));
        }
        catch (Exception ex) {
            throw new KDBizException("cache system is null.");
        }
    }

    private Long getModelPkValue() {
        try {
            return Long.valueOf(this.getPageCache().get("cache_model_pk"));
        }
        catch (Exception ex) {
            throw new KDBizException("cache model is null.");
        }
    }

    static {
        hideSet.add("gl_balance");
        hideSet.add("bcm");
        hideSet.add("epm");
    }
}

