/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datareview.FAFListColumns;
import kd.macc.faf.datareview.FAFReportAnalysisModel;
import kd.macc.faf.util.FormatUtils;
import kd.macc.faf.util.IDataDateUtil;

public class FAFDataReviewList2Plugin
extends FAFListColumns {
    private static final Log logger = LogFactory.getLog(FAFDataReviewList2Plugin.class);
    private final int HZ_LIMIT = 10000;
    private final int MX_LIMIT = 200000;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.transformQuery(reportQueryParam);
    }

    private DataSet transformQuery(ReportQueryParam reportQueryParam) {
        Object row;
        int showFieldLength;
        int originFieldLength;
        FilterInfo filter = reportQueryParam.getFilter();
        List paramFilters = filter.getQFilters();
        FilterItemInfo filterItem = filter.getFilterItem("showdata");
        FilterItemInfo showNumber = filter.getFilterItem("shownumber");
        String showData = filterItem != null ? filterItem.getString() : null;
        boolean needNumber = showNumber == null || showNumber.getBoolean();
        DynamicObject modelDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(reportQueryParam.getSortInfo()), (String)"pa_analysismodel");
        this.fAFReportAnalysisModel = new FAFReportAnalysisModel(modelDynamicObject, needNumber);
        String detailTableNumber = this.fAFReportAnalysisModel.getTableNumber();
        String summaryTableNumber = this.fAFReportAnalysisModel.getSummaryTableNumber();
        String selectFields = this.fAFReportAnalysisModel.getSelectFields2String();
        ArrayList<Long> summaryIdList = new ArrayList<Long>(16);
        Map<String, FAFReportAnalysisModel.Measure> measureMap = this.fAFReportAnalysisModel.getMeasureList().stream().collect(Collectors.toMap(p -> p.number, p -> p));
        HashSet<Tuple> ordinaryMeasureIndex = new HashSet<Tuple>(measureMap.size());
        HashSet<Tuple> allMeasureIndex = new HashSet<Tuple>(measureMap.size());
        ArrayList<Object[]> summaryDataList = new ArrayList<Object[]>(16);
        this.checkCount(summaryTableNumber, paramFilters.toArray(new QFilter[0]), 10000);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"padatareviewlist2plugin", (String)summaryTableNumber, (String)selectFields, (QFilter[])paramFilters.toArray(new QFilter[0]), null);){
            Field[] originFields = dataSet.getRowMeta().getFields();
            originFieldLength = originFields.length;
            showFieldLength = originFieldLength + 4;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                summaryIdList.add(row.getLong("id"));
                Integer collectStatus = row.getInteger("collectstatus");
                Object[] currentSummaryData = new Object[showFieldLength];
                for (int i = 0; i < originFieldLength; ++i) {
                    String fieldColumn = originFields[i].getName();
                    if (measureMap.containsKey(fieldColumn)) {
                        currentSummaryData[i] = row.getBigDecimal(fieldColumn);
                        if ("1".equals(measureMap.get((Object)fieldColumn).measuretype)) {
                            ordinaryMeasureIndex.add(new Tuple((Object)i, (Object)measureMap.get(fieldColumn).getPrecision()));
                        } else if ("2".equals(measureMap.get((Object)fieldColumn).measuretype) && (0 == collectStatus || "2".equals(showData))) {
                            currentSummaryData[i] = "-";
                        }
                        allMeasureIndex.add(new Tuple((Object)i, (Object)measureMap.get(fieldColumn).getPrecision()));
                        continue;
                    }
                    currentSummaryData[i] = originFields[i].getDataType() instanceof DateType || originFields[i].getDataType() instanceof TimestampType ? IDataDateUtil.dateToString((Date)row.getDate(fieldColumn), (String)"yyyy-MM-dd HH:mm:ss") : row.get(fieldColumn);
                }
                currentSummaryData[originFieldLength] = ResManager.loadKDString((String)"\u6c47\u603b", (String)"FAFDataReviewList2Plugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                summaryDataList.add(currentSummaryData);
            }
            if (summaryIdList.isEmpty()) {
                logger.info("FAFDataReviewList2Plugin no summary data");
                row = Algo.create((String)"PADataReviewList2Plugin").createDataSetBuilder(new RowMeta(new Field[0])).build();
                return row;
            }
        }
        HashMap<Long, List> summaryIdMappingDetailData = new HashMap<Long, List>(16);
        QFilter detailFilter = new QFilter("summaryid", "in", summaryIdList);
        if ("2".equals(showData)) {
            detailFilter.and(new QFilter("datastatus", "=", (Object)0));
        }
        this.checkCount(detailTableNumber, detailFilter.toArray(), 200000);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"padatareviewlist2plugin", (String)detailTableNumber, (String)(selectFields + ",summaryid"), (QFilter[])detailFilter.toArray(), null);
        row = null;
        try {
            Field[] fields = dataSet.getRowMeta().getFields();
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                Integer collectStatus = row2.getInteger("collectstatus");
                Object[] currentDetailData = new Object[showFieldLength];
                for (int i = 0; i < originFieldLength; ++i) {
                    String name = fields[i].getName();
                    if (measureMap.containsKey(name)) {
                        BigDecimal number = row2.getBigDecimal(name);
                        if (number == null) {
                            number = BigDecimal.ZERO;
                        }
                        currentDetailData[i] = "2".equals(measureMap.get((Object)name).measuretype) && (0 == collectStatus || "2".equals(showData)) ? "-" : number.setScale(measureMap.get(name).getPrecision(), 4);
                        continue;
                    }
                    currentDetailData[i] = fields[i].getDataType() instanceof DateType || fields[i].getDataType() instanceof TimestampType ? IDataDateUtil.dateToString((Date)row2.getDate(name), (String)"yyyy-MM-dd HH:mm:ss") : row2.get(name);
                }
                currentDetailData[originFieldLength] = ResManager.loadKDString((String)"\u660e\u7ec6", (String)"FAFDataReviewList2Plugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                Long summaryId = row2.getLong("summaryid");
                summaryIdMappingDetailData.computeIfAbsent(summaryId, p -> new ArrayList(1)).add(currentDetailData);
            }
        }
        catch (Throwable fields) {
            row = fields;
            throw fields;
        }
        finally {
            if (dataSet != null) {
                if (row != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable fields) {
                        ((Throwable)row).addSuppressed(fields);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Iterator summaryDataIterator = summaryDataList.iterator();
        while (summaryDataIterator.hasNext()) {
            Object summaryId;
            Object[] next = (Object[])summaryDataIterator.next();
            if (next.length <= 0 || !(next[0] instanceof Long) || summaryIdMappingDetailData.containsKey(summaryId = Long.valueOf(Long.parseLong(String.valueOf(next[0]))))) continue;
            summaryDataIterator.remove();
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(summaryDataList.size() + summaryIdMappingDetailData.size());
        for (Object[] summaryData : summaryDataList) {
            for (Tuple tuple : allMeasureIndex) {
                Object object = summaryData[(Integer)tuple.item1];
                if (!(object instanceof BigDecimal)) continue;
                summaryData[((Integer)tuple.item1).intValue()] = FormatUtils.formatNumber((int)((Integer)tuple.item2), (BigDecimal)((BigDecimal)object));
            }
            resultList.add(summaryData);
            Long summaryId = Long.parseLong(String.valueOf(summaryData[0]));
            List summaryDetailData = (List)summaryIdMappingDetailData.get(summaryId);
            this.setObjects2Tree(summaryData, "0", String.valueOf(summaryId), summaryDetailData != null);
            if (summaryDetailData == null) continue;
            if ("2".equals(showData)) {
                for (Tuple tuple : ordinaryMeasureIndex) {
                    Optional<BigDecimal> reduce = summaryDetailData.stream().map(p -> p[(Integer)tuple.item1]).map(p -> p == null ? (p = new BigDecimal(0)) : p).map(p -> (BigDecimal)p).reduce(BigDecimal::add);
                    reduce.ifPresent(bigDecimal -> {
                        summaryData[((Integer)tuple.item1).intValue()] = bigDecimal;
                    });
                }
            }
            for (Object[] mxValue : summaryDetailData) {
                this.setObjects2Tree(mxValue, String.valueOf(summaryId), String.valueOf(mxValue[0]), false);
                for (Tuple tuple : ordinaryMeasureIndex) {
                    Object object = mxValue[(Integer)tuple.item1];
                    if (!(object instanceof BigDecimal)) continue;
                    mxValue[((Integer)tuple.item1).intValue()] = FormatUtils.formatNumber((int)((Integer)tuple.item2), (BigDecimal)((BigDecimal)object));
                }
            }
            resultList.addAll(summaryDetailData);
        }
        List<Field> fieldList = this.fAFReportAnalysisModel.getColumnNumbers().stream().map(p -> new Field(p.getNumber(), (DataType)DataType.StringType)).collect(Collectors.toList());
        Field[] resultFields = new Field[showFieldLength];
        System.arraycopy(fieldList.toArray(new Field[0]), 0, resultFields, 0, originFieldLength);
        for (Tuple tuple : allMeasureIndex) {
            resultFields[(Integer)tuple.item1].setDataType((DataType)DataType.StringType);
        }
        resultFields[originFieldLength] = new Field("report_collectstatus", (DataType)DataType.StringType);
        resultFields[originFieldLength + 1] = new Field("pid", (DataType)DataType.StringType);
        resultFields[originFieldLength + 2] = new Field("rowid", (DataType)DataType.StringType);
        resultFields[originFieldLength + 3] = new Field("isgroupnode", (DataType)DataType.BooleanType);
        return Algo.create((String)"PADataReviewList2Plugin").createDataSet(resultList.iterator(), new RowMeta(resultFields));
    }

    private void setObjects2Tree(Object[] objects, String pid, String rowId, boolean isGroupNode) {
        int length = objects.length;
        objects[length - 1] = isGroupNode;
        objects[length - 2] = rowId;
        objects[length - 3] = pid;
    }

    private void checkCount(String tableNumber, QFilter[] paramFilters, int limitCount) {
        ORM orm = ORM.create();
        int count = orm.count("faf.padatareviewlist2plugin", tableNumber, paramFilters);
        if (count > limitCount) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4", (String)"FAFDataReviewList2Plugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }
}

