/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.FAFAbstactModelReport;
import kd.macc.faf.FAFReportDynFieldClass;
import kd.macc.faf.datareview.FAFCustomReportFilter;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.DateUtil;
import kd.macc.faf.util.DimensionDyUtil;
import org.apache.commons.lang3.StringUtils;

public class FAFDataReviewPlugin
extends FAFAbstactModelReport {
    protected static final String PERIOD = "period";
    protected static final String DATERANGE = "daterange";
    protected static final String ACCOUNT = "account";
    protected static final String ORG = "org";
    private boolean autoSearch = false;

    public FAFDataReviewPlugin() {
        super("analysis_model", ORG, ACCOUNT, PERIOD, DATERANGE);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isAutoSearch()) {
            ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
            reportFilter.search();
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        String zz;
        FilterGrid.FilterGridState filterGridState;
        FilterCondition fc;
        List filterRow;
        FilterGrid filterGrid;
        DynamicObjectCollection accountCol;
        FAFReportDynFieldClass.AbstractPeriod<?> abstractPeriod;
        Object value;
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        Long analysisSystemId = (Long)model.getValue("analysis_system_id");
        DynamicObject analysisModelObj = (DynamicObject)model.getValue("analysis_model");
        ArrayList<String> nullFilter = new ArrayList<String>(3);
        if (analysisSystemId == null || analysisSystemId == 0L) {
            nullFilter.add(ResManager.loadKDString((String)"\"\u5206\u6790\u4f53\u7cfb\"", (String)"FAFDataReviewPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if (analysisModelObj == null) {
            nullFilter.add(ResManager.loadKDString((String)"\"\u5206\u6790\u6a21\u578b\"", (String)"FAFDataReviewPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if ((value = (abstractPeriod = this.getCurrentDimensionType()).getValue()) == null && abstractPeriod.isMustInput()) {
            nullFilter.add("\"" + abstractPeriod.getControlName() + "\"");
        }
        if (!CollectionUtils.isEmpty(nullFilter)) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"FAFDataReviewPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), StringUtils.join(nullFilter, (String)"\u3001"));
            view.showTipNotification(msg);
            return false;
        }
        if (!super.verifyQuery(queryParam)) {
            return false;
        }
        if (analysisSystemId == null || analysisSystemId == 0L || analysisModelObj == null || value == null && abstractPeriod.isMustInput()) {
            return false;
        }
        queryParam.setSortInfo(analysisModelObj.get("id").toString());
        String periodNumber = analysisModelObj.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.PERIOD.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getString("number")).findFirst().orElse(null);
        filterList.add(abstractPeriod.getQFilter(periodNumber));
        DynamicObjectCollection orgCol = (DynamicObjectCollection)model.getValue(ORG);
        String orgNumber = analysisModelObj.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.ORG.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getString("number")).findFirst().orElse(null);
        OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)this.getModel().getDataEntityType().getName(), (String)this.getView().getFormShowParameter().getAppId());
        if (!permOrgResult.hasAllOrgPerm()) {
            filterList.add(new QFilter(orgNumber, "in", (Object)permOrgResult.getPermOrgs()));
        }
        if (!orgCol.isEmpty()) {
            HashSet orgIdSet = new HashSet(orgCol.size());
            orgCol.forEach(obj -> orgIdSet.add((Long)((DynamicObject)obj.get(1)).get("id")));
            filterList.add(new QFilter(orgNumber, "in", orgIdSet));
        }
        if (!(accountCol = (DynamicObjectCollection)model.getValue(ACCOUNT)).isEmpty()) {
            HashSet accountIdSet = new HashSet(accountCol.size());
            accountCol.forEach(obj -> accountIdSet.add((Long)((DynamicObject)obj.get(1)).get("id")));
            String accountNumber = analysisModelObj.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.ACCOUNT.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getString("number")).findFirst().orElse(null);
            filterList.add(new QFilter(accountNumber, "in", accountIdSet));
        }
        if ((filterGrid = (FilterGrid)this.getControl("filtergridap")) != null && (filterRow = (fc = (filterGridState = filterGrid.getFilterGridState()).getFilterCondition()).getFilterRow()) != null && !filterRow.isEmpty()) {
            String entityName = AnalysisModelUtil.buildEntityNumber((String)analysisModelObj.getString("tablenumber"));
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityName);
            FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, model);
            filterBuilder.buildFilter(false);
            FilterObject fo = filterBuilder.getFilterObject();
            fc.setFilter(fo.getFilter());
            filterList.add(filterBuilder.getQFilter());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.setQFilters(filterList);
        queryParam.setFilter(filterInfo);
        StringBuilder sb = new StringBuilder();
        sb.append(new LocaleString(ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb", (String)"FAFDataReviewPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(((DynamicObject)model.getValue("analysis_system")).getString("name")).append("\uff1b  ").append(new LocaleString(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b", (String)"FAFDataReviewPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(((DynamicObject)model.getValue("analysis_model")).getString("name")).append("\uff1b  ");
        if (abstractPeriod.getValue() != null) {
            sb.append(abstractPeriod.getControlName()).append("\uff1a").append(abstractPeriod.getQFilterShowMessage()).append("\uff1b  ");
        }
        if (StringUtils.isNotEmpty((CharSequence)(zz = ((DynamicObjectCollection)model.getValue(ORG)).stream().map(p -> (DynamicObject)p.get("fbasedataid")).map(p -> p.getString("name")).collect(Collectors.joining("\uff0c"))))) {
            sb.append(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"FAFDataReviewPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(zz).append("\uff1b  ");
        }
        if (StringUtils.isNotEmpty((CharSequence)(zz = ((DynamicObjectCollection)model.getValue(ACCOUNT)).stream().map(p -> (DynamicObject)p.get("fbasedataid")).map(p -> p.getString("name")).collect(Collectors.joining("\uff0c"))))) {
            sb.append(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"FAFDataReviewPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(zz).append("\uff1b  ");
        }
        String msg = sb.toString();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        view.getPageCache().put("searchCondition", msg);
        clientViewProxy.preInvokeControlMethod("reportfilterap", "updateSearchCondition", new Object[]{msg});
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "analysis_system": {
                this.getModel().setValue("analysis_model", null);
                break;
            }
            case "analysis_model": {
                Long modelPKId = this.getModelPkID();
                if (modelPKId == null) break;
                this.setAccountVisible(modelPKId);
                break;
            }
        }
    }

    @Override
    public ReportFilter getPaCustomReportFilter(ReportFilter control) {
        return new FAFCustomReportFilter(this, control, dynamicObject -> {
            if (dynamicObject != null) {
                this.setAccountVisible(dynamicObject.getLong("id"));
            }
            return dynamicObject;
        });
    }

    private void setAccountVisible(Long id) {
        if (id != null) {
            DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_analysismodel");
            DimensionTypeEnum dimensionTypeCodeFromNess = DimensionDyUtil.getDimensionTypeCodeFromNess((DynamicObject)dynamicObjects, (DimensionNecessityEnum)DimensionNecessityEnum.ACCOUNT);
            this.getView().setVisible(Boolean.valueOf(dimensionTypeCodeFromNess != null), new String[]{ACCOUNT});
        }
    }

    @Override
    public FAFReportDynFieldClass.IDefaultValueSet getIDefaultValueSet() {
        return new FAFReportDynFieldClass.IDefaultValueSet(){

            @Override
            public Object periodDefaultSet(String entity, QFilter[] f7Filters) {
                if ("bd_period".equals(entity) && f7Filters != null) {
                    Date date = new Date();
                    date = DateUtil.getDataFormat((Date)date, (boolean)true);
                    QFilter and = new QFilter("begindate", "<=", (Object)date).and(new QFilter("enddate", ">=", (Object)date)).and(new QFilter("isadjustperiod", "!=", (Object)"1"));
                    QFilter[] qFilters = new QFilter[f7Filters.length + 1];
                    System.arraycopy(f7Filters, 0, qFilters, 0, f7Filters.length);
                    qFilters[qFilters.length - 1] = and;
                    List objectList = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])qFilters, null, (int)1);
                    if (!CollectionUtils.isEmpty((Collection)objectList)) {
                        return objectList.get(0);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        IReportView view = this.getView();
        BasedataEdit analysisSystem = (BasedataEdit)view.getControl("analysis_system");
        analysisSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getView().getControl("analysis_model");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String fieldKey = evt.getProperty().getName();
        if ("analysis_model".equals(fieldKey)) {
            this.selectAnalysismodel(evt);
        }
    }

    @Override
    public Long getModelPkID() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("analysis_model");
        if (model == null) {
            return null;
        }
        return model.getLong("id");
    }

    @Override
    public Long getSystemId() {
        DynamicObject analysis_system = (DynamicObject)this.getModel().getValue("analysis_system");
        if (analysis_system == null) {
            return null;
        }
        return analysis_system.getLong("id");
    }

    @Override
    public void beforeSelectPeriodOrOrgOrAccount(String fieldKey, Map<String, QFilter[]> map, BeforeF7SelectEvent evt) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("analysis_model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"FAFDataReviewPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
            String name = basedataEdit.getKey();
            QFilter[] qFilters = map.get(name);
            if (qFilters != null) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                for (QFilter qFilter : qFilters) {
                    listFilterParameter.setFilter(qFilter);
                }
            }
        }
    }

    @Override
    protected String getModelTableNumber() {
        DynamicObject analysis_model = (DynamicObject)this.getModel().getValue("analysis_model");
        if (analysis_model == null) {
            return null;
        }
        return analysis_model.getString("tablenumber");
    }

    private void selectAnalysismodel(BeforeF7SelectEvent evt) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("analysis_system");
        if (model != null) {
            long id = model.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("analysis_system", "=", (Object)id).and(new QFilter("tablenumber", "!=", (Object)""));
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFDataReviewPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void setAutoSearch(boolean autoSearch) {
        this.autoSearch = autoSearch;
    }

    public boolean isAutoSearch() {
        return this.autoSearch;
    }
}

