/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.datareview.FAFReportAnalysisModel;
import kd.macc.faf.enums.DimensionTypeEnum;
import org.apache.commons.lang3.ArrayUtils;

public abstract class FAFListColumns
extends AbstractReportListDataPlugin {
    private final String[] existNumbers = new String[]{"report_period_number", "report_period_name", "report_org_number", "report_org_name", "report_account_number", "report_account_name", "report_daterange"};
    private final String[] useDimName = new String[]{"report_daterange"};
    FAFReportAnalysisModel fAFReportAnalysisModel = null;

    public final List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if (this.fAFReportAnalysisModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FAFListColumns_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        HashSet<String> containKey = new HashSet<String>(columns.size());
        ArrayList<AbstractReportColumn> finallyColumns = new ArrayList<AbstractReportColumn>(columns.size());
        List<FAFReportAnalysisModel.Field> selectFields2List = this.fAFReportAnalysisModel.getColumnNumbers();
        Map<String, FAFReportAnalysisModel.Dimension> enums = selectFields2List.stream().filter(p -> p instanceof FAFReportAnalysisModel.Dimension).map(p -> (FAFReportAnalysisModel.Dimension)p).filter(p -> p.dimensionTypeEnum == DimensionTypeEnum.DENUMS).collect(Collectors.toMap(FAFReportAnalysisModel.Field::getNumber, p -> p));
        Map<String, String> collect = selectFields2List.stream().collect(Collectors.toMap(FAFReportAnalysisModel.Field::getNumber, FAFReportAnalysisModel.Field::getName));
        this.setProgress(10);
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            String fieldKey = ((ReportColumn)column).getFieldKey();
            containKey.add(fieldKey);
            if (ArrayUtils.contains((Object[])this.existNumbers, (Object)fieldKey) && !collect.containsKey(fieldKey)) continue;
            if (ArrayUtils.contains((Object[])this.useDimName, (Object)fieldKey) && collect.containsKey(fieldKey)) {
                column.setCaption(new LocaleString(collect.get(fieldKey)));
            }
            finallyColumns.add(column);
        }
        this.setProgress(20);
        selectFields2List.forEach(p -> {
            String number = p.getNumber();
            String name = p.getName();
            boolean measure = false;
            if (p instanceof FAFReportAnalysisModel.Measure) {
                measure = true;
            }
            if (!containKey.contains(number)) {
                if (enums.containsKey(number)) {
                    List<FAFReportAnalysisModel.Field> entry = ((FAFReportAnalysisModel.Dimension)enums.get((Object)number)).entry;
                    List<ValueMapItem> valueMapItems = entry.stream().map(x -> new ValueMapItem(null, x.number, new LocaleString(x.name))).collect(Collectors.toList());
                    finallyColumns.add((AbstractReportColumn)this.addComboReportColumn(number, name, valueMapItems));
                } else {
                    finallyColumns.add((AbstractReportColumn)this.addReportColumn(number, name, measure));
                }
            }
        });
        this.setProgress(30);
        return finallyColumns;
    }

    private ReportColumn addReportColumn(String columnKey, String columnCaption, boolean isMeasure) {
        ReportColumn col = new ReportColumn();
        col.setFieldKey(columnKey);
        col.setCaption(new LocaleString(columnCaption));
        if (isMeasure) {
            col.setNeedFormat(true);
            Map<String, Integer> precisionOfMeasure = this.fAFReportAnalysisModel.getPrecisionOfMeasure();
            col.setScale(precisionOfMeasure.get(columnKey).intValue());
            col.setFieldType("decimal");
            CellStyle cellStyle = new CellStyle();
            cellStyle.setTextAlign("right");
            col.setStyle((ColumnStyle)cellStyle);
        }
        col.setFieldType("text");
        return col;
    }

    private ReportColumn addComboReportColumn(String columnKey, String columnCaption, List<ValueMapItem> valueMapItems) {
        ComboReportColumn col = new ComboReportColumn();
        col.setFieldKey(columnKey);
        col.setCaption(new LocaleString(columnCaption));
        if (!CollectionUtils.isEmpty(valueMapItems)) {
            col.setComboItems(valueMapItems);
        }
        CellStyle cellStyle = new CellStyle();
        cellStyle.setTextAlign("right");
        col.setStyle((ColumnStyle)cellStyle);
        col.setFieldType("combofield");
        return col;
    }
}

