/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.util.AnalysisModelUtil;
import org.apache.commons.lang3.StringUtils;

public class FAFReportAnalysisModel {
    private static final Log logger = LogFactory.getLog(FAFReportAnalysisModel.class);
    private String tableNumber;
    private String summaryTableNumber;
    private List<Measure> measureList;
    private Map<String, Integer> precisionOfMeasure;
    private List<Field> columnNumbers = new ArrayList<Field>(16);
    private Map<String, String> sqlColumnsMap;
    private int measureNumberIndex = 0;

    private void init(DynamicObject analysisModel, boolean needNumber) {
        String name;
        String number;
        String tableNumber = analysisModel.getString("tablenumber");
        if (StringUtils.isEmpty((CharSequence)tableNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e3a\u8be5\u6a21\u578b\u521b\u5efa\u6570\u636e\u8868", (String)"FAFReportAnalysisModel_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        this.tableNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
        this.summaryTableNumber = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
        if (!MetadataDao.checkNumber((String)this.tableNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e3a\u8be5\u6a21\u578b\u521b\u5efa\u6570\u636e\u8868", (String)"FAFReportAnalysisModel_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = analysisModel.getDynamicObjectCollection("measure_entry");
        this.sqlColumnsMap = new HashMap<String, String>(4);
        this.columnNumbers.add(new Field(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"FAFReportAnalysisModel_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), "id"));
        this.columnNumbers.add(new Field(ResManager.loadKDString((String)"\u6c47\u603b\u72b6\u6001", (String)"FAFReportAnalysisModel_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), "collectstatus"));
        this.columnNumbers.add(new Field(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"FAFReportAnalysisModel_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), "datastatus"));
        for (DynamicObject dimensionRow : dimensionEntry) {
            DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            number = dimension.getString("number");
            name = dimension.getString("name");
            logger.info("dimension name == > " + name);
            String columnNumber = null;
            String necessityDim = dimensionRow.getString("necessity_dim");
            DimensionNecessityEnum anEnum = DimensionNecessityEnum.getEnum((String)necessityDim);
            if (dimensionType == DimensionTypeEnum.DATABASE || dimensionType == DimensionTypeEnum.PERIOD || dimensionType == DimensionTypeEnum.ASSISTANTDATA) {
                if (anEnum == DimensionNecessityEnum.ORG) {
                    columnNumber = "report_org";
                } else if (anEnum == DimensionNecessityEnum.PERIOD) {
                    columnNumber = "report_period";
                } else if (anEnum == DimensionNecessityEnum.ACCOUNT) {
                    columnNumber = "report_account";
                }
                if (columnNumber == null) {
                    columnNumber = number;
                }
                boolean hasName = this.checkDataEntityProperties(dimensionType, dimension, "name"::equals);
                String nameProperity = "name";
                if (!hasName) {
                    nameProperity = "id";
                }
                String nameSuffix = number + "." + nameProperity;
                String columnNumberName = columnNumber + "_name";
                this.sqlColumnsMap.put(columnNumberName, nameSuffix + " as " + columnNumberName);
                this.columnNumbers.add(new Dimension(name, columnNumberName, dimensionType, dimensionRow));
                if (!needNumber) continue;
                boolean hasNumber = this.checkDataEntityProperties(dimensionType, dimension, "number"::equals);
                String numberProperity = "number";
                if (!hasNumber) {
                    numberProperity = "id";
                }
                String numberSuffix = number + "." + numberProperity;
                String columnNumberNumber = columnNumber + "_number";
                this.sqlColumnsMap.put(columnNumberNumber, numberSuffix + " as " + columnNumberNumber);
                this.columnNumbers.add(new Dimension(name + new LocaleString(ResManager.loadKDString((String)"\u7f16\u53f7", (String)"FAFReportAnalysisModel_4", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString(), columnNumberNumber, dimensionType, dimensionRow));
                continue;
            }
            if (dimensionType == DimensionTypeEnum.DATE && anEnum != null) {
                columnNumber = "report_daterange";
                this.sqlColumnsMap.put(columnNumber, number + " as " + columnNumber);
                this.columnNumbers.add(new Dimension(name, columnNumber, dimensionType, dimensionRow));
                continue;
            }
            columnNumber = number;
            this.columnNumbers.add(new Dimension(name, columnNumber, dimensionType, dimensionRow));
        }
        this.measureList = new ArrayList<Measure>(measureEntry.size());
        int measureIndex = this.measureNumberIndex = this.columnNumbers.size();
        this.precisionOfMeasure = new HashMap<String, Integer>(measureEntry.size());
        for (DynamicObject measureRow : measureEntry) {
            DynamicObject measureDy = measureRow.getDynamicObject("measure");
            number = measureDy.getString("number");
            name = measureDy.getString("name");
            String measuretype = measureDy.getString("measuretype");
            Measure measure = new Measure(name, number, measureIndex++, measuretype);
            int precision = 2;
            if (measureDy.getDataEntityType().getProperties().get((Object)"precision") != null) {
                if (!measuretype.equals("2")) {
                    precision = measureDy.getInt("precision");
                } else {
                    DynamicObject normalMeasureDy = measureDy.getDynamicObject("measure");
                    normalMeasureDy = BusinessDataServiceHelper.loadSingleFromCache((Object)normalMeasureDy.getPkValue(), (String)"pa_measure");
                    precision = normalMeasureDy.getInt("precision");
                }
            }
            measure.setPrecision(precision);
            this.precisionOfMeasure.put(number, precision);
            this.measureList.add(measure);
        }
        this.columnNumbers.addAll(this.measureList);
    }

    private boolean checkDataEntityProperties(DimensionTypeEnum dimensionType, DynamicObject dimension, Function<String, Boolean> function) {
        if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.PERIOD == dimensionType) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dimension.getDynamicObject("dimensionsource").getString("number"));
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            Optional<IDataEntityProperty> any = properties.stream().filter(p -> (Boolean)function.apply(p.getName())).findAny();
            if (!any.isPresent()) {
                return false;
            }
            IDataEntityProperty iDataEntityProperty = any.get();
            return !StringUtils.isEmpty((CharSequence)iDataEntityProperty.getAlias());
        }
        return true;
    }

    private void init(Long modelId, boolean needNumber) {
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        this.init(analysisModel, needNumber);
    }

    public FAFReportAnalysisModel(Long modelId, boolean needNumber) {
        this.init(modelId, needNumber);
    }

    public FAFReportAnalysisModel(DynamicObject analysisModel, boolean needNumber) {
        this.init(analysisModel, needNumber);
    }

    public String getTableNumber() {
        return this.tableNumber;
    }

    public String getSummaryTableNumber() {
        return this.summaryTableNumber;
    }

    public String getSelectFields2String() {
        StringBuilder sbd = new StringBuilder();
        for (Field column : this.columnNumbers) {
            String columnSql;
            sbd.append(',');
            if (this.sqlColumnsMap != null && (columnSql = this.sqlColumnsMap.get(column.getNumber())) != null) {
                sbd.append(columnSql);
                continue;
            }
            sbd.append(column.getNumber());
        }
        return sbd.length() > 0 ? sbd.substring(1) : null;
    }

    public String[] getSelectFields(String ... exNum) {
        List<String> list = this.getSelectFields2List().stream().map(Field::getNumber).collect(Collectors.toList());
        if (exNum != null && exNum.length > 0) {
            list.addAll(Arrays.asList(exNum));
        }
        return list.toArray(new String[0]);
    }

    public List<Field> getSelectFields2List() {
        return this.columnNumbers;
    }

    public String getSelectMeasureFieldString() {
        return this.measureList.stream().map(p -> p.getNumber() + " as " + p.getNumber() + "_clq").collect(Collectors.joining(","));
    }

    public String[] getSelectMeasureField() {
        return (String[])this.measureList.stream().map(p -> p.getNumber() + "_clq").toArray(String[]::new);
    }

    public List<Measure> getMeasureList() {
        return this.measureList;
    }

    public Map<String, Integer> getPrecisionOfMeasure() {
        return this.precisionOfMeasure;
    }

    public List<Field> getColumnNumbers() {
        return this.columnNumbers;
    }

    public int getMeasureNumberIndex() {
        return this.measureNumberIndex;
    }

    public static class Dimension
    extends Field {
        DimensionTypeEnum dimensionTypeEnum;
        List<Field> entry = Collections.emptyList();

        public Dimension(String name, String number, DimensionTypeEnum dimensionTypeEnum, DynamicObject dynamicObject) {
            super(name, number);
            this.dimensionTypeEnum = dimensionTypeEnum;
            if (this.dimensionTypeEnum == DimensionTypeEnum.DENUMS) {
                DynamicObjectCollection entryentityenums = dynamicObject.getDynamicObject("dimension").getDynamicObjectCollection("entryentityenums");
                this.entry = entryentityenums.stream().map(p -> new Field(p.getString("title"), p.getString("value"))).collect(Collectors.toList());
            }
        }
    }

    public static class Measure
    extends Field {
        private int precision;
        String measuretype;

        public Measure(String name, String number, int index, String measuretype) {
            super(name, number);
            this.measuretype = measuretype;
            this.index = index;
        }

        public Measure(String name, String number, int index, String measuretype, int precision) {
            super(name, number);
            this.measuretype = measuretype;
            this.precision = precision;
            this.index = index;
        }

        public String getMeasuretype() {
            return this.measuretype;
        }

        public void setMeasuretype(String measuretype) {
            this.measuretype = measuretype;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public int getPrecision() {
            return this.precision;
        }
    }

    public static class Field {
        String name;
        String number;
        int index;

        public Field(String name, String number) {
            this.name = name;
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }
}

